/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.event.FilterListenerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.filter.FilterChainContents;
import com.ibm.ws.webcontainer.filter.FilterInstanceWrapper;
import com.ibm.ws.webcontainer.filter.FilterMapping;
import com.ibm.ws.webcontainer.filter.WebAppFilterChain;
import com.ibm.ws.webcontainer.servlet.ServletWrapper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import com.ibm.wsspi.webcontainer.IInternalConfig;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.collaborator.CollaboratorInvocationEnum;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.security.SecurityViolationException;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import com.ibm.wsspi.webcontainer.webapp.NamespaceInvoker;
import java.beans.Beans;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppFilterManager
implements com.ibm.wsspi.webcontainer.filter.WebAppFilterManager {
    protected Hashtable _filterWrappers = new Hashtable();
    private Map chainCache = Collections.synchronizedMap(new LinkedHashMap(20, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 200;
        }
    });
    private Map forwardChainCache = Collections.synchronizedMap(new LinkedHashMap(10, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    private Map includeChainCache = Collections.synchronizedMap(new LinkedHashMap(5, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    private Map errorChainCache = Collections.synchronizedMap(new LinkedHashMap(2, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    private ArrayList _uriFilterMappings = new ArrayList();
    private ArrayList _servletFilterMappings = new ArrayList();
    public boolean _filtersDefined = false;
    static final int FMI_MAPPING_SINGLE_SLASH = 0;
    static final int FMI_MAPPING_PATH_MATCH = 1;
    static final int FMI_MAPPING_EXTENSION_MATCH = 2;
    static final int FMI_MAPPING_EXACT_MATCH = 3;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.filter");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.filter.WebAppFilterManager";
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    WebAppConfiguration webAppConfig;
    WebApp webApp;
    private ICollaboratorHelper collabHelper;
    private IWebAppNameSpaceCollaborator webAppNameSpaceCollab;
    private IWebAppSecurityCollaborator secCollab;
    private boolean sessionSecurityIntegrationEnabled;
    private boolean disableSecurityPreInvokeOnFilters = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.disablesecuritypreinvokeonfilters"));
    private WebAppEventSource _evtSource = null;

    public WebAppFilterManager(WebAppConfiguration webGroupConfig, WebApp webApp) {
        this.webAppConfig = webGroupConfig;
        this.webApp = webApp;
        this._evtSource = (WebAppEventSource)webApp.getServletContextEventSource();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "WebAppFilterManager", "Adding debug filter invocation listener");
            FilterListenerImpl testListener = new FilterListenerImpl();
            this._evtSource.addFilterInvocationListener(testListener);
            this._evtSource.addFilterListener(testListener);
            this._evtSource.addFilterErrorListener(testListener);
        }
        this.collabHelper = webApp.getCollaboratorHelper();
        this.webAppNameSpaceCollab = this.collabHelper.getWebAppNameSpaceCollaborator();
        this.secCollab = this.collabHelper.getSecurityCollaborator();
        this.sessionSecurityIntegrationEnabled = webApp.getSessionContext().getIntegrateWASSecurity();
    }

    public void init() {
        List fMappings = this.webAppConfig.getFilterMappings();
        if (!fMappings.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "filter mappings at init time ->" + fMappings);
            }
            this._filtersDefined = true;
            for (FilterMapping fMapping : fMappings) {
                this.addFilterMapping(fMapping);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "no filter mappings at init time");
        }
    }

    public void addFilterMapping(FilterMapping fMapping) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addFilterMapping", "filter mapping->" + fMapping);
        }
        if (fMapping != null) {
            this._filtersDefined = true;
            FilterMappingInfo fmInfo = new FilterMappingInfo();
            String urlMap = fMapping.getUrlPattern();
            IFilterConfig config2 = fMapping.getFilterConfig();
            if (config2 instanceof IInternalConfig) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addFilterMapping", "filter isInternal->" + ((IInternalConfig)((Object)config2)).getIsInternal());
                }
                fmInfo.setIsInternal(((IInternalConfig)((Object)config2)).getIsInternal());
            }
            if (urlMap != null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addFilterMapping", "add url pattern filter mapping");
                }
                fmInfo.setFilterName(fMapping.getFilterConfig().getFilterName());
                fmInfo.setFilterURI(urlMap);
                fmInfo.setDispatchMode(fMapping.getDispatchMode());
                this._uriFilterMappings.add(fmInfo);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addFilterMapping", "add servlet name filter mapping");
                }
                fmInfo.setFilterName(fMapping.getFilterConfig().getFilterName());
                IServletConfig servletConfig = fMapping.getServletConfig();
                if (servletConfig != null) {
                    fmInfo.setFilterServlet(servletConfig.getServletName());
                }
                fmInfo.setDispatchMode(fMapping.getDispatchMode());
                this._servletFilterMappings.add(fmInfo);
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addFilterMapping", "Adding filterMappingInfo -->" + fmInfo.toString());
            }
        }
    }

    public FilterInstanceWrapper getFilterInstanceWrapper(String filterName) throws ServletException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getFilterInstanceWrapper", "entry");
        }
        try {
            FilterInstanceWrapper filterInstW = (FilterInstanceWrapper)this._filterWrappers.get(filterName);
            if (filterInstW != null) {
                return filterInstW;
            }
            return this.loadFilter(filterName);
        }
        catch (ServletException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.getFilterInstanceWrapper", "166", this);
            throw e;
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.getFilterInstanceWrapper", "172", this);
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be loaded", filterName), th);
        }
    }

    public WebAppFilterChain getFilterChain(String reqURI, IServletWrapper reqServlet, int mode) throws ServletException {
        String servletName = "null";
        boolean isInternal = false;
        if (reqServlet != null) {
            servletName = reqServlet.getServletName();
            IServletConfig config2 = (IServletConfig)reqServlet.getServletConfig();
            if (config2 instanceof IInternalConfig) {
                isInternal = ((IInternalConfig)((Object)config2)).getIsInternal();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getFilterChain", "requestURI [" + reqURI + "] isInternal [" + isInternal + "]");
        }
        FilterChainContents fcc = this.getFilterChainContents(reqURI, servletName, mode, isInternal);
        WebAppFilterChain newChain = new WebAppFilterChain(this.webApp);
        if (fcc._hasFilters) {
            ArrayList filterNames = fcc.getFilterNames();
            int nbrOfNames = filterNames.size();
            for (int i = 0; i < nbrOfNames; ++i) {
                newChain.addFilter(this.getFilterInstanceWrapper((String)filterNames.get(i)));
            }
        }
        newChain.setRequestedServlet(reqServlet);
        return newChain;
    }

    public WebAppFilterChain getFilterChain(String reqURI, ServletWrapper reqServlet) throws ServletException {
        return this.getFilterChain(reqURI, reqServlet, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Enumeration filterWrappers = this._filterWrappers.elements();
        ClassLoader origClassLoader = ThreadContextHelper.getContextClassLoader();
        try {
            ClassLoader warClassLoader = this.webApp.getClassLoader();
            if (warClassLoader != origClassLoader) {
                ThreadContextHelper.setClassLoader(warClassLoader);
            }
            while (filterWrappers.hasMoreElements()) {
                try {
                    ((FilterInstanceWrapper)filterWrappers.nextElement()).destroy();
                }
                catch (Throwable th) {
                    FFDCFilter.processException(th, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.shutdown", "237", this);
                }
            }
        }
        finally {
            ThreadContextHelper.setClassLoader(origClassLoader);
        }
        this._filterWrappers = null;
        this.chainCache = null;
        this.forwardChainCache = null;
        this.includeChainCache = null;
        this.errorChainCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterInstanceWrapper loadFilter(String filterName) throws ServletException {
        ClassLoader origClassLoader = ThreadContextHelper.getContextClassLoader();
        try {
            ClassLoader warClassLoader = this.webApp.getClassLoader();
            if (warClassLoader != origClassLoader) {
                ThreadContextHelper.setClassLoader(warClassLoader);
            }
            FilterInstanceWrapper filterInstanceWrapper = this._loadFilter(filterName);
            return filterInstanceWrapper;
        }
        finally {
            ThreadContextHelper.setClassLoader(origClassLoader);
        }
    }

    private FilterInstanceWrapper _loadFilter(String filterName) throws ServletException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "_loadFilter", "entry");
        }
        FilterInstanceWrapper fiw = null;
        try {
            Filter filter;
            IFilterConfig filterConfig = this.webAppConfig.getFilterInfo(filterName);
            filterConfig.setContext(this.webApp.getFacade());
            String filterClass = filterConfig.getFilterClassName();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "_loadFilter", "Instantiating Filter Class: {0}", filterClass);
            }
            try {
                ClassLoader filterLoader = filterConfig.getFilterClassLoader();
                if (filterLoader != null) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "_loadFilter", "FilterConfig classloader: " + filterLoader);
                    }
                    filter = (Filter)Beans.instantiate(filterLoader, filterClass);
                    filterConfig.setFilterClassLoader(null);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "_loadFilter", "Filter default classloader: " + this.webApp.getClassLoader());
                    }
                    filter = (Filter)Beans.instantiate(this.webApp.getClassLoader(), filterClass);
                }
            }
            catch (ClassNotFoundException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "298", this);
                throw new ServletException(MessageFormat.format(nls.getString("Could.not.find.required.filter.class", "Filter [{0}]: Could not find required filter class - {1}.class"), filterName, filterClass), e);
            }
            catch (ClassCastException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "303", this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.not.a.filter.class", "Filter [{0}]: not a filter class"), filterName), e);
            }
            catch (NoClassDefFoundError e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "308", this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.was.found.but.is.missing.another.required.class", "Filter [{0}]: {1} was found, but is missing another required class.\n"), filterName, filterClass), e);
            }
            catch (ClassFormatError e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "313", this);
                throw new ServletException(MessageFormat.format(nls.getString("Filter.found.but.corrupt", "Filter [{0}]: {1} was found, but is corrupt:\n"), filterName, filterClass), e);
            }
            fiw = this.createFilterInstanceWrapper(filterName, filter);
            fiw.init(filterConfig);
            this._filterWrappers.put(filterName, fiw);
        }
        catch (ServletException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "380", this);
            throw e;
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "385", this);
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be loaded", filterName), th);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "_loadFilter", "exit");
        }
        return fiw;
    }

    protected FilterInstanceWrapper createFilterInstanceWrapper(String filterName, Filter filter) {
        return new FilterInstanceWrapper(filterName, filter, this._evtSource);
    }

    private FilterChainContents getFilterChainContents(String reqURI, String reqServletName, int mode, boolean servletIsInternal) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "reqUri->" + reqURI + ", reqServletName->" + reqServletName + ", mode->" + mode + ", servletIsInternal->" + servletIsInternal);
        }
        FilterChainContents fcc = null;
        String strippedUri = null;
        if (reqURI != null) {
            int queryIndex = reqURI.indexOf("?");
            strippedUri = queryIndex > 0 ? reqURI.substring(0, queryIndex) : reqURI;
            int semicolon = strippedUri.indexOf(59);
            if (semicolon != -1) {
                strippedUri = strippedUri.substring(0, semicolon);
            }
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "strippedUri->" + strippedUri);
            }
            if (mode == 0) {
                fcc = (FilterChainContents)this.chainCache.get(strippedUri);
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "fitler request mode, get cache entry fcc->" + fcc);
                }
            } else if (mode == 1) {
                fcc = (FilterChainContents)this.forwardChainCache.get(strippedUri);
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "fitler forward mode, get cache entry fcc->" + fcc);
                }
            } else if (mode == 2) {
                fcc = (FilterChainContents)this.includeChainCache.get(strippedUri);
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "fitler include mode, get cache entry fcc->" + fcc);
                }
            } else if (mode == 3) {
                fcc = (FilterChainContents)this.errorChainCache.get(strippedUri);
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "fitler error mode, get cache entry fcc->" + fcc);
                }
            }
        } else if (mode == 0) {
            fcc = (FilterChainContents)this.chainCache.get(reqServletName);
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "fitler request mode, get cache entry fcc->" + fcc);
            }
        } else if (mode == 1) {
            fcc = (FilterChainContents)this.forwardChainCache.get(reqServletName);
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "fitler forward mode, get cache entry fcc->" + fcc);
            }
        } else if (mode == 2) {
            fcc = (FilterChainContents)this.includeChainCache.get(reqServletName);
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "fitler include mode, get cache entry fcc->" + fcc);
            }
        } else if (mode == 3) {
            fcc = (FilterChainContents)this.errorChainCache.get(reqServletName);
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "fitler error mode, get cache entry fcc->" + fcc);
            }
        }
        if (fcc == null) {
            int i;
            int nbrOfMappings;
            fcc = new FilterChainContents();
            if (strippedUri != null) {
                nbrOfMappings = this._uriFilterMappings.size();
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "number of uri filter mapping->" + nbrOfMappings);
                }
                for (i = 0; i < nbrOfMappings; ++i) {
                    FilterMappingInfo fmInfo = (FilterMappingInfo)this._uriFilterMappings.get(i);
                    if (isTraceOn && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter mapping info->" + fmInfo);
                    }
                    if (!servletIsInternal && servletIsInternal != fmInfo._isInternal || !this.uriMatch(strippedUri, fmInfo, mode)) continue;
                    fcc.addFilter(fmInfo._filterName);
                }
            }
            nbrOfMappings = this._servletFilterMappings.size();
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "number of servlet filter mapping->" + nbrOfMappings);
            }
            block1: for (i = 0; i < nbrOfMappings; ++i) {
                FilterMappingInfo fmInfo = (FilterMappingInfo)this._servletFilterMappings.get(i);
                String filterServlet = fmInfo._filterServlet;
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter mapping info->" + fmInfo);
                }
                if (filterServlet != null) {
                    int j;
                    if (reqServletName.equals(filterServlet)) {
                        if (isTraceOn && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "matches servlet name");
                        }
                        for (j = 0; j < fmInfo.dispatchMode.length; ++j) {
                            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "current dispatch mode->" + fmInfo.dispatchMode[j]);
                            }
                            if (!servletIsInternal && servletIsInternal != fmInfo._isInternal || mode != fmInfo.dispatchMode[j]) continue;
                            fcc.addFilter(fmInfo._filterName);
                            continue block1;
                        }
                        continue;
                    }
                    if (!filterServlet.equals("*")) continue;
                    if (isTraceOn && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "matches *");
                    }
                    for (j = 0; j < fmInfo.dispatchMode.length; ++j) {
                        if (isTraceOn && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "current dispatch mode->" + fmInfo.dispatchMode[j]);
                        }
                        if (fmInfo.dispatchMode[j] != 1 && fmInfo.dispatchMode[j] != 2 || !servletIsInternal && servletIsInternal != fmInfo._isInternal || mode != fmInfo.dispatchMode[j]) continue;
                        fcc.addFilter(fmInfo._filterName);
                        continue block1;
                    }
                    continue;
                }
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.logp(Level.WARNING, CLASS_NAME, "getFilterChainContents", "Null.Filter.Mapping");
            }
            if (strippedUri != null) {
                if (mode == 0) {
                    this.chainCache.put(strippedUri, fcc);
                } else if (mode == 1) {
                    this.forwardChainCache.put(strippedUri, fcc);
                } else if (mode == 2) {
                    this.includeChainCache.put(strippedUri, fcc);
                } else if (mode == 3) {
                    this.errorChainCache.put(strippedUri, fcc);
                }
            } else if (mode == 0) {
                this.chainCache.put(reqServletName, fcc);
            } else if (mode == 1) {
                this.forwardChainCache.put(reqServletName, fcc);
            } else if (mode == 2) {
                this.includeChainCache.put(reqServletName, fcc);
            } else if (mode == 3) {
                this.errorChainCache.put(reqServletName, fcc);
            }
        }
        return fcc;
    }

    private boolean uriMatch(String requestURI, FilterMappingInfo fmInfo, int mode) {
        boolean theyMatch = false;
        switch (fmInfo._mappingType) {
            case 0: {
                if (!requestURI.equals("/")) break;
                theyMatch = true;
                break;
            }
            case 1: {
                if (!requestURI.startsWith(fmInfo._filterURI + "/") && !requestURI.equals(fmInfo._filterURI)) break;
                theyMatch = true;
                break;
            }
            case 2: {
                String ext = fmInfo._filterURI.substring(2);
                int index = requestURI.lastIndexOf(46);
                if (index == -1 || !ext.equals(requestURI.substring(index + 1))) break;
                theyMatch = true;
                break;
            }
            case 3: {
                if (!requestURI.equals(fmInfo._filterURI)) break;
                theyMatch = true;
                break;
            }
        }
        boolean dispMatch = false;
        if (theyMatch) {
            for (int i = 0; i < fmInfo.dispatchMode.length; ++i) {
                if (mode != fmInfo.dispatchMode[i]) continue;
                dispMatch = true;
                break;
            }
        }
        return dispMatch && theyMatch;
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, IServletWrapper target, ExtensionProcessor requestProcessor, WebAppDispatcherContext dispatchContext) throws ServletException, IOException {
        WebAppFilterChain fc;
        String nested;
        boolean isNested;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doFilter", "entry");
        }
        boolean bl = isNested = (nested = (String)request.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested")) != null && nested.equalsIgnoreCase("true");
        if (!isNested) {
            fc = this.getFilterChain(dispatchContext.getRelativeUri(), target, 0);
        } else if (request.getAttribute("javax.servlet.jsp.jspException") != null) {
            fc = this.getFilterChain(dispatchContext.getRelativeUri(), target, 3);
        } else if (request.getAttribute("com.ibm.servlet.engine.webapp.dispatch_type").equals("include")) {
            String attr = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (attr == null) {
                fc = this.getFilterChain(null, target, 2);
            } else {
                StringBuffer relUri = new StringBuffer(attr);
                String pi = (String)request.getAttribute("javax.servlet.include.path_info");
                if (pi != null) {
                    relUri.append(pi);
                }
                String ru = relUri.toString();
                fc = this.getFilterChain(ru, target, 2);
            }
        } else {
            fc = request.getAttribute("com.ibm.servlet.engine.webapp.dispatch_type").equals("forward") ? this.getFilterChain(dispatchContext.getRelativeUri(), target, 1) : this.getFilterChain(dispatchContext.getRelativeUri(), target, 0);
        }
        if (requestProcessor != null) {
            fc.setExtensionProcessor(requestProcessor);
        }
        fc._doFilter(request, response);
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doFilter", "exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean invokeFilters(HttpServletRequest request, HttpServletResponse response, IServletWrapper target, NamespaceInvoker invoker, IServletContext context, ExtensionProcessor ep, EnumSet<CollaboratorInvocationEnum> colEnum) throws ServletException, IOException {
        boolean result;
        block41: {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "invokeFilters", "request->" + request + ", response->" + response + ", target->" + target + ", context->" + context + ", invoker->" + invoker);
            }
            result = false;
            if (!context.isFiltersDefined()) break block41;
            Object secObject = null;
            String path = this.getPath(request);
            IExtendedRequest wasreq = null;
            WebAppDispatcherContext dispatchContext = null;
            ClassLoader origClassLoader = null;
            try {
                if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.NAMESPACE) && invoker != null) {
                    invoker.nameSpacePreInvoke();
                }
                wasreq = (IExtendedRequest)ServletUtil.unwrapRequest(request);
                dispatchContext = (WebAppDispatcherContext)wasreq.getWebAppDispatcherContext();
                if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SECURITY) && !this.disableSecurityPreInvokeOnFilters) {
                    if (this.sessionSecurityIntegrationEnabled && wasreq instanceof IExtendedRequest) {
                        wasreq.setRunningCollaborators(true);
                    }
                    secObject = this.secCollab.preInvoke(request, response, path, dispatchContext.isEnforceSecurity());
                    if (this.sessionSecurityIntegrationEnabled && wasreq instanceof IExtendedRequest) {
                        wasreq.setRunningCollaborators(false);
                    }
                }
                if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.CLASSLOADER)) {
                    origClassLoader = ThreadContextHelper.getContextClassLoader();
                    ClassLoader warClassLoader = context.getClassLoader();
                    if (warClassLoader != origClassLoader) {
                        ThreadContextHelper.setClassLoader(warClassLoader);
                    }
                }
                if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SESSION) && dispatchContext != null) {
                    dispatchContext.sessionPreInvoke();
                }
                try {
                    this.doFilter(request, response, target, ep, dispatchContext);
                    result = true;
                }
                catch (IOException e) {
                    if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.EXCEPTION)) {
                        throw e;
                    }
                    WebContainerRequestState.getInstance(true).setAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter", e);
                    result = false;
                }
                catch (ServletException e) {
                    if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.EXCEPTION)) {
                        throw e;
                    }
                    WebContainerRequestState.getInstance(true).setAttribute("com.ibm.ws.webcontainer.filter.exceptioninfilter", e);
                    result = false;
                }
                Object var16_18 = null;
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SESSION) && dispatchContext != null) {
                    dispatchContext.sessionPostInvoke();
                }
                if (colEnum != null && origClassLoader != null && colEnum.contains((Object)CollaboratorInvocationEnum.SESSION)) {
                    ThreadContextHelper.setClassLoader(origClassLoader);
                    if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SECURITY) && !this.disableSecurityPreInvokeOnFilters) {
                        if (this.sessionSecurityIntegrationEnabled && wasreq != null && wasreq instanceof IExtendedRequest) {
                            wasreq.setRunningCollaborators(true);
                        }
                        try {
                            this.secCollab.postInvoke(secObject);
                        }
                        finally {
                            if (this.sessionSecurityIntegrationEnabled && wasreq != null && wasreq instanceof IExtendedRequest) {
                                wasreq.setRunningCollaborators(false);
                            }
                        }
                    }
                    if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.NAMESPACE) && invoker != null) {
                        invoker.nameSpacePostInvoke();
                    }
                }
                throw throwable;
            }
            if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SESSION) && dispatchContext != null) {
                dispatchContext.sessionPostInvoke();
            }
            if (colEnum == null || origClassLoader == null || !colEnum.contains((Object)CollaboratorInvocationEnum.SESSION)) break block41;
            ThreadContextHelper.setClassLoader(origClassLoader);
            if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SECURITY) && !this.disableSecurityPreInvokeOnFilters) {
                if (this.sessionSecurityIntegrationEnabled && wasreq != null && wasreq instanceof IExtendedRequest) {
                    wasreq.setRunningCollaborators(true);
                }
                try {
                    this.secCollab.postInvoke(secObject);
                }
                finally {
                    if (this.sessionSecurityIntegrationEnabled && wasreq != null && wasreq instanceof IExtendedRequest) {
                        wasreq.setRunningCollaborators(false);
                    }
                }
            }
            if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.NAMESPACE) && invoker != null) {
                invoker.nameSpacePostInvoke();
            }
            break block41;
            {
                catch (SecurityViolationException e) {
                    this.collabHelper.processSecurityPreInvokeException(e, target, request, response, dispatchContext, this.webApp, path);
                    Object var16_19 = null;
                    if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SESSION) && dispatchContext != null) {
                        dispatchContext.sessionPostInvoke();
                    }
                    if (colEnum == null || origClassLoader == null || !colEnum.contains((Object)CollaboratorInvocationEnum.SESSION)) break block41;
                    ThreadContextHelper.setClassLoader(origClassLoader);
                    if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SECURITY) && !this.disableSecurityPreInvokeOnFilters) {
                        if (this.sessionSecurityIntegrationEnabled && wasreq != null && wasreq instanceof IExtendedRequest) {
                            wasreq.setRunningCollaborators(true);
                        }
                        try {
                            this.secCollab.postInvoke(secObject);
                        }
                        finally {
                            if (this.sessionSecurityIntegrationEnabled && wasreq != null && wasreq instanceof IExtendedRequest) {
                                wasreq.setRunningCollaborators(false);
                            }
                        }
                    }
                    if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.NAMESPACE) && invoker != null) {
                        invoker.nameSpacePostInvoke();
                    }
                }
            }
        }
        return result;
    }

    private String getPath(HttpServletRequest request) {
        int semicolon;
        String servletPath = null;
        String pathInfo = null;
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        if (pathInfo != null && (semicolon = pathInfo.indexOf(59)) != -1) {
            pathInfo = pathInfo.substring(0, semicolon);
        }
        return servletPath + pathInfo;
    }

    public boolean areFiltersDefined() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "invokeFilters", "_filtersDefined->" + this._filtersDefined);
        }
        return this._filtersDefined;
    }

    protected class FilterMappingInfo {
        String _filterName;
        String _filterURI;
        String _filterServlet;
        int _mappingType;
        int[] dispatchMode;
        boolean _isInternal = false;

        protected FilterMappingInfo() {
        }

        public void setFilterName(String filterName) {
            this._filterName = filterName;
        }

        public void setDispatchMode(int[] mode) {
            this.dispatchMode = mode;
        }

        public void setFilterURI(String filterURI) {
            if (filterURI.equals("/")) {
                this._mappingType = 0;
            } else if (filterURI.startsWith("/") && filterURI.endsWith("/*")) {
                this._mappingType = 1;
                filterURI = filterURI.substring(0, filterURI.length() - 2);
            } else if (filterURI.startsWith("*.")) {
                this._mappingType = 2;
            } else if (WCCustomProperties.MAP_FILTERS_TO_ASTERICK && filterURI.equals("*")) {
                this._mappingType = 1;
                filterURI = "";
            } else {
                this._mappingType = 3;
            }
            this._filterURI = filterURI;
        }

        public void setFilterServlet(String filterServlet) {
            this._filterServlet = filterServlet;
        }

        public void setIsInternal(boolean isInternal) {
            this._isInternal = isInternal;
        }

        public String toString() {
            return new String("filterName [" + this._filterName + "] filterURI [" + this._filterURI + "] _filterServlet [" + this._filterServlet + "] isInternal [" + this._isInternal + "]");
        }
    }
}

