/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.event.ApplicationListener;
import com.ibm.websphere.servlet.event.FilterErrorListener;
import com.ibm.websphere.servlet.event.FilterInvocationListener;
import com.ibm.websphere.servlet.event.FilterListener;
import com.ibm.websphere.servlet.event.ServletErrorListener;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.websphere.servlet.event.ServletListener;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.websphere.servlet.response.ResponseUtils;
import com.ibm.ws.container.Container;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.webcontainer.PlatformHelper;
import com.ibm.ws.webcontainer.SessionRegistry;
import com.ibm.ws.webcontainer.VirtualHost;
import com.ibm.ws.webcontainer.WebContainerConfiguration;
import com.ibm.ws.webcontainer.core.BaseContainer;
import com.ibm.ws.webcontainer.exception.WebAppHostNotFoundException;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.exception.WebContainerException;
import com.ibm.ws.webcontainer.exception.WebGroupVHostNotFoundException;
import com.ibm.ws.webcontainer.servlet.CacheServletWrapper;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.spi.servlet.http.IHttpServletResponseListener;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.util.InvalidCacheTargetException;
import com.ibm.ws.webcontainer.util.URIToServletWrapperCache;
import com.ibm.ws.webcontainer.util.VirtualHostMapper;
import com.ibm.ws.webcontainer.util.WSURLDecoder;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.webcontainer.IPlatformHelper;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.collaborator.CollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.security.SecurityViolationException;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.beans.Beans;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;

public abstract class WebContainer
extends BaseContainer {
    protected static final String ISO = "ISO-8859-1";
    protected String encoding = null;
    protected boolean decode = true;
    protected WebContainerConfiguration wcconfig;
    protected static List applicationListeners = new ArrayList();
    protected static List servletListeners = new ArrayList();
    protected static List servletErrorListeners = new ArrayList();
    protected static List servletInvocationListeners = new ArrayList();
    protected static List filterInvocationListeners = new ArrayList();
    protected static List filterErrorListeners = new ArrayList();
    protected static List filterListeners = new ArrayList();
    protected static ICollaboratorHelper collabHelper = null;
    private static List servletRequestListeners = new ArrayList();
    private static List servletRequestAttributeListeners = new ArrayList();
    private static List servletContextListeners = new ArrayList();
    private static List servletContextAttributeListeners = new ArrayList();
    private static List sessionListeners = new ArrayList();
    private static List sessionAttributeListeners = new ArrayList();
    public static final String DEFAULT_HOST = "default_host";
    protected static boolean _initialized;
    protected static Logger logger;
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.WebContainer";
    private static NLS nls;
    protected static WebContainer self;
    protected boolean production = false;
    private HashMap _cipherToBit = new HashMap();
    private static ThreadLocal cacheKeyStringBuilder;
    private static boolean listenersInitialized;
    protected static Properties webConProperties;
    protected SessionRegistry sessionRegistry;
    public static final String urlPrefix = ";jsessionid=";
    public static List<ExtensionFactory> extensionFactories;
    public static List<ExtensionFactory> postInitExtensionFactories;
    private static ArrayList httpResponseListeners;
    private static int invocationCacheSize;
    protected static boolean decodePlusSign;
    private static HashMap _cacheMap;
    private static boolean _cacheIsFull;
    protected boolean vHostCompatFlag = true;
    protected IPlatformHelper platformHelper;
    private IWebAppSecurityCollaborator secCollab;
    private static boolean isDefaultTempDir;
    private static String tempDir;
    private static boolean servletCachingInitNeeded;
    public static boolean appInstallBegun;

    protected WebContainer(String name, Container parent) {
        super(name, parent);
        this.requestMapper = new VirtualHostMapper();
    }

    public void initialize(WebContainerConfiguration config2) {
        this.wcconfig = config2;
        collabHelper = this.createCollaboratorHelper();
        this.secCollab = collabHelper.getSecurityCollaborator();
        this.getURIEncoding();
        _initialized = true;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "initialize", "Web Container invocationCache -->" + invocationCacheSize);
        }
    }

    protected ICollaboratorHelper createCollaboratorHelper() {
        return new CollaboratorHelper(null);
    }

    private static void registerGlobalWebAppListeners() {
        block7: {
            if (logger.isLoggable(Level.FINE)) {
                logger.entering(CLASS_NAME, "registerGlobalWebAppListeners");
            }
            try {
                String classes = WCCustomProperties.LISTENERS;
                String classname = null;
                if (classes == null) break block7;
                StringTokenizer st = new StringTokenizer(classes, ",");
                classname = null;
                while (st.hasMoreElements()) {
                    try {
                        classname = st.nextToken().trim();
                        WebContainer.addGlobalListener(classname);
                    }
                    catch (Throwable th) {
                        FFDCFilter.processException(th, "com.ibm.ws.webcontainer.webapp.WebApp.registerGlobalWebAppListeners", "785", WebContainer.getWebContainer());
                    }
                    listenersInitialized = true;
                }
            }
            catch (Throwable th) {
                logger.logp(Level.SEVERE, CLASS_NAME, "registerGlobalWebAppListeners", "Error occured while processing global listeners for the WebApp. ", th);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "registerGlobalWebAppListeners");
        }
    }

    public static void addGlobalListener(String classname) {
        Object listener;
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "addGlobalListener");
            logger.logp(Level.FINE, CLASS_NAME, "addGlobalListener", "classname->" + classname);
        }
        if ((listener = WebContainer.loadListener(classname)) != null) {
            if (listener instanceof ApplicationListener) {
                applicationListeners.add(listener);
            }
            if (listener instanceof ServletListener) {
                servletListeners.add(listener);
            }
            if (listener instanceof ServletErrorListener) {
                servletErrorListeners.add(listener);
            }
            if (listener instanceof ServletInvocationListener) {
                servletInvocationListeners.add(listener);
            }
            if (listener instanceof FilterInvocationListener) {
                filterInvocationListeners.add(listener);
            }
            if (listener instanceof FilterListener) {
                filterListeners.add(listener);
            }
            if (listener instanceof FilterErrorListener) {
                filterErrorListeners.add(listener);
            }
            if (listener instanceof ServletContextAttributeListener) {
                servletContextAttributeListeners.add(listener);
            }
            if (listener instanceof ServletContextListener) {
                servletContextListeners.add(listener);
            }
            if (listener instanceof ServletRequestAttributeListener) {
                servletRequestAttributeListeners.add(listener);
            }
            if (listener instanceof ServletRequestListener) {
                servletRequestListeners.add(listener);
            }
            if (listener instanceof HttpSessionListener) {
                sessionListeners.add(listener);
            }
            if (listener instanceof HttpSessionAttributeListener) {
                sessionAttributeListeners.add(listener);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "addGlobalListener");
        }
    }

    private static Object loadListener(String lClassName) {
        Object listener = null;
        try {
            listener = Beans.instantiate(ThreadContextHelper.getContextClassLoader(), lClassName);
        }
        catch (IOException io) {
            FFDCFilter.processException((Throwable)io, "com.ibm.ws.webcontainer.srt.WebGroup.loadListener", "1523", WebContainer.getWebContainer());
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.srt.WebGroup.loadListener", "1527", WebContainer.getWebContainer());
        }
        catch (ClassCastException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.srt.WebGroup.loadListener", "1531", WebContainer.getWebContainer());
        }
        catch (NoClassDefFoundError e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.srt.WebGroup.loadListener", "1535", WebContainer.getWebContainer());
        }
        catch (ClassFormatError e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.srt.WebGroup.loadListener", "1539", WebContainer.getWebContainer());
        }
        return listener;
    }

    protected void loadCipherToBit() {
        Properties cipherToBitProps = new Properties();
        try {
            String fileName = System.getProperty("server.root") + File.separator + "properties" + File.separator + "sslbitsizes.properties";
            cipherToBitProps.load(new FileInputStream(fileName));
        }
        catch (Exception ex) {
            logger.logp(Level.SEVERE, CLASS_NAME, "loadCipherToBit", "failed.to.load.sslbitsizes.properties ", ex);
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webcontainer.WebContainer.loadCipherToBit", "825", this);
        }
        this._cipherToBit.putAll(cipherToBitProps);
    }

    public void destroy() {
        super.destroy();
        this.requestMapper = null;
        if (!WebContainer.isDefaultTempDir()) {
            File f;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "destroy", "deleting tempDirectory");
            }
            if (tempDir != null && (f = new File(tempDir)).exists()) {
                try {
                    this.removeDir(f);
                }
                catch (SecurityException e) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "destroy", "Did not have access to delete Directory");
                }
            }
        }
    }

    private boolean removeDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.removeDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public void shutdown() {
        this.destroy();
    }

    public void addWebApplication(DeployedModule deployedModule, boolean production) throws WebAppNotLoadedException {
        try {
            appInstallBegun = true;
            this.production = production;
            this.addWebApp(deployedModule, production);
        }
        catch (WebAppNotLoadedException e) {
            throw e;
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, CLASS_NAME, "695", this);
            throw new WebAppNotLoadedException(th.getMessage(), th);
        }
    }

    private void addWebApp(DeployedModule dm, boolean production) throws WebAppNotLoadedException {
        try {
            VirtualHost vHost;
            String virtualHost = dm.getVirtualHostName();
            if (virtualHost == null || virtualHost.equals("")) {
                virtualHost = DEFAULT_HOST;
            }
            if ((vHost = this.getVirtualHost(virtualHost)) == null) {
                throw new WebAppNotLoadedException("Virtual Host " + virtualHost + " not found");
            }
            vHost.addWebApplication(dm, extensionFactories, production);
        }
        catch (WebAppHostNotFoundException wahnf) {
            FFDCFilter.processException((Throwable)wahnf, "com.ibm.ws.webcontainer.Webcontainer", "732", this);
            throw new WebAppNotLoadedException(wahnf.getMessage(), wahnf);
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, CLASS_NAME, "736", this);
            throw new WebAppNotLoadedException(th.getMessage(), th);
        }
    }

    public VirtualHost getVirtualHost(String virtualHost) throws WebAppHostNotFoundException {
        Iterator i = this.requestMapper.targetMappings();
        while (i.hasNext()) {
            VirtualHost vHost;
            RequestProcessor rp = (RequestProcessor)i.next();
            if (!(rp instanceof VirtualHost) || !virtualHost.equalsIgnoreCase((vHost = (VirtualHost)rp).getName())) continue;
            return vHost;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebApplication(DeployedModule deployedModule) throws Exception {
        try {
            BaseContainer vHost = this.getVirtualHost(deployedModule.getVirtualHostName());
            if (vHost == null) {
                throw new WebAppHostNotFoundException("VirtualHost not found");
            }
            vHost.removeWebApplication(deployedModule);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, CLASS_NAME, "removeWebApplication", "Exception", new Object[]{e});
            throw e;
        }
        finally {
            WebContainer webContainer = this;
            synchronized (webContainer) {
                _cacheIsFull = false;
            }
        }
    }

    public static WebContainer getWebContainer() {
        return self;
    }

    public void setSessionRegistry(SessionRegistry sessRegistry) {
        this.sessionRegistry = sessRegistry;
    }

    public void restartWebApplication(String moduleName) throws WebAppNotLoadedException {
    }

    public void reload(DeployedModule webModuleConfig) throws WebAppNotLoadedException {
        this.restartWebApplication(webModuleConfig);
    }

    public void restartWebApplication(DeployedModule webModuleConfig) throws WebAppNotLoadedException {
        String groupName = webModuleConfig.getName();
        try {
            this.removeWebApplication(webModuleConfig);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, CLASS_NAME, "restartWebApplication", "failed.to.remove.webmodule", new Object[]{groupName, e});
            return;
        }
        this.addWebApplication(webModuleConfig, this.production);
    }

    public boolean areRequestsOutstanding() {
        return false;
    }

    public WebContainerConfiguration getWebContainerConfig() {
        return this.wcconfig;
    }

    public IHttpSessionContext getSessionContext(DeployedModule moduleConfig, WebApp webApp, String host, ArrayList[] listeners) throws Throwable {
        try {
            return this.getSessionRegistry().getSessionContext(moduleConfig, webApp, host, listeners);
        }
        catch (Throwable e) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getSessionContext", "unable to get sessionContext ", e);
            return null;
        }
    }

    private SessionRegistry getSessionRegistry() {
        return this.sessionRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(IRequest req, IResponse res) throws IOException {
        isTraceOn = TraceComponent.isAnyTracingEnabled();
        secObject = null;
        connContext = null;
        cacheKey = null;
        try {
            block61: {
                if (WebContainer.collabHelper == null) {
                    throw new WebGroupVHostNotFoundException("Not found.");
                }
                secObject = this.secCollab.preInvoke();
                connContext = this.getConnectionContext();
                vhostKey = new StringBuilder();
                serverName = req.getServerName();
                if (serverName != null && serverName.length() > 0) {
                    if (serverName.charAt(0) == '[' && serverName.charAt(serverName.length() - 1) == ']') {
                        serverName = serverName.substring(1, serverName.length() - 1);
                    }
                    vhostKey.append(serverName.toLowerCase());
                }
                vhostKey.append(':');
                vhostKey.append(req.getServerPort());
                if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                    WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "Handling request with virtual host key of --> " + vhostKey.toString());
                }
                hreq = null;
                hres = null;
                if (this.wcconfig.isArdEnabled()) {
                    req.setShouldClose(false);
                }
                if ((cacheKey = (StringBuilder)WebContainer.cacheKeyStringBuilder.get()) == null) {
                    cacheKey = new StringBuilder();
                    WebContainer.cacheKeyStringBuilder.set(cacheKey);
                }
                connContext.prepareForNextConnection(req, res);
                hreq = connContext.getRequest();
                hres = connContext.getResponse();
                currDispatchContext = (WebAppDispatcherContext)hreq.getWebAppDispatcherContext();
                reqURI = req.getRequestURI();
                decodedReqURI = null;
                decodedReqURI = WebContainer.decodePlusSign != false ? URLDecoder.decode(reqURI, this.encoding) : WSURLDecoder.decode(reqURI, this.encoding);
                currDispatchContext.setDecodedReqUri(decodedReqURI);
                if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                    WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "webcontainer.handleRequest request uri --> (not decoded=" + reqURI + "), (decoded=" + decodedReqURI + "), (encoding=" + this.encoding + ")");
                }
                if (this.decode) {
                    isoURI = new String(reqURI.getBytes(this.encoding), "ISO-8859-1");
                    hreq.setAttribute("com.ibm.websphere.servlet.uri_non_decoded", isoURI);
                    if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                        WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "webcontainer.handleRequest uri_non_decoded --> " + isoURI);
                    }
                }
                cacheKey.append((CharSequence)vhostKey);
                pathInfoHelper = this.removeExtraPathInfo(reqURI);
                strippedRequestURI = null;
                extraPathInfo = null;
                if (pathInfoHelper != null) {
                    strippedRequestURI = PathInfoHelper.access$000(pathInfoHelper);
                    extraPathInfo = PathInfoHelper.access$100(pathInfoHelper);
                    if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                        WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "PathInfoHelper strippedRequestURI --> " + strippedRequestURI + " extraPath --> " + extraPathInfo);
                    }
                }
                cacheKey.append(strippedRequestURI);
                wrapper = (CacheServletWrapper)WebContainer._cacheMap.get(cacheKey.toString());
                if (wrapper == null) break block61;
                webApp = wrapper.getWebApp();
                if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                    WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "Found CacheServletWrapper with key --> " + cacheKey.toString());
                }
                try {
                    if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                        WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "Check if webApp is being destroyed --> " + webApp.getDestroyed());
                    }
                    if (webApp.getDestroyed().booleanValue()) {
                        if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                            WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "sending sendUnavailableException for servlet from: " + wrapper.getServletPath());
                        }
                        this.sendUnavailableException(req, res);
                    }
                    ** GOTO lbl-1000
                }
                catch (InvalidCacheTargetException ne) {
                    wrapper = null;
                    if (this.isVHostCompatFlag()) {
                        if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                            WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "Looking for vhost with key --> " + vhostKey.toString());
                        }
                        v = this.requestMapper.map(vhostKey.toString());
                    } else {
                        if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                            WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "Looking for vhost with key --> " + vhostKey.toString() + decodedReqURI);
                        }
                        v = this.requestMapper.map(vhostKey.toString() + decodedReqURI);
                    }
                    if (v == null) throw new WebGroupVHostNotFoundException(vhostKey.toString());
                    if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                        WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "request processor handling request --> " + v);
                    }
                    v.handleRequest(hreq, hres);
                    ** GOTO lbl257
                }
                catch (Throwable th) {
                    wrapper.invalidate();
                    if (isTraceOn == false) throw th;
                    if (WebContainer.logger.isLoggable(Level.FINE) == false) throw th;
                    WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "removing cache wrapper because exception was thrown and rethrowing the exception.");
                    throw th;
                }
                var24_35 = null;
                if (cacheKey != null) {
                    cacheKey.setLength(0);
                }
                if (connContext == null) ** GOTO lbl-1000
                connContext.finishConnection();
                this.releaseConnectionContext(connContext);
                connContext = null;
                ** GOTO lbl-1000
lbl-1000:
                // 1 sources

                {
                    currDispatchContext.setWebApp(webApp);
                    connContext.start();
                    contextPath = webApp.getContextPath();
                    if (contextPath == null || contextPath.equals("/")) {
                        contextPath = "";
                    }
                    servletPath = wrapper.getServletPath();
                    prePathInfoLength = contextPath.length() + servletPath.length();
                    pathInfo = decodedReqURI.substring(prePathInfoLength);
                    currDispatchContext.setRequestURI(reqURI);
                    currDispatchContext.setPathElements(servletPath, pathInfo.equals("") != false ? null : pathInfo);
                    if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                        WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "CachedServletWrapper servletPath --> " + currDispatchContext.getServletPath());
                        WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "CachedServletWrapper pathInfo --> " + currDispatchContext.getPathInfo());
                    }
                    currDispatchContext.setQueryString(((SRTServletRequest)hreq).getQueryString());
                    wrapper.handleRequest(hreq, hres);
                    ** GOTO lbl257
                }
            }
            currDispatchContext.setRequestURI(reqURI);
            currDispatchContext.setQueryString(req.getQueryString());
            if (this.isVHostCompatFlag()) {
                if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                    WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "Looking for vhost with key --> " + vhostKey.toString());
                }
                v = this.requestMapper.map(vhostKey.toString());
            } else {
                if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                    WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "Looking for vhost with key --> " + vhostKey.toString() + decodedReqURI);
                }
                v = this.requestMapper.map(vhostKey.toString() + decodedReqURI);
            }
            if (v == null) throw new WebGroupVHostNotFoundException(vhostKey.toString());
            if (isTraceOn && WebContainer.logger.isLoggable(Level.FINE)) {
                WebContainer.logger.logp(Level.FINE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "request processor handling request --> " + v);
            }
            v.handleRequest(hreq, hres);
            ** GOTO lbl257
        }
        catch (WebGroupVHostNotFoundException e) {
            res.addHeader("Content-Type", "text/html");
            res.setStatusCode(404);
            output = "<H1>" + MessageFormat.format(WebContainer.nls.getString("Web.Group.VHost.Not.Found", "WebGroup Not Found"), new Object[]{ResponseUtils.encodeDataString(req.getRequestURI())}) + "</H1><BR><H3>" + e.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
            outBytes = output.getBytes();
            res.getOutputStream().write(outBytes, 0, outBytes.length);
            WebContainer.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "Web.Group.VHost.Not.Found", new Object[]{this.truncateURI(req.getRequestURI())});
            var24_37 = null;
            if (cacheKey != null) {
                cacheKey.setLength(0);
            }
            if (connContext != null) {
                connContext.finishConnection();
                this.releaseConnectionContext(connContext);
                connContext = null;
            }
            try {
                this.secCollab.postInvoke(secObject);
                return;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.WebContainer", "183", this);
                args = new Object[]{e};
                WebContainer.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "postInvoke.Security.Exception.", args);
                return;
            }
        }
        catch (WebContainerException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.WebContainer", "134", this);
            res.addHeader("Content-Type", "text/html");
            res.setStatusCode(500);
            output = "<H1>" + WebContainer.nls.getFormattedMessage("Engine.Exception.[{0}]", new Object[]{e.getMessage()}, "Internal Server Error. <br> Exception Message: " + e.getMessage()) + "</H1><BR><H3>" + e.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
            outBytes = output.getBytes();
            res.getOutputStream().write(outBytes, 0, outBytes.length);
            args = new Object[]{e};
            WebContainer.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "Engine.Exception.[{0}]", args);
            var24_38 = null;
            if (cacheKey != null) {
                cacheKey.setLength(0);
            }
            if (connContext != null) {
                connContext.finishConnection();
                this.releaseConnectionContext(connContext);
                connContext = null;
            }
            try {}
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.WebContainer", "183", this);
                args = new Object[]{e};
                WebContainer.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "postInvoke.Security.Exception.", args);
                return;
            }
            this.secCollab.postInvoke(secObject);
            return;
        }
        catch (SecurityViolationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.WebContainer", "148", this);
            res.addHeader("Content-Type", "text/html");
            res.setStatusCode(403);
            output = "<H1>" + WebContainer.nls.getString("Forbidden.Web.Security.Exception", "Forbidden: Web Security Exception") + "</H1><BR><H3>" + e.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
            outBytes = output.getBytes();
            res.getOutputStream().write(outBytes, 0, outBytes.length);
            args = new Object[]{e};
            WebContainer.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "preInvoke.Security.Exception.", args);
            var24_39 = null;
            if (cacheKey != null) {
                cacheKey.setLength(0);
            }
            if (connContext != null) {
                connContext.finishConnection();
                this.releaseConnectionContext(connContext);
                connContext = null;
            }
            try {}
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.WebContainer", "183", this);
                args = new Object[]{e};
                WebContainer.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "postInvoke.Security.Exception.", args);
                return;
            }
            this.secCollab.postInvoke(secObject);
            return;
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, "com.ibm.ws.webcontainer.WebContainer", "162", this);
            res.addHeader("Content-Type", "text/html");
            res.setStatusCode(500);
            output = "<H1>" + WebContainer.nls.getFormattedMessage("Engine.Exception.[{0}]", new Object[]{th.getMessage()}, "Engine Exception") + "</H1><BR><H3>" + th.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
            outBytes = output.getBytes();
            res.getOutputStream().write(outBytes, 0, outBytes.length);
            args = new Object[]{th};
            WebContainer.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "Engine.Exception.[{0}]", args);
            var24_40 = null;
            if (cacheKey != null) {
                cacheKey.setLength(0);
            }
            if (connContext != null) {
                connContext.finishConnection();
                this.releaseConnectionContext(connContext);
                connContext = null;
            }
            try {}
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.WebContainer", "183", this);
                args = new Object[]{e};
                WebContainer.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "postInvoke.Security.Exception.", args);
                return;
            }
            this.secCollab.postInvoke(secObject);
            return;
        }
        {
            catch (Throwable var23_63) {
                var24_41 = null;
                if (cacheKey != null) {
                    cacheKey.setLength(0);
                }
                if (connContext != null) {
                    connContext.finishConnection();
                    this.releaseConnectionContext(connContext);
                    connContext = null;
                }
                ** try [egrp 4[TRYBLOCK] [19 : 2279->2293)] { 
lbl242:
                // 1 sources

                this.secCollab.postInvoke(secObject);
                throw var23_63;
lbl244:
                // 1 sources

                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.WebContainer", "183", this);
                    args = new Object[]{e};
                    WebContainer.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "postInvoke.Security.Exception.", args);
                }
                throw var23_63;
            }
lbl-1000:
            // 2 sources

            try {}
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.WebContainer", "183", this);
                args = new Object[]{e};
                WebContainer.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "postInvoke.Security.Exception.", args);
                return;
            }
            this.secCollab.postInvoke(secObject);
            return;
lbl257:
            // 3 sources

            var24_36 = null;
            if (cacheKey != null) {
                cacheKey.setLength(0);
            }
            if (connContext != null) {
                connContext.finishConnection();
                this.releaseConnectionContext(connContext);
                connContext = null;
            }
            try {}
            catch (Exception e) {}
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.WebContainer", "183", this);
            args = new Object[]{e};
            WebContainer.logger.logp(Level.SEVERE, "com.ibm.ws.webcontainer.WebContainer", "handleRequest", "postInvoke.Security.Exception.", args);
            return;
            this.secCollab.postInvoke(secObject);
            return;
        }
    }

    public static Properties getWebContainerProperties() {
        return webConProperties;
    }

    protected abstract SRTConnectionContext getConnectionContext();

    protected abstract void releaseConnectionContext(SRTConnectionContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToCache(HttpServletRequest req, RequestProcessor s, WebApp app) {
        if (_cacheIsFull) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addToCache", "cache is full");
            }
            return;
        }
        if (app.getDestroyed().booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addToCache", "Not caching as the webapp is destroyed");
            }
            return;
        }
        RequestProcessor requestProcessor = s;
        synchronized (requestProcessor) {
            StringBuilder cacheKey = (StringBuilder)cacheKeyStringBuilder.get();
            String cacheKeyStr = cacheKey.toString();
            if (_cacheMap.containsKey(cacheKeyStr)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addToCache", "Already cached cacheKey --> " + cacheKey);
                }
                return;
            }
            if (_cacheMap.size() < invocationCacheSize) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addToCache", "Adding to cache cacheKey --> " + cacheKey + " uri -->" + req.getRequestURI() + " servletWrapper -->" + ((IServletWrapper)s).getServletName());
                }
                CacheServletWrapper wrapper = new CacheServletWrapper((IServletWrapper)s, req, _cacheMap, cacheKey, app);
            } else {
                _cacheIsFull = true;
            }
        }
    }

    public static CacheServletWrapper getFromCache(StringBuffer key) {
        return (CacheServletWrapper)_cacheMap.get(key.toString());
    }

    public Integer getKeySize(String cipherSuite) {
        String keySize = (String)this._cipherToBit.get(cipherSuite);
        if (keySize == null || keySize.equals("") || keySize.equals("-1")) {
            return null;
        }
        return new Integer(keySize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtensionFactory(ExtensionFactory factory) {
        List l = factory.getPatternList();
        Iterator it = l.iterator();
        StringBuilder mapStr = new StringBuilder(32);
        while (it.hasNext()) {
            String mapping = (String)it.next();
            mapStr.append(mapping);
            mapStr.append(' ');
        }
        logger.logp(Level.INFO, CLASS_NAME, "addExtensionFactory", "ExtensionFactory.[{0}].registered.successfully", new Object[]{factory.getClass().toString()});
        logger.logp(Level.INFO, CLASS_NAME, "addExtensionFactory", "ExtensionFactory.[{0}].associated.with.patterns.[{1}]", new Object[]{factory.getClass().toString(), mapStr.toString()});
        if (!appInstallBegun) {
            extensionFactories.add(factory);
        } else {
            List<ExtensionFactory> list = extensionFactories;
            synchronized (list) {
                if (postInitExtensionFactories == null) {
                    postInitExtensionFactories = Collections.synchronizedList(new ArrayList());
                }
            }
            postInitExtensionFactories.add(factory);
        }
    }

    public static void addHttpServletResponseListener(IHttpServletResponseListener listener) {
        if (listener != null) {
            httpResponseListeners.add(listener);
        }
    }

    public static void notifyHttpServletResponseListenersPreHeaderCommit(HttpServletRequest request, HttpServletResponse response) {
        if (!httpResponseListeners.isEmpty()) {
            for (IHttpServletResponseListener rL : httpResponseListeners) {
                rL.preHeaderCommit(request, response);
            }
        }
    }

    public static List getApplicationListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return applicationListeners;
    }

    public static List getServletErrorListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletErrorListeners;
    }

    public static List getServletInvocationListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletInvocationListeners;
    }

    public static List getFilterInvocationListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return filterInvocationListeners;
    }

    public static List getFilterListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return filterListeners;
    }

    public static List getFilterErrorListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return filterErrorListeners;
    }

    public static List getServletContextAttributeListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletContextAttributeListeners;
    }

    public static List getServletContextListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletContextListeners;
    }

    public static List getServletRequestAttributeListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletRequestAttributeListeners;
    }

    public static List getServletRequestListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletRequestListeners;
    }

    public static List getSessionListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return sessionListeners;
    }

    public static List getSessionAttributeListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return sessionAttributeListeners;
    }

    public static List getServletListeners(boolean isSystemApp) {
        if (!listenersInitialized && !isSystemApp) {
            WebContainer.registerGlobalWebAppListeners();
        }
        return servletListeners;
    }

    public static List getExtensionFactories() {
        return extensionFactories;
    }

    protected String truncateURI(String uri) {
        if (uri.length() > 128) {
            uri = uri.substring(0, 127);
        }
        return uri;
    }

    public String getURIEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        if (!this.getPlatformHelper().isDecodeURIPlatform()) {
            this.decode = false;
        }
        this.encoding = "UTF-8";
        if (!WCCustomProperties.DECODE_URL_AS_UTF8) {
            this.encoding = ISO;
            this.decode = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getURIEncoding", "encoding -->" + this.encoding + " decode -->" + this.decode);
        }
        return this.encoding;
    }

    public boolean isEnableSecurityAtWARBoundary() {
        return false;
    }

    public boolean isEnableSecurityAtEARBoundary() {
        return false;
    }

    private PathInfoHelper removeExtraPathInfo(String pathInfo) {
        if (pathInfo == null) {
            return null;
        }
        int semicolon = pathInfo.indexOf(59);
        if (semicolon != -1) {
            String tmpPathInfo = pathInfo.substring(0, semicolon);
            String extraPathInfo = pathInfo.substring(semicolon);
            return new PathInfoHelper(tmpPathInfo, extraPathInfo);
        }
        return new PathInfoHelper(pathInfo, null);
    }

    public static Iterator getCachedServletWrapperNames() {
        Set cacheSet = _cacheMap.keySet();
        ArrayList l = new ArrayList(cacheSet);
        return l.listIterator();
    }

    protected boolean isVHostCompatFlag() {
        return this.vHostCompatFlag;
    }

    protected void setVHostCompatFlag(boolean hostCompatFlag) {
        this.vHostCompatFlag = hostCompatFlag;
    }

    public Iterator getVirtualHosts() {
        return this.getTargetMappings();
    }

    private void sendUnavailableException(IRequest req, IResponse res) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sendUnavailableException", "Inside sendUnavailableException");
        }
        res.addHeader("Content-Type", "text/html");
        res.setStatusCode(503);
        String output = "<H1>" + nls.getFormattedMessage("Servlet.has.become.temporarily.unavailable.for.service.{0}", new Object[]{this.truncateURI(req.getRequestURI())}, "Servlet has become temporarily unavailable for service") + "</H1><BR><H3>" + "</H3><BR><I>IBM WebSphere Application Server</I>";
        byte[] outBytes = output.getBytes();
        res.getOutputStream().write(outBytes, 0, outBytes.length);
        logger.logp(Level.SEVERE, CLASS_NAME, "sendUnavailableException", "Servlet.has.become.temporarily.unavailable.for.service", new Object[]{this.truncateURI(req.getRequestURI())});
    }

    public static boolean isDefaultTempDir() {
        return isDefaultTempDir;
    }

    public static void setIsDefaultTempDir(boolean isTempDir) {
        isDefaultTempDir = isTempDir;
    }

    public static String getTempDir() {
        return tempDir;
    }

    public static void setTempDir(String tempD) {
        tempDir = tempD;
    }

    public IPlatformHelper getPlatformHelper() {
        if (this.platformHelper == null) {
            this.platformHelper = new PlatformHelper();
        }
        return this.platformHelper;
    }

    protected static boolean isServletCachingInitNeeded() {
        return servletCachingInitNeeded;
    }

    public static void setServletCachingInitNeeded(boolean bool) {
        servletCachingInitNeeded = bool;
    }

    public boolean isCachingEnabled() {
        return false;
    }

    public ClassLoader getExtClassLoader() {
        return WebContainer.class.getClassLoader();
    }

    static {
        logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer");
        nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
        self = null;
        cacheKeyStringBuilder = new WSThreadLocal();
        listenersInitialized = false;
        webConProperties = new Properties();
        extensionFactories = new ArrayList<ExtensionFactory>();
        httpResponseListeners = new ArrayList();
        invocationCacheSize = 500;
        String invocationCacheSizeStr = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("invocationCacheSize");
            }
        });
        if (invocationCacheSizeStr != null) {
            try {
                invocationCacheSize = Integer.parseInt(invocationCacheSizeStr) * 10;
            }
            catch (NumberFormatException e) {
                invocationCacheSize = 500;
            }
        }
        decodePlusSign = true;
        _cacheMap = new URIToServletWrapperCache(invocationCacheSize);
        _cacheIsFull = false;
        isDefaultTempDir = false;
        tempDir = null;
        servletCachingInitNeeded = true;
        appInstallBegun = false;
    }

    private class PathInfoHelper {
        private String basePath = null;
        private String extraPathInfo = null;

        private PathInfoHelper(String pathInfo, String extraPathInfo) {
            this.basePath = pathInfo;
            this.extraPathInfo = extraPathInfo;
        }

        private String getExtraPathInfo() {
            return this.extraPathInfo;
        }

        private String getBasePath() {
            return this.basePath;
        }

        static /* synthetic */ String access$000(PathInfoHelper x0) {
            return x0.getBasePath();
        }

        static /* synthetic */ String access$100(PathInfoHelper x0) {
            return x0.getExtraPathInfo();
        }
    }
}

