/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.container.Container;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.http.Alias;
import com.ibm.ws.webcontainer.VirtualHostConfiguration;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.BaseContainer;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.exception.WebGroupVHostNotFoundException;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.ws.webcontainer.webapp.WebGroupConfiguration;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.util.URIMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public abstract class VirtualHost
extends BaseContainer {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.VirtualHost";
    protected VirtualHostConfiguration vHostConfig;

    public VirtualHost(String name, Container parent) {
        super(name, parent);
        this.requestMapper = new URIMapper();
    }

    public void init(VirtualHostConfiguration vHostConfig) {
        this.vHostConfig = vHostConfig;
    }

    public void addWebApplication(DeployedModule deployedModule, List extensionFactories, boolean production) throws WebAppNotLoadedException {
        WebGroupConfiguration wgConfig = deployedModule.getWebGroupConfig();
        WebGroup wg = deployedModule.getWebGroup();
        String contextRoot = deployedModule.getContextRoot();
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        if (contextRoot.endsWith("/") && !contextRoot.equals("/")) {
            contextRoot = contextRoot.substring(0, contextRoot.length() - 1);
        }
        String ct = contextRoot;
        contextRoot = contextRoot.equals("/") ? contextRoot + "*" : contextRoot + "/*";
        String displayName = deployedModule.getDisplayName();
        WebGroup webGroup = null;
        webGroup = (WebGroup)this.requestMapper.map(contextRoot);
        if (webGroup != null && ct.equalsIgnoreCase(webGroup.getConfiguration().getContextRoot())) {
            ArrayList list = webGroup.getWebApps();
            String originalName = "";
            if (list != null && list.size() > 0) {
                WebApp originalWebApp = (WebApp)list.get(0);
                originalName = originalWebApp.getWebAppName();
            }
            logger.logp(Level.SEVERE, CLASS_NAME, "addWebApplication", "context.root.already.in.use", new Object[]{displayName, contextRoot, originalName, displayName});
            throw new WebAppNotLoadedException("Context root " + contextRoot + " is already bound. Cannot start application " + displayName);
        }
        webGroup = wg;
        this.setWebAppVirtualHostList(deployedModule.getWebAppConfig());
        wgConfig.setWebAppHost(this);
        webGroup.initialize(wgConfig);
        try {
            this.addMapping(contextRoot, webGroup);
        }
        catch (Exception exc) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addWebApplication", "error adding mapping ", exc);
            }
            webGroup.destroy();
            throw new WebAppNotLoadedException("Context root " + contextRoot + " mapping unable to be bound. Application " + displayName + " unavailable.", exc);
        }
        try {
            webGroup.addWebApplication(deployedModule, extensionFactories, production);
            Object[] args = new Object[]{displayName, this.vHostConfig.toString()};
            logger.logp(Level.INFO, CLASS_NAME, "addWebApplication", "module.[{0}].successfully.bound.to.virtualhost.[{1}]", args);
        }
        catch (Throwable t) {
            this.removeMapping(contextRoot);
            throw new WebAppNotLoadedException(t.getMessage(), t);
        }
    }

    protected void setWebAppVirtualHostList(WebAppConfiguration config2) {
        Alias[] aliases = this.vHostConfig.getAliases();
        List virtualHostList = config2.getVirtualHostList();
        for (int i = 0; i < aliases.length; ++i) {
            String hostName = aliases[i].getHostname();
            String port = aliases[i].getPort();
            virtualHostList.add(hostName + ":" + port);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setWebAppVirtualHostList", "virtualHostList -->" + virtualHostList);
        }
    }

    public String getMimeType(String withDot, String withoutDot) {
        String type = this.vHostConfig.getMimeType(withoutDot);
        if (type == null) {
            type = this.vHostConfig.getMimeType(withDot);
        }
        return type;
    }

    public IHttpSessionContext getSessionContext(DeployedModule moduleConfig, WebApp webApp, ArrayList[] listeners) throws Throwable {
        return ((WebContainer)this.parent).getSessionContext(moduleConfig, webApp, this.vHostConfig.getName(), listeners);
    }

    public ServletContext findContext(String path) {
        WebGroup g = (WebGroup)this.requestMapper.map(path);
        if (g != null) {
            return g.getContext();
        }
        return null;
    }

    public synchronized void destroy() {
        super.destroy();
        this.requestMapper = null;
        this.vHostConfig = null;
    }

    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)((IExtendedRequest)req).getWebAppDispatcherContext();
        String reqURI = dispatchContext.getDecodedReqUri();
        RequestProcessor g = this.requestMapper.map(reqURI);
        if (g == null) {
            throw new WebGroupVHostNotFoundException(reqURI);
        }
        g.handleRequest(req, res);
    }

    public void removeWebApplication(DeployedModule deployedModule) {
        String contextRoot = deployedModule.getContextRoot();
        this.removeWebApplication(deployedModule, contextRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebApplication(DeployedModule deployedModule, String contextRoot) {
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        if (contextRoot.endsWith("/") && !contextRoot.equals("/")) {
            contextRoot = contextRoot.substring(0, contextRoot.length() - 1);
        }
        WebGroup webGroup = null;
        if (this.requestMapper != null) {
            VirtualHost virtualHost = this;
            synchronized (virtualHost) {
                if (this.requestMapper != null) {
                    webGroup = (WebGroup)this.requestMapper.map(contextRoot);
                    this.removeMapping(contextRoot.equals("/") ? contextRoot + "*" : contextRoot + "/*");
                }
            }
        }
        if (webGroup != null) {
            this.removeMapping(contextRoot.equals("/") ? contextRoot + "*" : contextRoot + "/*");
            webGroup.removeWebApplication(deployedModule);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "removeWebApplication", "name: " + webGroup.getName());
            }
            this.removeSubContainer(webGroup.getName());
        }
    }

    protected void addMapping(String contextRoot, WebGroup group) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addMapping", " contextRoot -->" + contextRoot + " group -->" + group.getName());
        }
        this.requestMapper.addMapping(contextRoot, group);
    }

    protected void removeMapping(String contextRoot) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeMapping", " contextRoot -->" + contextRoot);
        }
        this.requestMapper.removeMapping(contextRoot);
    }
}

