/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util.lock;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class WriterPriorityReadersWriterLock {
    private static final TraceComponent tc = Tr.register(WriterPriorityReadersWriterLock.class, null, null);
    private int nr = 0;
    private int nw = 0;
    private int nrtotal = 0;
    private int nwtotal = 0;

    public synchronized void startReading() throws InterruptedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startReading", this);
        }
        ++this.nrtotal;
        while (this.nwtotal != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Have to wait for a writer");
            }
            this.wait();
        }
        ++this.nr;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startReading");
        }
    }

    public synchronized boolean attemptReading(long msecs) throws InterruptedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attemptReading", new Object[]{new Long(msecs), this});
        }
        if (msecs < 0L) {
            this.startReading();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "attemptReading", Boolean.TRUE);
            }
            return true;
        }
        boolean result = true;
        ++this.nrtotal;
        long startTime = System.currentTimeMillis();
        while (this.nwtotal != 0 && msecs > 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Have to wait for a writer");
            }
            this.wait(msecs);
            msecs -= System.currentTimeMillis() - startTime;
            result = this.nwtotal == 0;
        }
        if (result) {
            ++this.nr;
        } else {
            --this.nrtotal;
            this.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attemptReading", new Boolean(result));
        }
        return result;
    }

    public synchronized void startWriting() throws InterruptedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startWriting", this);
        }
        ++this.nwtotal;
        while (this.nr + this.nw != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Have to wait for a reader");
            }
            this.wait();
        }
        this.nw = 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startWriting");
        }
    }

    public synchronized boolean attemptWriting(long msecs) throws InterruptedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attemptWriting", new Object[]{new Long(msecs), this});
        }
        if (msecs < 0L) {
            this.startWriting();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "attemptWriting", Boolean.TRUE);
            }
            return true;
        }
        ++this.nwtotal;
        boolean result = true;
        long startTime = System.currentTimeMillis();
        while (this.nr + this.nw != 0 && msecs > 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Have to wait for a reader");
            }
            this.wait(msecs);
            msecs -= System.currentTimeMillis() - startTime;
            result = this.nr + this.nw == 0;
        }
        if (result) {
            this.nw = 1;
        } else {
            --this.nwtotal;
            this.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attemptWriting", new Boolean(result));
        }
        return result;
    }

    public synchronized void stopReading() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopReading", this);
        }
        --this.nr;
        --this.nrtotal;
        if (this.nr == 0) {
            this.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopReading");
        }
    }

    public synchronized void stopWriting() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopWriting", this);
        }
        this.nw = 0;
        --this.nwtotal;
        this.notifyAll();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopWriting");
        }
    }

    public synchronized boolean hasReaderOrWriter() {
        boolean hasReaderOrWriter;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasReaderOrWriter", this);
        }
        boolean bl = hasReaderOrWriter = this.nrtotal + this.nwtotal != 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasReaderOrWriter", new Boolean(hasReaderOrWriter));
        }
        return hasReaderOrWriter;
    }
}

