/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class FileProps {
    protected String fileName = null;
    protected String header = null;
    protected ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.ws.util.config.wsinstance", Locale.getDefault());

    public FileProps(String fileName) {
        this(fileName, "");
    }

    public FileProps(String fileName, String header) {
        this.fileName = fileName;
        this.header = header;
    }

    void add(String key, String value) throws Exception {
        Properties prop = this.getProperties();
        if (prop.get(key) != null || prop.contains(value)) {
            throw new RuntimeException(this.bundle.getString("instancealready"));
        }
        prop.put(key, value);
        this.saveToFile(prop, this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getProperties() throws Exception {
        Properties prop = new Properties();
        File f = null;
        FileInputStream fin = null;
        try {
            f = new File(this.fileName);
            if (!f.exists()) {
                f.createNewFile();
            }
            fin = new FileInputStream(this.fileName);
            prop.load(fin);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fin.close();
            throw throwable;
        }
        fin.close();
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void remove(String name) throws Exception {
        File f = null;
        FileInputStream fin = null;
        try {
            f = new File(this.fileName);
            if (!f.exists()) {
                throw new RuntimeException(this.bundle.getString("instancenotpresent"));
            }
            fin = new FileInputStream(this.fileName);
            Properties prop = new Properties();
            prop.load(fin);
            if (prop.get(name) == null) {
                throw new RuntimeException(this.bundle.getString("instancenotpresent"));
            }
            prop.remove(name);
            this.saveToFile(prop, this.fileName);
            Object var6_5 = null;
            if (fin == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fin == null) throw throwable;
            fin.close();
            throw throwable;
        }
        fin.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveToFile(Properties props, String outputFile) throws Exception {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(outputFile);
            props.store(fout, this.header);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fout.close();
            throw throwable;
        }
        fout.close();
    }

    void throwError() {
        throw new RuntimeException();
    }

    private void processArgs(String[] args) throws Exception {
        if (args.length < 1) {
            this.throwError();
        }
        if (args[1].equalsIgnoreCase("add")) {
            if (args.length < 4) {
                this.throwError();
            }
            this.add(args[2], args[3]);
        } else if (args[1].equalsIgnoreCase("delete")) {
            if (args.length < 3) {
                this.throwError();
            }
            this.remove(args[2]);
        } else {
            this.throwError();
        }
    }

    public static void main(String[] args) throws Exception {
        FileProps props = new FileProps(args[0]);
        props.processArgs(args);
    }
}

