/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class WSUtil {
    private static char[] INVALID_MBEAN_CHARS = new char[]{':', '\"', ',', '=', '*', '?'};

    public static String convertToMbeanCompliantString(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s);
        int len = sb.length();
        block0: for (int i = 0; i < len; ++i) {
            char curChar = sb.charAt(i);
            for (int c = 0; c < INVALID_MBEAN_CHARS.length; ++c) {
                if (INVALID_MBEAN_CHARS[c] != curChar) continue;
                sb.setCharAt(i, '.');
                continue block0;
            }
        }
        return sb.toString();
    }

    public static String resolveURI(String uriToResolve) {
        int qindex = Integer.MAX_VALUE;
        String qstring = null;
        boolean parsedQuery = false;
        if (uriToResolve.indexOf(92) != -1) {
            parsedQuery = true;
            int tmpindex = -1;
            tmpindex = uriToResolve.indexOf(63);
            if (tmpindex != -1) {
                qindex = tmpindex;
                qstring = uriToResolve.substring(qindex);
                if ((uriToResolve = uriToResolve.substring(0, qindex)) == null || uriToResolve.equals("")) {
                    return qstring;
                }
            }
            uriToResolve = uriToResolve.replace('\\', '/');
        }
        int tmpIndex = -1;
        int testIndex = -1;
        int resolveIndex = Integer.MAX_VALUE;
        testIndex = uriToResolve.indexOf("/.");
        if (testIndex != -1) {
            tmpIndex = uriToResolve.indexOf("/../", testIndex);
            if (tmpIndex != -1) {
                int n = resolveIndex = resolveIndex < tmpIndex ? resolveIndex : tmpIndex;
            }
            if ((tmpIndex = uriToResolve.indexOf("/./", testIndex)) != -1) {
                int n = resolveIndex = resolveIndex < tmpIndex ? resolveIndex : tmpIndex;
            }
        }
        if ((tmpIndex = uriToResolve.indexOf("//")) != -1) {
            int n = resolveIndex = resolveIndex < tmpIndex ? resolveIndex : tmpIndex;
        }
        if (!parsedQuery) {
            if (resolveIndex == Integer.MAX_VALUE) {
                return uriToResolve;
            }
            qindex = uriToResolve.indexOf(63);
            if (qindex != -1) {
                qstring = uriToResolve.substring(qindex);
                if ((uriToResolve = uriToResolve.substring(0, qindex)) == null || uriToResolve.equals("")) {
                    return qstring;
                }
                if (qindex <= resolveIndex) {
                    return uriToResolve + qstring;
                }
            }
        } else if (qindex <= resolveIndex) {
            if (qstring == null) {
                return uriToResolve;
            }
            return uriToResolve + qstring;
        }
        StringTokenizer uriParser = new StringTokenizer(uriToResolve, "/", false);
        String currentElement = null;
        boolean tokenCount = false;
        ArrayList<String> uriElements = new ArrayList<String>();
        while (uriParser.hasMoreTokens()) {
            currentElement = uriParser.nextToken();
            if (currentElement == null || currentElement.length() < 1) continue;
            if (currentElement.equals("..")) {
                if (uriElements.size() < 1) {
                    throw new IllegalArgumentException(uriToResolve);
                }
                uriElements.remove(uriElements.size() - 1);
                continue;
            }
            if (currentElement.equals(".")) continue;
            uriElements.add(currentElement);
        }
        StringBuffer resolvedURI = new StringBuffer();
        int elementCount = uriElements.size();
        for (int elementIndex = 0; elementIndex < elementCount; ++elementIndex) {
            resolvedURI.append("/" + (String)uriElements.get(elementIndex));
        }
        if (qstring == null) {
            return resolvedURI.toString();
        }
        return resolvedURI.toString() + qstring;
    }

    public static void main(String[] args) {
        String question = "/hello\\\\there\\////dog?queryString=5";
        System.out.println(question + ": resolvedURI = [" + WSUtil.resolveURI(question) + "]");
        String question2 = "/hello/../dog/";
        System.out.println(question2 + ": resolvedURI = [" + WSUtil.resolveURI(question2) + "]");
        String question3 = "/hello/./dog/";
        System.out.println(question3 + ": resolvedURI = [" + WSUtil.resolveURI(question3) + "]");
        String question4 = "/hello//dog/";
        System.out.println(question4 + ": resolvedURI = [" + WSUtil.resolveURI(question4) + "]");
        String question5 = "/hello//dog/?hello=/../5";
        System.out.println(question5 + ": resolvedURI = [" + WSUtil.resolveURI(question5) + "]");
        String question6 = "/hello/dog/?hello=/../5";
        System.out.println(question6 + ": resolvedURI = [" + WSUtil.resolveURI(question6) + "]");
        String question7 = "?hello=/../5";
        System.out.println(question7 + ": resolvedURI = [" + WSUtil.resolveURI(question7) + "]");
        String question8 = "todd?hello=\\string";
        System.out.println(question8 + ": resolvedURI = [" + WSUtil.resolveURI(question8) + "]");
        String question9 = "?";
        System.out.println(question9 + ": resolvedURI = [" + WSUtil.resolveURI(question9) + "]");
        String question10 = "/servlet/snoop";
        System.out.println(question10 + ": resolvedURI = [" + WSUtil.resolveURI(question10) + "]");
        String question11 = "\\servlet\\snoop";
        System.out.println(question11 + ": resolvedURI = [" + WSUtil.resolveURI(question11) + "]");
        String question12 = "\\";
        System.out.println(question12 + ": resolvedURI = [" + WSUtil.resolveURI(question12) + "]");
    }
}

