/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.jpa.JPAPuId;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.persistence.PersistenceProperty;

public class JPAJndiLookupInfo
implements Serializable {
    private static final long serialVersionUID = 4608505288422385364L;
    private JPAPuId ivPuId;
    private J2EEName ivJ2eeName;
    private String ivRefName;
    private boolean ivIsFactory;
    private boolean ivIsExtendedContextType;
    private Properties ivProperties;
    private boolean ivIsSFSB;

    public JPAJndiLookupInfo(JPAPuId puId, boolean isSFSB) {
        this(puId, null, null, true, false, null);
        this.ivIsSFSB = isSFSB;
    }

    public JPAJndiLookupInfo(JPAPuId puId, J2EEName j2eeName, String refName, boolean isSFSB) {
        this(puId, j2eeName, refName, true, false, null);
        this.ivIsSFSB = isSFSB;
    }

    public JPAJndiLookupInfo(JPAPuId puId, J2EEName j2eeName, String refName, boolean isExtendedContextType, PersistenceProperty[] properties) {
        this(puId, j2eeName, refName, false, isExtendedContextType, properties);
    }

    private JPAJndiLookupInfo(JPAPuId puId, J2EEName j2eeName, String refName, boolean isFactory, boolean isExtendedContextType, PersistenceProperty[] pProperties) {
        this.ivPuId = puId;
        this.ivJ2eeName = j2eeName;
        this.ivRefName = refName;
        this.ivIsFactory = isFactory;
        this.ivIsExtendedContextType = isExtendedContextType;
        this.ivIsSFSB = false;
        this.ivProperties = null;
        if (pProperties != null && pProperties.length > 0) {
            this.ivProperties = new Properties();
            for (PersistenceProperty pProperty : pProperties) {
                this.ivProperties.put(pProperty.name(), pProperty.value());
            }
        }
    }

    public JPAPuId getPuId() {
        return this.ivPuId;
    }

    public J2EEName getJ2EEName() {
        return this.ivJ2eeName;
    }

    public String getReferenceName() {
        return this.ivRefName;
    }

    public boolean isFactory() {
        return this.ivIsFactory;
    }

    public boolean isExtendedContextType() {
        return this.ivIsExtendedContextType;
    }

    public Map getPersistenceProperties() {
        return this.ivProperties;
    }

    public boolean isSFSB() {
        return this.ivIsSFSB;
    }

    public String toString() {
        return this.ivPuId + ", " + this.ivJ2eeName + "#" + this.ivRefName + ", isFactory=" + this.ivIsFactory + ", isSFSB=" + this.ivIsSFSB + ", " + (this.ivIsFactory ? "" : "PersistenceContextType=" + (this.ivIsExtendedContextType ? "Extended" : "Transaction")) + ", properties=" + (this.ivProperties == null ? "[]" : this.ivProperties);
    }
}

