/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.util.DebugServerSocket;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class DebugInputStream
extends FilterInputStream {
    private static final byte[] eof = "EOF".getBytes();
    private OutputStream traceOs = null;
    private byte[] prefix;

    public DebugInputStream(InputStream is, OutputStream traceOs) {
        super(is);
        this.traceOs = traceOs;
        this.prefix = "(input)".getBytes();
    }

    public int read() throws IOException {
        int ch = super.read();
        this.traceOs.write(this.prefix);
        if (ch < 0) {
            this.traceOs.write(eof);
        } else {
            this.traceOs.write(ch);
        }
        this.traceOs.write(DebugServerSocket.NL);
        return ch;
    }

    public int read(byte[] buf) throws IOException {
        int rtn = super.read(buf);
        this.traceOs.write(this.prefix);
        if (rtn < 0) {
            this.traceOs.write(eof);
        } else {
            this.traceOs.write(buf, 0, rtn);
        }
        this.traceOs.write(DebugServerSocket.NL);
        return rtn;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int rtn = super.read(buf, off, len);
        this.traceOs.write(this.prefix);
        if (rtn < 0) {
            this.traceOs.write(eof);
        } else {
            this.traceOs.write(buf, off, rtn);
        }
        this.traceOs.write(DebugServerSocket.NL);
        return rtn;
    }

    public void close() throws IOException {
        super.close();
        this.traceOs.flush();
    }
}

