/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ffdc.Manager;
import com.ibm.ws.util.CaptureSocket;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class CaptureServerSocket
extends ServerSocket {
    private boolean captureOutput = false;
    private int count = -1;
    private ObjectOutputStream capturedOs = null;

    public CaptureServerSocket(int port, int backlog, InetAddress addr, String captureFile, boolean captureOutput) throws IOException {
        super(port, backlog, addr);
        this.captureOutput = captureOutput;
        this.capturedOs = new ObjectOutputStream(new FileOutputStream(captureFile));
        System.out.println("writing captured socket data to " + captureFile + " ...");
    }

    public synchronized Socket accept() throws IOException {
        CaptureSocket cs = new CaptureSocket(this.capturedOs, ++this.count, this.captureOutput);
        super.implAccept(cs);
        System.out.println("accepted connection " + this.count);
        try {
            cs.capture();
        }
        catch (SocketException se) {
            Manager.Ffdc.log(se, this, "com.ibm.ws.util.CaptureServerSocket.accept", "45", this);
            se.printStackTrace();
            throw new IOException("unable to capture socket: " + se.getMessage());
        }
        return cs;
    }

    public void close() throws IOException {
        super.close();
        this.capturedOs.close();
    }
}

