/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class Base64 {
    private static final TraceComponent tc;
    private static final char[] TOKENS;
    private static final char PAD_TOKEN = '=';
    private static final int TOKEN_MIN = 0;
    private static final int TOKEN_MAX = 127;
    private static final byte INVALID_TOKEN_VALUE = -1;
    private static final byte[] TOKEN_VALUES;

    private Base64() {
    }

    public static String encode(byte[] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encode", data);
        }
        String result = Base64.encode(data, 0, data.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encode", result);
        }
        return result;
    }

    public static void encode(byte[] data, Writer writer) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encode", new Object[]{data, writer});
        }
        Base64.encode(data, 0, data.length, writer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encode");
        }
    }

    public static void encode(byte[] data, int offset, int length, Writer writer) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encode", new Object[]{data, new Integer(offset), new Integer(length), writer});
        }
        writer.write(Base64.encode(data, offset, length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encode");
        }
    }

    public static void encode(byte[] data, OutputStream outputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encode", new Object[]{data, outputStream});
        }
        Base64.encode(data, 0, data.length, outputStream);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encode");
        }
    }

    public static void encode(byte[] data, int offset, int length, OutputStream outputStream) throws IOException {
        int remainder;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encode", new Object[]{data, new Integer(offset), new Integer(length), outputStream});
        }
        int resultSize = ((remainder = length % 3) == 0 ? length : length + 3 - remainder) / 3 * 4;
        int groupIndex = 0;
        byte previousByte = 0;
        byte[] encoded = new byte[resultSize];
        int index = 0;
        for (int i = offset; i < length; ++i) {
            byte currentByte = data[i];
            switch (groupIndex) {
                case 0: {
                    encoded[index++] = (byte)TOKENS[(currentByte & 0xFC) >> 2];
                    groupIndex = 1;
                    break;
                }
                case 1: {
                    encoded[index++] = (byte)TOKENS[(previousByte & 3) << 4 | (currentByte & 0xF0) >> 4];
                    groupIndex = 2;
                    break;
                }
                case 2: {
                    encoded[index++] = (byte)TOKENS[(previousByte & 0xF) << 2 | (currentByte & 0xC0) >> 6];
                    encoded[index++] = (byte)TOKENS[currentByte & 0x3F];
                    groupIndex = 0;
                }
            }
            previousByte = currentByte;
        }
        switch (groupIndex) {
            case 1: {
                encoded[index++] = (byte)TOKENS[(previousByte & 3) << 4];
                encoded[index++] = 61;
                encoded[index++] = 61;
                break;
            }
            case 2: {
                encoded[index++] = (byte)TOKENS[(previousByte & 0xF) << 2];
                encoded[index++] = 61;
            }
        }
        outputStream.write(encoded);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encode");
        }
    }

    public static String encode(byte[] data, int offset, int length) {
        int remainder;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encode", new Object[]{data, new Integer(offset), new Integer(length)});
        }
        int resultSize = ((remainder = length % 3) == 0 ? length : length + 3 - remainder) / 3 * 4;
        StringBuffer resultBuff = new StringBuffer(resultSize);
        int groupIndex = 0;
        int previousByte = 0;
        for (int i = offset; i < length; ++i) {
            int currentByte = data[i];
            switch (groupIndex) {
                case 0: {
                    resultBuff.append(TOKENS[(currentByte & 0xFC) >> 2]);
                    groupIndex = 1;
                    break;
                }
                case 1: {
                    resultBuff.append(TOKENS[(previousByte & 3) << 4 | (currentByte & 0xF0) >> 4]);
                    groupIndex = 2;
                    break;
                }
                case 2: {
                    resultBuff.append(TOKENS[(previousByte & 0xF) << 2 | (currentByte & 0xC0) >> 6]);
                    resultBuff.append(TOKENS[currentByte & 0x3F]);
                    groupIndex = 0;
                }
            }
            previousByte = currentByte;
        }
        switch (groupIndex) {
            case 1: {
                resultBuff.append(TOKENS[(previousByte & 3) << 4]);
                resultBuff.append('=');
                resultBuff.append('=');
                break;
            }
            case 2: {
                resultBuff.append(TOKENS[(previousByte & 0xF) << 2]);
                resultBuff.append('=');
            }
        }
        String result = resultBuff.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encode", result);
        }
        return result;
    }

    public static void encode(InputStream in, Writer out) throws IOException {
        int currentByte;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encode", new Object[]{in, out});
        }
        int groupIndex = 0;
        int previousByte = 0;
        while ((currentByte = in.read()) != -1) {
            switch (groupIndex) {
                case 0: {
                    out.write(TOKENS[(currentByte & 0xFC) >> 2]);
                    groupIndex = 1;
                    break;
                }
                case 1: {
                    out.write(TOKENS[(previousByte & 3) << 4 | (currentByte & 0xF0) >> 4]);
                    groupIndex = 2;
                    break;
                }
                case 2: {
                    out.write(TOKENS[(previousByte & 0xF) << 2 | (currentByte & 0xC0) >> 6]);
                    out.write(TOKENS[currentByte & 0x3F]);
                    groupIndex = 0;
                }
            }
            previousByte = currentByte;
        }
        switch (groupIndex) {
            case 1: {
                out.write(TOKENS[(previousByte & 3) << 4]);
                out.write(61);
                out.write(61);
                break;
            }
            case 2: {
                out.write(TOKENS[(previousByte & 0xF) << 2]);
                out.write(61);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encode");
        }
    }

    public static byte[] decode(String data) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decode", data);
        }
        byte[] result = Base64.decode(data, 0, data.length());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decode", result);
        }
        return result;
    }

    public static byte[] decode(char[] data) {
        return Base64.decode(data, 0, data.length);
    }

    public static byte[] decode(char[] data, int offset, int length) {
        byte[] decoded;
        byte[] result = new byte[length / 4 * 3];
        int index = 0;
        int groupIndex = 0;
        byte previousTokenValue = 0;
        boolean padTokenFound = false;
        for (int i = offset; i < length; ++i) {
            byte currentTokenValue;
            char token = data[i];
            if (token == '=') {
                if (groupIndex < 2) {
                    throw new IllegalArgumentException();
                }
                padTokenFound = true;
                break;
            }
            if (token < '\u0000' || token > '\u007f' || (currentTokenValue = TOKEN_VALUES[token]) == -1) continue;
            switch (groupIndex) {
                case 0: {
                    groupIndex = 1;
                    break;
                }
                case 1: {
                    result[index++] = (byte)(previousTokenValue << 2 | (currentTokenValue & 0x30) >> 4);
                    groupIndex = 2;
                    break;
                }
                case 2: {
                    result[index++] = (byte)((previousTokenValue & 0xF) << 4 | (currentTokenValue & 0x3C) >> 2);
                    groupIndex = 3;
                    break;
                }
                case 3: {
                    result[index++] = (byte)((previousTokenValue & 3) << 6 | currentTokenValue);
                    groupIndex = 0;
                }
            }
            previousTokenValue = currentTokenValue;
        }
        if (!padTokenFound && groupIndex != 0) {
            throw new IllegalArgumentException();
        }
        if (index < result.length) {
            decoded = new byte[index];
            System.arraycopy(result, 0, decoded, 0, decoded.length);
        } else {
            decoded = result;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decode", decoded);
        }
        return decoded;
    }

    public static byte[] decode(String data, int offset, int length) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decode", new Object[]{data, new Integer(offset), new Integer(length)});
        }
        byte[] decoded = Base64.decode(data.toCharArray(), offset, length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decode", decoded);
        }
        return decoded;
    }

    public static void decode(char[] data, OutputStream outputStream) throws IOException, IllegalArgumentException {
        Base64.decode(data, 0, data.length, outputStream);
    }

    public static void decode(char[] data, int offset, int length, OutputStream outputStream) throws IOException, IllegalArgumentException {
        outputStream.write(Base64.decode(data, offset, length));
    }

    public static void decode(String data, OutputStream outputStream) throws IOException, IllegalArgumentException {
        Base64.decode(data.toCharArray(), outputStream);
    }

    public static void decode(Reader in, OutputStream outputStream) throws IOException, IllegalArgumentException {
        int token;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decode", new Object[]{in, outputStream});
        }
        int groupIndex = 0;
        byte previousTokenValue = 0;
        boolean padTokenFound = false;
        while ((token = in.read()) != -1) {
            byte currentTokenValue;
            if (token == 61) {
                if (groupIndex < 2) {
                    throw new IllegalArgumentException();
                }
                padTokenFound = true;
                break;
            }
            if (token < 0 || token > 127 || (currentTokenValue = TOKEN_VALUES[token]) == -1) continue;
            switch (groupIndex) {
                case 0: {
                    groupIndex = 1;
                    break;
                }
                case 1: {
                    outputStream.write(previousTokenValue << 2 | (currentTokenValue & 0x30) >> 4);
                    groupIndex = 2;
                    break;
                }
                case 2: {
                    outputStream.write((previousTokenValue & 0xF) << 4 | (currentTokenValue & 0x3C) >> 2);
                    groupIndex = 3;
                    break;
                }
                case 3: {
                    outputStream.write((previousTokenValue & 3) << 6 | currentTokenValue);
                    groupIndex = 0;
                }
            }
            previousTokenValue = currentTokenValue;
        }
        if (!padTokenFound && groupIndex != 0) {
            throw new IllegalArgumentException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decode");
        }
    }

    static {
        int i;
        tc = Tr.register(Base64.class, null, null);
        TOKENS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        TOKEN_VALUES = new byte[128];
        for (i = 0; i < TOKEN_VALUES.length; ++i) {
            Base64.TOKEN_VALUES[i] = -1;
        }
        for (i = 0; i < TOKENS.length; ++i) {
            Base64.TOKEN_VALUES[Base64.TOKENS[i]] = (byte)i;
        }
    }
}

