/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import com.ibm.ws.ssl.provider.IBMJSSEProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Security;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class DefaultJSSEProvider
extends AbstractJSSEProvider
implements JSSEProvider {
    HostnameVerifier verifier = null;
    private String keyManager = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
    private String trustManager = JSSEProviderFactory.getTrustManagerFactoryAlgorithm();
    private String contextProvider = "IBMJSSE2";
    private String keyStoreProvider = "IBMJCE";
    private String socketFactory = "com.ibm.websphere.ssl.protocol.SSLSocketFactory";
    private String protocolPackageHandler = "com.ibm.net.ssl.www2.protocol";
    private static TraceComponent tc = Tr.register(IBMJSSEProvider.class.getName(), "SSL");

    public DefaultJSSEProvider() {
        this.initializeHandlers(this.protocolPackageHandler);
    }

    public String getDefaultSSLSocketFactoryClass() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDefaultSSLSocketFactoryClass: default");
        }
        return System.getProperty("ssl.SocketFactory.provider");
    }

    public String getSSLProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }

    public SSLContext getSSLContextInstance(SSLConfig config2) throws SSLException {
        return super.getSSLContextInstance(config2);
    }

    public TrustManagerFactory getTrustManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        this.trustManager = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("ssl.TrustManagerFactory.algorithm");
            }
        });
        if (this.trustManager == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No trustManager algorithm for property ssl.TrustManagerFactory.algorithm.");
            }
            throw new NoSuchAlgorithmException("No keyManager algorithm for property ssl.KeyManagerFactory.algorithm.");
        }
        if (Security.getProviders() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No providers configured in java.security.");
            }
            throw new NoSuchProviderException("No providers configured in java.security.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "return TrustManagerFactory.getInstance(" + this.trustManager + ")");
        }
        return TrustManagerFactory.getInstance(this.trustManager);
    }

    public KeyManagerFactory getKeyManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        this.keyManager = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("ssl.KeyManagerFactory.algorithm");
            }
        });
        if (this.keyManager == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No keyManager algorithm for property ssl.KeyManagerFactory.algorithm.");
            }
            throw new NoSuchAlgorithmException("No keyManager algorithm for property ssl.KeyManagerFactory.algorithm.");
        }
        if (Security.getProviders() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No providers configured in java.security.");
            }
            throw new NoSuchProviderException("No providers configured in java.security.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "return KeyManagerFactory.getInstance(" + this.keyManager + ")");
        }
        return KeyManagerFactory.getInstance(this.keyManager);
    }

    public KeyStore getKeyStoreInstance(String type, String provider) throws KeyStoreException, NoSuchProviderException {
        if (provider == null) {
            provider = this.keyStoreProvider;
        }
        return super.getKeyStoreInstance(type, provider);
    }

    public String getKeyManager() {
        return this.keyManager;
    }

    public String getTrustManager() {
        return this.trustManager;
    }

    public String getContextProvider() {
        return this.contextProvider;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public String getProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }
}

