/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ffdc.Manager;
import com.ibm.ws.ssl.config.CertificateManager;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.core.SignerPromptPanel;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.ssl.TrustManagerExtendedInfo;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class WSX509TrustManager
implements X509TrustManager {
    private TrustManager[] tm = null;
    private KeyStore ts = null;
    private String tsPw = null;
    private String tsFile = null;
    private String tsPass = null;
    private Map extendedInfo = null;
    private String peerHost = null;
    private SSLConfig config = null;
    private ArrayList signersAdded = new ArrayList();
    private ArrayList messagesPrinted = new ArrayList();
    private Class trustEvaluatorClass = null;
    private Object trustedIDEvaluatorObject = null;
    private Method mutualAuthCBINDCheckMethod = null;
    boolean isDoubleByteSystem = false;
    boolean skipDefaultTMIfCustomTMDefined = false;
    public static final int MAX_MSG_LEN = 79;
    public static final String INDENT = "           ";
    private static final TraceComponent tc = Tr.register(WSX509TrustManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static final TimerAlarm timer = new TimerAlarm();
    private static final String TRUST_EVALUATOR_CLASS_NAME = "com.ibm.ws.security.zOS.TrustedIDEvaluatorImpl";

    public WSX509TrustManager(TrustManager[] tmArray, Map connectionInfo, SSLConfig sslConfig, KeyStore trustStore, String trustStoreFilename, String trustStorePassword) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSX509TrustManager", new Object[]{connectionInfo, trustStoreFilename});
        }
        this.tm = tmArray;
        this.ts = trustStore;
        this.tsFile = trustStoreFilename;
        this.tsPass = trustStorePassword;
        this.config = sslConfig;
        this.extendedInfo = connectionInfo;
        String skip = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.skipDefaultTrustManagerWhenCustomDefined");
        if (skip != null && skip.equalsIgnoreCase("true")) {
            this.skipDefaultTMIfCustomTMDefined = true;
        }
        if (this.extendedInfo != null) {
            this.peerHost = (String)this.extendedInfo.get("com.ibm.ssl.remoteHost");
            for (int i = 0; i < tmArray.length; ++i) {
                if (tmArray[i] == null || !(tmArray[i] instanceof TrustManagerExtendedInfo)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding extended info to TrustManager " + tmArray[i].getClass().getName());
                }
                ((TrustManagerExtendedInfo)((Object)tmArray[i])).setExtendedInfo(this.extendedInfo);
                ((TrustManagerExtendedInfo)((Object)tmArray[i])).setSSLConfig(sslConfig);
            }
        }
        if (PlatformHelperFactory.getPlatformHelper().isZOS() && !PlatformHelperFactory.getPlatformHelper().isClientJvm()) {
            try {
                this.trustEvaluatorClass = Class.forName(TRUST_EVALUATOR_CLASS_NAME);
                this.trustedIDEvaluatorObject = this.trustEvaluatorClass.newInstance();
                this.mutualAuthCBINDCheckMethod = this.trustEvaluatorClass.getMethod("mutualAuthCBINDCheck", X509Certificate[].class);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No class, object, or method found for CBIND check", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.core.WSX509TrustManager.WSX509TrustManager", "150", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSX509TrustManager");
        }
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        block25: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkClientTrusted");
            }
            try {
                if (tc.isDebugEnabled()) {
                    for (int j = 0; j < chain.length; ++j) {
                        Tr.debug(tc, "chain[" + j + "]: " + chain[j].getSubjectDN());
                    }
                }
                if (this.isCertificateAuthenticationDisabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Certificate authentication is temporarily disabled due to configuration change.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkClientTrusted");
                    }
                    return;
                }
                for (int i = 0; i < this.tm.length; ++i) {
                    if (this.tm[i] == null || !(this.tm[i] instanceof X509TrustManager)) continue;
                    if (this.skipDefaultTMIfCustomTMDefined && i == 0 && this.tm.length > 1) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping default trust manager name: " + this.tm[i].getClass().getName());
                        continue;
                    }
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Delegating to X509TrustManager: " + this.tm[i].getClass().getName());
                        }
                        ((X509TrustManager)this.tm[i]).checkClientTrusted(chain, authType);
                        continue;
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Certificate Exception occurred: " + e.getMessage());
                        }
                        Manager.Ffdc.log(e, this, "com.ibm.ws.ssl.core.WSX509TrustManager.checkServerTrusted", "199", this);
                        this.printClientHandshakeError(this.config, this.extendedInfo, this.tsFile, e, chain, authType);
                        if (e instanceof CertificateException) {
                            throw (CertificateException)e;
                        }
                        throw new CertificateException(e.getMessage());
                    }
                }
                if (!PlatformHelperFactory.getPlatformHelper().isZOS() || PlatformHelperFactory.getPlatformHelper().isClientJvm()) break block25;
                try {
                    if (this.mutualAuthCBINDCheckMethod != null && !((Boolean)this.mutualAuthCBINDCheckMethod.invoke(this.trustedIDEvaluatorObject, new Object[]{chain})).booleanValue()) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "checkClientTrusted");
                        }
                        throw new CertificateException("CBIND check failed.");
                    }
                }
                catch (Exception e) {
                    if (e instanceof CertificateException) {
                        throw (CertificateException)e;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkClientTrusted");
                    }
                    throw new CertificateException("CBIND check failed.", e);
                }
            }
            catch (Throwable t) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception in checkClientTrusted.", new Object[]{t});
                }
                Manager.Ffdc.log(t, this, "com.ibm.ws.ssl.core.WSX509TrustManager.checkClientTrusted", "246", this);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof CertificateException) {
                    throw (CertificateException)t;
                }
                throw new CertificateException(t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClientTrusted");
        }
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkServerTrusted");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Target host: " + this.peerHost);
            for (int j = 0; j < chain.length; ++j) {
                Tr.debug(tc, "Certificate information:");
                Tr.debug(tc, "  Subject DN: " + chain[j].getSubjectDN());
                Tr.debug(tc, "  Issuer DN: " + chain[j].getIssuerDN());
                Tr.debug(tc, "  Serial number: " + chain[j].getSerialNumber());
                Tr.debug(tc, "");
            }
        }
        if (this.isCertificateAuthenticationDisabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Certificate authentication is temporarily disabled due to configuration change.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkServerTrusted");
            }
            return;
        }
        CertificateException originalException = null;
        for (int i = 0; i < this.tm.length; ++i) {
            if (this.tm[i] == null || !(this.tm[i] instanceof X509TrustManager)) continue;
            if (this.skipDefaultTMIfCustomTMDefined && i == 0 && this.tm.length > 1) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Skipping default trust manager name: " + this.tm[i].getClass().getName());
                continue;
            }
            boolean attempts = false;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Delegating to X509TrustManager: " + this.tm[i].getClass().getName());
                }
                ((X509TrustManager)this.tm[i]).checkServerTrusted(chain, authType);
                continue;
            }
            catch (CertificateException e) {
                boolean added;
                block73: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Certificate Exception occurred: " + e.getMessage());
                    }
                    originalException = e;
                    boolean dateValid = this.checkIfExpiredBeforeOrAfter(chain);
                    if (!dateValid) {
                        throw e;
                    }
                    added = false;
                    boolean readOnly = false;
                    String readOnlyValue = this.getProperty("com.ibm.ssl.trustStoreReadOnly", this.config, SSLConfigManager.getInstance().isServerProcess());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "readOnlyValue is " + readOnlyValue);
                    }
                    if (readOnlyValue != null && readOnlyValue.equalsIgnoreCase("true")) {
                        readOnly = true;
                    }
                    boolean autoAccept = ThreadManager.getInstance().getAutoAcceptBootstrapSigner();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server is NOT trusted by X509TrustManager, auto accept mode? " + autoAccept);
                    }
                    ThreadManager.getInstance().setAutoAcceptBootstrapSigner(false);
                    boolean autoAcceptWithoutStorage = ThreadManager.getInstance().getAutoAcceptBootstrapSignerWithoutStorage();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server is NOT trusted by X509TrustManager, auto accept w/o storage mode? " + autoAcceptWithoutStorage);
                    }
                    ThreadManager.getInstance().setAutoAcceptBootstrapSignerWithoutStorage(false);
                    String prompt = this.getProperty("com.ibm.ssl.enableSignerExchangePrompt", this.config, SSLConfigManager.getInstance().isServerProcess());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server is NOT trusted by X509TrustManager, prompt for signer exchange? " + prompt);
                    }
                    if (!autoAcceptWithoutStorage && (autoAccept || prompt != null && (prompt.equalsIgnoreCase("true") || prompt.equalsIgnoreCase("yes") || prompt.equalsIgnoreCase("gui") || prompt.equalsIgnoreCase("stdin")))) {
                        String shaDigest = "Cannot determine SHA digest.";
                        String md5Digest = "Cannot determine MD5 digest.";
                        String answer = null;
                        String yes = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.answer.yes", "y");
                        yes = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.answer.yes", "y");
                        if (yes != null) {
                            if ((yes = yes.trim().toLowerCase()).length() == 0) {
                                yes = "y";
                            }
                        } else {
                            yes = "y";
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Translated yes string is: " + yes);
                        }
                        try {
                            shaDigest = KeyStoreManager.getInstance().generateDigest("SHA-1", chain[chain.length - 1]);
                            md5Digest = KeyStoreManager.getInstance().generateDigest("MD5", chain[chain.length - 1]);
                            if (shaDigest != null) {
                                added = this.signersAdded.contains(shaDigest);
                            }
                        }
                        catch (NoClassDefFoundError ncdfe) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "No class found for generateDigest.", new Object[]{ncdfe});
                            }
                            Manager.Ffdc.log(ncdfe, this, "com.ibm.ws.ssl.core.WSX509TrustManager.checkServerTrusted", "376", this);
                        }
                        if (!added) {
                            if (!autoAccept && !SSLConfigManager.getInstance().isServerProcess()) {
                                if (prompt.equalsIgnoreCase("gui")) {
                                    try {
                                        SignerPromptPanel promptPanel = new SignerPromptPanel(500, this.peerHost, this.tsFile, ((Object)chain[0].getSubjectDN()).toString(), ((Object)chain[0].getIssuerDN()).toString(), chain[0].getSerialNumber().toString(), chain[0].getNotAfter().toString(), shaDigest, md5Digest);
                                        int result = promptPanel.showPanel();
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Result from prompt panel: " + result);
                                        }
                                        answer = result == 3 ? TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.answer.yes", "y") : TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.answer.no", "n");
                                    }
                                    catch (Throwable t) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Received the following exception starting GUI prompt.", new Object[]{t});
                                        }
                                        Manager.Ffdc.log(t, this, "com.ibm.ws.ssl.core.WSX509TrustManager.checkServerTrusted", "411", this);
                                        answer = null;
                                    }
                                }
                                if (answer == null) {
                                    try {
                                        System.out.println("");
                                        System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0100I", "*** SSL SIGNER EXCHANGE PROMPT ***"));
                                        System.out.println(TraceNLSHelper.getInstance().getFormattedMessage("ssl.trustmanager.signer.prompt.CWPKI0101I", new Object[]{this.peerHost, this.tsFile}, "SSL signer from target host " + this.peerHost + " is not found in trust store " + this.tsFile + ".\n\nHere's the signer information (verify the digest value matches what is displayed at the server):"));
                                        System.out.println("");
                                        for (int j = 0; j < chain.length; ++j) {
                                            System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0102I", "  Subject DN:    ") + chain[j].getSubjectDN());
                                            System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0103I", "  Issuer DN:     ") + chain[j].getIssuerDN());
                                            System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0104I", "  Serial number: ") + chain[j].getSerialNumber());
                                            System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0109I", "  Expires: ") + chain[j].getNotAfter());
                                            System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0105I", "  SHA-1 digest:  ") + shaDigest);
                                            System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0106I", "  MD5 digest:    ") + md5Digest);
                                            System.out.println("");
                                        }
                                        if (!autoAccept) {
                                            System.out.print(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0107I", "Add signer to the trust store now? (y/n) "));
                                            System.out.flush();
                                            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                                            answer = stdin.readLine();
                                            if (answer != null) {
                                                answer = answer.trim().toLowerCase();
                                            }
                                        }
                                    }
                                    catch (Exception ex) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Received the following exception added signer to TrustStore.", new Object[]{ex});
                                        }
                                        Manager.Ffdc.log(ex, this, "com.ibm.ws.ssl.core.WSX509TrustManager.checkServerTrusted", "450", this);
                                    }
                                }
                            }
                            try {
                                if (!readOnly && (autoAccept || answer != null && (answer.startsWith("y") || answer.startsWith(yes)))) {
                                    OutputStream fos;
                                    block72: {
                                        String alias;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Adding cert " + chain[chain.length - 1].getSubjectDN().getName() + " to TrustStore " + this.tsFile + ".");
                                        }
                                        if ((alias = chain[chain.length - 1].getSubjectDN().getName()).length() > 32) {
                                            alias = alias.substring(0, 31);
                                        }
                                        if (!this.ts.containsAlias(alias)) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Adding alias \"" + alias + "\" to truststore \"" + this.tsFile + "\".");
                                            }
                                            this.ts.setCertificateEntry(alias, chain[chain.length - 1]);
                                            if (autoAccept) {
                                                String trustStoreName = this.getProperty("com.ibm.ssl.trustStoreName", this.config, SSLConfigManager.getInstance().isServerProcess());
                                                this.issueMessage("ssl.signer.add.to.local.truststore.CWPKI0308I", new Object[]{alias, trustStoreName, shaDigest}, "CWPKI0308I: Adding signer alias \"" + alias + "\" to local keystore \"" + trustStoreName + "\" with the following SHA digest: " + shaDigest);
                                            }
                                        } else {
                                            String newAlias = CertificateManager.getInstance().incrementAlias(this.ts, alias);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Adding alias \"" + newAlias + "\" to truststore \"" + this.tsFile + "\".");
                                            }
                                            this.ts.setCertificateEntry(newAlias, chain[chain.length - 1]);
                                            if (autoAccept) {
                                                String trustStoreName = this.getProperty("com.ibm.ssl.trustStoreName", this.config, SSLConfigManager.getInstance().isServerProcess());
                                                this.issueMessage("ssl.signer.add.to.local.truststore.CWPKI0308I", new Object[]{newAlias, trustStoreName, shaDigest}, "CWPKI0308I: Adding signer alias \"" + newAlias + "\" to local keystore \"" + trustStoreName + "\" with the following SHA digest: " + shaDigest);
                                            }
                                        }
                                        fos = KeyStoreManager.getInstance().getOutputStream(this.tsFile);
                                        try {
                                            this.ts.store(fos, this.tsPass.toCharArray());
                                        }
                                        catch (IOException ioe) {
                                            if (this.getProperty("com.ibm.ssl.keyStoreType", this.config, SSLConfigManager.getInstance().isServerProcess()).equals("JCERACFKS") || this.getProperty("com.ibm.ssl.keyStoreType", this.config, SSLConfigManager.getInstance().isServerProcess()).equals("JCECCARACFKS")) {
                                                if (KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore(chain[chain.length - 1], this.ts)) {
                                                    Tr.debug(tc, "Certificate already exists in RACF: " + e.getMessage());
                                                    break block72;
                                                }
                                                throw e;
                                            }
                                            throw e;
                                        }
                                    }
                                    if (shaDigest != null) {
                                        this.signersAdded.add(shaDigest);
                                    }
                                    added = true;
                                    fos.close();
                                    AbstractJSSEProvider.clearSSLContextCache();
                                    KeyStoreManager.getInstance().clearJavaKeyStoresFromKeyStoreMap();
                                    if (!autoAccept) {
                                        System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0108I", "A retry of the request may need to occur."));
                                    }
                                    break block73;
                                }
                                if (readOnly && answer != null && (answer.startsWith("y") || answer.startsWith(yes))) {
                                    ThreadManager.getInstance().setAutoAcceptBootstrapSignerWithoutStorage(true);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Accepting signer for read-only keystore per prompt response.");
                                    }
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit(tc, "checkServerTrusted");
                                    }
                                    return;
                                }
                                if (answer != null) {
                                    this.printClientHandshakeError(this.config, this.extendedInfo, this.tsFile, e, chain, authType);
                                }
                            }
                            catch (Exception ex) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Received the following exception added signer to TrustStore.", new Object[]{ex});
                                }
                                Manager.Ffdc.log(ex, this, "com.ibm.ws.ssl.core.WSX509TrustManager.checkServerTrusted", "551", this);
                            }
                        }
                    } else if (ThreadManager.getInstance().getSetSignerOnThread()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting signer chain on the thread from the WSX509TrustManager.");
                        }
                        ThreadManager.getInstance().setSignerChain(chain);
                    } else {
                        if (autoAcceptWithoutStorage) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Accepting signer but not storing into trust store.");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "checkServerTrusted");
                            }
                            return;
                        }
                        this.printClientHandshakeError(this.config, this.extendedInfo, this.tsFile, e, chain, authType);
                    }
                }
                if (added) continue;
                throw originalException;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server is trusted by all X509TrustManagers.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkServerTrusted");
        }
    }

    private boolean checkIfExpiredBeforeOrAfter(X509Certificate[] chain) {
        if (chain != null && chain[0] != null) {
            long currentTime = System.currentTimeMillis();
            long notBefore = chain[0].getNotBefore().getTime();
            long notAfter = chain[0].getNotAfter().getTime();
            if (notBefore > currentTime) {
                Tr.error(tc, "ssl.certificate.before.date.invalid.CWPKI0311E", new Object[]{chain[0].getSubjectDN(), new Date(notBefore)});
                return false;
            }
            if (notAfter < currentTime) {
                Tr.error(tc, "ssl.certificate.end.date.invalid.CWPKI0312E", new Object[]{chain[0].getSubjectDN(), new Date(notAfter)});
                return false;
            }
            return true;
        }
        return false;
    }

    private void printClientHandshakeError(SSLConfig config2, Map extendedInfo, String tsFile, Exception e, X509Certificate[] chain, String authType) {
        String helpMessage;
        String extendedMessage = e.getMessage();
        String subjectDN = "unknown";
        if (chain[0] != null) {
            subjectDN = ((Object)chain[0].getSubjectDN()).toString();
        }
        String alias = this.getProperty("com.ibm.ssl.alias", config2, SSLConfigManager.getInstance().isServerProcess());
        String configURL = this.getProperty("com.ibm.ssl.configURLLoadedFrom", config2, SSLConfigManager.getInstance().isServerProcess());
        String host = "unknown";
        String port = "0";
        if (extendedInfo != null) {
            host = (String)extendedInfo.get("com.ibm.ssl.remoteHost");
            port = (String)extendedInfo.get("com.ibm.ssl.remotePort");
        }
        String hostport = host + ":" + port;
        String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.client.handshake.error.CWPKI0022E", new Object[]{subjectDN, hostport, tsFile, alias, configURL, extendedMessage}, "CWPKI0022E: SSL handshake failure occurred.  A signer with SubjectDN " + subjectDN + " was sent from target host/port " + hostport + ".  The signer may need to be added to local trust store " + tsFile + " located in SSL configuration alias " + alias + " loaded from configURL " + configURL + ".  The extended error message from the SSL handshake is: " + extendedMessage);
        if (!this.messagesPrinted.contains(message)) {
            Tr.error(tc, "ssl.client.handshake.error.CWPKI0022E", new Object[]{subjectDN, hostport, tsFile, alias, configURL, extendedMessage});
            if (this.messagesPrinted.size() > 20) {
                this.messagesPrinted.clear();
            }
            this.messagesPrinted.add(message);
        }
        if (!SSLConfigManager.getInstance().isServerProcess() && !this.messagesPrinted.contains(helpMessage = TraceNLSHelper.getInstance().getString("ssl.handshake.failure.info.CWPKI0040I", "CWPKI0040I: An SSL handshake failure occurred from a client.  The server's SSL signer needs to be added to the client trust store.  A retrieveSigners utility is provided for this function.  Check with your administrator to have this utility run to setup the secure enviroment before running the client.   Additional, the com.ibm.ssl.enableSignerExchangePrompt can be enabled in ssl.client.props for DefaultSSLSettings in order to allow acceptance of the signer during the connection attempt."))) {
            System.out.println("");
            System.out.println(message);
            System.out.println("");
            System.out.println("");
            System.out.println(helpMessage);
            System.out.println("");
            if (this.messagesPrinted.size() > 20) {
                this.messagesPrinted.clear();
            }
            this.messagesPrinted.add(helpMessage);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAcceptedIssuers");
        }
        X509Certificate[] allIssuers = null;
        ArrayList<X509Certificate> allIssuersList = new ArrayList<X509Certificate>();
        for (int i = 0; i < this.tm.length; ++i) {
            if (!(this.tm[i] instanceof X509TrustManager)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Delegating to X509TrustManager: " + this.tm[i].getClass().getName());
            }
            if ((allIssuers = ((X509TrustManager)this.tm[i]).getAcceptedIssuers()) == null) continue;
            for (int j = 0; j < allIssuers.length; ++j) {
                if (allIssuersList.contains(allIssuers[j])) continue;
                allIssuersList.add(allIssuers[j]);
            }
        }
        if (allIssuersList.size() > 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAcceptedIssuers");
            }
            return allIssuersList.toArray(new X509Certificate[allIssuersList.size()]);
        }
        return null;
    }

    protected void issueMessage(String key, Object[] args, String defaultMsg) {
        String msg = TraceNLSHelper.getInstance().getFormattedMessage(key, args, defaultMsg);
        this.printMessage(msg);
    }

    protected void printMessage(String msg) {
        int maxLength = 79;
        if (this.isDoubleByteSystem(msg)) {
            maxLength /= 2;
        }
        this.printMessage(msg, maxLength, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoubleByteSystem(String sampleStr) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(sampleStr);
            dos.flush();
        }
        catch (IOException exc) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException exc) {}
        }
        byte[] bytes = baos.toByteArray();
        this.isDoubleByteSystem = (double)bytes.length > (double)sampleStr.length() + (double)sampleStr.length() * 0.1;
        return this.isDoubleByteSystem;
    }

    private void printMessage(String msg, int maxLength, boolean indent) {
        int maxLocalLength = maxLength;
        if (indent) {
            System.out.print(INDENT);
            maxLocalLength -= INDENT.length();
        }
        if (msg.length() <= maxLocalLength) {
            System.out.println(msg);
        } else {
            int i = msg.lastIndexOf(32, maxLocalLength);
            if (i == -1 && (i = msg.indexOf(32)) == -1) {
                System.out.println(msg);
                return;
            }
            this.printMessage(msg.substring(0, i), maxLength, false);
            this.printMessage(msg.substring(i + 1), maxLength, true);
        }
    }

    private String getProperty(String propertyName, Properties prop, boolean processIsServer) {
        String value = null;
        if (prop != null) {
            if (!processIsServer && (value = System.getProperty(propertyName)) == null) {
                value = SSLConfigManager.getInstance().getGlobalProperty(propertyName);
            }
            if (value == null) {
                value = prop.getProperty(propertyName);
            }
        } else {
            value = System.getProperty(propertyName);
            if (value == null) {
                value = SSLConfigManager.getInstance().getGlobalProperty(propertyName);
            }
        }
        return value;
    }

    private boolean isCertificateAuthenticationDisabled() {
        return timer.isCertificateAuthenticationDisabled();
    }

    protected static void temporarilyDisableCertificateAuthentication(Long millisToDisable) {
        timer.temporarilyDisableCertificateAuthentication(millisToDisable);
    }

    static class TimerAlarm
    implements AlarmListener {
        private boolean certificateAuthenticationEnabled = true;

        public void alarm(Object alarmCtx) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "alarm", alarmCtx);
            }
            this.certificateAuthenticationEnabled = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "alarm");
            }
        }

        protected void temporarilyDisableCertificateAuthentication(Long millisToDisable) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "temporarilyDisableCertificateAuthentication");
            }
            this.certificateAuthenticationEnabled = false;
            AlarmManager.createDeferrable(millisToDisable, this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "temporarilyDisableCertificateAuthentication");
            }
        }

        protected boolean isCertificateAuthenticationDisabled() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isCertificateAuthenticationDisabled");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCertificateAuthenticationDisabled -> " + !this.certificateAuthenticationEnabled);
            }
            return !this.certificateAuthenticationEnabled;
        }
    }
}

