/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.core.CertMappingKeyManager;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.wsspi.ssl.KeyManagerExtendedInfo;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public final class WSX509KeyManager
extends X509ExtendedKeyManager
implements X509KeyManager {
    private static final TraceComponent tc = Tr.register(WSX509KeyManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private SSLConfig config = null;
    private KeyStore ks = null;
    private KeyManager[] kmList = null;
    private X509KeyManager km = null;
    private X509KeyManager customKM = null;
    private CertMappingKeyManager certMappingKeyManager = null;
    private String clientAlias = null;
    private String serverAlias = null;
    private int clientslotnum = 0;
    private int serverslotnum = 0;

    public void setClientAlias(String alias, int slotnum) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClientAlias", new Object[]{alias, new Integer(slotnum)});
        }
        if (!this.ks.containsAlias(alias)) {
            String keyFileName = this.config.getProperty("com.ibm.ssl.keyStore");
            String tokenLibraryFile = this.config.getProperty("com.ibm.ssl.tokenLibraryFile");
            String location = keyFileName != null ? keyFileName : tokenLibraryFile;
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.client.alias.not.found.CWPKI0023E", new Object[]{alias, location}, "Client alias " + alias + " not found in keystore.");
            Tr.error(tc, message);
            throw new IllegalArgumentException(message);
        }
        this.clientAlias = alias;
        this.clientslotnum = slotnum;
        if (this.customKM != null && this.customKM instanceof KeyManagerExtendedInfo) {
            ((KeyManagerExtendedInfo)((Object)this.customKM)).setKeyStoreClientAlias(alias);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClientAlias");
        }
    }

    public void setServerAlias(String alias, int slotnum) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServerAlias", new Object[]{alias, new Integer(slotnum)});
        }
        if (!this.ks.containsAlias(alias)) {
            String keyFileName = this.config.getProperty("com.ibm.ssl.keyStore");
            String tokenLibraryFile = this.config.getProperty("com.ibm.ssl.tokenLibraryFile");
            String location = keyFileName != null ? keyFileName : tokenLibraryFile;
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.server.alias.not.found.CWPKI0024E", new Object[]{alias, location}, "Server alias " + alias + " not found in keystore.");
            Tr.error(tc, message);
            throw new IllegalArgumentException(message);
        }
        this.serverAlias = alias;
        this.serverslotnum = slotnum;
        if (this.customKM != null && this.customKM instanceof KeyManagerExtendedInfo) {
            ((KeyManagerExtendedInfo)((Object)this.customKM)).setKeyStoreServerAlias(alias);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerAlias");
        }
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseClientAlias", new Object[]{keyType, issuers, socket});
        }
        try {
            if (this.customKM != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "chooseClientAlias -> " + this.customKM.getClass().getName());
                }
                return this.customKM.chooseClientAlias(keyType, issuers, socket);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseClientAlias");
            }
            return this.chooseClientAlias(keyType[0], issuers);
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception in chooseClientAlias.", new Object[]{t});
            }
            Manager.Ffdc.log(t, this, "com.ibm.ws.ssl.core.WSX509KeyManager.chooseClientAlias", "127", this);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias", new Object[]{keyType, issuers, socket});
        }
        try {
            if (this.customKM != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "chooseServerAlias -> " + this.customKM.getClass().getName());
                }
                return this.customKM.chooseServerAlias(keyType, issuers, socket);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseServerAlias");
            }
            return this.chooseServerAlias(keyType, issuers);
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception in chooseServerAlias.", new Object[]{t});
            }
            Manager.Ffdc.log(t, this, "com.ibm.ws.ssl.core.WSX509KeyManager.chooseServerAlias", "161", this);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public String chooseClientAlias(String keyType, Principal[] issuers) {
        Map connectionInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseClientAlias", new Object[]{keyType, issuers});
        }
        if ((connectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo()) != null && connectionInfo.get("com.ibm.ssl.endPointName") != null && connectionInfo.get("com.ibm.ssl.endPointName").equals("IIOP") && !SSLConfigManager.getInstance().isClientAuthenticationEnabled()) {
            return null;
        }
        if (this.clientAlias != null && !this.clientAlias.equals("")) {
            String[] list = this.km.getClientAliases(keyType, issuers);
            String aliases = "";
            if (list != null) {
                boolean found = false;
                for (int i = 0; i < list.length; ++i) {
                    aliases = aliases + list[i] + " ";
                    if (!this.clientAlias.equalsIgnoreCase(list[i])) continue;
                    found = true;
                }
                if (found) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "chooseClientAlias", new Object[]{this.clientAlias});
                    }
                    if (this.ks.getType() != null && (this.ks.getType().equals("JCERACFKS") || this.ks.getType().equals("JCECCARACFKS"))) {
                        return this.clientAlias;
                    }
                    return this.clientAlias.toLowerCase();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseClientAlias (default)", new Object[]{this.clientAlias});
            }
            return this.clientAlias;
        }
        String[] keyArray = new String[]{keyType};
        String alias = this.km.chooseClientAlias(keyArray, issuers, null);
        if (this.ks.getType() != null && !this.ks.getType().equals("JCERACFKS") && !this.ks.getType().equals("JCECCARACFKS") && alias != null) {
            alias = alias.toLowerCase();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseClientAlias (from JSSE)", new Object[]{alias});
        }
        return alias;
    }

    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseEngineServerAlias", new Object[]{keyType, issuers, engine2});
        }
        String rc = null;
        if (null != this.customKM && this.customKM instanceof X509ExtendedKeyManager) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "chooseEngineServerAlias, using customKM -> " + this.customKM.getClass().getName());
            }
            rc = ((X509ExtendedKeyManager)this.customKM).chooseEngineServerAlias(keyType, issuers, engine2);
        } else {
            rc = this.chooseServerAlias(keyType, issuers);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseEngineServerAlias");
        }
        return rc;
    }

    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseEngineClientAlias", new Object[]{keyType, issuers, engine2});
        }
        String rc = null;
        if (null != this.customKM && this.customKM instanceof X509ExtendedKeyManager) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "chooseEngineClientAlias, using customKM -> " + this.customKM.getClass().getName());
            }
            rc = ((X509ExtendedKeyManager)this.customKM).chooseEngineClientAlias(keyType, issuers, engine2);
        } else {
            rc = this.chooseClientAlias(keyType[0], issuers);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseEngineClientAlias");
        }
        return rc;
    }

    public String chooseServerAlias(String keyType, Principal[] issuers) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias", new Object[]{keyType, issuers});
        }
        Map connectionInfo = JSSEHelper.getInstance().getInboundConnectionInfo();
        String certMappingFile = this.certMappingKeyManager.getProperty("com.ibm.ssl.cert.mapping.file");
        String mappedAlias = null;
        Boolean webContainerInbound = null;
        if (connectionInfo != null) {
            webContainerInbound = (Boolean)connectionInfo.get("com.ibm.ssl.isWebContainerInbound");
        }
        if (webContainerInbound != null && webContainerInbound.booleanValue() && certMappingFile != null) {
            mappedAlias = this.certMappingKeyManager.chooseServerAlias(keyType, issuers, null);
        }
        if (mappedAlias == null) {
            if (this.serverAlias != null && !this.serverAlias.equals("")) {
                String[] list = this.km.getServerAliases(keyType, issuers);
                String aliases = "";
                if (list != null) {
                    boolean found = false;
                    for (int i = 0; i < list.length; ++i) {
                        aliases = aliases + list[i] + " ";
                        if (!this.serverAlias.equalsIgnoreCase(list[i])) continue;
                        found = true;
                    }
                    if (found) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "chooseServerAlias", new Object[]{this.serverAlias});
                        }
                        if (this.ks.getType() != null && (this.ks.getType().equals("JCERACFKS") || this.ks.getType().equals("JCECCARACFKS"))) {
                            return this.serverAlias;
                        }
                        return this.serverAlias.toLowerCase();
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "chooseServerAlias (default)", new Object[]{this.serverAlias});
                }
                return this.serverAlias;
            }
            String alias = this.km.chooseServerAlias(keyType, issuers, null);
            if (this.ks.getType() != null && !this.ks.getType().equals("JCERACFKS") && !this.ks.getType().equals("JCECCARACFKS") && alias != null) {
                alias = alias.toLowerCase();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "chooseServerAlias (from JSSE)", new Object[]{alias});
            }
            return alias;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseServerAlias", new Object[]{mappedAlias});
        }
        return mappedAlias;
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAliases", new Object[]{keyType, issuers});
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClientAliases -> " + this.customKM.getClass().getName());
            }
            return this.customKM.getClientAliases(keyType, issuers);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAliases -> " + this.km.getClass().getName());
        }
        return this.km.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerAliases", new Object[]{keyType, issuers});
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerAliases -> " + this.customKM.getClass().getName());
            }
            return this.customKM.getServerAliases(keyType, issuers);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerAliases -> " + this.km.getClass().getName());
        }
        return this.km.getServerAliases(keyType, issuers);
    }

    public PrivateKey getPrivateKey(String s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateKey", new Object[]{s});
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPrivateKey -> " + this.customKM.getClass().getName());
            }
            return this.customKM.getPrivateKey(s);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateKey -> " + this.km.getClass().getName());
        }
        return this.km.getPrivateKey(s);
    }

    public X509Certificate[] getCertificateChain(String s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificateChain", new Object[]{s});
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertificateChain -> " + this.customKM.getClass().getName());
            }
            return this.customKM.getCertificateChain(s);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificateChain -> " + this.km.getClass().getName());
        }
        return this.km.getCertificateChain(s);
    }

    public X509KeyManager getX509KeyManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509KeyManager");
        }
        if (this.customKM != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getX509KeyManager -> " + this.customKM.getClass().getName());
            }
            return this.customKM;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getX509KeyManager -> " + this.km.getClass().getName());
        }
        return this.km;
    }

    public WSX509KeyManager(KeyStore keystore, char[] ac, KeyManagerFactory kmf, SSLConfig sslConfig, X509KeyManager customKeyManager) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        this.ks = keystore;
        this.kmList = kmf.getKeyManagers();
        this.certMappingKeyManager = new CertMappingKeyManager();
        if (this.kmList != null) {
            this.km = (X509KeyManager)this.kmList[0];
        }
        this.config = sslConfig;
        this.customKM = customKeyManager;
        if (this.customKM != null && this.customKM instanceof KeyManagerExtendedInfo) {
            if (sslConfig != null) {
                ((KeyManagerExtendedInfo)((Object)this.customKM)).setSSLConfig(sslConfig);
            }
            KeyManager[] kmList = kmf.getKeyManagers();
            X509KeyManager defaultX509keyManager = null;
            if (kmList != null && kmList[0] != null) {
                defaultX509keyManager = (X509KeyManager)kmList[0];
            }
            if (defaultX509keyManager != null) {
                ((KeyManagerExtendedInfo)((Object)this.customKM)).setDefaultX509KeyManager(defaultX509keyManager);
            }
            if (keystore != null) {
                ((KeyManagerExtendedInfo)((Object)this.customKM)).setKeyStore(keystore);
            }
        }
    }
}

