/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.ssl.TrustManagerExtendedInfo;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.X509TrustManager;

public final class CustomTrustManager
implements X509TrustManager,
TrustManagerExtendedInfo {
    private Map extendedInfo = null;
    private Properties sslConfig = null;
    private Properties props = null;
    private static final TraceComponent tc = Tr.register(CustomTrustManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public CustomTrustManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CustomTrustManager");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CustomTrustManager");
        }
    }

    public void setExtendedInfo(Map info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setExtendedInfo", new Object[]{info});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setExtendedInfo");
        }
        this.extendedInfo = info;
    }

    public void setCustomProperties(Properties customProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCustomProperties", new Object[]{customProps});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCustomProperties");
        }
        this.props = customProps;
    }

    public Map getExtendedInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExtendedInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExtendedInfo");
        }
        return this.extendedInfo;
    }

    public void setSSLConfig(Properties config2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSSLConfig");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSSLConfig");
        }
        this.sslConfig = config2;
    }

    public Properties getSSLConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExtendedInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExtendedInfo");
        }
        return this.sslConfig;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkClientTrusted");
        }
        if (tc.isDebugEnabled()) {
            for (int j = 0; j < chain.length; ++j) {
                Tr.debug(tc, "chain[" + j + "]: " + chain[j].getSubjectDN());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClientTrusted");
        }
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkServerTrusted");
        }
        if (tc.isDebugEnabled()) {
            for (int j = 0; j < chain.length; ++j) {
                Tr.debug(tc, "Certificate information:");
                Tr.debug(tc, "  Subject DN: " + chain[j].getSubjectDN());
                Tr.debug(tc, "  Issuer DN: " + chain[j].getIssuerDN());
                Tr.debug(tc, "  Serial number: " + chain[j].getSerialNumber());
                Tr.debug(tc, "");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkServerTrusted");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAcceptedIssuers");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAcceptedIssuers");
        }
        return null;
    }
}

