/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.HashMap;
import java.util.Map;

public class ManagementScopeManager {
    private static final TraceComponent tc = Tr.register(ManagementScopeManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static ManagementScopeManager thisClass = null;
    private static ManagementScopeManager clientClass = null;
    private static HashMap scopeMapSM = new HashMap();
    private HashMap inboundEndPointAliasMap = new HashMap();
    private HashMap outboundEndPointAliasMap = new HashMap();
    private String inboundProcessAlias = null;
    private String outboundProcessAlias = null;
    private String inboundNodeAlias = null;
    private String outboundNodeAlias = null;
    private HashMap inboundNodeGroupAliasMap = new HashMap();
    private HashMap outboundNodeGroupAliasMap = new HashMap();
    private String inboundClusterAlias = null;
    private String outboundClusterAlias = null;
    private String inboundCellAlias = null;
    private String outboundCellAlias = null;
    private String inboundEffectiveProcessAlias = null;
    private String inboundEffectiveProcessScope = null;
    private String outboundEffectiveProcessAlias = null;
    private String outboundEffectiveProcessScope = null;
    private String adminDataScope = "Security";
    public static final int MSM_SCOPE_FORMAT_CLASSIC = 1;
    public static final int MSM_SCOPE_FORMAT_SM = 2;

    private ManagementScopeManager() {
        if (!RasHelper.isServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ctor - not on a server, using null scope ");
            }
            this.adminDataScope = null;
        } else if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ctor - on server in admin agent, using null scope ");
            }
            this.adminDataScope = null;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ctor - on server, not admin agent, using 'Security' scope ");
        }
        SecurityObjectLocator.getAdminData(this.adminDataScope);
    }

    public static synchronized ManagementScopeManager getInstance() {
        if (thisClass == null) {
            thisClass = new ManagementScopeManager();
        }
        return thisClass;
    }

    public String getProcessType() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getProcessType();
    }

    public String getProcessName() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getProcessName();
    }

    public String getServerType() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getServerType();
    }

    public String getNodeName() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getNodeName();
    }

    public String getCellName() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getCellName();
    }

    public String getJvmType() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getJvmType();
    }

    public String getClusterName() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getClusterName();
    }

    public String[] getFullScopeNames() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getCurrentScopeNames();
    }

    public String[] getNodeGroupScopeNames() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getCurrentNodeGroupScopeNames();
    }

    public String getClusterScopeName() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getCurrentClusterScopeName();
    }

    public String getProcessScopeName() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getCurrentProcessScopeName();
    }

    public String getNodeScopeName() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getCurrentNodeScopeName();
    }

    public String getCellScopeName() {
        return SecurityObjectLocator.getAdminData(this.adminDataScope).getCurrentCellScopeName();
    }

    public boolean currentScopeContained(String scope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "currentScopeContained", new Object[]{scope});
        }
        return this.currentScopeContained(scope, 1);
    }

    public boolean currentScopeContained(String scope, int scopeFormat) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "currentScopeContained", new Object[]{scope, scopeFormat});
        }
        if (scope == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "currentScopeContained: cannot compare scopes if one or both are null.");
            }
            return false;
        }
        String classicScope = null;
        if (scopeFormat == 1) {
            classicScope = scope;
        } else if (scopeFormat == 2) {
            classicScope = (String)scopeMapSM.get(scope);
            if (classicScope == null) {
                classicScope = this.convertSMScopeToClassic(scope);
                scopeMapSM.put(scope, classicScope);
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "currentScopeContained: invalid scope format.");
            }
            return false;
        }
        ManagementScopeData scopeData = new ManagementScopeData(classicScope);
        String scopeType = scopeData.getScopeType();
        String[] currentScopeNames = this.getFullScopeNames();
        for (int i = 0; i < currentScopeNames.length; ++i) {
            String currentScope = currentScopeNames[i];
            if (currentScope.equals("client")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "currentScopeContained: current scope is client, returning true.");
                }
                return true;
            }
            if (currentScope.equals(scope)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "currentScopeContained: scopes are equal, returning true.");
                }
                return true;
            }
            if (scopeData == null) continue;
            if (scopeType.equals("endpoint") || scopeType.equals("server")) {
                String processScope = scopeData.formProcessScope();
                String currentProcessScopeName = this.getProcessScopeName();
                if (processScope != null && currentProcessScopeName != null && processScope.equals(currentProcessScopeName)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "currentScopeContained: server scopes match.");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "!currentScopeContained: server scopes do not match.");
                }
                return false;
            }
            if (scopeType.equalsIgnoreCase("cluster") || scopeType.equalsIgnoreCase("servercluster")) {
                String clusterScope = scopeData.formClusterScope();
                String currentClusterScopeName = this.getClusterScopeName();
                if (clusterScope != null && currentClusterScopeName != null && clusterScope.equals(currentClusterScopeName)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "currentScopeContained: cluster scopes match.");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "!currentScopeContained: cluster scopes do not match.");
                }
                return false;
            }
            if (scopeType.equals("node")) {
                String nodeScope = scopeData.formNodeScope();
                String currentNodeScopeName = this.getNodeScopeName();
                if (nodeScope != null && currentNodeScopeName != null && nodeScope.equals(currentNodeScopeName)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "currentScopeContained: node scopes match.");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "!currentScopeContained: node scopes do not match.");
                }
                return false;
            }
            if (scopeType.equals("nodegroup")) {
                String nodeGroupScope = scopeData.formNodeGroupScope();
                String[] currentNodeGroupScopeNames = this.getNodeGroupScopeNames();
                if (nodeGroupScope != null) {
                    for (int j = 0; j < currentNodeGroupScopeNames.length; ++j) {
                        if (!nodeGroupScope.equals(currentNodeGroupScopeNames[j])) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "currentScopeContained: nodegroup scopes match.");
                        }
                        return true;
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "!currentScopeContained: nodegroup scopes do not match.");
                }
                return false;
            }
            if (scopeType.equals("cell")) {
                String cellScope = scopeData.formCellScope();
                String currentCellScopeName = this.getCellScopeName();
                if (cellScope != null && currentCellScopeName != null && cellScope.equals(currentCellScopeName)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "currentScopeContained: cell scopes match.");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "!currentScopeContained: cell scopes do not match.");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "!currentScopeContained: scopes do not match.");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "currentScopeContained: CurrentScopeNames is null.");
        }
        return false;
    }

    private String convertSMScopeToClassic(String scope) {
        String result = null;
        String[] atoms = scope.split("/");
        boolean keyword = true;
        for (int i = 0; i < atoms.length; ++i) {
            if (keyword) {
                if (atoms[i].equals("cells")) {
                    result = "(cell):";
                } else if (atoms[i].equals("nodes")) {
                    result = result + ":(node):";
                } else if (atoms[i].equals("servers")) {
                    result = result + ":(server):";
                } else if (atoms[i].equals("clusters")) {
                    result = result + ":(cluster):";
                } else if (atoms[i].equals("nodegroups")) {
                    result = result + ":(nodegroup):";
                }
                keyword = false;
                continue;
            }
            result = result + atoms[i];
            keyword = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertSMScopeToClassic", new Object[]{result});
        }
        return result;
    }

    public void loadSSLConfigGroups(SecurityConfigObject security, boolean reinitialize) {
        SecurityConfigObjectList sslConfigGroupList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSSLConfigGroups");
        }
        if ((sslConfigGroupList = security.getObjectList("sslConfigGroups")) != null) {
            String alias;
            for (int i = 0; i < sslConfigGroupList.size(); ++i) {
                SecurityConfigObject group = sslConfigGroupList.get(i);
                if (group == null) continue;
                SecurityConfigObject scope = group.getObject("managementScope");
                String scopeString = null;
                scopeString = scope != null ? scope.getString("scopeName") : ManagementScopeManager.getInstance().getCellScopeName();
                if (!this.currentScopeContained(scopeString)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "SSLConfigGroup \"" + group.getString("name") + "\" with scope \"" + scopeString + "\" is not in the current process scope.");
                    continue;
                }
                ManagementScopeData scopeData = new ManagementScopeData(scopeString);
                String direction = group.getString("direction");
                String certAlias = group.getString("certificateAlias");
                String sslAlias = group.getObject("sslConfig").getString("alias");
                String groupAlias = null;
                groupAlias = certAlias != null && certAlias.length() > 0 ? sslAlias + "," + certAlias : sslAlias;
                if (scopeData == null) continue;
                if (scopeData.getScopeType().equals("endpoint")) {
                    if (direction.equals("inbound")) {
                        this.inboundEndPointAliasMap.put(scopeString, groupAlias);
                        continue;
                    }
                    this.outboundEndPointAliasMap.put(scopeString, groupAlias);
                    continue;
                }
                if (scopeData.getScopeType().equals("server")) {
                    if (direction.equals("inbound")) {
                        this.inboundProcessAlias = groupAlias;
                        continue;
                    }
                    this.outboundProcessAlias = groupAlias;
                    continue;
                }
                if (scopeData.getScopeType().equals("cluster")) {
                    if (direction.equals("inbound")) {
                        this.inboundClusterAlias = groupAlias;
                        continue;
                    }
                    this.outboundClusterAlias = groupAlias;
                    continue;
                }
                if (scopeData.getScopeType().equals("node")) {
                    if (direction.equals("inbound")) {
                        this.inboundNodeAlias = groupAlias;
                        continue;
                    }
                    this.outboundNodeAlias = groupAlias;
                    continue;
                }
                if (scopeData.getScopeType().equals("nodegroup")) {
                    if (direction.equals("inbound")) {
                        this.inboundNodeGroupAliasMap.put(scopeString, groupAlias);
                        continue;
                    }
                    this.outboundNodeGroupAliasMap.put(scopeString, groupAlias);
                    continue;
                }
                if (scopeData.getScopeType().equals("cell")) {
                    if (direction.equals("inbound")) {
                        this.inboundCellAlias = groupAlias;
                        continue;
                    }
                    this.outboundCellAlias = groupAlias;
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Scope data with the following information is not a known scope type: " + scopeData);
            }
            if (this.inboundProcessAlias != null) {
                this.inboundEffectiveProcessAlias = this.inboundProcessAlias;
                this.inboundEffectiveProcessScope = "server";
            } else if (this.inboundClusterAlias != null) {
                this.inboundEffectiveProcessAlias = this.inboundClusterAlias;
                this.inboundEffectiveProcessScope = "cluster";
            } else if (this.inboundNodeAlias != null) {
                this.inboundEffectiveProcessAlias = this.inboundNodeAlias;
                this.inboundEffectiveProcessScope = "node";
            } else if (this.inboundNodeGroupAliasMap != null && this.inboundNodeGroupAliasMap.size() > 0) {
                for (Map.Entry entry : this.inboundNodeGroupAliasMap.entrySet()) {
                    if (entry == null) continue;
                    this.inboundEffectiveProcessAlias = (String)entry.getValue();
                    this.inboundEffectiveProcessScope = "nodegroup";
                    break;
                }
            } else if (this.inboundCellAlias != null) {
                this.inboundEffectiveProcessAlias = this.inboundCellAlias;
                this.inboundEffectiveProcessScope = "cell";
            } else {
                SSLConfig defaultSSLConfig = SSLConfigManager.getInstance().getDefaultSSLConfig();
                if (defaultSSLConfig != null) {
                    alias = defaultSSLConfig.getProperty("com.ibm.ssl.alias");
                    String serverCertAlias = defaultSSLConfig.getProperty("com.ibm.ssl.keyStoreServerAlias");
                    this.inboundCellAlias = serverCertAlias != null && !serverCertAlias.equals("") ? alias + "," + serverCertAlias : alias;
                }
                this.inboundEffectiveProcessAlias = this.inboundCellAlias;
                this.inboundEffectiveProcessScope = "cell";
            }
            if (this.outboundProcessAlias != null) {
                this.outboundEffectiveProcessAlias = this.outboundProcessAlias;
                this.outboundEffectiveProcessScope = "server";
            } else if (this.outboundClusterAlias != null) {
                this.outboundEffectiveProcessAlias = this.outboundClusterAlias;
                this.outboundEffectiveProcessScope = "cluster";
            } else if (this.outboundNodeAlias != null) {
                this.outboundEffectiveProcessAlias = this.outboundNodeAlias;
                this.outboundEffectiveProcessScope = "node";
            } else if (this.outboundNodeGroupAliasMap != null && this.outboundNodeGroupAliasMap.size() > 0) {
                for (Map.Entry entry : this.outboundNodeGroupAliasMap.entrySet()) {
                    if (entry == null) continue;
                    this.outboundEffectiveProcessAlias = (String)entry.getValue();
                    this.outboundEffectiveProcessScope = "nodegroup";
                    break;
                }
            } else if (this.outboundCellAlias != null) {
                this.outboundEffectiveProcessAlias = this.outboundCellAlias;
                this.outboundEffectiveProcessScope = "cell";
            } else {
                SSLConfig defaultSSLConfig = SSLConfigManager.getInstance().getDefaultSSLConfig();
                if (defaultSSLConfig != null) {
                    alias = defaultSSLConfig.getProperty("com.ibm.ssl.alias");
                    String clientCertAlias = defaultSSLConfig.getProperty("com.ibm.ssl.keyStoreClientAlias");
                    this.outboundCellAlias = clientCertAlias != null && !clientCertAlias.equals("") ? alias + "," + clientCertAlias : alias;
                }
                this.outboundEffectiveProcessAlias = this.outboundCellAlias;
                this.outboundEffectiveProcessScope = "cell";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Effective inbound group alias is \"" + this.inboundEffectiveProcessAlias + "\" from scope \"" + this.inboundEffectiveProcessScope + "\".");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Effective outbound group alias is \"" + this.outboundEffectiveProcessAlias + "\" from scope \"" + this.outboundEffectiveProcessScope + "\".");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSSLConfigGroups");
        }
    }

    public String getConfigAndCertAliasesFromGroups(Map connectionInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigAndCertAliasesFromGroups", new Object[]{connectionInfo});
        }
        String aliasFound = null;
        String currentEndPointScopeName = null;
        String direction = null;
        if (connectionInfo != null && connectionInfo.size() != 0) {
            direction = (String)connectionInfo.get("com.ibm.ssl.direction");
            String localEndPointName = null;
            if (connectionInfo != null) {
                localEndPointName = (String)connectionInfo.get("com.ibm.ssl.endPointName");
            }
            String currentProcessScopeName = this.getProcessScopeName();
            currentEndPointScopeName = currentProcessScopeName + ":(endpoint):" + localEndPointName;
            if (direction.equals("inbound")) {
                aliasFound = (String)this.inboundEndPointAliasMap.get(currentEndPointScopeName);
                if (aliasFound != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getConfigAndCertAliasesFromGroups (found from inbound endpoint) -> " + aliasFound);
                    }
                    return aliasFound;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConfigAndCertAliasesFromGroups (found from inbound scope) -> " + this.inboundEffectiveProcessAlias);
                }
                return this.inboundEffectiveProcessAlias;
            }
            aliasFound = (String)this.outboundEndPointAliasMap.get(currentEndPointScopeName);
            if (aliasFound != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConfigAndCertAliasesFromGroups (found from outbound endpoint) -> " + aliasFound);
                }
                return aliasFound;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigAndCertAliasesFromGroups (found from outbound scope) -> " + this.outboundEffectiveProcessAlias);
            }
            return this.outboundEffectiveProcessAlias;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigAndCertAliasesFromGroups (found from outbound scope without connection info) -> " + this.outboundEffectiveProcessAlias);
        }
        return this.outboundEffectiveProcessAlias;
    }

    public static boolean isInitialized() {
        boolean initialized;
        boolean bl = initialized = thisClass != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInitialized " + initialized);
        }
        return initialized;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("*** INBOUND ***\n");
        sb.append("\nCell Alias: ");
        sb.append(this.inboundCellAlias);
        sb.append("\nNodeGroup Alias(es): ");
        sb.append(this.inboundNodeGroupAliasMap);
        sb.append("\nNode Alias: ");
        sb.append(this.inboundNodeAlias);
        sb.append("\nServer Alias: ");
        sb.append(this.inboundProcessAlias);
        sb.append("\nCluster Alias: ");
        sb.append(this.inboundClusterAlias);
        sb.append("\nEndPoint Alias(es): ");
        sb.append(this.inboundEndPointAliasMap);
        sb.append("\nEffective Process Alias: ");
        sb.append(this.inboundEffectiveProcessAlias);
        sb.append("\nEffective Process Scope: ");
        sb.append(this.inboundEffectiveProcessScope);
        sb.append("\n\n*** OUTBOUND ***\n");
        sb.append("\nCell Alias: ");
        sb.append(this.outboundCellAlias);
        sb.append("\nNodeGroup Alias(es): ");
        sb.append(this.outboundNodeGroupAliasMap);
        sb.append("\nNode Alias: ");
        sb.append(this.outboundNodeAlias);
        sb.append("\nServer Alias: ");
        sb.append(this.outboundProcessAlias);
        sb.append("\nCluster Alias: ");
        sb.append(this.outboundClusterAlias);
        sb.append("\nEndPoint Alias(es): ");
        sb.append(this.outboundEndPointAliasMap);
        sb.append("\nEffective Process Alias: ");
        sb.append(this.outboundEffectiveProcessAlias);
        sb.append("\nEffective Process Scope: ");
        sb.append(this.outboundEffectiveProcessScope);
        return sb.toString();
    }
}

