/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.wsspi.security.token.Token;
import java.util.Enumeration;

public abstract class AbstractTokenImpl
implements Token {
    private com.ibm.wsspi.security.ltpa.Token token = null;
    private String accessId = "";
    private ContextManager contextManager = null;
    private boolean isReadOnly = false;
    private short version = 1;
    private byte[] tokenBytes = null;
    private long change_counter = 0L;
    private static final WebSphereRuntimePermission UPDATE_TOKEN = new WebSphereRuntimePermission("updateToken");
    private static final WebSphereRuntimePermission GET_TOKEN = new WebSphereRuntimePermission("getToken");
    private static final TraceComponent tc = Tr.register(AbstractTokenImpl.class, null, "com.ibm.ejs.resources.security");

    public void setToken(com.ibm.wsspi.security.ltpa.Token _token) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + UPDATE_TOKEN.toString());
            }
            sm.checkPermission(UPDATE_TOKEN);
        }
        ++this.change_counter;
        this.token = _token;
    }

    public com.ibm.wsspi.security.ltpa.Token getToken() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_TOKEN.toString());
            }
            sm.checkPermission(GET_TOKEN);
        }
        return this.token;
    }

    public boolean isValid() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking validity of token " + this.getClass().getName());
        }
        if (this.token != null) {
            long currentTime = System.currentTimeMillis();
            long expiration = this.getExpiration();
            long timeleft = expiration - currentTime;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Time left for token: " + timeleft);
            }
            if (timeleft > 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "token is valid.");
                }
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token is invalid.");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "token is null, returning invalid.");
        }
        return false;
    }

    public long getExpiration() {
        if (this.token != null) {
            return this.token.getExpiration();
        }
        return -1L;
    }

    public boolean isForwardable() {
        return true;
    }

    public String getPrincipal() {
        String[] accessIDArray = this.getAttributes("u");
        if (accessIDArray != null && accessIDArray.length > 0) {
            return accessIDArray[0];
        }
        return null;
    }

    public String getUniqueID() {
        String[] cacheKeyArray = this.getAttributes("com.ibm.wsspi.security.cred.cacheKey");
        if (cacheKeyArray != null && cacheKeyArray[0] != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found cache key in Authz token: " + cacheKeyArray[0]);
            }
            return cacheKeyArray[0];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No unique cache key found in token.");
        }
        return null;
    }

    public byte[] getBytes() {
        if (this.token != null) {
            try {
                return this.token.getBytes();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred getting bytes[] from token.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.AbstractTokenImpl.getBytes", "197");
                return null;
            }
        }
        return new byte[0];
    }

    public String getName() {
        return this.getClass().getName();
    }

    public short getVersion() {
        return this.version;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.isReadOnly = true;
    }

    public String[] getAttributes(String key) {
        if (this.token != null) {
            return this.token.getAttributes(key);
        }
        return null;
    }

    public String[] addAttribute(String key, String value) {
        SecurityManager sm;
        if ((key.startsWith("com.ibm.wsspi.security") || key.startsWith("com.ibm.websphere.security")) && (sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + UPDATE_TOKEN.toString());
            }
            sm.checkPermission(UPDATE_TOKEN);
        }
        if (!this.isReadOnly && this.token != null) {
            ++this.change_counter;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting attribute with key: " + key + ", value: " + value);
            }
            return this.token.addAttribute(key, value);
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        if (this.token != null) {
            return this.token.getAttributeNames();
        }
        return null;
    }

    public Object clone() {
        return null;
    }

    protected String getChangeCounter() {
        return new Long(this.change_counter).toString();
    }
}

