/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.config.SecurityConfigManagerImpl;
import com.ibm.ws.security.config.SecurityConfigObjectFactoryImpl;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.SecurityConfigChangeListener;
import com.ibm.ws.security.core.SecurityConfigService;
import com.ibm.ws.security.core.SecurityConfigServiceEvent;
import com.ibm.ws.security.core.SecurityConfigServiceListener;
import com.ibm.wsspi.runtime.component.WsComponent;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.List;

public class SecurityConfigComponentImpl
extends WsComponentImpl
implements WsComponent,
SecurityConfigService {
    private static final TraceComponent tc = Tr.register(SecurityConfigComponentImpl.class, "SecurityConfig", "com.ibm.ws.ssl.resources.ssl");
    private ConfigChangeListener configListener = null;
    private ArrayList<SecurityConfigServiceListener> listeners = new ArrayList(32);
    private int componentState = 2;
    private static Repository repository = null;

    public void initialize(Object config2) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SecurityConfigComponentImpl initializing...");
        }
        repository = this.getRepositoryService();
        SecurityConfigManagerImpl scm = SecurityConfigManagerImpl.getInstance();
        if (scm == null) {
            throw new ConfigurationError("Unable to load cell security configuration");
        }
        SecurityObjectLocator.setSecurityConfigManager(scm);
        SecurityConfigObjectFactoryImpl scof = SecurityConfigObjectFactoryImpl.getInstance();
        SecurityObjectLocator.setSecurityConfigHelperFactory(scof);
        AdminService adminService = AdminServiceFactory.getAdminService();
        SecurityConfigManagerImpl.setProcessType(adminService.getProcessType());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SecurityConfigComponentImpl completed initializing...");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SecurityConfigComponentImpl starting...");
        }
        try {
            if (repository == null) {
                repository = this.getRepositoryService();
            }
            if (this.componentState == 1) {
                return;
            }
            this.registerListenerWithAdminService();
            this.fireStartedEvent();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.core.SSLComponentImpl.start", "233", this);
            Tr.error(tc, "ssl.init.error.CWPKI0008E", new Object[]{e});
            Tr.audit(tc, "ssl.init.svcstartfail.CWPKI0007I");
            throw new RuntimeError(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SecurityConfigComponentImpl completed starting...");
        }
    }

    private void registerListenerWithAdminService() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerListenerWithAdminService");
            }
            Admin adminService = null;
            try {
                adminService = WsServiceRegistry.getService(this, Admin.class);
                if (adminService != null) {
                    this.configListener = new SecurityConfigChangeListener(this);
                    adminService.addConfigChangeListener(this.configListener);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.registerListenerWithAdminService", "261", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "attempt to register ConfigChangeListener failed", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerListenerWithAdminService");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        this.fireStoppedEvent();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SecurityConfigServiceListener l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addListener", l);
        }
        ArrayList<SecurityConfigServiceListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SecurityConfigServiceListener l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListener", l);
        }
        ArrayList<SecurityConfigServiceListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStartedEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fireStartedEvent");
        }
        List list = null;
        ArrayList<SecurityConfigServiceListener> arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int SIZE = list.size();
            SecurityConfigServiceEvent e = new SecurityConfigServiceEvent(1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list size = " + SIZE);
            }
            for (int i = 0; i < SIZE; ++i) {
                if (tc.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer("Invoking stateChanged(), Listener.hashCode() = ");
                    sb.append(list.get(i).hashCode());
                    sb.append("Listener.toString()");
                    sb.append(list.get(i).toString());
                    Tr.debug(tc, sb.toString());
                }
                try {
                    ((SecurityConfigServiceListener)list.get(i)).stateChanged(e);
                    continue;
                }
                catch (Exception ex) {
                    Tr.error(tc, "ssl.init.error.CWPKI0008E", new Object[]{ex});
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.ssl.core.SSLComponentImpl.fireStartedEvent", "429", this);
                }
            }
        }
        this.componentState = 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fireStartedEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStoppedEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fireStoppedEvent");
        }
        List list = null;
        ArrayList<SecurityConfigServiceListener> arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int SIZE = list.size();
            SecurityConfigServiceEvent e = new SecurityConfigServiceEvent(2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list size = " + SIZE);
            }
            for (int i = 0; i < SIZE; ++i) {
                if (tc.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer("Invoking stateChanged(), Listener.hashCode() = ");
                    sb.append(list.get(i).hashCode());
                    sb.append("Listener.toString()");
                    sb.append(list.get(i).toString());
                    Tr.debug(tc, sb.toString());
                }
                try {
                    ((SecurityConfigServiceListener)list.get(i)).stateChanged(e);
                    continue;
                }
                catch (Exception ex) {
                    Tr.error(tc, "ssl.stop.error.CWPKI0015E", new Object[]{ex});
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.config.SecurityConfigComponentImpl.fireStoppedEvent", "476", this);
                }
            }
        }
        this.componentState = 2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fireStoppedEvent");
        }
    }

    public Repository getRepositoryService() {
        try {
            repository = WsServiceRegistry.getService(this, Repository.class);
            if (repository == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Repository is null.");
            }
            return repository;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Repository getRepository() {
        return repository;
    }
}

