/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.JAASLoginConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.jaas.Parser;
import com.ibm.ws.security.config.jaas.ParserException;
import com.ibm.ws.security.util.AuthData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.login.AppConfigurationEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAASLoginConfigImpl
extends Parser
implements JAASLoginConfig {
    private static TraceComponent tc = Tr.register(JAASLoginConfigImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private SecurityConfigObject parent_sco = null;
    private String cacheKey = null;
    private HashMap<String, List<AppConfigurationEntry>> sysMap = null;
    private HashMap<String, List<AppConfigurationEntry>> appMap = null;
    private Object authDataSyncObject = new Object();
    private HashMap authDataMap = null;

    public JAASLoginConfigImpl(SecurityConfigObject parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey, parent);
        }
        this.cacheKey = _cacheKey;
        this.parent_sco = parent;
        this.sysMap = new HashMap();
        this.appMap = new HashMap();
        this.initialize(this.parent_sco);
        this.refreshAuthDataEntries(null);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor " + this.cacheKey);
        }
    }

    @Override
    public List<AppConfigurationEntry> get(String alias) {
        List<AppConfigurationEntry> ret;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "get() alias=" + alias + " " + this.cacheKey);
        }
        if ((ret = this.appMap.get(alias)) == null) {
            ret = this.sysMap.get(alias);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "get " + this.cacheKey, ret);
        }
        return ret;
    }

    public HashMap<String, List<AppConfigurationEntry>> getMap() {
        HashMap<String, List<AppConfigurationEntry>> ret = new HashMap<String, List<AppConfigurationEntry>>();
        ret.putAll(this.sysMap);
        ret.putAll(this.appMap);
        return ret;
    }

    @Override
    public Map<String, List<AppConfigurationEntry>> getSysMap() {
        return this.sysMap;
    }

    @Override
    public Map<String, List<AppConfigurationEntry>> getAppMap() {
        return this.appMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateSysMap(String cfgString) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "update() cfgString=" + cfgString + " " + this.cacheKey);
        }
        if (cfgString == null || cfgString.length() == 0) {
            Tr.warning(tc, "security.jaas.update");
        } else {
            Reader retrdr = null;
            try {
                retrdr = new BufferedReader(new StringReader(cfgString));
                this.sysMap = this.parse(retrdr);
            }
            catch (IOException ioe) {
                Tr.error(tc, "security.jaas.open.stringreader");
            }
            catch (ParserException pe) {
                Tr.error(tc, "security.jaas.parser.stringreader");
            }
            finally {
                try {
                    retrdr.close();
                }
                catch (IOException ioe) {
                    Tr.warning(tc, "security.jaas.close.stream");
                }
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "update() " + this.cacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateAppMap(String cfgString) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAppMap " + this.cacheKey, cfgString);
        }
        Reader rdr = null;
        try {
            rdr = new BufferedReader(new StringReader(cfgString));
            this.appMap = this.parse(rdr);
        }
        catch (IOException ioe) {
            Tr.error(tc, "security.core.open.stringreader");
        }
        catch (ParserException pe) {
            Tr.error(tc, "security.core.parser.stringreader");
        }
        finally {
            try {
                rdr.close();
            }
            catch (IOException ioe) {
                Tr.warning(tc, "security.core.close.stream");
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Updated JAAS Login Configuration: " + this.appMap.toString());
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAppMap " + this.cacheKey);
        }
    }

    @Override
    public String toString2() {
        String result = null;
        StringBuffer sb = new StringBuffer(1024);
        sb.append("JAAS WCCM configuration data:\n");
        Map oneMap = this.getMap();
        if (oneMap != null && ((HashMap)oneMap).size() > 0) {
            result = JAASLoginConfigImpl.convertMapToString((HashMap)oneMap);
            sb.append(result).append("\n");
        } else {
            sb.append("None.\n");
        }
        return sb.toString();
    }

    private synchronized void initialize(SecurityConfigObject security_sco) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        SecurityConfigObject sysJAASConfig = security_sco.getObject("systemLoginConfig");
        this.sysMap = JAASLoginConfigImpl.convertToConfiguration(sysJAASConfig, true);
        SecurityConfigObject appJAASConfig = security_sco.getObject("applicationLoginConfig");
        this.appMap = JAASLoginConfigImpl.convertToConfiguration(appJAASConfig, false);
        Tr.info(tc, "security.init.wccmjaas.init");
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "The dynamic JAAS login configuration is:", JAASLoginConfigImpl.convertMapToString((HashMap)this.getMap()));
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private static String convertMapToString(HashMap map) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "convertMapToString, in Map= " + map);
        }
        String result = null;
        StringBuffer sb = new StringBuffer(1024);
        if (map != null) {
            Set aeSet = map.entrySet();
            for (Map.Entry me : aeSet) {
                String alias = (String)me.getKey();
                if (alias == null) {
                    Tr.error(tc, "security.jaasconfig.helper.baddata", new Object[]{"convertMapToString", "alias", null});
                    continue;
                }
                sb.append(me.getKey()).append(" ").append('{').append('\n');
                Vector aeVec = (Vector)me.getValue();
                int aeVecSize = aeVec.size();
                for (int i = 0; i < aeVecSize; ++i) {
                    AppConfigurationEntry ace = (AppConfigurationEntry)aeVec.elementAt(i);
                    JAASLoginConfigImpl.printACE(sb, ace);
                }
                sb.append("};\n");
            }
        }
        result = sb.toString();
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "The internal JAAS config map has been converted to:\n" + result);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "convertMapToString");
        }
        return result;
    }

    private static void printACE(StringBuffer sb, AppConfigurationEntry ace) {
        if (sb == null || ace == null) {
            return;
        }
        String flag = ace.getControlFlag().toString();
        flag = flag.substring(flag.indexOf(58) + 1);
        sb.append("    ").append(ace.getLoginModuleName()).append(" ").append(flag);
        Map<String, ?> options = ace.getOptions();
        if (options != null && options.size() > 0) {
            Set<Map.Entry<String, ?>> entrySet = options.entrySet();
            for (Map.Entry<String, ?> me : entrySet) {
                String optionName = me.getKey();
                String optionValue = (String)me.getValue();
                sb.append("\n       ").append(optionName).append('=').append('\"').append(optionValue).append('\"');
            }
        }
        sb.append("   ").append(";\n");
    }

    private static HashMap<String, List<AppConfigurationEntry>> convertToConfiguration(SecurityConfigObject config2, boolean sys) {
        JAASLoginConfig adminJAASConfig;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToConfiguration " + config2);
        }
        HashMap<String, List<AppConfigurationEntry>> configMap = new HashMap<String, List<AppConfigurationEntry>>();
        if (config2 == null) {
            return null;
        }
        SecurityConfig security = SecurityObjectLocator.getSecurityConfig();
        if (!SecurityObjectLocator.getSecurityConfigManager().isAdminAgent() && config2.isDomainConfig() && security.getPropertyBool("com.ibm.websphere.security.domain.inherit.JAAS") && (adminJAASConfig = SecurityObjectLocator.getSecurityConfig("security").getJAASLoginConfig()) != null) {
            HashMap adminMap = null;
            adminMap = sys ? (HashMap)adminJAASConfig.getSysMap() : (HashMap)adminJAASConfig.getAppMap();
            if (adminMap != null) {
                configMap.putAll(adminMap);
            }
        }
        SecurityConfigObjectList entries = config2.getObjectList("entries");
        for (int i = 0; i < entries.size(); ++i) {
            SecurityConfigObject entry = entries.get(i);
            String name = entry.getString("alias");
            if (name.length() != 0) {
                if (sys) {
                    name = "system." + name;
                }
                if (configMap.containsKey(name)) {
                    Tr.warning(tc, "security.init.wccmjaas.dupentry", new Object[]{name});
                }
                configMap.put(name, JAASLoginConfigImpl.convertToAppEntry(entry));
                continue;
            }
            Tr.warning(tc, "security.wccmjaas.no.alias", new Object[]{config2});
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToConfiguration ");
        }
        return configMap;
    }

    private static Vector<AppConfigurationEntry> convertToAppEntry(SecurityConfigObject wcEntry) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToAppEntry " + wcEntry);
        }
        Vector<AppConfigurationEntry> appEntry = new Vector<AppConfigurationEntry>();
        SecurityConfigObjectList loginModules = wcEntry.getObjectList("loginModules");
        for (int i = 0; i < loginModules.size(); ++i) {
            SecurityConfigObject wcLModule = loginModules.get(i);
            appEntry.add(JAASLoginConfigImpl.convertWCCMtoJaasConfig(wcLModule));
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToAppEntry ");
        }
        return appEntry;
    }

    private static AppConfigurationEntry convertWCCMtoJaasConfig(SecurityConfigObject wcLM) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "convertWCCMtoJaasConfig " + wcLM);
        }
        AppConfigurationEntry appEntry = new AppConfigurationEntry(wcLM.getString("moduleClassName"), JAASLoginConfigImpl.buildFlag(wcLM), JAASLoginConfigImpl.buildOptions(wcLM));
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "convertWCCMtoJaasConfig ");
        }
        return appEntry;
    }

    private static AppConfigurationEntry.LoginModuleControlFlag buildFlag(SecurityConfigObject wcLModule) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "buildModuleControlFlag " + wcLModule);
        }
        AppConfigurationEntry.LoginModuleControlFlag appFlag = null;
        String authStrat = wcLModule.getString("authenticationStrategy", "REQUIRED");
        if (authStrat.equals("REQUIRED")) {
            appFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        } else if (authStrat.equals("REQUISITE")) {
            appFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        } else if (authStrat.equals("SUFFICIENT")) {
            appFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        } else if (authStrat.equals("OPTIONAL")) {
            appFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        } else {
            System.out.println("Error, invalid JAAS authentication strategy: " + authStrat + ". Using REQUIRED");
        }
        appFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "buildModuleControlFlag " + appFlag);
        }
        return appFlag;
    }

    private static Map<String, String> buildOptions(SecurityConfigObject lm) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "buildOptions " + lm);
        }
        HashMap<String, String> opt = new HashMap<String, String>();
        SecurityConfigObjectList options = lm.getObjectList("options", false);
        for (int i = 0; i < options.size(); ++i) {
            SecurityConfigObject wcOpt = options.get(i);
            opt.put(wcOpt.getString("name"), wcOpt.getString("value"));
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "buildOptions " + opt);
        }
        return opt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthData getAuthData(String uidpswEntry) {
        AuthData ret;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthData: uidpswEntry=" + uidpswEntry + " " + this.cacheKey);
        }
        Object object = this.authDataSyncObject;
        synchronized (object) {
            ret = (AuthData)this.authDataMap.get(uidpswEntry);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthData " + this.cacheKey, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAuthDataEntries(HashMap map) {
        HashMap _map;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshAuthDataEntries " + this.cacheKey, map);
        }
        if ((_map = map == null ? this.refreshAuthDataEntries() : map) != null) {
            Object object = this.authDataSyncObject;
            synchronized (object) {
                this.authDataMap = _map;
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAuthDataEntries " + this.cacheKey, this.authDataMap);
        }
    }

    private HashMap refreshAuthDataEntries() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshAuthDataEntries " + this.cacheKey);
        }
        HashMap<String, AuthData> tmpAuthDataMap = null;
        try {
            HashMap adminAuthData;
            JAASLoginConfig adminJAASConfig;
            SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
            String scope = null;
            scope = this.parent_sco.isDomainConfig() ? "AppSecurity" : "Security";
            SecurityConfigObjectList adlist = scm.refreshAuthData(scope);
            tmpAuthDataMap = new HashMap<String, AuthData>();
            SecurityConfig security = SecurityObjectLocator.getSecurityConfig();
            if (this.parent_sco.isDomainConfig() && security.getPropertyBool("com.ibm.websphere.security.domain.inherit.J2C") && (adminJAASConfig = SecurityObjectLocator.getSecurityConfig("security").getJAASLoginConfig()) != null && (adminAuthData = adminJAASConfig.getAuthDataMap()) != null) {
                tmpAuthDataMap.putAll(adminAuthData);
            }
            for (int i = 0; i < adlist.size(); ++i) {
                SecurityConfigObject jad = adlist.get(i);
                if (jad == null) continue;
                tmpAuthDataMap.put(jad.getString("alias"), new AuthData(jad.getString("userId"), jad.getDecodedString("password")));
                if (!SecurityConfigGlobals.enableVerbose || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "AuthData - add " + jad.getString("alias", null));
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.refreshAuthDataEntries", "806", this);
            Tr.error(tc, "security.servcomp.init");
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAuthDataEntries " + this.cacheKey);
        }
        return tmpAuthDataMap;
    }

    @Override
    public HashMap getAuthDataMap() {
        return this.authDataMap;
    }
}

