/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException;
import com.ibm.websphere.resource.WASResourceImpl;
import com.ibm.ws.config.ModelMgr;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;

public class EncodePasswords {
    public static void fixPasswords(String pathFile) throws IOException, UnsupportedCryptoAlgorithmException, InvalidPasswordEncodingException {
        ModelMgr.initialize("ws-server");
        WASResourceImpl r = new WASResourceImpl(URI.createFileURI(pathFile));
        r.load(null);
        r.save(null);
    }

    public static boolean hasPlainTextPasswords(ConfigObject rcsObject) {
        if (EncodePasswords.checkChildren(rcsObject, "userRegistries", new String[]{"serverPassword", "bindPassword"})) {
            return true;
        }
        if (EncodePasswords.checkChildren(rcsObject, "authDataEntries", new String[]{"password"})) {
            return true;
        }
        if (EncodePasswords.checkChildren(rcsObject, "keySets", new String[]{"password"})) {
            return true;
        }
        if (EncodePasswords.checkChildren(rcsObject, "keyStores", new String[]{"password"})) {
            return true;
        }
        List l1 = rcsObject.getObjectList("CSI");
        Iterator i1 = l1.iterator();
        while (i1.hasNext()) {
            List l2 = ((ConfigObject)i1.next()).getObjectList("performs");
            Iterator i2 = l2.iterator();
            while (i2.hasNext()) {
                List l3 = ((ConfigObject)i2.next()).getObjectList("layers");
                Iterator i3 = l3.iterator();
                while (i3.hasNext()) {
                    if (!EncodePasswords.checkChildren((ConfigObject)i3.next(), "supportedQOP", new String[]{"trustedPassword"})) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean checkChildren(ConfigObject rcsObject, String key, String[] attributes) {
        List l = rcsObject.getObjectList(key);
        for (ConfigObject child : l) {
            for (int i = 0; child != null && i < attributes.length; ++i) {
                String password = child.getString(attributes[i], null);
                if (!EncodePasswords.hasPlainTextPassword(password)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasPlainTextPassword(String password) {
        return password != null && password.length() > 0 && !PasswordUtil.isEncrypted(password);
    }
}

