/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.CSIv2QOPConfig;
import com.ibm.ws.security.config.GenericConfigHelperImpl;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;

public class CSIv2LayerConfig
extends GenericConfigHelperImpl {
    public static final String SUPPORTED_AUTH_MECH_LIST = "supportedAuthMechList";
    public static final String AUTHENTICATION_LAYER_RETRY_COUNT = "authenticationLayerRetryCount";
    public static final String AUTHENTICATION_LAYER_RETRY_ENABLED = "authenticationRetryEnabled";
    public static final String TYPE_IDENTITY_ASSERTION_LAYER = "IdentityAssertionLayer";
    public static final String TYPE_MESSAGE_LAYER = "MessageLayer";
    public static final String TPYE_TRANSPORT_LAYER = "TransportLayer";
    private static final String SERVER_AUTHENTICATION = "serverAuthentication";
    private static final String SSL_CONFIG = "sslConfig";
    private static final String SUPPORTED_QOP = "supportedQOP";
    private static final String REQUIRED_QOP = "requiredQOP";
    private static TraceComponent tc = Tr.register(CSIv2LayerConfig.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private CSIv2QOPConfig requiredQOP = null;
    private CSIv2QOPConfig supportedQOP = null;
    private String type = null;

    public CSIv2LayerConfig(SecurityConfigObject obj, GenericConfigHelperImpl parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey, new Object[]{obj, parent});
        }
        super.initialize(obj, parent, _cacheKey);
        this.initialize_defaults();
        this.initialization();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor" + this.cacheKey, this);
        }
    }

    private void initialize_defaults() {
        this.defaults.put(SUPPORTED_AUTH_MECH_LIST, "ltpa|basicAuth|custom");
        this.defaults.put(AUTHENTICATION_LAYER_RETRY_COUNT, 3);
        this.defaults.put(AUTHENTICATION_LAYER_RETRY_ENABLED, Boolean.FALSE);
    }

    private void initialization() {
        int retryCount;
        if (this.isSet(SUPPORTED_AUTH_MECH_LIST)) {
            String authMechList = this.getString(SUPPORTED_AUTH_MECH_LIST);
            String[] list = null;
            if (authMechList.length() == 0) {
                throw new IllegalStateException("Invalid empty string for supportedAuthMechList");
            }
            list = authMechList.split("\\|");
            int i = 0;
            for (i = 0; i < list.length; ++i) {
                String value = list[i].toLowerCase();
                if (value.equalsIgnoreCase("krb5") || value.equalsIgnoreCase("ltpa") || value.equalsIgnoreCase("rsatoken") || value.equalsIgnoreCase("basicauth") || value.equalsIgnoreCase("custom")) continue;
                throw new IllegalStateException("A value defined in supportedAuthMechList is invalid. The value is:" + value);
            }
        }
        if ((retryCount = this.getInteger(AUTHENTICATION_LAYER_RETRY_COUNT)) > 0) {
            this.setBoolean(AUTHENTICATION_LAYER_RETRY_ENABLED, Boolean.TRUE);
        } else {
            this.setBoolean(AUTHENTICATION_LAYER_RETRY_ENABLED, Boolean.FALSE);
        }
    }

    public String getType() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getType" + this.cacheKey);
        }
        if (this.type == null) {
            if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.securityprotocol.xmi", TYPE_IDENTITY_ASSERTION_LAYER)) {
                this.type = TYPE_IDENTITY_ASSERTION_LAYER;
            } else if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.securityprotocol.xmi", TYPE_MESSAGE_LAYER)) {
                this.type = TYPE_MESSAGE_LAYER;
            } else if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.securityprotocol.xmi", TPYE_TRANSPORT_LAYER)) {
                this.type = TPYE_TRANSPORT_LAYER;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown CSIv2 Layer type");
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getType" + this.cacheKey, this.type);
        }
        return this.type;
    }

    private synchronized void do_getSupportedQOP() {
        SecurityConfigObject sQOP;
        if (this.supportedQOP == null && (sQOP = this.sco.getObject(SUPPORTED_QOP, false)) != null) {
            this.supportedQOP = new CSIv2QOPConfig(sQOP, this, this.cacheKey);
        }
    }

    public CSIv2QOPConfig getSupportedQOP() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedQOP" + this.cacheKey);
        }
        if (this.supportedQOP == null) {
            this.do_getSupportedQOP();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedQOP" + this.cacheKey, this.supportedQOP);
        }
        return this.supportedQOP;
    }

    private synchronized void do_getRequiredQOP() {
        SecurityConfigObject rQOP;
        if (this.requiredQOP == null && (rQOP = this.sco.getObject(REQUIRED_QOP, false)) != null) {
            this.requiredQOP = new CSIv2QOPConfig(rQOP, this, this.cacheKey);
        }
    }

    public CSIv2QOPConfig getRequiredQOP() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequiredQOP" + this.cacheKey);
        }
        if (this.requiredQOP == null) {
            this.do_getRequiredQOP();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequiredQOP" + this.cacheKey, this.requiredQOP);
        }
        return this.requiredQOP;
    }

    public String getTrustedServers() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustedServers" + this.cacheKey);
        }
        StringBuffer serverIDBuf = new StringBuffer("");
        SecurityConfigObjectList trustedServers = this.sco.getObjectList("trustedServers");
        for (int i = 0; i < trustedServers.size(); ++i) {
            String serverId = trustedServers.get(i).getString("serverId");
            if (i == 0) {
                serverIDBuf.append(serverId);
                continue;
            }
            serverIDBuf.append(",");
            serverIDBuf.append(serverId);
        }
        String serverIDList = serverIDBuf.toString();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustedServers" + this.cacheKey, serverIDList);
        }
        return serverIDList;
    }

    public String getServerAuthentication() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerAuthentication" + this.cacheKey);
        }
        String result = scm.getString(this.sco, SERVER_AUTHENTICATION, SSL_CONFIG, null, false, true);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerAuthentication" + this.cacheKey, result);
        }
        return result;
    }
}

