/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ISecurityUtilityImpl.AuthenticationTarget;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.CSIv2ConfigData;
import com.ibm.ws.security.config.CSIv2IOBoundConfig;
import com.ibm.ws.security.config.CSIv2LayerConfig;
import com.ibm.ws.security.config.CSIv2QOPConfig;
import com.ibm.ws.security.config.ConfigURLProperties;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigImpl;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.util.ConfigUtils;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class CSIv2ConfigImpl
implements CSIv2Config {
    private static final TraceComponent tc = Tr.register(CSIv2ConfigImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private HashMap<String, Object> defaults = null;
    private HashMap<String, Object> generatedData = null;
    private HashMap<String, Object> userPasswordMap = null;
    private String cacheKey = null;
    private Properties myProps = null;

    public CSIv2ConfigImpl(String _cacheKey, Object endPointMgr) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey);
        }
        this.cacheKey = _cacheKey;
        this.defaults = new HashMap();
        this.generatedData = new HashMap();
        this.userPasswordMap = new HashMap();
        if (endPointMgr == null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: endPointMgr is null");
            }
        } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor: endPointMgr is not null");
        }
        this.initialize((EndPointMgr)endPointMgr);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor " + this.cacheKey);
        }
    }

    private void setGloballyVisiblyDefaults() {
        if (!RasHelper.isServer()) {
            this.defaults.put("DefaultLoginSource", "prompt");
        } else {
            this.defaults.put("DefaultLoginSource", "properties");
        }
        this.defaults.put("DefaultLoginTimeout", 300);
        this.defaults.put("DefaultSessionGCinterval", 300000);
        this.defaults.put("DefaultSessionGCdiscardunused", 900000);
        this.defaults.put("DefaultAuthenticationRetryCount", 3);
        this.defaults.put("DefaultDelegateCredentialsServerString", "methoddefined");
        this.defaults.put("DefaultClaimStateful", Boolean.TRUE);
        this.defaults.put("DefaultClaimClientAuthenticationSupported", Boolean.TRUE);
        this.defaults.put("DefaultClaimClientAuthenticationRequired", Boolean.FALSE);
        this.defaults.put("DefaultClaimIdentityAssertionSupported", Boolean.FALSE);
        this.defaults.put("DefaultClaimMessageConfidentialityRequired", Boolean.FALSE);
        this.defaults.put("DefaultClaimMessageConfidentialitySupported", Boolean.TRUE);
        this.defaults.put("DefaultClaimMessageIntegrityRequired", Boolean.TRUE);
        this.defaults.put("DefaultClaimMessageIntegritySupported", Boolean.TRUE);
        this.defaults.put("DefaultClaimTransportAssocSSLTLSRequired", Boolean.FALSE);
        this.defaults.put("DefaultClaimTransportAssocSSLTLSSupported", Boolean.FALSE);
        this.defaults.put("DefaultClaimTLClientAuthenticationRequired", Boolean.FALSE);
        this.defaults.put("DefaultPerformStateful", Boolean.TRUE);
        this.defaults.put("DefaultPerformClientAuthenticationRequired", Boolean.FALSE);
        this.defaults.put("DefaultPerformClientAuthenticationSupported", Boolean.TRUE);
        this.defaults.put("DefaultPerformIdentityAssertionSupported", Boolean.FALSE);
        this.defaults.put("DefaultPerformIdentityAssertionRequired", Boolean.FALSE);
        this.defaults.put("DefaultPerformMessageConfidentiality", Boolean.FALSE);
        this.defaults.put("DefaultPerformMessageConfidentialityRequired", Boolean.FALSE);
        this.defaults.put("DefaultPerformMessageConfidentialitySupported", Boolean.TRUE);
        this.defaults.put("DefaultPerformMessageIntegrity", Boolean.FALSE);
        this.defaults.put("DefaultPerformMessageIntegrityRequired", Boolean.TRUE);
        this.defaults.put("DefaultPerformMessageIntegritySupported", Boolean.TRUE);
        this.defaults.put("DefaultPerformTransportAssocSSLTLSRequired", Boolean.FALSE);
        this.defaults.put("DefaultPerformTransportAssocSSLTLSSupported", Boolean.TRUE);
        this.defaults.put("DefaultPerformTLClientAuthenticationRequired", Boolean.FALSE);
        this.defaults.put("DefaultPerformTLClientAuthenticationSupported", Boolean.FALSE);
    }

    private void setDefaults() {
        this.setGloballyVisiblyDefaults();
        this.defaults.put("com.ibm.CORBA.securityEnabled", Boolean.TRUE);
        this.defaults.put("com.ibm.CORBA.serverSecurityEnabled", Boolean.FALSE);
        this.defaults.put("com.ibm.CORBA.authenticationRetryEnabled", Boolean.FALSE);
        this.defaults.put("com.ibm.CORBA.validateBasicAuth", Boolean.TRUE);
        this.defaults.put("com.ibm.CORBA.authenticationTarget", 2);
        this.defaults.put("com.ibm.CORBA.authenticationRetryCount", 3);
        this.defaults.put("com.ibm.CORBA.securityServerHost", "");
        this.defaults.put("com.ibm.CORBA.securityServerPort", "");
        this.defaults.put("com.ibm.CORBA.validateBasicAuth", Boolean.TRUE);
        this.defaults.put("com.ibm.CORBA.loginUserid", "");
        this.defaults.put("com.ibm.CORBA.loginPassword", "");
        this.defaults.put("com.ibm.CORBA.loginSource", this.defaults.get("DefaultLoginSource"));
        this.defaults.put("com.ibm.CORBA.loginTimeout", this.defaults.get("DefaultLoginTimeout"));
        this.defaults.put("com.ibm.CORBA.sessionGCdiscardunused", this.defaults.get("DefaultSessionGCdiscardunused"));
        this.defaults.put("com.ibm.CORBA.sessionGCinterval", this.defaults.get("DefaultSessionGCinterval"));
        this.defaults.put("com.ibm.CSI.claimStateful", this.defaults.get("DefaultClaimStateful"));
        this.defaults.put("com.ibm.CSI.claimClientAuthenticationRequired", this.defaults.get("DefaultClaimClientAuthenticationRequired"));
        this.defaults.put("com.ibm.CSI.claimClientAuthenticationSupported", this.defaults.get("DefaultClaimClientAuthenticationSupported"));
        this.defaults.put("com.ibm.CSI.claimIdentityAssertionRequired", "DEPRICATED");
        this.defaults.put("com.ibm.CSI.claimIdentityAssertionSupported", this.defaults.get("DefaultClaimIdentityAssertionSupported"));
        this.defaults.put("com.ibm.CSI.claimMessageConfidentialityRequired", this.defaults.get("DefaultClaimMessageConfidentialityRequired"));
        this.defaults.put("com.ibm.CSI.claimMessageConfidentialitySupported", this.defaults.get("DefaultClaimMessageConfidentialitySupported"));
        this.defaults.put("com.ibm.CSI.claimMessageIntegrityRequired", this.defaults.get("DefaultClaimMessageIntegrityRequired"));
        this.defaults.put("com.ibm.CSI.claimMessageIntegritySupported", this.defaults.get("DefaultClaimMessageIntegritySupported"));
        this.defaults.put("com.ibm.CSI.claimMessageOutOfSequenceDetectionRequired", "DEPRICATED");
        this.defaults.put("com.ibm.CSI.claimMessageOutOfSequenceDetectionSupported", "DEPRICATED");
        this.defaults.put("com.ibm.CSI.claimMessageReplayDetectionRequired", "DEPRICATED");
        this.defaults.put("com.ibm.CSI.claimMessageReplayDetectionSupported", "DEPRICATED");
        this.defaults.put("com.ibm.CSI.claimMessageSupportedAuthMechList", null);
        this.defaults.put("com.ibm.CSI.claimServerAuthenticationRequired", "DEPRICATED");
        this.defaults.put("com.ibm.CSI.claimServerAuthenticationSupported", "DEPRICATED");
        this.defaults.put("com.ibm.CSI.claimTransportAssocSSLTLSRequired", this.defaults.get("DefaultClaimTransportAssocSSLTLSRequired"));
        this.defaults.put("com.ibm.CSI.claimTransportAssocSSLTLSSupported", this.defaults.get("DefaultClaimTransportAssocSSLTLSSupported"));
        this.defaults.put("com.ibm.CSI.claimTLClientAuthenticationRequired", this.defaults.get("DefaultClaimTLClientAuthenticationRequired"));
        this.defaults.put("com.ibm.CSI.claimTLClientAuthenticationSupported", Boolean.FALSE);
        this.defaults.put("com.ibm.CSI.performStateful", Boolean.TRUE);
        this.defaults.put("com.ibm.CSI.performClientAuthenticationRequired", Boolean.FALSE);
        this.defaults.put("com.ibm.CSI.performClientAuthenticationSupported", Boolean.TRUE);
        this.defaults.put("com.ibm.CSI.performIdentityAssertionMechanism", 2);
        this.defaults.put("com.ibm.CSI.performIdentityAssertionName", "DEPRICATED");
        this.defaults.put("com.ibm.CSI.performIdentityAssertionRequired", Boolean.FALSE);
        this.defaults.put("com.ibm.CSI.performIdentityAssertionSupported", Boolean.FALSE);
        this.defaults.put("com.ibm.CSI.performIdentityAssertionType", 15);
        this.defaults.put("com.ibm.CSI.performMessageConfidentialityRequired", Boolean.FALSE);
        this.defaults.put("com.ibm.CSI.performMessageConfidentialitySupported", Boolean.TRUE);
        this.defaults.put("com.ibm.CSI.performMessageIntegrityRequired", Boolean.TRUE);
        this.defaults.put("com.ibm.CSI.performMessageIntegritySupported", Boolean.TRUE);
        this.defaults.put("com.ibm.CSI.performMessageOutOfSequenceDetection", "DEPRICATED");
        this.defaults.put("com.ibm.CSI.performMessageReplayDetection", "DEPRICATED");
        this.defaults.put("com.ibm.CSI.performMessageSupportedAuthMechList", null);
        this.defaults.put("com.ibm.CSI.performServerAuthenticationRequired", Boolean.FALSE);
        this.defaults.put("com.ibm.CSI.performServerAuthenticationSupported", Boolean.TRUE);
        this.defaults.put("com.ibm.CSI.performTLClientAuthenticationRequired", Boolean.FALSE);
        this.defaults.put("com.ibm.CSI.performTLClientAuthenticationSupported", Boolean.FALSE);
        this.defaults.put("com.ibm.CSI.performTransportAssocSSLTLSRequired", Boolean.FALSE);
        this.defaults.put("com.ibm.CSI.performTransportAssocSSLTLSSupported", Boolean.TRUE);
        this.defaults.put("com.ibm.ws.security.includeRunAsChangesInCallerList", Boolean.FALSE);
        this.defaults.put("com.ibm.CORBA.NotifyBrokenConnectionEnabled", Boolean.TRUE);
        this.defaults.put("com.ibm.CSI.ClientCertSSLPort", 0);
        this.defaults.put("com.ibm.CSI.SSLPort", 0);
        this.defaults.put("com.ibm.CORBA.SSLPort", 0);
        this.defaults.put("com.ibm.CSI.isRealmHostSubjectLookupEnabled", Boolean.FALSE);
        this.defaults.put("com.ibm.CORBA.keyFileName", "");
        this.defaults.put("com.ibm.ws.security.assertLDAPShortName", Boolean.FALSE);
        this.defaults.put("com.ibm.CSI.WSSecurityContextActiveOID", "oid:1.3.18.0.2.30.2");
        this.defaults.put("com.ibm.CSI.WSSecurityContextActiveClass", "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl");
        this.defaults.put("com.ibm.CSI.WSSecurityContextCustomOID", "oid:1.3.18.0.2.30.3");
        this.defaults.put("com.ibm.CSI.WSSecurityContextCustomClass", "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextCustomImpl");
        this.defaults.put("com.ibm.CORBA.realmName", "");
        this.defaults.put("com.ibm.CORBA.principalName", "");
        this.defaults.put("com.ibm.CSI.trustedPrincipalList", "");
        this.defaults.put("com.ibm.CSI.refreshClientSubjectGoingOutbound", Boolean.TRUE);
        this.defaults.put("com.ibm.CSI.authenticateSpecialMethods", Boolean.FALSE);
        this.defaults.put("com.ibm.CSI.neverUseClientCertificateForCallerLogin", Boolean.FALSE);
        this.defaults.put("com.ibm.websphere.security.krb.allowLTPAAuth", Boolean.TRUE);
        this.defaults.put("com.ibm.websphere.security.krb.spn", "");
        this.defaults.put("com.ibm.websphere.security.krb.spn_password", "");
        this.defaults.put("com.ibm.websphere.security.krb.realm", "");
        this.defaults.put("com.ibm.websphere.security.krb.keytab", "");
        this.defaults.put("com.ibm.websphere.security.krb.config", "");
        this.defaults.put("com.ibm.ws.security.createTokenSubjectForAsynchLogin", Boolean.FALSE);
        this.defaults.put("com.ibm.CORBA.useDefaultSubjectForThreads", Boolean.TRUE);
        this.defaults.put("com.ibm.CSI.authMechAuthAlias", "system.LTPA");
        this.defaults.put("com.ibm.CSI.activeUserRegistry", "NONE");
        this.defaults.put("com.ibm.ws.security.webChallengeIfCustomSubjectNotFound", Boolean.TRUE);
        this.defaults.put("multiLoginEnabled", Boolean.FALSE);
    }

    private void initializeLoginProperties() {
        String REALM_SEPARATOR = "\\|";
        String loginRealm = this.getString("com.ibm.CORBA.loginRealm");
        String loginUserID = this.getString("com.ibm.CORBA.loginUserid");
        String loginPassword = this.getString("com.ibm.CORBA.loginPassword");
        if (loginRealm != null && loginRealm.length() > 0 && loginUserID != null && loginUserID.length() > 0 && loginPassword != null && loginPassword.length() > 0) {
            String[] multiRealm = loginRealm.split(REALM_SEPARATOR);
            String[] multiUserid = loginUserID.split(REALM_SEPARATOR);
            String[] multiPassword = loginPassword.split(REALM_SEPARATOR);
            if (multiRealm.length > 1 && multiUserid.length > 1 && multiPassword.length > 1 && multiRealm.length == multiUserid.length && multiRealm.length == multiPassword.length) {
                try {
                    for (int i = 0; i < multiRealm.length; ++i) {
                        Object[] userPassword = new Object[]{multiUserid[i], multiPassword[i].getBytes("UTF8")};
                        this.userPasswordMap.put(multiRealm[i], userPassword);
                        if (!SecurityConfigGlobals.enableVerbose || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Adding realm = " + multiRealm[i] + " userid = " + multiUserid[i] + " to the map");
                    }
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting multiLoginEnabled");
                    }
                    this.setBoolean("multiLoginEnabled", true);
                }
                catch (UnsupportedEncodingException uee) {
                    Tr.debug(tc, "Exception during byte converstion. " + uee.toString());
                }
            } else {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not setting multiLoginEnabled, check configuration");
                }
                this.setBoolean("multiLoginEnabled", false);
            }
        }
    }

    private void initializeOnClient(String propertiesURL, ORB orb) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeOnClient()  + cacheKey");
        }
        String propertyResult = null;
        boolean propertyValid = false;
        ConfigURLProperties sasClientProps = ConfigURLProperties.getInstance();
        sasClientProps.init(propertiesURL, orb);
        boolean securityEnabled = false;
        boolean serverSecurityEnabled = true;
        String secEnabled = sasClientProps.getProperty("com.ibm.CORBA.securityEnabled");
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "*** secEnabled = " + secEnabled);
        }
        securityEnabled = ConfigUtils.stringToBoolean((String)secEnabled);
        String serverSecEnabled = sasClientProps.getProperty("com.ibm.CORBA.serverSecurityEnabled");
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "*** serverSecEnabled = " + serverSecEnabled);
        }
        if (serverSecEnabled == null || serverSecEnabled.equals("null")) {
            serverSecurityEnabled = securityEnabled;
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "serverSecurityEnabled set to securityEnabled");
            }
        } else {
            serverSecurityEnabled = ConfigUtils.stringToBoolean((String)serverSecEnabled);
        }
        this.setBoolean("com.ibm.CORBA.securityEnabled", securityEnabled);
        this.setBoolean("com.ibm.CORBA.serverSecurityEnabled", serverSecurityEnabled);
        String appRealm = DomainInfo.getAppRealm();
        if (appRealm != null && appRealm.length() > 0) {
            this.setString("com.ibm.CORBA.realmName", appRealm);
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.authenticationRetryEnabled"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CORBA.authenticationRetryEnabled", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.authenticationRetryCount"))) != null && propertyResult.length() > 0) {
            int authenticationRetryCountProperty = -1;
            propertyValid = false;
            try {
                authenticationRetryCountProperty = new Integer(propertyResult);
                propertyValid = true;
            }
            catch (IllegalArgumentException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.CSIv2ConfigImpl.initializeOnClient", "796", this);
                Tr.error(tc, "security.JSAS0628E", new Object[]{new Integer((String)this.defaults.get("DefaultAuthenticationRetryCount")).toString()});
            }
            if (propertyValid) {
                this.setInteger("com.ibm.CORBA.authenticationRetryCount", authenticationRetryCountProperty);
            }
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.authenticationTarget"))) != null && propertyResult.length() > 0) {
            propertyResult = propertyResult.toLowerCase();
            AuthenticationTarget authTarget = new AuthenticationTarget();
            try {
                this.setInteger("com.ibm.CORBA.authenticationTarget", authTarget.mechtypeToAuthTarget(propertyResult));
            }
            catch (Exception e) {
                Tr.error(tc, "security.JSAS0051E");
            }
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.ssl.csi.outbound.alias"))) != null && propertyResult.length() > 0) {
            this.setString("com.ibm.ssl.csi.outbound.alias", propertyResult);
        } else {
            propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.ssl.alias"));
            if (propertyResult != null && propertyResult.length() > 0) {
                this.setString("com.ibm.ssl.csi.outbound.alias", propertyResult);
            }
        }
        propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.validateBasicAuth"));
        if (propertyResult != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CORBA.validateBasicAuth", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.isRealmSubjectLookupEnabled"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.isRealmSubjectLookupEnabled", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.isRealmHostSubjectLookupEnabled"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.isRealmHostSubjectLookupEnabled", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = PlatformHelperFactory.getPlatformHelper().isZOS() ? sasClientProps.getProperty("com.ibm.CORBA.loginPassword") : ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.loginPassword"))) != null && propertyResult.length() > 0) {
            this.setString("com.ibm.CORBA.loginPassword", propertyResult);
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.krb5CcacheFile"))) != null && propertyResult.length() > 0) {
            this.setString("com.ibm.CORBA.krb5CcacheFile", propertyResult);
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.krb5ConfigFile"))) != null && propertyResult.length() > 0) {
            this.setString("com.ibm.CORBA.krb5ConfigFile", propertyResult);
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.loginSource"))) != null && propertyResult.length() > 0) {
            int loginSource = -1;
            propertyValid = true;
            if ((propertyResult = propertyResult.toLowerCase()).equals("environment")) {
                loginSource = 4;
            } else if (propertyResult.equals("key file")) {
                loginSource = 3;
            } else if (propertyResult.equals("key table")) {
                loginSource = 2;
            } else if (propertyResult.equals("none")) {
                loginSource = 11;
            } else if (propertyResult.equals("prompt")) {
                loginSource = 1;
            } else if (propertyResult.equals("properties")) {
                loginSource = 5;
            } else if (propertyResult.equals("stdin")) {
                loginSource = 6;
            } else if (propertyResult.equals("krb5ccache")) {
                loginSource = 7;
            } else if (propertyResult.equals("krb5ccache:stdin")) {
                loginSource = 9;
            } else if (propertyResult.equals("krb5ccache:prompt")) {
                loginSource = 8;
            } else if (propertyResult.equals("krb5ccache:properties")) {
                loginSource = 10;
            } else {
                propertyValid = false;
                Tr.error(tc, "security.JSAS0498E", new Object[]{this.getString("DefaultLoginSource")});
            }
            if (propertyValid) {
                this.setInteger("com.ibm.CORBA.loginSource", loginSource);
            }
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.loginTimeout"))) != null && propertyResult.length() > 0) {
            int loginTimeoutProperty = -1;
            propertyValid = false;
            try {
                loginTimeoutProperty = new Integer(propertyResult);
                propertyValid = true;
            }
            catch (IllegalArgumentException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.CSIv2ConfigImpl.initializeOnClient", "1517", this);
                Tr.error(tc, "security.JSAS0405E", new Object[]{this.getInteger("DefaultLoginTimeout")});
            }
            if (propertyValid) {
                int MaximumLoginTimeout = 600;
                boolean MinimumLoginTimeout = false;
                if (loginTimeoutProperty < 0) {
                    propertyValid = false;
                } else if (loginTimeoutProperty > 600) {
                    propertyValid = false;
                }
                if (propertyValid) {
                    this.setInteger("com.ibm.CORBA.loginTimeout", loginTimeoutProperty);
                } else {
                    Tr.error(tc, "security.JSAS0404E", new Object[]{this.getInteger("DefaultLoginTimeout")});
                }
            }
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.loginUserid"))) != null && propertyResult.length() > 0) {
            this.setString("com.ibm.CORBA.loginUserid", propertyResult);
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.securityServerPort"))) != null && propertyResult.length() > 0) {
            this.setString("com.ibm.CORBA.securityServerPort", propertyResult);
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CORBA.securityServerHost"))) != null && propertyResult.length() > 0) {
            this.setString("com.ibm.CORBA.securityServerHost", propertyResult);
        }
        this.clientSetCSIv2Values(sasClientProps);
        this.initializeLoginProperties();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeOnClient() " + this.cacheKey);
        }
    }

    private void clientSetCSIv2Values(ConfigURLProperties sasClientProps) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "clientSetCSIv2Values() " + this.cacheKey);
        }
        String propertyResult = null;
        propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performStateful"));
        if (propertyResult != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performStateful", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.alternateIdentityAssertionPerformTrustedId"))) != null && propertyResult.length() > 0) {
            this.setString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedId", propertyResult);
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.alternateIdentityAssertionPerformTrustedPassword"))) != null && propertyResult.length() > 0) {
            this.setString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedPassword", propertyResult);
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performClientAuthenticationRequired"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performClientAuthenticationRequired", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performClientAuthenticationSupported"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performClientAuthenticationSupported", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performIdentityAssertionRequired"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performIdentityAssertionRequired", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performIdentityAssertionSupported"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performIdentityAssertionSupported", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performMessageConfidentialityRequired"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performMessageConfidentialityRequired", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performMessageConfidentialitySupported"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performMessageConfidentialitySupported", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performMessageIntegrityRequired"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performMessageIntegrityRequired", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performMessageIntegritySupported"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performMessageIntegritySupported", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performTransportAssocSSLTLSRequired"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performTransportAssocSSLTLSRequired", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performTransportAssocSSLTLSSupported"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performTransportAssocSSLTLSSupported", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performTLClientAuthenticationRequired"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performTLClientAuthenticationRequired", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performTLClientAuthenticationSupported"))) != null && propertyResult.length() > 0) {
            this.setBoolean("com.ibm.CSI.performTLClientAuthenticationSupported", ConfigUtils.stringToBoolean((String)propertyResult));
        }
        if ((propertyResult = ConfigUtils.clean((String)sasClientProps.getProperty("com.ibm.CSI.performMessageSupportedAuthMechList"))) != null && propertyResult.length() > 0) {
            this.setString("com.ibm.CSI.performMessageSupportedAuthMechList", propertyResult);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "clientSetCSIv2Values() " + this.cacheKey);
        }
    }

    private void initializeOnServer(EndPointMgr endPointMgr) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeOnServer() " + this.cacheKey);
        }
        SecurityConfig security = SecurityObjectLocator.getSecurityConfig();
        boolean securityEnabled = security.getBoolean("enabled");
        this.setBoolean("com.ibm.CORBA.securityEnabled", securityEnabled);
        this.setBoolean("com.ibm.CORBA.serverSecurityEnabled", security.getBoolean("appEnabled"));
        boolean isBasicAuth = security.getPropertyBool("com.ibm.CORBA.delegateBasicAuth", false);
        this.setBoolean("com.ibm.CORBA.delegateBasicAuth", isBasicAuth);
        this.setString("com.ibm.CSI.CellNodeServer", SecurityObjectLocator.getAdminData().getString("process.serverName"));
        if (securityEnabled) {
            AuthMechanismConfig aam = security.getActiveAuthMechanism();
            UserRegistryConfig aur = security.getActiveUserRegistry();
            AuthenticationTarget authTarget = new AuthenticationTarget();
            if (aam == null || aur == null || authTarget == null) {
                Tr.warning(tc, "Unable to complete initializeOnServer(), missing expected configuration information");
                if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                    Tr.exit(tc, "initializeOnServer() " + this.cacheKey);
                }
                return;
            }
            this.setString("com.ibm.CSI.activeUserRegistry", aur.getType());
            this.setString("com.ibm.CSI.authMechAuthAlias", aam.getString("authConfig"));
            try {
                this.setInteger("com.ibm.CORBA.authenticationTarget", authTarget.mechtypeToAuthTarget(aam.getType()));
            }
            catch (Exception e) {
                Tr.error(tc, "security.JSAS0051E", aam.getType());
            }
            String curVal = aur.getString("serverId");
            if (curVal == null) {
                curVal = "";
            }
            this.setString("com.ibm.CORBA.loginUserid", curVal);
            this.setString("com.ibm.CORBA.loginPassword", aur.getDecodedString("serverPassword"));
            this.setString("com.ibm.CORBA.principalName", aur.getPrincipalName());
            this.setBoolean("com.ibm.ws.security.includeRunAsChangesInCallerList", security.getPropertyBool("com.ibm.ws.security.includeRunAsChangesInCallerList"));
            this.setBoolean("com.ibm.CSI.rmiOutboundPropagationEnabled", security.getPropertyBool("com.ibm.CSI.rmiOutboundPropagationEnabled"));
            this.setBoolean("com.ibm.CSI.rmiOutboundLoginEnabled", security.getPropertyBool("com.ibm.CSI.rmiOutboundLoginEnabled"));
            this.setBoolean("com.ibm.CSI.rmiInboundMappingEnabled", security.getPropertyBool("com.ibm.CSI.rmiInboundMappingEnabled"));
            this.setBoolean("com.ibm.CSI.rmiOutboundMappingEnabled", security.getPropertyBool("com.ibm.CSI.rmiOutboundMappingEnabled"));
            this.setString("com.ibm.CSI.rmiInboundMappingConfig", security.getProperty("com.ibm.CSI.rmiInboundMappingConfig"));
            this.setBoolean("com.ibm.CSI.rmiInboundPropagationEnabled", security.getPropertyBool("com.ibm.CSI.rmiInboundPropagationEnabled"));
            this.setBoolean("com.ibm.ws.security.webInboundPropagationEnabled", security.getPropertyBool("com.ibm.ws.security.webInboundPropagationEnabled"));
            this.setString("com.ibm.CSI.rmiInboundLoginConfig", security.getProperty("com.ibm.CSI.rmiInboundLoginConfig"));
            this.setString("com.ibm.ws.security.webInboundLoginConfig", security.getProperty("com.ibm.ws.security.webInboundLoginConfig"));
            this.setString("com.ibm.CSI.rmiOutboundLoginConfig", security.getProperty("com.ibm.CSI.rmiOutboundLoginConfig"));
            this.setString("com.ibm.CSI.supportedTargetRealms", security.getOutboundTrustedAuthenticationRealm().getRealmList());
            this.setString("com.ibm.CSI.WSSecurityContextActiveOID", aam.getString("OID"));
            this.setString("com.ibm.CSI.WSSecurityContextActiveClass", aam.getString("authContextImplClass"));
            if (aam.getType().equals("CUSTOM")) {
                this.setString("com.ibm.CSI.WSSecurityContextCustomOID", aam.getString("OID"));
                this.setString("com.ibm.CSI.WSSecurityContextCustomClass", aam.getString("authContextImplClass"));
            }
            this.setBoolean("com.ibm.ws.security.isUseRegistryServerId", aur.getBoolean("useRegistryServerId"));
            this.setString("com.ibm.ws.security.ssoInteropModeEnabled", security.getProperty("com.ibm.ws.security.ssoInteropModeEnabled"));
            this.setBoolean("com.ibm.ws.security.assertLDAPShortName", security.getPropertyBool("com.ibm.ws.security.assertLDAPShortName"));
            this.setBoolean("com.ibm.CSI.refreshClientSubjectGoingOutbound", security.getPropertyBool("com.ibm.CSI.refreshClientSubjectGoingOutbound"));
            this.setBoolean("com.ibm.CSI.authenticateSpecialMethods", security.getPropertyBool("com.ibm.CSI.authenticateSpecialMethods"));
            this.setBoolean("com.ibm.CSI.neverUseClientCertificateForCallerLogin", security.getPropertyBool("com.ibm.CSI.neverUseClientCertificateForCallerLogin"));
            this.setBoolean("com.ibm.ws.security.createTokenSubjectForAsynchLogin", security.getPropertyBool("com.ibm.ws.security.createTokenSubjectForAsynchLogin"));
            this.setString("com.ibm.CORBA.delegateCredentials", security.getProperty("com.ibm.CORBA.delegateCredentials"));
            this.setString("com.ibm.ws.security.internalServerId", SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.internalServerId"));
            this.setBoolean("com.ibm.ws.security.webChallengeIfCustomSubjectNotFound", security.getPropertyBool("com.ibm.ws.security.webChallengeIfCustomSubjectNotFound"));
            AuthMechanismConfig krb5am = security.getAuthMechanism("KRB5");
            if (krb5am != null) {
                this.setBoolean("com.ibm.websphere.security.krb.allowLTPAAuth", krb5am.getBoolean("allowLPTAAuth"));
                this.setString("com.ibm.websphere.security.krb.spn", krb5am.getString("krb5Spn"));
                this.setString("com.ibm.websphere.security.krb.spn_password", krb5am.getString("krb5SpnPassword"));
                this.setString("com.ibm.websphere.security.krb.realm", krb5am.getString("krb5Realm"));
                this.setString("com.ibm.websphere.security.krb.keytab", krb5am.getString("krb5Keytab"));
                this.setString("com.ibm.websphere.security.krb.config", krb5am.getString("krb5Config"));
            }
            this.serverSetCSIValues(security, endPointMgr);
            this.initializeLoginProperties();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeOnServer() " + this.cacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverSetCSIValues(SecurityConfig security, EndPointMgr endPointMgr) {
        CSIv2IOBoundConfig performs;
        CSIv2ConfigData csiv2;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "serverSetCSIValues() " + this.cacheKey);
        }
        if ((csiv2 = ((SecurityConfigImpl)security).getCSIv2Data()) == null) {
            return;
        }
        CSIv2IOBoundConfig claims = csiv2.getClaims();
        if (claims != null) {
            CSIv2LayerConfig claimsMessage;
            this.setBoolean("com.ibm.CSI.claimStateful", claims.getBoolean("stateful"));
            CSIv2LayerConfig claimsIDA = claims.getLayer("IdentityAssertionLayer");
            if (claimsIDA != null) {
                CSIv2QOPConfig claimsIDASupported = claimsIDA.getSupportedQOP();
                if (claimsIDASupported != null) {
                    this.setBoolean("com.ibm.CSI.claimIdentityAssertionSupported", claimsIDASupported.getBoolean("enable"));
                }
                this.setString("com.ibm.CSI.trustedPrincipalList", claimsIDA.getTrustedServers());
            }
            if ((claimsMessage = claims.getLayer("MessageLayer")) != null) {
                CSIv2QOPConfig claimsMessageRequired;
                CSIv2QOPConfig claimsMessageSupported = claimsMessage.getSupportedQOP();
                if (claimsMessageSupported != null) {
                    this.setBoolean("com.ibm.CSI.claimClientAuthenticationSupported", claimsMessageSupported.getBoolean("establishTrustInClient"));
                }
                if ((claimsMessageRequired = claimsMessage.getRequiredQOP()) != null) {
                    this.setBoolean("com.ibm.CSI.claimClientAuthenticationRequired", claimsMessageRequired.getBoolean("establishTrustInClient"));
                }
                this.setString("com.ibm.CSI.claimMessageSupportedAuthMechList", claimsMessage.getString("supportedAuthMechList"));
            }
            if (!csiv2.getSCO().isDomainConfig() || !SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                CSIv2LayerConfig claimsTransport = claims.getLayer("TransportLayer");
                if (claimsTransport != null) {
                    CSIv2QOPConfig claimsTransportRequired;
                    CSIv2QOPConfig claimsTransportSupported = claimsTransport.getSupportedQOP();
                    if (claimsTransportSupported != null) {
                        this.setBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported", claimsTransportSupported.getBoolean("enableProtection"));
                        this.setBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported", claimsTransportSupported.getBoolean("establishTrustInClient"));
                        this.setBoolean("com.ibm.CSI.claimMessageIntegritySupported", claimsTransportSupported.getBoolean("integrity"));
                        this.setBoolean("com.ibm.CSI.claimMessageConfidentialitySupported", claimsTransportSupported.getBoolean("confidentiality"));
                    }
                    if ((claimsTransportRequired = claimsTransport.getRequiredQOP()) != null) {
                        this.setBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired", claimsTransportRequired.getBoolean("enableProtection"));
                        this.setBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired", claimsTransportRequired.getBoolean("establishTrustInClient"));
                        this.setBoolean("com.ibm.CSI.claimMessageIntegrityRequired", claimsTransportRequired.getBoolean("integrity"));
                        this.setBoolean("com.ibm.CSI.claimMessageConfidentialityRequired", claimsTransportRequired.getBoolean("confidentiality"));
                    }
                    this.setString("com.ibm.ssl.csi.inbound.alias", claimsTransport.getServerAuthentication());
                }
            } else {
                boolean pushed = false;
                try {
                    pushed = AdminContext.push(null);
                    CSIv2Config adminAgent_csiv2 = SecurityObjectLocator.getCSIv2Config();
                    this.setBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported", adminAgent_csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported"));
                    this.setBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported", adminAgent_csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported"));
                    this.setBoolean("com.ibm.CSI.claimMessageIntegritySupported", adminAgent_csiv2.getBoolean("com.ibm.CSI.claimMessageIntegritySupported"));
                    this.setBoolean("com.ibm.CSI.claimMessageConfidentialitySupported", adminAgent_csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialitySupported"));
                    this.setBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired", adminAgent_csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired"));
                    this.setBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired", adminAgent_csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired"));
                    this.setBoolean("com.ibm.CSI.claimMessageIntegrityRequired", adminAgent_csiv2.getBoolean("com.ibm.CSI.claimMessageIntegrityRequired"));
                    this.setBoolean("com.ibm.CSI.claimMessageConfidentialityRequired", adminAgent_csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialityRequired"));
                    this.setString("com.ibm.ssl.csi.inbound.alias", adminAgent_csiv2.getString("com.ibm.ssl.csi.inbound.alias"));
                }
                finally {
                    if (pushed) {
                        AdminContext.pop();
                    }
                }
            }
            if (csiv2.getSCO().isDomainConfig() && !SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                boolean pushed = SecurityObjectLocator.pushAdminContext();
                try {
                    CSIv2Config admin_csiv2 = SecurityObjectLocator.getCSIv2Config();
                    admin_csiv2.setBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported", this.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported"));
                    admin_csiv2.setBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported", this.getBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported"));
                    admin_csiv2.setBoolean("com.ibm.CSI.claimMessageIntegritySupported", this.getBoolean("com.ibm.CSI.claimMessageIntegritySupported"));
                    admin_csiv2.setBoolean("com.ibm.CSI.claimMessageConfidentialitySupported", this.getBoolean("com.ibm.CSI.claimMessageConfidentialitySupported"));
                    admin_csiv2.setBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired", this.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired"));
                    admin_csiv2.setBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired", this.getBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired"));
                    admin_csiv2.setBoolean("com.ibm.CSI.claimMessageIntegrityRequired", this.getBoolean("com.ibm.CSI.claimMessageIntegrityRequired"));
                    admin_csiv2.setBoolean("com.ibm.CSI.claimMessageConfidentialityRequired", this.getBoolean("com.ibm.CSI.claimMessageConfidentialityRequired"));
                    admin_csiv2.setString("com.ibm.ssl.csi.inbound.alias", this.getString("com.ibm.ssl.csi.inbound.alias"));
                }
                finally {
                    if (pushed) {
                        SecurityObjectLocator.popContext();
                    }
                }
            }
        }
        if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                if (endPointMgr == null) {
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "endPointMgr is null");
                    }
                } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "endPointMgr is not null");
                }
            }
            if (endPointMgr != null) {
                EndPoint csiv2ClaimSSLPortServerAuthEndPoint = null;
                String csiv2ClaimSSLPortServerAuthPort = "0";
                try {
                    csiv2ClaimSSLPortServerAuthEndPoint = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
                    if (csiv2ClaimSSLPortServerAuthEndPoint != null) {
                        csiv2ClaimSSLPortServerAuthPort = Integer.toString(csiv2ClaimSSLPortServerAuthEndPoint.getPort());
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.config.CSIv2ConfigImpl.serverSetCSIValues", "%");
                }
                if (csiv2ClaimSSLPortServerAuthPort != null && !csiv2ClaimSSLPortServerAuthPort.equals("")) {
                    if (csiv2ClaimSSLPortServerAuthEndPoint != null) {
                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                            Tr.debug(tc, " endpoint ssl port: " + csiv2ClaimSSLPortServerAuthEndPoint.getPort());
                        }
                        this.setInteger("com.ibm.CSI.SSLPort", csiv2ClaimSSLPortServerAuthEndPoint.getPort());
                    } else {
                        this.setInteger("com.ibm.CSI.SSLPort", 0);
                    }
                } else {
                    this.setInteger("com.ibm.CSI.SSLPort", 0);
                }
                EndPoint csiv2ClaimSSLPortMutualAuthEndPoint = null;
                String csiv2ClaimSSLPortMutualAuthPort = "0";
                try {
                    csiv2ClaimSSLPortMutualAuthEndPoint = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
                    if (csiv2ClaimSSLPortMutualAuthEndPoint != null) {
                        csiv2ClaimSSLPortMutualAuthPort = Integer.toString(csiv2ClaimSSLPortMutualAuthEndPoint.getPort());
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.config.CSIv2ConfigImpl.serverSetCSIValues", "%");
                }
                if (csiv2ClaimSSLPortMutualAuthPort != null && !csiv2ClaimSSLPortMutualAuthPort.equals("")) {
                    if (csiv2ClaimSSLPortMutualAuthEndPoint != null) {
                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                            Tr.debug(tc, " endpoint client ssl port: " + csiv2ClaimSSLPortMutualAuthEndPoint.getPort());
                        }
                        this.setInteger("com.ibm.CSI.ClientCertSSLPort", csiv2ClaimSSLPortMutualAuthEndPoint.getPort());
                    } else {
                        this.setInteger("com.ibm.CSI.ClientCertSSLPort", 0);
                    }
                } else {
                    this.setInteger("com.ibm.CSI.ClientCertSSLPort", 0);
                }
            } else {
                if (this.getInteger("com.ibm.CSI.SSLPort") == 0) {
                    this.setInteger("com.ibm.CSI.SSLPort", 0);
                }
                if (this.getInteger("com.ibm.CSI.ClientCertSSLPort") == 0) {
                    this.setInteger("com.ibm.CSI.ClientCertSSLPort", 0);
                }
            }
        }
        if ((performs = csiv2.getPerforms()) != null) {
            CSIv2LayerConfig performsTransport;
            CSIv2LayerConfig performsMessage;
            this.setBoolean("com.ibm.CSI.performStateful", performs.getBoolean("stateful"));
            this.setInteger("com.ibm.CORBA.sessionGCinterval", performs.getInteger("sessionGCInterval"));
            this.setInteger("com.ibm.CORBA.sessionGCdiscardunused", performs.getInteger("sessionGCIdleTime"));
            CSIv2LayerConfig performsIDA = performs.getLayer("IdentityAssertionLayer");
            if (performsIDA != null) {
                CSIv2QOPConfig performsIDARequired;
                CSIv2QOPConfig performsIDASupported = performsIDA.getSupportedQOP();
                if (performsIDASupported != null) {
                    this.setBoolean("com.ibm.CSI.performIdentityAssertionSupported", performsIDASupported.getBoolean("enable"));
                    String alternateTrustedId = performsIDASupported.getString("trustedID");
                    String alternateTrustedPassword = performsIDASupported.getString("trustedPassword");
                    if (alternateTrustedId != null && !alternateTrustedId.equals("") && alternateTrustedPassword != null && !alternateTrustedPassword.equals("")) {
                        this.setString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedId", alternateTrustedId);
                        this.setString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedPassword", alternateTrustedPassword);
                    }
                }
                if ((performsIDARequired = performsIDA.getRequiredQOP()) != null) {
                    this.setBoolean("com.ibm.CSI.performIdentityAssertionRequired", performsIDARequired.getBoolean("enable"));
                }
            }
            if ((performsMessage = performs.getLayer("MessageLayer")) != null) {
                CSIv2QOPConfig performsMessageRequired;
                CSIv2QOPConfig performsMessageSupported = performsMessage.getSupportedQOP();
                if (performsMessageSupported != null) {
                    this.setBoolean("com.ibm.CSI.performClientAuthenticationSupported", performsMessageSupported.getBoolean("establishTrustInClient"));
                }
                if ((performsMessageRequired = performsMessage.getRequiredQOP()) != null) {
                    this.setBoolean("com.ibm.CSI.performClientAuthenticationRequired", performsMessageRequired.getBoolean("establishTrustInClient"));
                }
                int retryCount = performsMessage.getInteger("authenticationLayerRetryCount");
                this.setInteger("com.ibm.CORBA.authenticationRetryCount", retryCount);
                if (retryCount > 0) {
                    this.setBoolean("com.ibm.CORBA.authenticationRetryEnabled", true);
                }
                this.setString("com.ibm.CSI.performMessageSupportedAuthMechList", performsMessage.getString("supportedAuthMechList"));
            }
            if ((performsTransport = performs.getLayer("TransportLayer")) != null) {
                CSIv2QOPConfig performsTransportRequired;
                CSIv2QOPConfig performsTransportSupported = performsTransport.getSupportedQOP();
                if (performsTransportSupported != null) {
                    this.setBoolean("com.ibm.CSI.performTransportAssocSSLTLSSupported", performsTransportSupported.getBoolean("enableProtection"));
                    this.setBoolean("com.ibm.CSI.performTLClientAuthenticationSupported", performsTransportSupported.getBoolean("establishTrustInClient"));
                    this.setBoolean("com.ibm.CSI.performMessageIntegritySupported", performsTransportSupported.getBoolean("integrity"));
                    this.setBoolean("com.ibm.CSI.performMessageConfidentialitySupported", performsTransportSupported.getBoolean("confidentiality"));
                }
                if ((performsTransportRequired = performsTransport.getRequiredQOP()) != null) {
                    this.setBoolean("com.ibm.CSI.performTransportAssocSSLTLSRequired", performsTransportRequired.getBoolean("enableProtection"));
                    this.setBoolean("com.ibm.CSI.performTLClientAuthenticationRequired", performsTransportRequired.getBoolean("establishTrustInClient"));
                    this.setBoolean("com.ibm.CSI.performMessageIntegrityRequired", performsTransportRequired.getBoolean("integrity"));
                    this.setBoolean("com.ibm.CSI.performMessageConfidentialityRequired", performsTransportRequired.getBoolean("confidentiality"));
                }
                this.setString("com.ibm.ssl.csi.outbound.alias", performsTransport.getServerAuthentication());
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "serverSetCSIValues() " + this.cacheKey);
        }
    }

    public void updatePorts(Object epm) {
        if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
            EndPointMgr endPointMgr = (EndPointMgr)epm;
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                if (endPointMgr == null) {
                    Tr.debug(tc, "updatePorts: endPointMgr is null");
                } else {
                    Tr.debug(tc, "updatePorts: endPointMgr is not null");
                }
            }
            if (endPointMgr != null) {
                EndPoint csiv2ClaimSSLPortServerAuthEndPoint = null;
                String csiv2ClaimSSLPortServerAuthPort = "0";
                try {
                    csiv2ClaimSSLPortServerAuthEndPoint = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
                    if (csiv2ClaimSSLPortServerAuthEndPoint != null) {
                        csiv2ClaimSSLPortServerAuthPort = Integer.toString(csiv2ClaimSSLPortServerAuthEndPoint.getPort());
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.config.CSIv2ConfigImpl.serverSetCSIValues", "%");
                }
                if (csiv2ClaimSSLPortServerAuthEndPoint != null && csiv2ClaimSSLPortServerAuthPort != null && !csiv2ClaimSSLPortServerAuthPort.equals("")) {
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, " endpoint ssl port: " + csiv2ClaimSSLPortServerAuthEndPoint.getPort());
                    }
                    this.setInteger("com.ibm.CSI.SSLPort", csiv2ClaimSSLPortServerAuthEndPoint.getPort());
                } else {
                    this.setInteger("com.ibm.CSI.SSLPort", 0);
                }
                EndPoint csiv2ClaimSSLPortMutualAuthEndPoint = null;
                String csiv2ClaimSSLPortMutualAuthPort = "0";
                try {
                    csiv2ClaimSSLPortMutualAuthEndPoint = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
                    if (csiv2ClaimSSLPortMutualAuthEndPoint != null) {
                        csiv2ClaimSSLPortMutualAuthPort = Integer.toString(csiv2ClaimSSLPortMutualAuthEndPoint.getPort());
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.config.CSIv2ConfigImpl.serverSetCSIValues", "%");
                }
                if (csiv2ClaimSSLPortMutualAuthEndPoint != null && csiv2ClaimSSLPortMutualAuthPort != null && !csiv2ClaimSSLPortMutualAuthPort.equals("")) {
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, " endpoint client ssl port: " + csiv2ClaimSSLPortMutualAuthEndPoint.getPort());
                    }
                    this.setInteger("com.ibm.CSI.ClientCertSSLPort", csiv2ClaimSSLPortMutualAuthEndPoint.getPort());
                } else {
                    this.setInteger("com.ibm.CSI.ClientCertSSLPort", 0);
                }
            } else {
                if (this.getInteger("com.ibm.CSI.SSLPort") == 0) {
                    this.setInteger("com.ibm.CSI.SSLPort", 0);
                }
                if (this.getInteger("com.ibm.CSI.ClientCertSSLPort") == 0) {
                    this.setInteger("com.ibm.CSI.ClientCertSSLPort", 0);
                }
            }
        }
    }

    private void initialize(EndPointMgr endPointMgr) {
        this.setDefaults();
        if (RasHelper.isServer()) {
            this.initializeOnServer(endPointMgr);
        }
    }

    public void init(String configURL, Object ORB2) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "init() " + this.cacheKey, new Object[]{configURL, ORB2});
        }
        if (!RasHelper.isServer()) {
            this.initializeOnClient(configURL, (ORB)ORB2);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            this.dumpProperties();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled() && ORB2 != null) {
            Tr.debug(tc, "ORB contents: " + ((ORB)ORB2).toString());
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "init() " + this.cacheKey);
        }
    }

    public Properties getProperties() {
        if (this.myProps == null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating the properties object " + this.cacheKey);
            }
            this.myProps = new Properties();
            for (String name : this.generatedData.keySet()) {
                Object value = this.generatedData.get(name);
                if (value instanceof Boolean) {
                    this.myProps.put(name, ((Boolean)value).toString());
                    continue;
                }
                if (value instanceof Integer) {
                    this.myProps.put(name, ((Integer)value).toString());
                    continue;
                }
                if (value instanceof String) {
                    this.myProps.put(name, (String)value);
                    continue;
                }
                Tr.warning(tc, "CSIv2Config getProperties() encountered an unknown type " + this.cacheKey);
            }
            this.myProps.putAll((Map<?, ?>)this.generatedData);
        }
        return this.myProps;
    }

    public boolean getBoolean(String key) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getBoolean() key=" + key + " " + this.cacheKey);
        }
        boolean ret = false;
        Object val = this.generatedData.get(key);
        if (val == null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting key=" + key + " from defaults");
            }
            val = this.defaults.get(key);
        }
        if (val != null) {
            if (!(val instanceof Boolean)) {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.exit(tc, "getBoolean() Code error, getting key=" + key + " as Boolean, not stored as such");
                }
            } else {
                ret = (Boolean)val;
            }
        } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Null value for key=" + key);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getBoolean() " + this.cacheKey, ret);
        }
        return ret;
    }

    public int getInteger(String key) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInteger() key=" + key);
        }
        int ret = 0;
        Object val = this.generatedData.get(key);
        if (val == null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting key=" + key + " from defaults");
            }
            val = this.defaults.get(key);
        }
        if (val != null) {
            if (!(val instanceof Integer)) {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.exit(tc, "getInteger() Code error, getting key=" + key + " as Integer, not stored as such " + this.cacheKey);
                }
            } else {
                ret = (Integer)val;
            }
        } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Null value for key=" + key);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInteger() " + this.cacheKey, ret);
        }
        return ret;
    }

    public String getString(String key) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getString() key=" + key + " " + this.cacheKey);
        }
        String ret = null;
        Object val = this.generatedData.get(key);
        if (val == null && !RasHelper.isServer()) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting key=" + key + " from ORB");
            }
            ConfigURLProperties sasClientProps = ConfigURLProperties.getInstance();
            val = sasClientProps.getProperty(key);
        }
        if (val == null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting key=" + key + " from defaults");
            }
            val = this.defaults.get(key);
        }
        if (val != null) {
            ret = val.toString();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled() && key != null && key.toLowerCase().indexOf("password") != -1) {
            Tr.exit(tc, "getString() " + this.cacheKey, ConfigUtils.mask((String)ret));
        } else if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getString() " + this.cacheKey, ret);
        }
        return ret;
    }

    public void setInteger(String key, int value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "setInteger() " + this.cacheKey, new Object[]{key, value});
        }
        this.generatedData.put(key, value);
    }

    public void setString(String key, String value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled() && key != null && key.toLowerCase().indexOf("password") != -1) {
            Tr.debug(tc, "getString()" + this.cacheKey, new Object[]{key, ConfigUtils.mask((String)value)});
        } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setString() " + this.cacheKey, new Object[]{key, value});
        }
        if (value == null) {
            return;
        }
        this.generatedData.put(key, value);
    }

    public void setBoolean(String key, boolean value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "setBoolean() " + this.cacheKey, new Object[]{key, value});
        }
        this.generatedData.put(key, value);
    }

    public final String getloginUserid(String loginRealm) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getloginUserid() loginRealm=" + loginRealm + " " + this.cacheKey);
        }
        Object[] UserPasswordArray = (Object[])this.userPasswordMap.get(loginRealm);
        String loginUserID = (String)UserPasswordArray[0];
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getloginUserid() " + this.cacheKey, loginUserID);
        }
        return loginUserID;
    }

    public final String getloginPassword(String loginRealm) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getloginPassword() loginRealm=" + loginRealm + " " + this.cacheKey);
        }
        Object[] UserPasswordArray = (Object[])this.userPasswordMap.get(loginRealm);
        byte[] lPassword = (byte[])UserPasswordArray[1];
        String loginPassword = null;
        try {
            loginPassword = new String(lPassword, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            Tr.debug(tc, "Exception during byte converstion. " + uee.toString());
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getloginPassword() " + this.cacheKey);
        }
        return loginPassword;
    }

    public void dumpProperties() {
        Object value;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "dumpProperties() " + this.cacheKey);
        }
        StringBuffer buf = new StringBuffer();
        if (this.generatedData != null && this.generatedData.size() > 0) {
            buf.append("Generated Data: {\n");
            for (String name : this.generatedData.keySet()) {
                value = this.generatedData.get(name);
                if (name.toLowerCase().indexOf("password") != -1) {
                    buf.append(name);
                    buf.append(" = ");
                    if (value instanceof String) {
                        buf.append(ConfigUtils.mask((String)((String)value)));
                    } else {
                        buf.append("*****");
                    }
                    buf.append("\n");
                    continue;
                }
                buf.append(name);
                buf.append(" = ");
                buf.append(value);
                buf.append("\n");
            }
            buf.append("}");
        }
        if (this.userPasswordMap != null && this.userPasswordMap.size() > 0) {
            Iterator<String> itr = this.userPasswordMap.keySet().iterator();
            buf.append("\nUser Password Map: {\n");
            while (itr.hasNext()) {
                String name;
                name = itr.next();
                value = this.userPasswordMap.get(name);
                if (name.toLowerCase().indexOf("password") != -1) {
                    buf.append(name);
                    buf.append(" = ");
                    if (value instanceof String) {
                        buf.append(ConfigUtils.mask((String)((String)value)));
                    } else {
                        buf.append("*****");
                    }
                    buf.append("\n");
                    continue;
                }
                buf.append(name);
                buf.append(" = ");
                buf.append(value);
                buf.append("\n");
            }
            buf.append("}");
        }
        if (this.defaults != null && this.defaults.size() > 0) {
            buf.append("\nDefaults:\n");
            buf.append(this.defaults.toString());
            buf.append("\n");
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, buf.toString());
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "dumpProperties() " + this.cacheKey);
        }
    }
}

