/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.CSIv2IOBoundConfig;
import com.ibm.ws.security.config.CSIv2LayerConfig;
import com.ibm.ws.security.config.CSIv2QOPConfig;
import com.ibm.ws.security.config.GenericConfigHelperImpl;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigObject;

public class CSIv2ConfigData
extends GenericConfigHelperImpl {
    private static TraceComponent tc = Tr.register(CSIv2ConfigData.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private CSIv2IOBoundConfig claims = null;
    private CSIv2IOBoundConfig performs = null;
    public static final String CLAIMS = "claims";
    public static final String PERFORMS = "performs";
    public static final String IDENTITY_ASSERTION_LAYER = "IdentityAssertionLayer";
    public static final String MESSAGE_LAYER = "MessageLayer";
    public static final String TRANSPORT_LAYER = "TransportLayer";
    public static final String REQUIRED_QOP = "requiredQOP";
    public static final String SUPPORTED_QOP = "supportedQOP";

    public CSIv2ConfigData(SecurityConfigObject obj, GenericConfigHelperImpl parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey, new Object[]{obj, parent});
        }
        super.initialize(obj, parent, _cacheKey);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor" + this.cacheKey, this);
        }
    }

    private synchronized void do_getClaims() {
        SecurityConfigObject c;
        if (this.claims == null && (c = this.sco.getObject(CLAIMS, false)) != null) {
            this.claims = new CSIv2IOBoundConfig(c, this, this.cacheKey);
        }
    }

    public CSIv2IOBoundConfig getClaims() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getClaims" + this.cacheKey);
        }
        if (this.claims == null) {
            this.do_getClaims();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getClaims" + this.cacheKey, this.claims);
        }
        return this.claims;
    }

    private synchronized void do_getPerforms() {
        SecurityConfigObject p;
        if (this.performs == null && (p = this.sco.getObject(PERFORMS, false)) != null) {
            this.performs = new CSIv2IOBoundConfig(p, this, this.cacheKey);
        }
    }

    public CSIv2IOBoundConfig getPerforms() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPerforms" + this.cacheKey);
        }
        if (this.performs == null) {
            this.do_getPerforms();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerforms" + this.cacheKey, this.performs);
        }
        return this.performs;
    }

    public CSIv2LayerConfig getLayer(String cORp, String layer) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLayer" + this.cacheKey, new Object[]{cORp, layer});
        }
        CSIv2LayerConfig l = null;
        CSIv2IOBoundConfig io = null;
        if (cORp.equalsIgnoreCase(CLAIMS)) {
            io = this.getClaims();
        } else if (cORp.equalsIgnoreCase(PERFORMS)) {
            io = this.getPerforms();
        }
        if (io != null) {
            if (layer.equalsIgnoreCase(IDENTITY_ASSERTION_LAYER)) {
                l = io.getLayer(IDENTITY_ASSERTION_LAYER);
            } else if (layer.equalsIgnoreCase(MESSAGE_LAYER)) {
                l = io.getLayer(MESSAGE_LAYER);
            } else if (layer.equalsIgnoreCase(TRANSPORT_LAYER)) {
                l = io.getLayer(TRANSPORT_LAYER);
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLayer" + this.cacheKey, l);
        }
        return l;
    }

    public CSIv2QOPConfig getQOP(String cORp, String layer, String rORs) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getQOP" + this.cacheKey, new Object[]{cORp, layer, rORs});
        }
        CSIv2LayerConfig l = this.getLayer(cORp, layer);
        CSIv2QOPConfig qop = null;
        if (l != null) {
            if (rORs.equalsIgnoreCase(REQUIRED_QOP)) {
                qop = l.getRequiredQOP();
            } else if (rORs.equalsIgnoreCase(SUPPORTED_QOP)) {
                qop = l.getSupportedQOP();
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getQOP" + this.cacheKey, l);
        }
        return qop;
    }

    public Boolean getBoolean(String cORp, String layer, String rORs, String attribute) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getBoolean" + this.cacheKey, new Object[]{cORp, layer, rORs, attribute});
        }
        Boolean result = null;
        CSIv2QOPConfig qop = this.getQOP(cORp, layer, rORs);
        if (qop != null) {
            result = qop.getBoolean(attribute);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getBoolean" + this.cacheKey, result);
        }
        return result;
    }
}

