/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.AuthorizationProviderConfig;
import com.ibm.ws.security.config.GenericConfigHelperImpl;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.util.ConfigUtils;
import java.util.Properties;

public class AuthorizationProviderConfigImpl
extends GenericConfigHelperImpl
implements AuthorizationProviderConfig {
    private static String DEFAULT_JACC_PROVIDER = "com.ibm.ws.security.policy.JaccPolicyProxy";
    private static TraceComponent tc = Tr.register(AuthorizationProviderConfigImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private Properties props = null;

    public AuthorizationProviderConfigImpl(SecurityConfigObject obj, GenericConfigHelperImpl parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey, new Object[]{obj, parent});
        }
        super.initialize(obj, parent, _cacheKey);
        this.initialize_defaults();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor" + this.cacheKey, this);
        }
    }

    private void initialize_defaults() {
        this.defaults.put("j2eePolicyImplClassName", DEFAULT_JACC_PROVIDER);
        this.defaults.put("name", null);
        this.defaults.put("policyConfigurationFactoryImplClassName", null);
        this.defaults.put("roleConfigurationFactoryImplClassName", null);
        this.defaults.put("initializeJACCProviderClassName", null);
        this.defaults.put("requiresEJBArgumentsPolicyContextHandler", null);
        this.defaults.put("supportsDynamicModuleUpdates", null);
    }

    public boolean isDefaultJACCProvider() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "isDefaultJACCProvider" + this.cacheKey);
        }
        boolean result = this.getString("j2eePolicyImplClassName").equals(DEFAULT_JACC_PROVIDER);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "isDefaultJACCProvider" + this.cacheKey, result);
        }
        return result;
    }

    private synchronized void do_getProperties() {
        if (this.props == null) {
            this.props = ConfigUtils.expandProps((Properties)this.sco.getProperties());
        }
    }

    public Properties getProperties() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties" + this.cacheKey);
        }
        if (this.props == null) {
            this.do_getProperties();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties" + this.cacheKey, this.props);
        }
        return this.props;
    }
}

