/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.util.Arrays;
import java.util.Date;

public class ServerCredSigner {
    private KeyPairGenerator rsaKeyPairGen = null;
    private KeyPair rsaKeyPair = null;
    private Signature sig = null;
    private PublicKey rsaPub = null;
    private PrivateKey rsaPriv = null;
    private MessageDigest md = null;
    private static String CRYPTO_ALGORITHM = "RSA";
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static ServerCredSigner scs = null;
    private static final String _uniqueServerID = SecurityUIDGenerator.createUID();
    private static final byte[] _uniqueServerIDBytes = _uniqueServerID.getBytes();
    private static byte[] _uniqueServerCipher = null;
    private static final String _uniqueWSCredID = SecurityUIDGenerator.createUID();
    private static final byte[] _uniqueWSCredIDBytes = _uniqueWSCredID.getBytes();
    private static byte[] _uniqueWSCredCipher = null;
    private static byte[] nullByteArray = new byte[0];
    private static final TraceComponent tc = Tr.register(ServerCredSigner.class, null, "com.ibm.ISecurityL13SupportImpl.sec");

    public static ServerCredSigner getInstance() {
        if (scs == null) {
            scs = new ServerCredSigner();
        }
        return scs;
    }

    private ServerCredSigner() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.ServerCredSigner.constructor", "92", this);
        }
    }

    private void initialize() throws WSSecurityException {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security disabed, not initializing server cred signer.");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing server cred signer at " + new Date(System.currentTimeMillis()));
        }
        String JCEProvider = null;
        if (SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
            try {
                JCEProvider = Security.getProperty("DEFAULT_JCE_PROVIDER");
                if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent() && JCEProvider == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AdminAgent initialization, cannot sign servercred");
                    }
                } else {
                    this.rsaKeyPairGen = KeyPairGenerator.getInstance(CRYPTO_ALGORITHM, JCEProvider);
                    this.rsaKeyPairGen.initialize(512);
                    this.rsaKeyPair = this.rsaKeyPairGen.generateKeyPair();
                    if (this.rsaKeyPair == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WARNING: Did not successfully load the server cred signer key pair.");
                        }
                    } else {
                        this.rsaPub = this.rsaKeyPair.getPublic();
                        this.rsaPriv = this.rsaKeyPair.getPrivate();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "PrivateKey format: " + this.rsaPriv.getFormat());
                        Tr.debug(tc, "PrivateKey algorithm: " + this.rsaPriv.getAlgorithm());
                        Tr.debug(tc, "PublicKey format: " + this.rsaPub.getFormat());
                        Tr.debug(tc, "PublicKey algorithm: " + this.rsaPub.getAlgorithm());
                        Tr.debug(tc, "Loading " + CRYPTO_ALGORITHM + " signature instance from " + JCEProvider);
                    }
                    this.sig = Signature.getInstance(CRYPTO_ALGORITHM, JCEProvider);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loading SHA message digest instance from " + JCEProvider);
                    }
                    this.md = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, JCEProvider);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Initialization of server cred signer complete at " + new Date(System.currentTimeMillis()));
                    }
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.ServerCredSigner.initialize", "213", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing server cred signer.", new Object[]{e});
                }
                throw new WSSecurityException(e);
            }
        }
    }

    public synchronized byte[] encryptString(String value) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (this.sig == null && csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            try {
                this.initialize();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.ServerCredSigner.encryptString", "233", this);
            }
        }
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled") || !SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from encryptString because of security disabled or not initialized.");
            }
            return nullByteArray;
        }
        if (value == null || value.length() == 0) {
            return nullByteArray;
        }
        byte[] cipherText = null;
        try {
            this.sig.initSign(this.rsaPriv);
            this.sig.update(value.getBytes());
            cipherText = this.sig.sign();
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error encrypting: ", new Object[]{ex});
            }
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.auth.ServerCredSigner.getEncryptedSigner", "262", this);
            return null;
        }
        return cipherText;
    }

    public synchronized String decryptString(byte[] cipherText) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (this.sig == null && csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            try {
                this.initialize();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.ServerCredSigner.decryptString", "281", this);
            }
        }
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled") || !SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from decryptString because of security disabled or not initialized.");
            }
            return null;
        }
        if (cipherText == null) {
            return null;
        }
        byte[] newText = cipherText;
        try {
            this.sig.initVerify(this.rsaPub);
            this.sig.update(newText);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error decrypting: ", new Object[]{ex});
            }
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.auth.ServerCredSigner.verify", "309", this);
            return null;
        }
        return newText.toString();
    }

    protected synchronized byte[] getEncryptedServerSigner() {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (this.sig == null && csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            try {
                this.initialize();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.ServerCredSigner.getEncryptedServerSigner", "330", this);
            }
        }
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled") || !SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from getEncryptedServerSigner because of security disabled or not initialized.");
            }
            return nullByteArray;
        }
        if (_uniqueServerCipher == null) {
            try {
                this.sig.initSign(this.rsaPriv);
                this.sig.update(_uniqueServerIDBytes);
                _uniqueServerCipher = this.sig.sign();
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error encrypting: ", new Object[]{ex});
                }
                Manager.Ffdc.log(ex, this, "com.ibm.ws.security.auth.ServerCredSigner.getEncryptedSigner", "357", this);
                return null;
            }
        }
        return _uniqueServerCipher;
    }

    protected synchronized byte[] getEncryptedWSCredSigner() {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (this.sig == null && csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            try {
                this.initialize();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.ServerCredSigner.getEncryptedWSCredSigner", "377", this);
            }
        }
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled") || !SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from getEncryptedWSCredSigner because of security disabled or not initialized.");
            }
            return nullByteArray;
        }
        if (_uniqueWSCredCipher == null) {
            try {
                this.sig.initSign(this.rsaPriv);
                this.sig.update(_uniqueWSCredIDBytes);
                _uniqueWSCredCipher = this.sig.sign();
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error encrypting: ", new Object[]{ex});
                }
                Manager.Ffdc.log(ex, this, "com.ibm.ws.security.auth.ServerCredSigner.getEncryptedSigner", "404", this);
                return null;
            }
        }
        return _uniqueWSCredCipher;
    }

    protected synchronized boolean isServerCred(WSCredential cred) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled") || !SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from isServerCred because of security disabled or not initialized.");
            }
            return false;
        }
        if (((WSCredentialImpl)cred).getServerCredCipher() != null && _uniqueServerCipher != null) {
            return Arrays.equals(_uniqueServerCipher, ((WSCredentialImpl)cred).getServerCredCipher());
        }
        return false;
    }

    protected synchronized boolean isWSCred(WSCredential cred) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled") || !SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from isWSCred because of security disabled or not initialized.");
            }
            return false;
        }
        if (cred == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "null cred passed into isWSCred()");
            }
            return false;
        }
        if (((WSCredentialImpl)cred).getWSCredCipher() != null && _uniqueWSCredCipher != null) {
            return Arrays.equals(_uniqueWSCredCipher, ((WSCredentialImpl)cred).getWSCredCipher());
        }
        return false;
    }

    public synchronized byte[] getOneWayHash(String password) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (this.md == null && csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            try {
                this.initialize();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.ServerCredSigner.getOneWayHash", "465", this);
            }
        }
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled") || !SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from getOneWayHash because of security disabled or not initialized.");
            }
            return null;
        }
        this.md.reset();
        this.md.update(password.getBytes());
        return this.md.digest();
    }
}

