/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class JaasLoginHelper {
    private static boolean isServant = false;
    private static TraceComponent tc = null;
    String authMech = "LTPA";
    boolean bvt_mode = false;

    public JaasLoginHelper() {
    }

    public JaasLoginHelper(String _authMech) {
        this.authMech = _authMech;
    }

    protected Subject jaas_login(byte[] token, String auth_mech, Subject in_subject) throws WSLoginFailedException {
        Subject subject = this.jaas_login(token, auth_mech, null, null, in_subject, null, null);
        return subject;
    }

    protected Subject jaas_login(byte[] token, String auth_mech, Subject in_subject, String authMechOid) throws WSLoginFailedException {
        Subject subject = this.jaas_login(token, auth_mech, null, null, in_subject, null, authMechOid);
        return subject;
    }

    protected Subject jaas_login(byte[] token, Subject in_subject) throws WSLoginFailedException {
        Subject subject = this.jaas_login(token, null, null, null, in_subject, null, null);
        return subject;
    }

    protected Subject jaas_login(byte[] token, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Map appContext, Subject in_subject) throws WSLoginFailedException {
        Subject subject = this.jaas_login(token, auth_mech, req, resp, in_subject, appContext, null);
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Subject jaas_login(byte[] token, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Subject in_subject, Map appContext, String authMechOid) throws WSLoginFailedException {
        Subject subject;
        long startTime = 0L;
        long endTime = 0L;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        try {
            if (ctxMgr.isPMIEnabled()) {
                startTime = System.currentTimeMillis();
                ctxMgr.pmiCountStatistic("JAASTokenAuthCount");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "jaas_login(token, auth_mech = " + auth_mech + ", req, resp, in_subject, appContext, authMechOid)");
            }
            Subject subject2 = null;
            ArrayList tokenHolderList = null;
            LoginContext lc = null;
            try {
                try {
                    if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                        tokenHolderList = (ArrayList)ctxMgr.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
                    }
                    lc = in_subject != null ? new LoginContext(auth_mech, in_subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(token, req, resp, (List)tokenHolderList, appContext, authMechOid)) : new LoginContext(auth_mech, WSCallbackHandlerFactory.getInstance().getCallbackHandler(token, req, resp, (List)tokenHolderList, appContext, authMechOid));
                }
                catch (LoginException le) {
                    Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "326", this);
                    Tr.audit(tc, "security.lc.create.err", new Object[]{auth_mech, le.toString()});
                    if (!(le instanceof WSLoginFailedException)) throw new WSLoginFailedException(le.getMessage(), le);
                    throw (WSLoginFailedException)le;
                }
                catch (SecurityException se) {
                    Manager.Ffdc.log(se, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "336", this);
                    Tr.error(tc, "security.lc.create.err", new Object[]{auth_mech, se});
                    throw new WSLoginFailedException(se.getMessage(), se);
                }
                Object var18_14 = null;
                if (tokenHolderList != null) {
                    ctxMgr.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
                }
            }
            catch (Throwable throwable) {
                Object var18_15 = null;
                if (tokenHolderList == null) throw throwable;
                ctxMgr.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
                throw throwable;
            }
            try {
                try {
                    ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(true);
                    lc.login();
                    subject2 = lc.getSubject();
                    if (subject2 == null) {
                        Tr.error(tc, "security.jaas.nosubect", new Object[]{"unknown user -- token based validation", this.authMech});
                        throw new WSLoginFailedException("Subject returned from login module is null.");
                    }
                    Object var20_21 = null;
                }
                catch (LoginException le) {
                    Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "364", this);
                    if (!(le instanceof WSLoginFailedException)) throw new WSLoginFailedException(le.getMessage(), le);
                    throw (WSLoginFailedException)le;
                }
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(false);
                throw throwable;
            }
            ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "jaas_login(token, auth_mech) for web");
            }
            subject = subject2;
            Object var22_24 = null;
            if (!ctxMgr.isPMIEnabled()) return subject;
        }
        catch (Throwable throwable) {
            Object var22_25 = null;
            if (!ctxMgr.isPMIEnabled()) throw throwable;
            endTime = System.currentTimeMillis();
            ctxMgr.pmiTimeStatistic("JAASTokenAuthTime", endTime - startTime);
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        ctxMgr.pmiTimeStatistic("JAASTokenAuthTime", endTime - startTime);
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Subject jaas_login(String realm, String user, String passwd, String auth_mech, Subject in_subject) throws WSLoginFailedException {
        Subject subject;
        long startTime = 0L;
        long endTime = 0L;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        try {
            if (ctxMgr.isPMIEnabled()) {
                startTime = System.currentTimeMillis();
                ctxMgr.pmiCountStatistic("JAASBasicAuthCount");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "jaas_login(realm,user,password,auth_mech,subject = " + auth_mech + ")");
            }
            Subject subject2 = null;
            ArrayList tokenHolderList = null;
            LoginContext lc = null;
            try {
                try {
                    if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                        tokenHolderList = (ArrayList)ctxMgr.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
                    }
                    if (tokenHolderList != null && user != null && realm != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Performing attribute propagation login.");
                        }
                        lc = new LoginContext(auth_mech, WSCallbackHandlerFactory.getInstance().getCallbackHandler(user, realm, passwd, (List)tokenHolderList));
                    } else {
                        lc = in_subject != null ? new LoginContext(auth_mech, in_subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(user, realm, passwd)) : new LoginContext(auth_mech, WSCallbackHandlerFactory.getInstance().getCallbackHandler(user, realm, passwd));
                    }
                }
                catch (LoginException le) {
                    Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "439", this);
                    Tr.audit(tc, "security.lc.create.err", new Object[]{auth_mech, le.toString()});
                    if (!(le instanceof WSLoginFailedException)) throw new WSLoginFailedException(le.getMessage(), le);
                    throw (WSLoginFailedException)le;
                }
                catch (SecurityException se) {
                    Manager.Ffdc.log(se, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "449", this);
                    Tr.error(tc, "security.lc.create.err", new Object[]{auth_mech, se});
                    throw new WSLoginFailedException(se.getMessage(), se);
                }
                Object var16_12 = null;
                if (tokenHolderList != null) {
                    ctxMgr.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
                }
            }
            catch (Throwable throwable) {
                Object var16_13 = null;
                if (tokenHolderList == null) throw throwable;
                ctxMgr.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
                throw throwable;
            }
            try {
                try {
                    ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(true);
                    lc.login();
                    subject2 = lc.getSubject();
                    if (subject2 == null) {
                        Tr.error(tc, "security.jaas.nosubect", new Object[]{user, auth_mech});
                        throw new WSLoginFailedException("Subject returned from login module is null.");
                    }
                    Object var18_19 = null;
                }
                catch (LoginException le) {
                    Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "477", this);
                    if (!(le instanceof WSLoginFailedException)) throw new WSLoginFailedException(le.getMessage(), le);
                    throw (WSLoginFailedException)le;
                }
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(false);
                throw throwable;
            }
            ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "jaas_login(realm,user,password, auth_mech)");
            }
            subject = subject2;
            Object var20_22 = null;
            if (!ctxMgr.isPMIEnabled()) return subject;
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            if (!ctxMgr.isPMIEnabled()) throw throwable;
            endTime = System.currentTimeMillis();
            ctxMgr.pmiTimeStatistic("JAASBasicAuthTime", endTime - startTime);
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        ctxMgr.pmiTimeStatistic("JAASBasicAuthTime", endTime - startTime);
        return subject;
    }

    protected Subject jaas_login(String realm, String user, String passwd, Subject in_subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(realm,user,password)");
        }
        Subject subject = this.jaas_login(realm, user, passwd, this.authMech, in_subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(realm,user,password)");
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Subject jaas_login(String realm, String user, String passwd, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Map appContext, Subject in_subject) throws WSLoginFailedException {
        Subject subject;
        long startTime = 0L;
        long endTime = 0L;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        try {
            if (ctxMgr.isPMIEnabled()) {
                startTime = System.currentTimeMillis();
                ctxMgr.pmiCountStatistic("JAASBasicAuthCount");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "jaas_login(realm,user,password,auth_mech = " + auth_mech + ") for web");
            }
            Subject subject2 = null;
            ArrayList tokenHolderList = null;
            LoginContext lc = null;
            try {
                try {
                    if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                        tokenHolderList = (ArrayList)ctxMgr.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
                    }
                    if (tokenHolderList != null && user != null && realm != null && passwd == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Performing attribute propagation login.");
                        }
                        lc = new LoginContext(auth_mech, WSCallbackHandlerFactory.getInstance().getCallbackHandler(user, realm, (List)tokenHolderList));
                    } else {
                        lc = in_subject != null ? new LoginContext(auth_mech, in_subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(user, realm, passwd, req, resp, appContext)) : new LoginContext(auth_mech, WSCallbackHandlerFactory.getInstance().getCallbackHandler(user, realm, passwd, req, resp, appContext));
                    }
                }
                catch (LoginException le) {
                    Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "564", this);
                    Tr.audit(tc, "security.lc.create.err", new Object[]{auth_mech, le.toString()});
                    if (!(le instanceof WSLoginFailedException)) throw new WSLoginFailedException(le.getMessage(), le);
                    throw (WSLoginFailedException)le;
                }
                catch (SecurityException se) {
                    Manager.Ffdc.log(se, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "574", this);
                    Tr.error(tc, "security.lc.create.err", new Object[]{auth_mech, se});
                    throw new WSLoginFailedException(se.getMessage(), se);
                }
                Object var19_15 = null;
                if (tokenHolderList != null) {
                    ctxMgr.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
                }
            }
            catch (Throwable throwable) {
                Object var19_16 = null;
                if (tokenHolderList == null) throw throwable;
                ctxMgr.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
                throw throwable;
            }
            try {
                try {
                    ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(true);
                    lc.login();
                    subject2 = lc.getSubject();
                    if (subject2 == null) {
                        Tr.error(tc, "security.jaas.nosubect", new Object[]{user, auth_mech});
                        throw new WSLoginFailedException("Subject returned from login module is null.");
                    }
                    Object var21_22 = null;
                }
                catch (LoginException le) {
                    Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "602", this);
                    if (!(le instanceof WSLoginFailedException)) throw new WSLoginFailedException(le.getMessage(), le);
                    throw (WSLoginFailedException)le;
                }
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(false);
                throw throwable;
            }
            ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "jaas_login(realm,user,password, auth_mech) for web");
            }
            subject = subject2;
            Object var23_25 = null;
            if (!ctxMgr.isPMIEnabled()) return subject;
        }
        catch (Throwable throwable) {
            Object var23_26 = null;
            if (!ctxMgr.isPMIEnabled()) throw throwable;
            endTime = System.currentTimeMillis();
            ctxMgr.pmiTimeStatistic("JAASBasicAuthTime", endTime - startTime);
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        ctxMgr.pmiTimeStatistic("JAASBasicAuthTime", endTime - startTime);
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Subject jaas_login(String realm, X509Certificate[] certChain, String auth_mech, Subject in_subject) throws WSLoginFailedException {
        Subject subject;
        long startTime = 0L;
        long endTime = 0L;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        try {
            if (ctxMgr.isPMIEnabled()) {
                startTime = System.currentTimeMillis();
                ctxMgr.pmiCountStatistic("JAASIDAssertionCount");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "jaas_login(realm,certChain,auth_mech,subject = " + auth_mech + ")");
            }
            Subject subject2 = null;
            ArrayList tokenHolderList = null;
            LoginContext lc = null;
            try {
                try {
                    if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                        tokenHolderList = (ArrayList)ctxMgr.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
                    }
                    if (tokenHolderList != null && certChain != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Performing attribute propagation login.");
                        }
                        lc = new LoginContext(auth_mech, WSCallbackHandlerFactory.getInstance().getCallbackHandler(realm, certChain, (List)tokenHolderList));
                    } else {
                        lc = in_subject != null ? new LoginContext(auth_mech, in_subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(realm, certChain)) : new LoginContext(auth_mech, WSCallbackHandlerFactory.getInstance().getCallbackHandler(realm, certChain));
                    }
                }
                catch (LoginException le) {
                    Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "678", this);
                    Tr.audit(tc, "security.lc.create.err", new Object[]{auth_mech, le.toString()});
                    if (!(le instanceof WSLoginFailedException)) throw new WSLoginFailedException(le.getMessage(), le);
                    throw (WSLoginFailedException)le;
                }
                catch (SecurityException se) {
                    Manager.Ffdc.log(se, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "688", this);
                    Tr.error(tc, "security.lc.create.err", new Object[]{auth_mech, se});
                    throw new WSLoginFailedException(se.getMessage(), se);
                }
                Object var15_11 = null;
                if (tokenHolderList != null) {
                    ctxMgr.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
                }
            }
            catch (Throwable throwable) {
                Object var15_12 = null;
                if (tokenHolderList == null) throw throwable;
                ctxMgr.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
                throw throwable;
            }
            try {
                try {
                    ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(true);
                    lc.login();
                    subject2 = lc.getSubject();
                    if (subject2 == null) {
                        Tr.error(tc, "security.jaas.nosubect", new Object[]{certChain, auth_mech});
                        throw new WSLoginFailedException("Subject returned from login module is null.");
                    }
                    Object var17_18 = null;
                }
                catch (LoginException le) {
                    Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "716", this);
                    if (!(le instanceof WSLoginFailedException)) throw new WSLoginFailedException(le.getMessage(), le);
                    throw (WSLoginFailedException)le;
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(false);
                throw throwable;
            }
            ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "jaas_login(realm,certChain, auth_mech)");
            }
            subject = subject2;
            Object var19_21 = null;
            if (!ctxMgr.isPMIEnabled()) return subject;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            if (!ctxMgr.isPMIEnabled()) throw throwable;
            endTime = System.currentTimeMillis();
            ctxMgr.pmiTimeStatistic("JAASIDAssertionTime", endTime - startTime);
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        ctxMgr.pmiTimeStatistic("JAASIDAssertionTime", endTime - startTime);
        return subject;
    }

    protected Subject jaas_login(String realm, X509Certificate[] certChain, Subject in_subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(realm,certChain)");
        }
        Subject subject = this.jaas_login(realm, certChain, this.authMech, in_subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(realm,certChain)");
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Subject jaas_login(String realm, X509Certificate[] certChain, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Map appContext, Subject in_subject) throws WSLoginFailedException {
        Subject subject;
        long startTime = 0L;
        long endTime = 0L;
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        try {
            if (ctxMgr.isPMIEnabled()) {
                startTime = System.currentTimeMillis();
                ctxMgr.pmiCountStatistic("JAASIDAssertionCount");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "jaas_login(realm,certChain,auth_mech = " + auth_mech + ") for web");
            }
            Subject subject2 = null;
            ArrayList tokenHolderList = null;
            LoginContext lc = null;
            try {
                try {
                    if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                        tokenHolderList = (ArrayList)ctxMgr.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
                    }
                    if (tokenHolderList != null && certChain != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Performing attribute propagation login.");
                        }
                        lc = new LoginContext(auth_mech, WSCallbackHandlerFactory.getInstance().getCallbackHandler(realm, certChain, (List)tokenHolderList));
                    } else {
                        lc = in_subject != null ? new LoginContext(auth_mech, in_subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(realm, certChain, req, resp, appContext)) : new LoginContext(auth_mech, WSCallbackHandlerFactory.getInstance().getCallbackHandler(realm, certChain, req, resp, appContext));
                    }
                }
                catch (LoginException le) {
                    Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "803", this);
                    Tr.audit(tc, "security.lc.create.err", new Object[]{auth_mech, le.toString()});
                    if (!(le instanceof WSLoginFailedException)) throw new WSLoginFailedException(le.getMessage(), le);
                    throw (WSLoginFailedException)le;
                }
                catch (SecurityException se) {
                    Manager.Ffdc.log(se, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "813", this);
                    Tr.error(tc, "security.lc.create.err", new Object[]{auth_mech, se});
                    throw new WSLoginFailedException(se.getMessage(), se);
                }
                Object var18_14 = null;
                if (tokenHolderList != null) {
                    ctxMgr.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
                }
            }
            catch (Throwable throwable) {
                Object var18_15 = null;
                if (tokenHolderList == null) throw throwable;
                ctxMgr.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
                throw throwable;
            }
            try {
                try {
                    ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(true);
                    lc.login();
                    subject2 = lc.getSubject();
                    if (subject2 == null) {
                        Tr.error(tc, "security.jaas.nosubect", new Object[]{certChain, auth_mech});
                        throw new WSLoginFailedException("Subject returned from login module is null.");
                    }
                    Object var20_21 = null;
                }
                catch (LoginException le) {
                    Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "841", this);
                    if (!(le instanceof WSLoginFailedException)) throw new WSLoginFailedException(le.getMessage(), le);
                    throw (WSLoginFailedException)le;
                }
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(false);
                throw throwable;
            }
            ctxMgr.getThreadLocal().set_update_to_caller_list_disabled_during_login(false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "jaas_login(realm,certChain, auth_mech) for web");
            }
            subject = subject2;
            Object var22_24 = null;
            if (!ctxMgr.isPMIEnabled()) return subject;
        }
        catch (Throwable throwable) {
            Object var22_25 = null;
            if (!ctxMgr.isPMIEnabled()) throw throwable;
            endTime = System.currentTimeMillis();
            ctxMgr.pmiTimeStatistic("JAASIDAssertionTime", endTime - startTime);
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        ctxMgr.pmiTimeStatistic("JAASIDAssertionTime", endTime - startTime);
        return subject;
    }

    protected Subject jaas_login(String auth_mech, Object protocolPolicy, Subject invocation_subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(auth_mech = " + auth_mech + ", protocolPolicy, invocationSubject) for outbound");
        }
        Subject subject = null;
        LoginContext lc = null;
        try {
            lc = new LoginContext(auth_mech, invocation_subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(protocolPolicy));
        }
        catch (LoginException le) {
            Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "887", this);
            Tr.audit(tc, "security.lc.create.err", new Object[]{auth_mech, le.toString()});
            if (le instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)le;
            }
            throw new WSLoginFailedException(le.getMessage(), le);
        }
        catch (SecurityException se) {
            Manager.Ffdc.log(se, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "897", this);
            Tr.error(tc, "security.lc.create.err", new Object[]{auth_mech, se});
            throw new WSLoginFailedException(se.getMessage(), se);
        }
        try {
            if (lc != null) {
                lc.login();
                subject = lc.getSubject();
                if (subject == null) {
                    throw new WSLoginFailedException("Subject returned from login module is null.");
                }
            }
        }
        catch (LoginException le) {
            Manager.Ffdc.log(le, this, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "920", this);
            if (le instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)le;
            }
            throw new WSLoginFailedException(le.getMessage(), le);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(auth_mech = " + auth_mech + ", protocolPolicy, invocationSubject) for outbound");
        }
        return subject;
    }

    static {
        Object platformHelperClass = null;
        try {
            tc = Tr.register(JaasLoginHelper.class, null, "com.ibm.ejs.resources.security");
            if (ContextManagerFactory.getInstance().getPlatformHelper().isServantJvm()) {
                isServant = true;
            }
        }
        catch (Exception e) {
            Tr.error(tc, "exception " + e.toString() + " in static initializer");
        }
    }
}

