/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.util;

import com.ibm.ejs.models.base.resources.url.URLProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import com.ibm.ws.runtime.util.utilHandlerClass;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;

public class URLHandlerFactory
implements URLStreamHandlerFactory {
    private static final TraceComponent tc = Tr.register(URLHandlerFactory.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private Map streamHandlerTable;

    public URLHandlerFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "URLHandlerFactory ctor");
        }
        this.streamHandlerTable = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "URLHandlerFactory ctor");
        }
    }

    void registerProvider(String name, String protocol, String classname, String classpath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerProvider " + name + " " + protocol + " " + classname + " " + classpath);
        }
        if (protocol != null && classname != null) {
            this.streamHandlerTable.put(protocol, new utilHandlerClass(classname, classpath));
        } else {
            Tr.warning(tc, "WSVR0051W", name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerProvider");
        }
    }

    public void registerProvider(URLProvider urlProvider) {
        String classpath = StreamHandlerUtils.getProviderClasspath(urlProvider.getClasspath());
        this.registerProvider(urlProvider, classpath);
    }

    public void registerProvider(URLProvider provider, String classpath) {
        String name = provider.getName();
        String protocol = provider.getProtocol();
        String classname = provider.getStreamHandlerClassName();
        this.registerProvider(name, protocol, classname, classpath);
    }

    public void registerProvider(String protocol, String classpath) {
        String classname = StreamHandlerUtils.getClassName(classpath);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerProvider " + protocol + " : " + classname);
        }
        if (protocol != null && classname != null) {
            this.streamHandlerTable.put(protocol, new utilHandlerClass(classname, classpath));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerProvider(provider,class)");
        }
    }

    public void deregisterProvider(String protocol) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterProvider");
        }
        if (protocol != null) {
            this.streamHandlerTable.remove(protocol);
        } else {
            Tr.info(tc, "WSVR0052");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterProvider");
        }
    }

    public boolean queryProvider(String protocol) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryProvider");
        }
        boolean result = false;
        if (protocol != null) {
            result = this.streamHandlerTable.containsKey(protocol);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryProvider");
        }
        return result;
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createURLStreamHandler for protocol=" + protocol);
        }
        URLStreamHandler handler = null;
        if (protocol != null && protocol.length() > 0) {
            protocol = protocol.toLowerCase();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "streamHandlerTable=" + this.streamHandlerTable);
            }
            utilHandlerClass hc = (utilHandlerClass)this.streamHandlerTable.get(protocol);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handler class " + hc + " retrieved from streamHandlerTable");
            }
            if (hc != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found a handlerClass object for " + protocol);
                }
                if (hc.getClassname() != null) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "attempting to get a class loader for " + hc.getClasspath());
                        }
                        ClassLoader cl = StreamHandlerUtils.getResourceClassLoader(hc.getClasspath(), null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Attempting to load " + hc.getClassname());
                        }
                        Class<?> streamhandlerClass = cl.loadClass(hc.getClassname());
                        handler = (URLStreamHandler)streamhandlerClass.newInstance();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found streamHandlerClass " + hc.getClassname() + " for protocol " + protocol);
                        }
                    }
                    catch (Throwable t) {
                        String[] parms = new String[]{hc.getClassname(), protocol};
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "URLStreamHandlerError " + t.toString() + " " + hc.getClassname() + " " + protocol);
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find streamHandlerClass for: " + protocol);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createURLStreamHandler returning handler:" + handler);
        }
        return handler;
    }
}

