/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.provisioning;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.bootstrap.StopWatch;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.runtime.component.ContainerHelper;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.component.WsComponent;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.provisioning.ComponentInfo;
import com.ibm.wsspi.runtime.provisioning.ComponentInfoFactory;
import com.ibm.wsspi.runtime.provisioning.ConfigAnalyzer;
import com.ibm.wsspi.runtime.provisioning.DependentComponentInfo;
import com.ibm.wsspi.runtime.provisioning.ServerActivation;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentMetaDataMgr {
    private final Map<String, ContainerImpl.ComponentStartup> idToComponentMap = new HashMap<String, ContainerImpl.ComponentStartup>();
    private final Map<String, List> extensionPointToComponentsMap = new HashMap<String, List>();
    private final Map<String, ContainerImpl.ComponentStartup> serviceToComponentMap = new HashMap<String, ContainerImpl.ComponentStartup>();
    private Set<String> otherPlatformComponents = new HashSet<String>();
    private static final PlatformHelper ph = PlatformHelperFactory.getPlatformHelper();
    private static final boolean isClient = ComponentMetaDataMgr.isClient();
    private static Map<Integer, String> componentStateHistory = null;
    private static final PlatformCheck platformCheck = new PlatformCheck();
    private static final TraceComponent tc = Tr.register(ComponentMetaDataMgr.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static ComponentMetaDataMgr instance = null;
    private static final String SERVER_ACTIVATION_EXT_PT = "server-activation";
    private static final String SERVER_STARTUP_EXT_PT = "com.ibm.wsspi.extension.server-startup";
    private static final String CLIENT_STARTUP_EXT_PT = "com.ibm.wsspi.extension.client-startup";
    private Set<ComponentInfo> serverActivationPlan = new HashSet<ComponentInfo>();
    private Set<ContainerImpl.ComponentStartup> activationPlanAllComponents = null;
    private static boolean provisioningFlag = false;
    private static boolean provisioningFlagSet = false;

    private static boolean isClient() {
        String container = System.getProperty("com.ibm.ws.container");
        return container != null && container.equalsIgnoreCase("client");
    }

    private ComponentMetaDataMgr() throws ConfigurationError {
        StopWatch sw = StopWatch.instance();
        sw.start("ComponentMetaDataMgr()");
        this.isProvisioningEnabled();
        if (!isClient) {
            if (this.isProvisioningEnabled()) {
                Tr.info(tc, "WSVR0178I");
            } else {
                Tr.info(tc, "WSVR0179I");
            }
            this.loadComponentMetaData(SERVER_STARTUP_EXT_PT);
            this.setGlobalSortOrder(SERVER_STARTUP_EXT_PT, 0);
        } else {
            this.loadComponentMetaData(CLIENT_STARTUP_EXT_PT);
            this.setGlobalSortOrder(CLIENT_STARTUP_EXT_PT, 0);
        }
        if (!this.isProvisioningEnabled()) {
            this.processDefaultActivationPlan();
        } else {
            this.createServerActivationPlan();
            this.processImmediateComponents(SERVER_STARTUP_EXT_PT);
            try {
                this.processActivationPlan(this.serverActivationPlan, true);
            }
            catch (RuntimeError e) {
                Manager.Ffdc.log(e, this, null, "174");
            }
        }
        sw.stop();
    }

    public static ComponentMetaDataMgr instance() throws ConfigurationError {
        if (instance == null) {
            instance = new ComponentMetaDataMgr();
        }
        return instance;
    }

    private String dumpComponents() {
        StringBuilder sb = new StringBuilder("Activation plan processed the following component data:");
        String extensionPoint = null;
        if (isClient) {
            extensionPoint = CLIENT_STARTUP_EXT_PT;
        } else {
            extensionPoint = SERVER_STARTUP_EXT_PT;
            if (this.isProvisioningEnabled()) {
                sb.append("( + indicates state change)");
            }
        }
        sb.append("\n            ").append(extensionPoint).append('\n');
        this.dumpComponents(extensionPoint, sb, 0);
        return sb.toString();
    }

    private void dumpComponents(String extensionPoint, StringBuilder sb, int indent) {
        if (componentStateHistory == null && this.isProvisioningEnabled()) {
            componentStateHistory = new Hashtable<Integer, String>(50);
        }
        for (ContainerImpl.ComponentStartup componentData : this.extensionPointToComponentsMap.get(extensionPoint)) {
            String previousState;
            int begin = 0;
            char stateChangeIndicator = ' ';
            String state = componentData.getState().substring(0, 3);
            if (this.isProvisioningEnabled() && !state.equals(previousState = componentStateHistory.get(componentData.globalOrder))) {
                componentStateHistory.put(componentData.globalOrder, state);
                stateChangeIndicator = '+';
            }
            begin = sb.length();
            sb.append(componentData.globalOrder);
            while (sb.length() - begin < 3) {
                sb.append(' ');
            }
            if (componentData.startupMode == 0) {
                sb.append(" PRI  ").append("INI");
            } else if (componentData.startupMode == 1) {
                sb.append(" IMM ").append(stateChangeIndicator).append(state);
            } else if (componentData.startupMode == 2) {
                sb.append(" DEP ").append(stateChangeIndicator).append(state);
            }
            while (sb.length() - begin < 12 + indent) {
                sb.append(' ');
            }
            sb.append(' ');
            begin = sb.length();
            if (componentData.componentId != null) {
                sb.append(componentData.componentId);
            }
            while (sb.length() - begin < 30) {
                sb.append(' ');
            }
            sb.append(' ');
            if (componentData.clazz != null) {
                sb.append(componentData.clazz);
                if (componentData.type != null) {
                    sb.append(' ').append(componentData.type);
                }
            } else {
                sb.append(componentData.type);
            }
            if (componentData.hostingBundleId != null) {
                sb.append(" [").append(componentData.hostingBundleId).append(']');
            }
            sb.append('\n');
            if (componentData.containerExtensionPoint == null) continue;
            begin = sb.length();
            while (sb.length() - begin < 14 + indent) {
                sb.append(' ');
            }
            sb.append(componentData.containerExtensionPoint);
            sb.append('\n');
            this.dumpComponents(componentData.containerExtensionPoint, sb, indent + 2);
        }
    }

    private void validateDependencies(ContainerImpl.ComponentStartup componentData, boolean tolerationMode, int depth) throws RuntimeError {
        boolean debugging;
        String indent = "Depth [" + depth + "] validate():";
        boolean bl = debugging = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (componentData.state != 0) {
            if (componentData.isRootComponent() && debugging) {
                Tr.debug(tc, indent + " ROOT component already processed, check activation plan. " + componentData.componentId + " state=" + componentData.getState());
            }
            if (debugging) {
                Tr.debug(tc, indent + "component already processed, skip. " + componentData.componentId + " state=" + componentData.getState());
            }
            return;
        }
        componentData.state = 2;
        for (int i = 0; i < componentData.dependencies.size(); ++i) {
            ContainerHelper.Dependency dependency;
            block18: {
                block16: {
                    block17: {
                        dependency = (ContainerHelper.Dependency)componentData.dependencies.get(i);
                        if (debugging) {
                            Tr.debug(tc, indent + dependency);
                        }
                        if (dependency.component == null || dependency.component.startupMode == 0) continue;
                        if (dependency.component.state != 4) break block16;
                        if (provisioningFlag) break block17;
                        if (debugging) {
                            Tr.debug(tc, "Ignoring disabled dependency: " + dependency.component.componentId);
                        }
                        break block18;
                    }
                    if (dependency.mandatory) {
                        if (debugging) {
                            Tr.debug(tc, indent + "Because mandatory dependency " + dependency.component.componentId + " is DISABLED, parent component " + componentData.componentId + " will be DISABLED");
                        }
                        componentData.state = 4;
                        return;
                    }
                    if (!debugging) break block18;
                    Tr.debug(tc, indent + "optional dependency disabled: " + dependency.component.componentId + " state=" + dependency.component.getState());
                    break block18;
                }
                if (dependency.component.state != 0) {
                    if (!debugging) continue;
                    if (dependency.component.isRootComponent()) {
                        Tr.debug(tc, indent + "ROOT component in dependency chain, check activation plan: " + dependency.component.componentId);
                    }
                    Tr.debug(tc, indent + "skip dependency: " + dependency.component.componentId + " state=" + dependency.component.getState());
                    continue;
                }
            }
            if (!dependency.mandatory && !dependency.attemptStart) {
                if (!debugging) continue;
                Tr.debug(tc, indent + "skip validating optional " + dependency.component.componentId);
                continue;
            }
            boolean enabled = this.analyzeConfig(dependency.component, tolerationMode, depth);
            if (enabled) {
                this.validateDependencies(dependency.component, tolerationMode, depth + 1);
            }
            if (dependency.component.state != 4 || !dependency.mandatory || !provisioningFlag) continue;
            if (debugging) {
                Tr.debug(tc, indent + " " + componentData.componentId + " mandatory dependency failed:" + dependency);
            }
            componentData.state = 4;
            return;
        }
        if (componentData.state == 2) {
            componentData.state = 1;
            if (debugging) {
                Tr.debug(tc, "component selected: " + componentData.getName());
            }
            if (this.activationPlanAllComponents != null) {
                this.activationPlanAllComponents.add(componentData);
            }
        }
    }

    private boolean addToComponentIdAndServiceMaps(ContainerImpl.ComponentStartup componentData) {
        boolean result = true;
        if (componentData.componentId != null) {
            ContainerImpl.ComponentStartup comp = this.idToComponentMap.get(componentData.componentId);
            if (comp != null) {
                Tr.error(tc, "WSVR0152E", new Object[]{componentData});
                result = false;
            }
            if (result) {
                for (ContainerHelper.ServiceMetaData service : componentData.services) {
                    comp = this.serviceToComponentMap.get(service.interfaceName);
                    if (comp == null) continue;
                    Tr.error(tc, "WSVR0151E", new Object[]{componentData.componentId, service.interfaceName});
                    result = false;
                    break;
                }
            }
            if (result) {
                this.idToComponentMap.put(componentData.componentId, componentData);
                for (ContainerHelper.ServiceMetaData service : componentData.services) {
                    this.serviceToComponentMap.put(service.interfaceName, componentData);
                }
            }
        }
        return result;
    }

    public List getComponentsByExtensionPoint(String extensionPointId) throws ConfigurationError {
        return this.getComponentsByExtensionPoint(extensionPointId, null);
    }

    public List getComponentsByExtensionPoint(String extensionPointId, WsComponent container) throws ConfigurationError {
        boolean debugging = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        List components = this.extensionPointToComponentsMap.get(extensionPointId);
        if (components == null) {
            if (debugging) {
                Tr.debug(tc, "Extension point not found in component map: " + extensionPointId);
            }
            components = this.loadComponentMetaData(extensionPointId);
        }
        if (container != null) {
            if (debugging) {
                Tr.debug(tc, "Container being specified for components in extension point " + extensionPointId);
            }
            for (ContainerImpl.ComponentStartup componentData : components) {
                componentData.container = container;
            }
        } else if (debugging) {
            Tr.debug(tc, "No container specified for extension point " + extensionPointId);
        }
        return components;
    }

    public ContainerImpl.ComponentStartup getComponentByDependency(ContainerHelper.Dependency dependency) {
        if (dependency.type == 0) {
            return this.idToComponentMap.get(dependency.name);
        }
        return this.serviceToComponentMap.get(dependency.name);
    }

    private List loadComponentMetaData(String extensionPointId) throws ConfigurationError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing extension point: " + extensionPointId);
        }
        List<ContainerImpl.ComponentStartup> componentList = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId);
        IExtension[] extensions = null;
        if (extensionPoint != null) {
            extensions = extensionPoint.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                IExtension extension = extensions[i];
                IConfigurationElement[] componentsElement = extension.getConfigurationElements();
                if (componentsElement.length != 1) {
                    Tr.error(tc, "WSVR0153E", new Object[]{extensionPointId, extension.getNamespaceIdentifier()});
                    continue;
                }
                IConfigurationElement element = componentsElement[0];
                if (!element.getName().equals("components")) {
                    Tr.error(tc, "WSVR0154E", new Object[]{extensionPointId, extension.getNamespaceIdentifier()});
                    continue;
                }
                IConfigurationElement[] componentElements = element.getChildren();
                for (int j = 0; j < componentElements.length; ++j) {
                    String startupMode;
                    String inhibitAsynchronousBehavior;
                    String asyncInitialize;
                    String asyncStart;
                    IConfigurationElement component = componentElements[j];
                    if (!component.getName().equals("component")) {
                        Tr.error(tc, "WSVR0155E", new Object[]{extensionPointId, extension.getNamespaceIdentifier()});
                        continue;
                    }
                    String type = component.getAttribute("type");
                    String clazz = component.getAttribute("class");
                    String startup = component.getAttribute("startup");
                    String platform = component.getAttribute("platform");
                    if (type == null && clazz == null) {
                        Tr.error(tc, "WSVR0156E", new Object[]{extensionPointId, extension.getNamespaceIdentifier()});
                        continue;
                    }
                    ContainerImpl.ComponentStartup componentStartup = new ContainerImpl.ComponentStartup();
                    try {
                        int startupInt;
                        componentStartup.order = startupInt = Integer.parseInt(startup);
                    }
                    catch (NumberFormatException e) {
                        if (clazz != null) {
                            Tr.error(tc, "WSVR0157E", new Object[]{clazz, extensionPointId, extension.getNamespaceIdentifier()});
                            continue;
                        }
                        Tr.error(tc, "WSVR0158E", new Object[]{type, extensionPointId, extension.getNamespaceIdentifier()});
                        continue;
                    }
                    boolean configurationDataRequiredBoolean = componentStartup.configurationDataRequired;
                    boolean asyncStartBoolean = componentStartup.asyncStart;
                    boolean asyncInitializeBoolean = componentStartup.asyncInitialize;
                    boolean inhibitAsynchronousBehaviorBoolean = componentStartup.inhibitAsynchronousBehavior;
                    int startupModeInt = 1;
                    String configurationDataRequired = component.getAttribute("configurationDataRequired");
                    if (configurationDataRequired != null) {
                        configurationDataRequiredBoolean = configurationDataRequired.equalsIgnoreCase("true");
                    }
                    if ((asyncStart = component.getAttribute("asyncStart")) != null) {
                        asyncStartBoolean = asyncStart.equalsIgnoreCase("true");
                    }
                    if ((asyncInitialize = component.getAttribute("asyncInitialize")) != null) {
                        asyncInitializeBoolean = asyncInitialize.equalsIgnoreCase("true");
                    }
                    if ((inhibitAsynchronousBehavior = component.getAttribute("inhibitAsynchronousBehavior")) != null) {
                        inhibitAsynchronousBehaviorBoolean = inhibitAsynchronousBehavior.equalsIgnoreCase("true");
                    }
                    if ((startupMode = component.getAttribute("startup-mode")) != null) {
                        if (startupMode.equalsIgnoreCase("primordial")) {
                            startupModeInt = 0;
                        } else if (startupMode.equalsIgnoreCase("dependency")) {
                            startupModeInt = 2;
                        } else if (startupMode.equalsIgnoreCase("immediate")) {
                            startupModeInt = 1;
                        } else {
                            if (clazz != null) {
                                Tr.error(tc, "WSVR0159E", new Object[]{startupMode, clazz, extensionPointId, extension.getNamespaceIdentifier()});
                                continue;
                            }
                            Tr.error(tc, "WSVR0160E", new Object[]{startupMode, type, extensionPointId, extension.getNamespaceIdentifier()});
                            continue;
                        }
                    }
                    componentStartup.type = type;
                    componentStartup.clazz = clazz;
                    if (clazz != null) {
                        componentStartup.hostingBundleId = component.getNamespaceIdentifier();
                    }
                    componentStartup.platforms = platform;
                    componentStartup.configurationDataRequired = configurationDataRequiredBoolean;
                    componentStartup.asyncStart = asyncStartBoolean;
                    componentStartup.asyncInitialize = asyncInitializeBoolean;
                    componentStartup.inhibitAsynchronousBehavior = inhibitAsynchronousBehaviorBoolean;
                    componentStartup.processtypes = component.getAttribute("processType");
                    componentStartup.recoverytypes = component.getAttribute("recoveryType");
                    componentStartup.configurationData = component.getAttribute("configurationData");
                    componentStartup.componentId = component.getAttribute("component-id");
                    if (componentStartup.componentId == null) {
                        componentStartup.state = 1;
                    } else if (componentStartup.componentId.length() == 0) {
                        Tr.warning(tc, "WSVR0173W", new Object[]{componentStartup, extensionPointId, extension.getNamespaceIdentifier()});
                        continue;
                    }
                    componentStartup.version = component.getAttribute("version");
                    componentStartup.startupMode = startupModeInt;
                    componentStartup.configAnalyzer = component.getAttribute("configuration-analyzer-class");
                    componentStartup.initMethod = component.getAttribute("init-method");
                    componentStartup.startMethod = component.getAttribute("start-method");
                    componentStartup.stopMethod = component.getAttribute("stop-method");
                    componentStartup.destroyMethod = component.getAttribute("destroy-method");
                    componentStartup.hostingBundleId = component.getNamespaceIdentifier();
                    String containerExtensionPoint = component.getAttribute("containerExtensionPoint");
                    IConfigurationElement[] componentChildren = component.getChildren();
                    boolean error = false;
                    block4: for (int k = 0; k < componentChildren.length; ++k) {
                        IConfigurationElement childElement = componentChildren[k];
                        String childElementName = childElement.getName();
                        if (childElementName.equals("dependency")) {
                            String afterInit;
                            String attemptStart;
                            ContainerHelper.Dependency dependency = new ContainerHelper.Dependency(componentStartup);
                            String dependencyType = childElement.getAttribute("type");
                            if (dependencyType == null) {
                                if (componentStartup.componentId != null) {
                                    Tr.error(tc, "WSVR0161E", new Object[]{componentStartup.componentId, extensionPointId, extension.getNamespaceIdentifier()});
                                } else if (clazz != null) {
                                    Tr.error(tc, "WSVR0162E", new Object[]{clazz, extensionPointId, extension.getNamespaceIdentifier()});
                                } else {
                                    Tr.error(tc, "WSVR0163E", new Object[]{type, extensionPointId, extension.getNamespaceIdentifier()});
                                }
                                error = true;
                                break;
                            }
                            if (dependencyType.equalsIgnoreCase("component")) {
                                dependency.type = 0;
                            } else if (dependencyType.equalsIgnoreCase("service")) {
                                dependency.type = 1;
                            } else {
                                if (componentStartup.componentId != null) {
                                    Tr.error(tc, "WSVR0164E", new Object[]{componentStartup.componentId, extensionPointId, extension.getNamespaceIdentifier()});
                                } else if (clazz != null) {
                                    Tr.error(tc, "WSVR0165E", new Object[]{clazz, extensionPointId, extension.getNamespaceIdentifier()});
                                } else {
                                    Tr.error(tc, "WSVR0166E", new Object[]{type, extensionPointId, extension.getNamespaceIdentifier()});
                                }
                                error = true;
                                break;
                            }
                            dependency.name = childElement.getAttribute("name");
                            if (dependency.name != null) {
                                dependency.name = dependency.name.trim();
                            }
                            if (dependency.name == null || dependency.name.length() == 0) {
                                if (componentStartup.componentId != null) {
                                    Tr.error(tc, "WSVR0167E", new Object[]{componentStartup.componentId, extensionPointId, extension.getNamespaceIdentifier()});
                                } else if (clazz != null) {
                                    Tr.error(tc, "WSVR0168E", new Object[]{clazz, extensionPointId, extension.getNamespaceIdentifier()});
                                } else {
                                    Tr.error(tc, "WSVR0169E", new Object[]{type, extensionPointId, extension.getNamespaceIdentifier()});
                                }
                                error = true;
                                break;
                            }
                            String mandatory = childElement.getAttribute("mandatory");
                            if (mandatory != null) {
                                dependency.mandatory = mandatory.equalsIgnoreCase("true");
                            }
                            if ((attemptStart = childElement.getAttribute("attempt-start")) != null) {
                                dependency.attemptStart = attemptStart.equalsIgnoreCase("true");
                            }
                            if (dependency.mandatory && dependency.attemptStart) {
                                Tr.error(tc, "The specification of attempt-start=true is not valid for mandatory dependency " + dependency.name + " for the " + componentStartup.componentId + " component");
                            }
                            if ((afterInit = childElement.getAttribute("after-init")) != null) {
                                dependency.afterInit = afterInit.equalsIgnoreCase("true");
                            }
                            dependency.method = childElement.getAttribute("method");
                            if (dependency.method != null) {
                                componentStartup.injectDependencies = true;
                            }
                            dependency.parmType = childElement.getAttribute("parmtype");
                            if (componentStartup.dependencies == Collections.EMPTY_LIST) {
                                componentStartup.dependencies = new ArrayList();
                            }
                            componentStartup.dependencies.add(dependency);
                            continue;
                        }
                        if (childElementName.equals("services")) {
                            IConfigurationElement[] providers = childElement.getChildren();
                            for (int l = 0; l < providers.length; ++l) {
                                ContainerHelper.ServiceMetaData service;
                                IConfigurationElement provider = providers[l];
                                if (provider.getName().equals("provide")) {
                                    service = new ContainerHelper.ServiceMetaData();
                                    service.interfaceName = provider.getAttribute("interface");
                                    if (service.interfaceName != null) {
                                        service.interfaceName = service.interfaceName.trim();
                                    }
                                    if (service.interfaceName == null || service.interfaceName.length() == 0) {
                                        String componentReplacement = null;
                                        componentReplacement = componentStartup.componentId != null ? "component-id=" + componentStartup.componentId : (clazz != null ? "class=" + clazz : "type=" + type);
                                        Tr.error(tc, "WSVR0170E", new Object[]{componentReplacement, extensionPointId, extension.getNamespaceIdentifier()});
                                        error = true;
                                        continue block4;
                                    }
                                    String autoregister = provider.getAttribute("autoregister");
                                    if (autoregister != null) {
                                        service.autoregister = autoregister.equalsIgnoreCase("true");
                                    }
                                    if (componentStartup.services == Collections.EMPTY_LIST) {
                                        componentStartup.services = new ArrayList();
                                    }
                                } else {
                                    String componentReplacement = null;
                                    componentReplacement = componentStartup.componentId != null ? "component-id=" + componentStartup.componentId : (clazz != null ? "class=" + clazz : "type=" + type);
                                    Tr.error(tc, "WSVR0171E", new Object[]{componentReplacement, extensionPointId, extension.getNamespaceIdentifier()});
                                    error = true;
                                    continue block4;
                                }
                                componentStartup.services.add(service);
                            }
                            continue;
                        }
                        String componentReplacement = null;
                        componentReplacement = componentStartup.componentId != null ? "component-id=" + componentStartup.componentId : (clazz != null ? "class=" + clazz : "type=" + type);
                        Tr.error(tc, "WSVR0172E", new Object[]{componentReplacement, extensionPointId, extension.getNamespaceIdentifier()});
                        error = true;
                        break;
                    }
                    if (error) {
                        Tr.warning(tc, "WSVR0173W", new Object[]{componentStartup, extensionPointId, extension.getNamespaceIdentifier()});
                        continue;
                    }
                    if (ComponentMetaDataMgr.platformCheck.validOn(componentStartup.platforms, componentStartup.processtypes, componentStartup.recoverytypes)) {
                        if (componentList.contains(componentStartup)) {
                            Tr.warning(tc, "WSVR0174W", new Object[]{componentStartup, extensionPointId, extension.getNamespaceIdentifier()});
                            continue;
                        }
                        if (!this.addToComponentIdAndServiceMaps(componentStartup)) continue;
                        componentList.add(componentStartup);
                        if (containerExtensionPoint == null) continue;
                        componentStartup.containerExtensionPoint = containerExtensionPoint;
                        this.loadComponentMetaData(containerExtensionPoint);
                        continue;
                    }
                    this.otherPlatformComponents.add(componentStartup.componentId);
                }
            }
        }
        int lastDot = extensionPointId.lastIndexOf(".");
        String shortExtensionPointId = extensionPointId.substring(lastDot + 1);
        String pluginName = "META-INF/ws-" + shortExtensionPointId + ".xml";
        this.loadLegacyPlugins(pluginName, componentList);
        Collections.sort(componentList, new StartupComparator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "loadedComponents: " + componentList.size());
            for (int i = 0; i < componentList.size(); ++i) {
                Tr.debug(tc, " component[" + i + "]=" + componentList.get(i));
            }
        }
        this.extensionPointToComponentsMap.put(extensionPointId, componentList);
        return componentList;
    }

    private void loadLegacyPlugins(String pluginName, List componentList) throws ConfigurationError {
        Enumeration<URL> e;
        try {
            e = Thread.currentThread().getContextClassLoader().getResources(pluginName);
        }
        catch (IOException ioe) {
            throw new ConfigurationError(ioe);
        }
        XMLReader xmlReader = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            xmlReader = factory.newSAXParser().getXMLReader();
        }
        catch (SAXException ex) {
            throw new ConfigurationError(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ConfigurationError(ex);
        }
        catch (FactoryConfigurationError ex) {
            throw new ConfigurationError(ex);
        }
        StartupHandler handler = new StartupHandler();
        xmlReader.setContentHandler(handler);
        xmlReader.setDTDHandler(handler);
        xmlReader.setEntityResolver(handler);
        xmlReader.setErrorHandler(handler);
        Object is = null;
        while (e.hasMoreElements()) {
            URL pluginUrl = e.nextElement();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "parsing " + pluginUrl);
            }
            try {
                xmlReader.parse(new InputSource(pluginUrl.openStream()));
                List components = handler.getComponents();
                for (int i = 0; i < components.size(); ++i) {
                    ContainerImpl.ComponentStartup component = (ContainerImpl.ComponentStartup)components.get(i);
                    if (componentList.contains(component)) continue;
                    component.state = 1;
                    componentList.add(component);
                }
            }
            catch (SAXParseException spe) {
                Manager.Ffdc.log(spe, this, null, "817");
                Tr.error(tc, "WSVR0500E", new Object[]{pluginUrl.getFile(), new Integer(spe.getLineNumber()), new Integer(spe.getColumnNumber()), spe});
            }
            catch (SAXException se) {
                Manager.Ffdc.log(se, this, null, "823");
                Exception t = se.getException();
                if (t == null) {
                    t = se;
                }
                Tr.error(tc, "WSVR0500E", new Object[]{pluginUrl.getFile(), "?", "?", t});
            }
            catch (IOException ioe) {
                Manager.Ffdc.log(ioe, this, null, "831");
                Tr.error(tc, "WSVR0500E", new Object[]{pluginUrl.getFile(), "?", "?", ioe});
            }
        }
    }

    private boolean getAttribute(IConfigurationElement element, String attributeName, boolean defaultValue) {
        String attr = element.getAttribute(attributeName);
        if (attr == null) {
            return defaultValue;
        }
        if (attr.equalsIgnoreCase(Boolean.toString(true))) {
            return true;
        }
        if (attr.equalsIgnoreCase(Boolean.toString(false))) {
            return false;
        }
        Manager.Ffdc.log(new ConfigurationWarning("invalid boolean attribute: \"" + attr + "\" specified for attribute \"" + attributeName + "\""), this, null, "877");
        return defaultValue;
    }

    private void createServerActivationPlan() throws ConfigurationError {
        String extensionPointId;
        boolean debugging;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerActivationPlan");
        }
        boolean bl = debugging = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (!this.isProvisioningEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug(tc, "createServerActivationPlan - provisioning off");
            }
            return;
        }
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId = ExtensionRegistryFactory.instance().getDefaultPluginID() + "." + SERVER_ACTIVATION_EXT_PT);
        if (extensionPoint == null) {
            throw new ConfigurationError("Extension point " + extensionPointId + " not found");
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (debugging) {
            Tr.debug(tc, "Processing extension point " + extensionPointId);
            Tr.debug(tc, "There are " + extensions.length + " extensions");
        }
        for (int i = 0; i < extensions.length; ++i) {
            IExtension extension;
            IConfigurationElement[] serverActivations;
            if (debugging) {
                Tr.debug(tc, "Processing extension in bundle " + extensions[i].getNamespaceIdentifier());
            }
            if ((serverActivations = (extension = extensions[i]).getConfigurationElements()).length != 1) {
                throw new ConfigurationError("Invalid number of <server-activations> elements - " + serverActivations.length);
            }
            IConfigurationElement serverActivationsElement = serverActivations[0];
            if (!serverActivationsElement.getName().equals("server-activations")) {
                throw new ConfigurationError("Invalid element name - expecting <server-activations>, got <" + serverActivationsElement.getName() + ">");
            }
            IConfigurationElement[] serverActivationElements = serverActivationsElement.getChildren();
            if (serverActivationElements == null || serverActivationElements.length == 0) continue;
            for (int j = 0; j < serverActivationElements.length; ++j) {
                IConfigurationElement serverActivationElement = serverActivationElements[j];
                if (!serverActivationElement.getName().equals(SERVER_ACTIVATION_EXT_PT)) {
                    throw new ConfigurationError("Invalid element name - expecting <server-activation>, got <" + serverActivationElement.getName() + ">");
                }
                String className = serverActivationElement.getAttribute("class");
                if (className == null) {
                    throw new ConfigurationError("Missing class attribute on <server-activation> element");
                }
                List<ComponentInfo> serverActivationComponents = null;
                try {
                    ServerActivation serverActivation = (ServerActivation)serverActivationElement.createExecutableExtension("class");
                    serverActivationComponents = serverActivation.getActivationPlan();
                }
                catch (Exception e) {
                    throw new ConfigurationError("Exception activator: " + className, e);
                }
                if (serverActivationComponents == null || serverActivationComponents.size() == 0) {
                    if (!debugging) continue;
                    Tr.debug(tc, "Activator returned empty list: " + className);
                    continue;
                }
                for (ComponentInfo serverActivationComponent : serverActivationComponents) {
                    if (serverActivationComponent == null) continue;
                    if (debugging) {
                        Tr.debug(tc, "server activation component:[" + serverActivationComponent.getComponentId() + ":" + serverActivationComponent.getVersion() + "]");
                    }
                    this.serverActivationPlan.add(serverActivationComponent);
                }
            }
        }
        if (this.serverActivationPlan.size() == 0) {
            throw new ConfigurationError("No server activation components found.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerActivationPlan");
        }
    }

    public boolean isProvisioningEnabled() {
        boolean debugTrace;
        boolean bl = debugTrace = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (!provisioningFlagSet) {
            try {
                if (PlatformCheck.recoveryMode || isClient || PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
                    provisioningFlag = false;
                    if (debugTrace) {
                        Tr.debug(tc, "Provisioning is disabled, recoveryMode=" + PlatformCheck.recoveryMode + ", isClient=" + isClient + ", isCRAJvm=" + PlatformHelperFactory.getPlatformHelper().isCRAJvm());
                    }
                } else {
                    ConfigService configService = WsServiceRegistry.getService(this, ConfigService.class);
                    List list = configService.getDocumentObjects(configService.getScope(4), "server.xml");
                    ConfigObject serverObject = (ConfigObject)list.get(0);
                    provisioningFlag = serverObject.getBoolean("provisionComponents", false);
                }
                provisioningFlagSet = true;
                if (debugTrace) {
                    Tr.debug(tc, "provisioningFlag - " + provisioningFlag);
                }
            }
            catch (Exception e) {
                if (debugTrace) {
                    Tr.debug(tc, "exception retrieving provisionComponents value");
                    Tr.debug(tc, "e.getMessage()");
                }
                provisioningFlag = false;
            }
        }
        return provisioningFlag;
    }

    private void processImmediateComponents(String extensionPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processImmediateComponents " + extensionPoint);
        }
        List componentList = this.extensionPointToComponentsMap.get(extensionPoint);
        for (ContainerImpl.ComponentStartup componentData : componentList) {
            try {
                if (componentData.componentId == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, " legacy component: " + componentData);
                    continue;
                }
                if (componentData.isRootComponent()) {
                    this.processComponent(componentData, true);
                }
                if (componentData.containerExtensionPoint == null) continue;
                this.processImmediateComponents(componentData.containerExtensionPoint);
            }
            catch (RuntimeError e) {
                Manager.Ffdc.log(e, this, null, "1678");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processImmediateComponents");
        }
    }

    private Set<ContainerImpl.ComponentStartup> processDefaultActivationPlan() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processDefaultActivationPlan");
        }
        this.activationPlanAllComponents = new HashSet<ContainerImpl.ComponentStartup>();
        Collection<List> componentLists = this.extensionPointToComponentsMap.values();
        for (List componentList : componentLists) {
            for (ContainerImpl.ComponentStartup componentData : componentList) {
                try {
                    this.processComponent(componentData, true);
                }
                catch (RuntimeError e) {
                    Manager.Ffdc.log(e, this, null, "1694");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.dumpComponents());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processDefaultActivationPlan");
        }
        return this.activationPlanAllComponents;
    }

    public Set<ContainerImpl.ComponentStartup> processActivationPlan(Set<ComponentInfo> activationPlanComponents, boolean tolerationMode) throws RuntimeError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processActivationPlan");
        }
        this.activationPlanAllComponents = new HashSet<ContainerImpl.ComponentStartup>();
        HashSet<ContainerImpl.ComponentStartup> plan = new HashSet<ContainerImpl.ComponentStartup>();
        for (ComponentInfo componentInfo : activationPlanComponents) {
            ContainerImpl.ComponentStartup componentData = this.idToComponentMap.get(componentInfo.getComponentId());
            if (componentData == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No componentData found for componentId " + componentInfo.getComponentId());
                }
                if (tolerationMode) continue;
                if (!this.otherPlatformComponents.contains(componentInfo.getComponentId())) {
                    throw new RuntimeError("Component " + componentInfo.getComponentId() + " not defined");
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Component not defined for this platform/region: " + componentInfo.getComponentId());
                continue;
            }
            String inputVersion = componentInfo.getVersion();
            if (inputVersion != null && !inputVersion.equals(componentData.version)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "input version, " + inputVersion + ", for component, " + componentInfo.getComponentId() + ", does not match actual version, " + componentData.version);
                }
                if (!tolerationMode) {
                    throw new RuntimeError("input version, " + inputVersion + ", for component, " + componentInfo.getComponentId() + ", does not match actual version, " + componentData.version);
                }
            }
            componentData.inActivationPlan = true;
            plan.add(componentData);
        }
        for (ContainerImpl.ComponentStartup comp : plan) {
            this.processComponent(comp, tolerationMode);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.dumpComponents());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processActivationPlan");
        }
        return this.activationPlanAllComponents;
    }

    public void processComponent(ContainerImpl.ComponentStartup componentData, boolean tolerationMode) throws RuntimeError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "processComponent ROOT: " + componentData);
        }
        if (componentData.componentId == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "legacy component, return.");
            }
            return;
        }
        if (componentData.state != 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ROOT component already processed: state=" + componentData.getState());
            }
            return;
        }
        boolean result = this.analyzeConfig(componentData, tolerationMode, 0);
        if (result) {
            this.validateDependencies(componentData, tolerationMode, 0);
            if (this.activationPlanAllComponents != null && componentData.state != 4) {
                this.activationPlanAllComponents.add(componentData);
            }
        }
    }

    private boolean analyzeConfig(ContainerImpl.ComponentStartup componentData, boolean tolerationMode, int depth) throws RuntimeError {
        block24: {
            boolean debugging = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            String indent = "Depth[" + depth + "] analyzeConfig(): ";
            if (componentData.state == 4) {
                Tr.debug(tc, "config analysis of component has already set state to DISABLED");
                return false;
            }
            try {
                ArrayList<DependentComponentInfoImpl> dependantComponents = Collections.EMPTY_LIST;
                Iterator it = componentData.dependencies.iterator();
                while (it.hasNext()) {
                    ContainerHelper.Dependency dependency = (ContainerHelper.Dependency)it.next();
                    dependency.component = this.getComponentByDependency(dependency);
                    if (dependency.component == null) {
                        if (!provisioningFlag) {
                            it.remove();
                            if (!debugging) continue;
                            Tr.debug(tc, "Ignoring missing dependency: " + dependency);
                            continue;
                        }
                        if (dependency.mandatory) {
                            Tr.error(tc, "WSVR0175E", new Object[]{dependency, componentData.componentId});
                            componentData.state = 4;
                            if (!tolerationMode) {
                                throw new RuntimeError("Component " + componentData.componentId + " not started: Missing mandatory component " + dependency);
                            }
                            return false;
                        }
                        if (debugging) {
                            Tr.debug(tc, "Ignore optional dependency, cannot map to component: " + dependency);
                        }
                        it.remove();
                        continue;
                    }
                    if (dependantComponents == Collections.EMPTY_LIST) {
                        dependantComponents = new ArrayList<DependentComponentInfoImpl>(3);
                    }
                    dependantComponents.add(new DependentComponentInfoImpl(componentData, dependency));
                }
                if (dependantComponents != Collections.EMPTY_LIST) {
                    dependantComponents = new RestrictedList((List<DependentComponentInfoImpl>)dependantComponents);
                }
                if (componentData.configAnalyzer == null) {
                    if (debugging) {
                        Tr.debug(tc, indent + "no config analyzer: " + componentData.componentId);
                    }
                } else if (!this.isProvisioningEnabled()) {
                    if (debugging) {
                        Tr.debug(tc, indent + "provisioning disabled, so not calling config analyzer");
                    }
                } else {
                    if (debugging) {
                        Tr.debug(tc, indent + "loading config analyzer: " + componentData.configAnalyzer);
                    }
                    Class analyzerClass = componentData.loadClass(componentData.configAnalyzer);
                    ConfigAnalyzer analyzer = (ConfigAnalyzer)analyzerClass.newInstance();
                    ComponentInfo componentInfo = ComponentInfoFactory.createComponentInfo(componentData.componentId, componentData.version);
                    int sizeDependentComponents = dependantComponents.size();
                    if (!analyzer.analyze(componentInfo, dependantComponents)) {
                        componentData.state = 4;
                        if (debugging) {
                            Tr.debug(tc, indent + "disabled by config analyzer: " + componentData.componentId);
                        }
                    } else {
                        if (debugging) {
                            Tr.debug(tc, indent + "enabled by config analyzer: " + componentData.componentId);
                        }
                        if (sizeDependentComponents != dependantComponents.size()) {
                            if (debugging) {
                                Tr.debug(tc, "dependency list changed, oldsize=" + sizeDependentComponents + "newsize=" + dependantComponents.size());
                            }
                            this.resetDependencies(componentData, dependantComponents);
                        }
                    }
                }
            }
            catch (Throwable th) {
                Manager.Ffdc.log(th, this, null, "373");
                componentData.state = 4;
                Tr.error(tc, "WSVR0176E", new Object[]{th});
                Tr.error(tc, "WSVR0177E", new Object[]{componentData.componentId});
                if (tolerationMode) break block24;
                throw new RuntimeError("Exception caught analyzing config: " + th.getMessage());
            }
        }
        return componentData.state != 4;
    }

    private void resetDependencies(ContainerImpl.ComponentStartup componentData, List<DependentComponentInfoImpl> dependantComponents) {
        if (dependantComponents == null || dependantComponents.size() == 0) {
            componentData.dependencies = Collections.EMPTY_LIST;
            return;
        }
        ArrayList<ContainerHelper.Dependency> newDependencies = new ArrayList<ContainerHelper.Dependency>();
        for (DependentComponentInfoImpl newDependentComponent : dependantComponents) {
            newDependencies.add(newDependentComponent.dependency);
        }
        for (ContainerHelper.Dependency dependency : componentData.dependencies) {
            if (newDependencies.contains(dependency)) continue;
            componentData.dependencies.remove(dependency);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Removing dependency: " + dependency);
        }
    }

    private int setGlobalSortOrder(String extPoint, int startNumber) throws ConfigurationError {
        int globalOrder = startNumber;
        List extPointComponents = this.getComponentsByExtensionPoint(extPoint);
        for (ContainerImpl.ComponentStartup componentData : extPointComponents) {
            componentData.globalOrder = globalOrder++;
            if (componentData.containerExtensionPoint == null) continue;
            globalOrder = this.setGlobalSortOrder(componentData.containerExtensionPoint, globalOrder);
        }
        return globalOrder;
    }

    public Map<String, List> getExtensionPointToComponentsMap() {
        return this.extensionPointToComponentsMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StartupComparator
    implements Comparator<ContainerImpl.ComponentStartup> {
        StartupComparator() {
        }

        @Override
        public int compare(ContainerImpl.ComponentStartup cs1, ContainerImpl.ComponentStartup cs2) {
            return cs1.order - cs2.order;
        }
    }

    static class StartupHandler
    extends DefaultHandler {
        static final String DISTRIBUTED = "distributed";
        static final String ZSERIES = "zos";
        static final String ISERIES = "os400";
        static final String ALL = "all";
        static final String COMPONENT = "component";
        static final String PLATFORM = "platform";
        static final String CLASS = "class";
        static final String TYPE = "type";
        static final String STARTUP = "startup";
        static final String OVERRIDE = "override";
        static final String CONFIG_DATA_REQUIRED = "configurationDataRequired";
        static final String ASYNC_INIT = "asynchronousInit";
        static final String ASYNC_START = "asynchronousStart";
        static final String INHIBIT_MULTI_THREAD = "inhibitMultiThreadedBehavior";
        static final String COMPONENT_ID = "component-id";
        static final String VERSION = "version";
        static final String STARTUP_MODE = "startup-mode";
        static final String CONFIG_ANALYZER = "configuration-analyzer-class";
        static final String INIT_METHOD = "init-method";
        static final String START_METHOD = "start-method";
        static final String STOP_METHOD = "stop-method";
        static final String DESTROY_METHOD = "destroy-method";
        static final String PROCESSTYPE = "processType";
        static final String ADJUNCT = "adjunct";
        static final String SERVANT = "servant";
        static final String CONTROL = "control";
        private Locator locator = null;
        URL documentURL = null;
        private List components = new ArrayList();
        private ContainerImpl.ComponentStartup currentComponent = null;
        private StringBuffer value = new StringBuffer();
        private boolean overriding = false;
        private boolean ignoring = false;
        private static String actualPlatformString = null;
        private static String processType = "control";

        StartupHandler() {
        }

        public List getComponents() {
            return this.components;
        }

        public void startDocument() throws SAXException {
            this.components.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.value.setLength(0);
            if (qName.equals(COMPONENT)) {
                this.currentComponent = new ContainerImpl.ComponentStartup();
                this.currentComponent.platforms = this.getStringAttribute(attributes, PLATFORM, null);
                this.currentComponent.processtypes = this.getStringAttribute(attributes, PROCESSTYPE, null);
                this.currentComponent.configurationDataRequired = this.getBooleanAttribute(attributes, CONFIG_DATA_REQUIRED, true);
                this.currentComponent.asyncInitialize = this.getBooleanAttribute(attributes, ASYNC_INIT, false);
                this.currentComponent.asyncStart = this.getBooleanAttribute(attributes, ASYNC_START, false);
                this.currentComponent.inhibitAsynchronousBehavior = this.getBooleanAttribute(attributes, INHIBIT_MULTI_THREAD, false);
                this.currentComponent.initMethod = this.getStringAttribute(attributes, INIT_METHOD, null);
                this.currentComponent.startMethod = this.getStringAttribute(attributes, START_METHOD, null);
                this.currentComponent.stopMethod = this.getStringAttribute(attributes, STOP_METHOD, null);
                this.currentComponent.destroyMethod = this.getStringAttribute(attributes, DESTROY_METHOD, null);
            } else if (qName.equals(OVERRIDE)) {
                String platforms = this.getStringAttribute(attributes, PLATFORM, null);
                String processtypes = this.getStringAttribute(attributes, PROCESSTYPE, null);
                if (platforms != null) {
                    if (this.validOn(platforms, processtypes)) {
                        this.overriding = true;
                        this.currentComponent.configurationDataRequired = this.getBooleanAttribute(attributes, CONFIG_DATA_REQUIRED, this.currentComponent.configurationDataRequired);
                        this.currentComponent.asyncInitialize = this.getBooleanAttribute(attributes, ASYNC_INIT, this.currentComponent.asyncInitialize);
                        this.currentComponent.asyncStart = this.getBooleanAttribute(attributes, ASYNC_START, this.currentComponent.asyncStart);
                        this.currentComponent.inhibitAsynchronousBehavior = this.getBooleanAttribute(attributes, INHIBIT_MULTI_THREAD, this.currentComponent.inhibitAsynchronousBehavior);
                    } else {
                        this.ignoring = true;
                    }
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.currentComponent == null) {
                return;
            }
            if (COMPONENT.equals(qName)) {
                this.endComponent();
            } else if (CLASS.equals(qName)) {
                this.endClass();
            } else if (TYPE.equals(qName)) {
                this.endType();
            } else if (STARTUP.equals(qName)) {
                this.endStartup();
            } else if (OVERRIDE.equals(qName)) {
                this.overriding = false;
                this.ignoring = false;
            } else {
                this.parsingError("Invalid tag: " + qName);
            }
            this.value.setLength(0);
        }

        private void parsingError(String msg) throws SAXException {
            throw new SAXException(msg + "[" + this.documentURL + ", line:" + this.locator.getLineNumber() + ", col:" + this.locator.getColumnNumber() + "]");
        }

        private void endComponent() throws SAXException {
            if (this.currentComponent.type == null && this.currentComponent.clazz == null) {
                Tr.error(tc, "WSVR0104E", new Object[]{this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
            } else if (this.currentComponent.type != null && this.currentComponent.clazz != null && this.currentComponent.configurationDataRequired) {
                Tr.error(tc, "WSVR0105E", new Object[]{this.currentComponent.type, this.currentComponent.clazz, this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
            } else if (this.validOn(this.currentComponent.platforms, this.currentComponent.processtypes)) {
                this.components.add(this.currentComponent);
            }
            this.currentComponent = null;
        }

        private void endClass() throws SAXException {
            if (!this.ignoring) {
                if (this.overriding || this.currentComponent.clazz == null) {
                    this.currentComponent.clazz = this.value.toString();
                } else {
                    this.parsingError("<class> already defined");
                }
            }
        }

        private void endType() throws SAXException {
            if (!this.ignoring) {
                if (this.currentComponent.type == null || this.overriding) {
                    this.currentComponent.type = this.value.toString();
                } else {
                    this.parsingError("<type> already defined");
                }
            }
        }

        private void endStartup() throws SAXException {
            if (this.ignoring) {
                return;
            }
            try {
                int startup;
                this.currentComponent.order = startup = Integer.parseInt(this.value.toString());
            }
            catch (NumberFormatException nfe) {
                Tr.error(tc, "WSVR0106E", new Object[]{this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
            }
        }

        private boolean validOn(String platforms, String zosprocesstypes) {
            boolean isValid;
            block6: {
                block7: {
                    isValid = false;
                    if (platforms == null) {
                        isValid = true;
                    } else {
                        StringTokenizer platformList = new StringTokenizer(platforms, ",");
                        while (platformList.hasMoreTokens()) {
                            String specifiedPlatform = platformList.nextToken().trim().toLowerCase();
                            if (specifiedPlatform.equals(ALL)) {
                                isValid = true;
                                break;
                            }
                            if (!specifiedPlatform.equals(actualPlatformString)) continue;
                            isValid = true;
                            break;
                        }
                    }
                    if (!isValid || !actualPlatformString.equals(ZSERIES)) break block6;
                    isValid = false;
                    if (zosprocesstypes != null) break block7;
                    if (processType.equals(ADJUNCT)) break block6;
                    isValid = true;
                    break block6;
                }
                StringTokenizer zOSprocesstypeList = new StringTokenizer(zosprocesstypes, ",");
                while (zOSprocesstypeList.hasMoreTokens()) {
                    String specifiedProcess = zOSprocesstypeList.nextToken().trim().toLowerCase();
                    if (specifiedProcess.equals(ALL)) {
                        isValid = true;
                        break;
                    }
                    if (!specifiedProcess.equals(processType)) continue;
                    isValid = true;
                    break;
                }
            }
            return isValid;
        }

        public void warning(SAXParseException arg0) throws SAXException {
            this.currentComponent = null;
        }

        public void error(SAXParseException arg0) throws SAXException {
            this.currentComponent = null;
        }

        public void fatalError(SAXParseException arg0) throws SAXException {
            this.components.clear();
            this.currentComponent = null;
            throw arg0;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.value.append(ch, start, length);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private String getStringAttribute(Attributes a, String key, String defaultValue) {
            String value = a.getValue(key);
            return value != null ? value : defaultValue;
        }

        private boolean getBooleanAttribute(Attributes a, String key, boolean defaultValue) {
            String value = a.getValue(key);
            return value != null ? Boolean.valueOf(value) : defaultValue;
        }

        static {
            actualPlatformString = DISTRIBUTED;
            if (ph.isZOS()) {
                actualPlatformString = ZSERIES;
                if (ph.isCRAJvm()) {
                    processType = ADJUNCT;
                } else if (ph.isServantJvm()) {
                    processType = SERVANT;
                }
            } else if (ph.isOS400()) {
                actualPlatformString = ISERIES;
            }
        }
    }

    private static class PlatformCheck {
        static final String DISTRIBUTED = "distributed";
        static final String ZSERIES = "zos";
        static final String ISERIES = "os400";
        static final String ALL = "all";
        static final String ADJUNCT = "adjunct";
        static final String CONTROL = "control";
        static final String SERVANT = "servant";
        static final String CLIENT = "client";
        private static String actualPlatformString = null;
        private static String processType = "control";
        private static boolean recoveryMode = false;

        private PlatformCheck() {
        }

        private boolean validOn(String platforms, String processtypes, String recoverytypes) {
            boolean isValid = false;
            if (platforms == null) {
                isValid = true;
            } else {
                StringTokenizer platformList = new StringTokenizer(platforms, ",");
                while (platformList.hasMoreTokens()) {
                    String specifiedPlatform = platformList.nextToken().trim().toLowerCase();
                    if (specifiedPlatform.equals(ALL)) {
                        isValid = true;
                        break;
                    }
                    if (!specifiedPlatform.equals(actualPlatformString)) continue;
                    isValid = true;
                    break;
                }
            }
            if (isValid && actualPlatformString.equals(ZSERIES)) {
                isValid = false;
                if (recoveryMode && (processtypes = recoverytypes) == null) {
                    processtypes = "";
                }
                if (processtypes == null) {
                    isValid = true;
                } else {
                    StringTokenizer processtypeList = new StringTokenizer(processtypes, ",");
                    while (processtypeList.hasMoreTokens()) {
                        String specifiedProcess = processtypeList.nextToken().trim().toLowerCase();
                        if (specifiedProcess.equals(ALL)) {
                            isValid = true;
                            break;
                        }
                        if (!specifiedProcess.equalsIgnoreCase(processType)) continue;
                        isValid = true;
                        break;
                    }
                }
            }
            return isValid;
        }

        public static boolean isRecoveryMode() {
            return recoveryMode;
        }

        static {
            actualPlatformString = DISTRIBUTED;
            PlatformHelper ph = PlatformHelperFactory.getPlatformHelper();
            if (ph.isZOS()) {
                actualPlatformString = ZSERIES;
                if (ph.isCRAJvm()) {
                    processType = ADJUNCT;
                } else if (ph.isServantJvm()) {
                    processType = SERVANT;
                } else if (ph.isClientJvm()) {
                    processType = CLIENT;
                }
                if (processType != CLIENT && !ph.runningWhereConfigured()) {
                    recoveryMode = true;
                }
            } else if (ph.isOS400()) {
                actualPlatformString = ISERIES;
            }
        }
    }

    private static class DependentComponentInfoImpl
    implements DependentComponentInfo {
        private ContainerHelper.Dependency dependency;
        private ContainerImpl.ComponentStartup metadata;

        public DependentComponentInfoImpl(ContainerImpl.ComponentStartup metadata, ContainerHelper.Dependency dependency) {
            this.metadata = metadata;
            this.dependency = dependency;
        }

        public String getComponentId() {
            return this.dependency.component.componentId;
        }

        public boolean isMandatory() {
            return this.dependency.mandatory;
        }

        public void setMandatory(boolean mandatory) {
            this.dependency.mandatory = mandatory;
        }

        public void removeDependency() {
            this.metadata.dependencies.remove(this.dependency);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RestrictedList
    extends ArrayList {
        private static final long serialVersionUID = -179671059616361226L;
        String msg = "Cannot add to dependency list";

        public RestrictedList(List<DependentComponentInfoImpl> list) {
            super(list);
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException(this.msg);
        }

        @Override
        public void add(int pos, Object o) {
            throw new UnsupportedOperationException(this.msg);
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException(this.msg);
        }

        @Override
        public boolean addAll(int pos, Collection c) {
            throw new UnsupportedOperationException(this.msg);
        }

        @Override
        public Object set(int index, Object o) {
            throw new UnsupportedOperationException(this.msg);
        }

        @Override
        public Object remove(int index) {
            DependentComponentInfoImpl dep = (DependentComponentInfoImpl)super.remove(index);
            dep.removeDependency();
            return dep;
        }

        @Override
        public boolean remove(Object object) {
            if (super.remove(object)) {
                ((DependentComponentInfoImpl)object).removeDependency();
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            if (super.removeAll(c)) {
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    ((DependentComponentInfoImpl)it.next()).removeDependency();
                }
                return true;
            }
            return false;
        }
    }
}

