/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.deploy;

import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedObjectCollaborator;
import java.util.jar.Attributes;

public class ApplicationCollaborator
extends DeployedObjectCollaborator {
    private String implVersion;

    public ApplicationCollaborator(DeployedApplication dapp) {
        super(dapp);
        this.implVersion = dapp.getModuleFile().getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    public String[] getModules() {
        StringBuffer sb = new StringBuffer("WebSphere:Application=");
        sb.append(this.getObjectName().getKeyProperty("name"));
        sb.append(",*,type=");
        int idx = sb.length();
        sb.append("WebModule");
        String[] webModules = this.getObjectNames(sb.toString());
        sb.setLength(idx);
        sb.append("EJBModule");
        String[] ejbModules = this.getObjectNames(sb.toString());
        sb.setLength(idx);
        sb.append("ResourceAdapterModule");
        String[] rarModules = this.getObjectNames(sb.toString());
        int len = webModules.length + ejbModules.length + rarModules.length;
        String[] result = new String[len];
        System.arraycopy(webModules, 0, result, 0, webModules.length);
        System.arraycopy(ejbModules, 0, result, webModules.length, ejbModules.length);
        System.arraycopy(rarModules, 0, result, webModules.length + ejbModules.length, rarModules.length);
        return result;
    }

    public String getType() {
        return "Application";
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }
}

