/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.collaborator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.RALifeCycleManager;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.runtime.component.collaborator.J2EEResourceMBean;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.resource.ResourceException;

public class JCAResourceMBean
extends J2EEResourceMBean {
    private static final TraceComponent tc = Tr.register(JCAResourceMBean.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    private String archivePath;
    private String name;
    private String description;
    private RALifeCycleManager raLifecycleManager;
    private String raKey;
    private boolean paused = false;

    public void activeMBean(ConfigObject rp, String serverName, String mBeanParentName, RALifeCycleManager raMgr, String raId) {
        try {
            this.name = rp.getString("name", "__null__");
            this.description = rp.getString("description", "__null__");
            this.raLifecycleManager = raMgr;
            this.raKey = raId;
            MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
            String configId = mbeanFactory.getConfigId(rp);
            Properties jcaResourceProperties = new Properties();
            if (mBeanParentName != null) {
                jcaResourceProperties.setProperty("ResourceAdapter", mBeanParentName);
            }
            jcaResourceProperties.setProperty("name", this.name);
            jcaResourceProperties.setProperty("Server", serverName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "activateMBean started for " + this.name + " Type " + this.getResourceType());
            }
            mbeanFactory.activateMBean(this.getResourceType(), this, configId, null, jcaResourceProperties);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "activateMBean completed for " + this.name);
            }
        }
        catch (AdminException x) {
            FFDCFilter.processException(x, this.getClass().getName(), "60");
        }
        if (rp != null) {
            this.archivePath = rp.getString("archivePath", "__null__");
            this.name = rp.getString("name", "__null__");
            ConfigObject connector = rp.getObject("deploymentDescriptor");
            if (connector != null) {
                String tempDescription = connector.getString("description", "__null__");
                if (tempDescription != null && !tempDescription.equals("")) {
                    this.description = tempDescription;
                }
            } else if (this.description == null) {
                this.description = "";
            }
        }
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    protected String getResourceType() {
        return "J2CResourceAdapter";
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getConnectionFactories() {
        ObjectName o = null;
        try {
            o = new ObjectName("WebSphere:type=J2CConnectionFactory,JCAResource=" + this.getObjectName().getKeyProperty("name") + ",Server=" + this.getObjectName().getKeyProperty("Server") + ",*");
        }
        catch (MalformedObjectNameException exc) {
            // empty catch block
        }
        Set objectNames = AdminServiceFactory.getAdminService().queryNames(o, null);
        String[] strNames = new String[objectNames.size()];
        int index = 0;
        Iterator i = objectNames.iterator();
        while (i.hasNext()) {
            strNames[index++] = ((ObjectName)i.next()).getCanonicalName();
        }
        return strNames;
    }

    public void start() throws Exception {
        this.raLifecycleManager.restartRA(this.raKey);
    }

    public void startRecursive() throws Exception {
        this.start();
    }

    public void stop() throws Exception {
        List appsWithRefsToRA = null;
        appsWithRefsToRA = J2CAppUtils.getAppRefs(this.raKey);
        String nodeName = AdminServiceFactory.getAdminService().getNodeName();
        String processName = AdminServiceFactory.getAdminService().getProcessName();
        Iterator appsIterator = appsWithRefsToRA.iterator();
        boolean appIsRunning = false;
        StringBuffer runningAppsSB = null;
        String nl = System.getProperty("line.separator");
        while (appsIterator.hasNext()) {
            String appName = (String)appsIterator.next();
            ObjectName on = new ObjectName("WebSphere:type=Application,name=" + appName + ",node=" + nodeName + ",process=" + processName + ",*");
            Iterator appsMBeanIterator = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
            if (!appsMBeanIterator.hasNext()) continue;
            appIsRunning = true;
            if (runningAppsSB == null) {
                runningAppsSB = new StringBuffer();
                runningAppsSB.append("ResourceAdapter <");
                runningAppsSB.append(this.raKey);
                runningAppsSB.append("> could not be stopped because applications which use it are still running.");
                runningAppsSB.append(nl);
                runningAppsSB.append("The applications are:");
            }
            runningAppsSB.append(nl);
            runningAppsSB.append("  ");
            runningAppsSB.append(appName);
        }
        if (appIsRunning) {
            ResourceException e = new ResourceException(runningAppsSB.toString());
            throw e;
        }
        this.raLifecycleManager.stopRA(this.raKey);
    }

    public void changeState(int state) {
        super.changeState(state);
    }

    public void pause() throws Exception {
        this.raLifecycleManager.pauseRA(this.raKey);
        this.paused = true;
    }

    public void resume() throws Exception {
        this.raLifecycleManager.resumeRA(this.raKey);
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getStatus() {
        return this.raLifecycleManager.getStatus(this.raKey);
    }
}

