/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.collaborator;

import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.j2ee.J2EEDeployedObjectProxy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;

public class J2EEApplication
extends J2EEDeployedObjectProxy
implements PropertyChangeListener {
    static final String WEB_MODULE = "WebModule";
    static final String EJB_MODULE = "EJBModule";
    static final String RESOURCE_ADAPTER_MODULE = "ResourceAdapterModule";
    static final String J2EE_SERVER = "J2EEServer";
    static final String J2EE_APPLICATION = "J2EEApplication";
    static final String J2EE_TYPE = "j2eeType";
    static final String NAME = "name";
    private ObjectName appMgr;
    private ObjectName appQueryName;
    private String ddUri = null;

    public J2EEApplication(String earPath, String ddUri) {
        this(earPath, ddUri, 3);
    }

    public J2EEApplication(String earPath, String ddUri, int initialState) {
        super(earPath, earPath + File.separator + ddUri, initialState);
        this.ddUri = ddUri;
    }

    public String[] getModules() {
        if (this.getJ2EEState() == 1) {
            return this.getModulesWhenRunning();
        }
        return this.getModulesWhenStopped();
    }

    private String[] getModulesWhenRunning() {
        StringBuffer sb = new StringBuffer("WebSphere:J2EEApplication=");
        sb.append(this.getObjectName().getKeyProperty(NAME));
        sb.append(",*,type=");
        int idx = sb.length();
        sb.append(WEB_MODULE);
        String[] webModules = this.getObjectNames(sb.toString());
        sb.setLength(idx);
        sb.append(EJB_MODULE);
        String[] ejbModules = this.getObjectNames(sb.toString());
        sb.setLength(idx);
        sb.append(RESOURCE_ADAPTER_MODULE);
        String[] rarModules = this.getObjectNames(sb.toString());
        int len = webModules.length + ejbModules.length + rarModules.length;
        String[] result = new String[len];
        System.arraycopy(webModules, 0, result, 0, webModules.length);
        System.arraycopy(ejbModules, 0, result, webModules.length, ejbModules.length);
        System.arraycopy(rarModules, 0, result, webModules.length + ejbModules.length, rarModules.length);
        return result;
    }

    private String[] getModulesWhenStopped() {
        String[] result = null;
        try {
            CommonarchiveFactory archiveFactory = (CommonarchiveFactory)CommonarchivePackage.eINSTANCE.getEFactoryInstance();
            ArchiveOptions options = new ArchiveOptions();
            options.setIsReadOnly(true);
            options.setUseJavaReflection(false);
            EARFile earFile = archiveFactory.openEARFile(options, this.earPath);
            Properties props = new Properties();
            props.setProperty(J2EE_SERVER, this.getObjectName().getKeyProperty(J2EE_SERVER));
            props.setProperty(J2EE_APPLICATION, this.getObjectName().getKeyProperty(NAME));
            MBeanFactory mbeanFactory = AdminServiceFactory.getAdminService().getMBeanFactory();
            int N = earFile.getWARFiles().size() + earFile.getEJBJarFiles().size() + earFile.getRARFiles().size();
            int n = 0;
            result = new String[N];
            props.setProperty(J2EE_TYPE, WEB_MODULE);
            for (WARFile war : earFile.getWARFiles()) {
                props.setProperty(NAME, war.getName());
                result[n++] = mbeanFactory.createObjectName(WEB_MODULE, mbeanFactory.getConfigId(war), null, props).toString();
            }
            props.setProperty(J2EE_TYPE, EJB_MODULE);
            for (EJBJarFile jar : earFile.getEJBJarFiles()) {
                props.setProperty(NAME, jar.getName());
                result[n++] = mbeanFactory.createObjectName(EJB_MODULE, mbeanFactory.getConfigId(jar), null, props).toString();
            }
            props.setProperty(J2EE_TYPE, RESOURCE_ADAPTER_MODULE);
            for (RARFile rar : earFile.getRARFiles()) {
                result[n++] = mbeanFactory.createObjectName(RESOURCE_ADAPTER_MODULE, mbeanFactory.getConfigId(rar), null, props).toString();
            }
        }
        catch (AdminException e) {
            FFDCFilter.processException((Throwable)e, J2EEApplication.class.getName() + ".getModulesWhenStopped", "227", this);
        }
        catch (OpenFailureException e) {
            FFDCFilter.processException((Throwable)((Object)e), J2EEApplication.class.getName() + ".getModulesWhenStopped", "238", this);
        }
        return result;
    }

    public void start() throws InstanceNotFoundException, MBeanException, ReflectionException, AdminException {
        if (this.getJ2EEState() != 3 && this.getJ2EEState() != 4) {
            throw new AdminException("Cannot call start() when in state " + STATE_NAMES[this.getJ2EEState()]);
        }
        try {
            AdminServiceFactory.getAdminService().invoke(this.getApplicationManager(), "startApplication", new Object[]{this.getJ2EEName()}, new String[]{"java.lang.String"});
        }
        catch (MBeanException exc) {
            if (this.getJ2EEState() == 3) {
                this.changeState(0);
            }
            this.changeState(4);
            throw exc;
        }
    }

    public void startRecursive() throws InstanceNotFoundException, MBeanException, ReflectionException, AdminException {
        this.start();
    }

    public void stop() throws InstanceNotFoundException, MBeanException, ReflectionException, AdminException {
        if (this.getJ2EEState() != 1 && this.getJ2EEState() != 0 && this.getJ2EEState() != 4) {
            throw new AdminException("Cannot call stop() when in state " + STATE_NAMES[this.getJ2EEState()]);
        }
        try {
            AdminServiceFactory.getAdminService().invoke(this.getApplicationManager(), "stopApplication", new Object[]{this.getJ2EEName()}, new String[]{"java.lang.String"});
        }
        catch (MBeanException exc) {
            this.changeState(4);
            throw exc;
        }
    }

    private ObjectName getApplicationManager() {
        if (this.appMgr == null) {
            try {
                ObjectName appMgrQuery = new ObjectName("WebSphere:*,type=ApplicationManager," + this.getLocationKeyProperties());
                this.appMgr = this.getFirstObjectName(appMgrQuery);
            }
            catch (MalformedObjectNameException exc) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.management.j2ee.J2EEApplicationProxy.getApplicationManager", "135", this);
            }
        }
        return this.appMgr;
    }

    protected ObjectName getWebSphereMBeanQueryName() {
        if (this.appQueryName == null) {
            try {
                StringBuffer buf = new StringBuffer();
                buf.append("WebSphere:*,type=Application,name=");
                buf.append(this.getJ2EEName());
                buf.append(",");
                buf.append(this.getLocationKeyProperties());
                this.appQueryName = new ObjectName(buf.toString());
            }
            catch (MalformedObjectNameException exc) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.management.j2ee.J2EEApplication.getWebSphereMBeanQueryName", "156", this);
            }
        }
        return this.appQueryName;
    }

    public void handleNotification(Notification n, Object handback) {
        String type = n.getType();
        if (type.equals("j2ee.state.starting")) {
            this.changeState(0);
        } else if (type.equals("j2ee.state.running")) {
            this.changeState(1);
        } else if (type.equals("j2ee.state.stopping")) {
            this.changeState(2);
        } else if (type.equals("j2ee.state.stopped")) {
            this.changeState(3);
        } else if (type.equals("j2ee.state.failed")) {
            this.changeState(4);
        }
    }

    protected Set lookupMBeans(String name, QueryExp queryExp) {
        try {
            ObjectName objName = new ObjectName(name);
            return AdminServiceFactory.getMBeanFactory().getMBeanServer().queryNames(objName, queryExp);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
    }

    protected String[] getObjectNames(String query) {
        return this.getObjectNames(query, null);
    }

    protected String[] getObjectNames(String query, QueryExp queryExp) {
        Set s = this.lookupMBeans(query, queryExp);
        String[] objNames = new String[s.size()];
        int idx = 0;
        Iterator i = s.iterator();
        while (i.hasNext()) {
            objNames[idx++] = i.next().toString();
        }
        return objNames;
    }

    protected String getObjectName(String query) {
        Set s = this.lookupMBeans(query, null);
        if (s.size() == 0) {
            return null;
        }
        return s.iterator().next().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImplementationVersion() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException {
        if (this.getJ2EEState() == 1) {
            return (String)AdminServiceFactory.getAdminService().getAttribute(this.getWebSphereMBeanObjectName(), "implementationVersion");
        }
        String implementationVersion = null;
        EARFile earFile = null;
        try {
            CommonarchiveFactory archiveFactory = (CommonarchiveFactory)CommonarchivePackage.eINSTANCE.getEFactoryInstance();
            ArchiveOptions options = new ArchiveOptions();
            options.setIsReadOnly(true);
            options.setUseJavaReflection(false);
            earFile = archiveFactory.openEARFile(options, this.earPath);
            implementationVersion = earFile.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (OpenFailureException e) {
            FFDCFilter.processException((Throwable)((Object)e), J2EEApplication.class.getName() + ".getModulesWhenStopped", "413", this);
        }
        finally {
            if (earFile != null) {
                earFile.close();
            }
        }
        return implementationVersion;
    }

    public void propertyChange(PropertyChangeEvent event) {
        int ntfyType;
        String currentState = (String)event.getNewValue();
        if (currentState.equals("STARTING")) {
            ntfyType = 0;
        } else if (currentState.equals("STARTED")) {
            ntfyType = 1;
        } else if (currentState.equals("STOPPING")) {
            ntfyType = 2;
        } else if (currentState.equals("STOPPED")) {
            ntfyType = 3;
        } else if (currentState.equals("ERROR")) {
            ntfyType = 4;
        } else {
            return;
        }
        this.changeState(ntfyType);
    }
}

