/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.jms.JMSResourceRefBuilder;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.JMSBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.naming.Referenceable;

public class MQQueueBinder
extends JMSBinder {
    private static TraceComponent tc = Tr.register(MQQueueBinder.class, "ResourceBinders", "com.ibm.ejs.jms.messaging");

    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.mqseries.xmi", "MQQueue");
    }

    public Object getBindingObject(ConfigObject resource) throws ResourceBindingException {
        int intValueTargetClient;
        Boolean nativeEnc;
        int intValueExpiry;
        int intValuePriority;
        int intValuePersistence;
        Properties jmsProps = new Properties();
        ConfigObject jmsProvider = resource.getParent();
        String mqqueueName = resource.getString("name", "__null__");
        this.addPropertySet(jmsProps, resource.getObject("propertySet"), true);
        this.addPropertySet(jmsProps, jmsProvider.getObject("propertySet"), true);
        this.setProperty(jmsProps, "NAME", mqqueueName, true);
        this.setProperty(jmsProps, "DESC", resource.getString("description", "__null__"), true);
        String stringValue = resource.getString("persistence", "APPLICATION_DEFINED");
        if (stringValue.equals("APPLICATION_DEFINED")) {
            intValuePersistence = -2;
        } else if (stringValue.equals("NONPERSISTENT")) {
            intValuePersistence = 1;
        } else if (stringValue.equals("PERSISTENT")) {
            intValuePersistence = 2;
        } else if (stringValue.equals("QUEUE_DEFINED")) {
            intValuePersistence = -1;
        } else if (stringValue.equals("HIGH")) {
            intValuePersistence = 3;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.checkRequiredProperty(mqqueueName, "persistence", resource.isSet("persistence") ? Integer.valueOf(intValuePersistence) : null);
        this.setProperty(jmsProps, "PER", intValuePersistence, true);
        stringValue = resource.getString("priority", "APPLICATION_DEFINED");
        if (stringValue.equals("APPLICATION_DEFINED")) {
            intValuePriority = -2;
        } else if (stringValue.equals("SPECIFIED")) {
            intValuePriority = -3;
        } else if (stringValue.equals("QUEUE_DEFINED")) {
            intValuePriority = -1;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.checkRequiredProperty(mqqueueName, "priority", resource.isSet("priority") ? Integer.valueOf(intValuePriority) : null);
        if (intValuePriority == -2 || intValuePriority == -1) {
            this.setProperty(jmsProps, "PRI", intValuePriority, true);
        } else {
            this.checkRequiredProperty(mqqueueName, "specifiedPriority", resource.isSet("specifiedPriority") ? new Integer(resource.getInt("specifiedPriority", 0)) : null);
            this.setProperty(jmsProps, "PRI", resource.getInt("specifiedPriority", 0), true);
        }
        stringValue = resource.getString("priority", "APPLICATION_DEFINED");
        if (stringValue.equals("APPLICATION_DEFINED")) {
            intValueExpiry = -2;
        } else if (stringValue.equals("SPECIFIED")) {
            intValueExpiry = -3;
        } else if (stringValue.equals("UNLIMITED")) {
            intValueExpiry = 0;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.checkRequiredProperty(mqqueueName, "expiry", resource.isSet("expiry") ? Integer.valueOf(intValueExpiry) : null);
        if (intValueExpiry == -2 || intValueExpiry == 0) {
            this.setProperty(jmsProps, "EXP", intValueExpiry, true);
        } else {
            this.checkRequiredProperty(mqqueueName, "specifiedExpiry", resource.isSet("specifiedExpiry") ? new Long(resource.getLong("specifiedExpiry", 0L)) : null);
            this.setProperty(jmsProps, "EXP", new Long(resource.getLong("specifiedExpiry", 0L)), true);
        }
        Boolean bl = nativeEnc = resource.isSet("useNativeEncoding") ? new Boolean(resource.getBoolean("useNativeEncoding", false)) : null;
        if (nativeEnc != null && nativeEnc.booleanValue()) {
            this.setProperty(jmsProps, "ENC", "NATIVE", true);
        } else {
            String encString = new String("");
            encString = !resource.isSet("integerEncoding") || resource.getString("integerEncoding", "Normal").equals("Normal") ? encString + "N" : encString + "R";
            encString = !resource.isSet("decimalEncoding") || resource.getString("decimalEncoding", "Normal").equals("Normal") ? encString + "N" : encString + "R";
            encString = !resource.isSet("floatingPointEncoding") || resource.getString("floatingPointEncoding", "IEEENormal").equals("IEEENormal") ? encString + "N" : (resource.getString("floatingPointEncoding", "IEEENormal").equals("IEEEReversed") ? encString + "R" : encString + "3");
            this.setProperty(jmsProps, "ENC", encString, true);
        }
        this.setProperty(jmsProps, "CCS", resource.isSet("CCSID") ? new Integer(resource.getInt("CCSID", 0)) : null, true);
        stringValue = resource.getString("targetClient", "JMS");
        if (stringValue.equals("JMS")) {
            intValueTargetClient = 0;
        } else if (stringValue.equals("MQ")) {
            intValueTargetClient = 1;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "TC", resource.isSet("targetClient") ? Integer.valueOf(intValueTargetClient) : null, true);
        this.setProperty(jmsProps, "QU", resource.getString("baseQueueName", "__null__"), true);
        this.setProperty(jmsProps, "QMGR", resource.getString("baseQueueManagerName", "__null__"), true);
        stringValue = resource.getString("sendAsync", "YES");
        if (stringValue.equals("QUEUE_DEFINED")) {
            stringValue = "AS_Q_DEF";
        } else if (!stringValue.equals("YES") && !stringValue.equals("NO")) {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "PAALD", stringValue, false);
        stringValue = resource.getString("readAhead", "YES");
        if (stringValue.equals("QUEUE_DEFINED")) {
            stringValue = "AS_Q_DEF";
        } else if (!stringValue.equals("YES") && !stringValue.equals("NO")) {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "RAALD", stringValue, false);
        stringValue = resource.getString("readAheadClose", "DELIVERALL");
        if (stringValue.equals("DELIVERALL")) {
            stringValue = "DELIVER_ALL";
        } else if (stringValue.equals("DELIVERCURRENT")) {
            stringValue = "DELIVER_CURRENT";
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "RACP", stringValue, false);
        this.addCustomPropertySet(jmsProps, resource.getObject("propertySet"));
        JMSResourceRefBuilder refBuilder = JMSResourceRefBuilderFactory.createJMSResourceRefBuilder();
        Referenceable ref = null;
        try {
            ref = refBuilder.createMQQueueReferenceable(jmsProps);
        }
        catch (ResourceBindingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.MQQueueBinder.getBindingObject", "127", this);
            throw e;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.runtime.component.binder.MQQueueBinder.getBindingObject", "132", this);
            throw new ResourceBindingException(t.toString());
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addCustomPropertySet(Properties jmsProps, ConfigObject customProps) throws ResourceBindingException {
        HashSet<String> unknownCustomPropertiesSet;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addCustomPropertySet", new Object[]{jmsProps, customProps});
            }
            unknownCustomPropertiesSet = new HashSet<String>();
            if (jmsProps != null && customProps != null) break block11;
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
            return;
        }
        try {
            List propertyList = customProps.getObjectList("resourceProperties");
            for (int i = 0; i < propertyList.size(); ++i) {
                ConfigObject property = (ConfigObject)propertyList.get(i);
                if (property == null) continue;
                String name = property.getString("name", "__null__");
                String value = property.getString("value", "__null__");
                try {
                    value = this.expandVariable(value);
                }
                catch (IllegalArgumentException e) {
                    throw new ResourceBindingException("Illegal value '" + value + "' for Custom Property '" + name + "'");
                }
                if (name == null) {
                    throw new ResourceBindingException("Illegal Custom Property name " + name);
                }
                if (value == null) {
                    throw new ResourceBindingException("Illegal Custom Property value " + value);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding unknown custom property <" + name + "=" + value + ">");
                }
                if (unknownCustomPropertiesSet.contains(name.toUpperCase())) {
                    throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                }
                this.setProperty(jmsProps, name, value, true);
                unknownCustomPropertiesSet.add(name.toUpperCase());
            }
            if (!tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
            throw throwable;
        }
        Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
    }
}

