/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.mbean.RasLoggingServiceMBean;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import org.apache.commons.logging.LogFactory;

public class RASImpl
extends WsComponentImpl
implements DeployedObjectListener {
    private static final int oneMeg = 0x100000;
    protected ConfigObject rasConfig;

    public void boot(ConfigObject config2) throws ConfigurationError {
        boolean serviceLogEnabled = false;
        String serviceLogName = null;
        int serviceLogSize = 0x100000;
        String messageFilterLevel = "NONE";
        boolean enableCorrelationId = false;
        if (config2 != null) {
            try {
                if (config2.getBoolean("enable", false)) {
                    enableCorrelationId = config2.getBoolean("enableCorrelationId", true);
                    String value = config2.getString("messageFilterLevel", "NONE");
                    messageFilterLevel = value.equals("WARNING") ? "WARNING" : (value.equals("SERVICE") ? "SERVICE" : (value.equals("AUDIT") ? "AUDIT" : "NONE"));
                    ConfigObject serviceLog = config2.getObject("serviceLog");
                    if (serviceLog != null) {
                        int size = serviceLog.getInt("size", 0);
                        if (size > 0) {
                            serviceLogSize = size * 0x100000;
                        }
                        serviceLogEnabled = serviceLog.getBoolean("enabled", false);
                        serviceLogName = this.expandVariable(serviceLog.getString("name", "__null__"));
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            ManagerAdmin.configureMessageLogging(serviceLogEnabled, serviceLogName, serviceLogSize, messageFilterLevel, enableCorrelationId);
        }
        catch (Throwable t) {
            throw new ConfigurationError(t);
        }
    }

    public void initialize(Object config2) throws ConfigurationError {
        this.rasConfig = (ConfigObject)config2;
    }

    public void destroy() {
    }

    public void start() {
        RasLoggingServiceMBean logging = new RasLoggingServiceMBean();
        this.registerMBean("RasLoggingService", logging, "RasLoggingService", this.getConfigId(this.rasConfig), null);
        this.rasConfig = null;
        ApplicationMgr appMgr = (ApplicationMgr)this.localGetService(ApplicationMgr.class);
        if (appMgr != null) {
            appMgr.addDeployedObjectListener(this);
        }
    }

    public void stop() {
    }

    private Object localGetService(Class interfaceClass) {
        Object service;
        try {
            service = WsServiceRegistry.getService(this, interfaceClass);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return service;
    }

    public void stateChanged(DeployedObjectEvent ev) {
        if (ev.getNewValue() == "DESTROYED") {
            LogFactory.release(ev.getDeployedObject().getClassLoader());
        }
    }
}

