/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.PropertyVetoException;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.component.Component;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ComponentImpl
extends WsComponentImpl
implements Component,
BeanContextChild,
BeanContextServiceProvider,
BeanContextServiceRevokedListener {
    private BeanContext beanContext;
    private VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);

    protected ComponentImpl() {
    }

    protected BeanContextServices getBeanContextServices() {
        return (BeanContextServices)this.getBeanContext();
    }

    protected void setState(String newState) throws RuntimeError, RuntimeWarning, ConfigurationError, ConfigurationWarning {
        try {
            this.vetoableChangeSupport.fireVetoableChange("state", this.state, newState);
        }
        catch (PropertyVetoException pve) {
            Throwable cause = pve.getCause();
            if (cause instanceof RuntimeWarning) {
                throw (RuntimeWarning)cause;
            }
            if (cause instanceof RuntimeError) {
                throw (RuntimeError)cause;
            }
            if (cause instanceof ConfigurationError) {
                throw (ConfigurationError)cause;
            }
            if (cause instanceof ConfigurationWarning) {
                throw (ConfigurationWarning)cause;
            }
            throw new RuntimeError(pve);
        }
        catch (java.beans.PropertyVetoException pve) {
            throw new RuntimeError(pve);
        }
        super.setState(newState);
    }

    protected void setInitializationState(String newState) throws ConfigurationError, ConfigurationWarning {
        try {
            this.setState(newState);
        }
        catch (ConfigurationWarning cw) {
            throw cw;
        }
        catch (ConfigurationError ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationError(e);
        }
    }

    protected void setStartState(String newState) throws RuntimeError, RuntimeWarning {
        try {
            this.setState(newState);
        }
        catch (RuntimeError re) {
            throw re;
        }
        catch (RuntimeWarning rw) {
            throw rw;
        }
        catch (Exception e) {
            throw new RuntimeError(e);
        }
    }

    public void setBeanContext(BeanContext context) throws java.beans.PropertyVetoException {
        if (this.beanContext == context) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange("beanContext", this.beanContext, context);
        BeanContext oldValue = this.beanContext;
        this.beanContext = context;
        this.getPropertyChangeSupport().firePropertyChange("beanContext", oldValue, context);
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.vetoableChangeSupport.addVetoableChangeListener(name, vcl);
    }

    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.vetoableChangeSupport.removeVetoableChangeListener(name, vcl);
    }

    public void initialize(Object config2) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
    }

    public void destroy() {
    }

    public void start() throws RuntimeWarning, RuntimeError {
    }

    public void stop() {
    }

    protected Object getService(Class serviceClass) {
        try {
            final Class serviceClassF = serviceClass;
            final ComponentImpl instance = this;
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return WsServiceRegistry.getService(instance, serviceClassF);
                }
            });
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, ComponentImpl.class.getName(), "556");
            return null;
        }
    }

    protected void releaseService(Object service) {
    }

    protected boolean addService(Class serviceClass) {
        try {
            WsServiceRegistry.addService(this, serviceClass);
            return true;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, ComponentImpl.class.getName(), "594");
            return false;
        }
    }

    public boolean addService(Class serviceClass, BeanContextServiceProvider serviceProvider) {
        try {
            WsServiceRegistry.addService(serviceProvider, serviceClass);
            return true;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, ComponentImpl.class.getName(), "617");
            return false;
        }
    }

    private void whine(String label) {
        System.err.println("=======================================================");
        new Exception(label).printStackTrace(System.err);
    }

    public Object getService(BeanContextServices bcs, Object requestor, Class serviceClass, Object serviceSelector) {
        this.whine("getService(BCS,Object,Class,Object) called");
        return this;
    }

    public void releaseService(BeanContextServices bcs, Object requestor, Object service) {
    }

    public Iterator getCurrentServiceSelectors(BeanContextServices bcs, Class serviceClass) {
        this.whine("getCurrentServiceSelectors() called");
        return null;
    }

    public void serviceRevoked(BeanContextServiceRevokedEvent bcsre) {
    }

    protected String getConfigId(EObject object) {
        try {
            MBeanFactory factory = AdminServiceFactory.getMBeanFactory();
            if (factory != null) {
                return factory.getConfigId(object);
            }
        }
        catch (AdminException e) {
            Manager.Ffdc.log(e, this, ComponentImpl.class.getName(), "353");
        }
        return null;
    }

    protected void registerMBean(String type, RuntimeCollaborator collab, String name, EObject object, Properties properties) {
        String id = this.getConfigId(object);
        this.registerMBean(type, collab, name, id, properties);
    }

    protected void deregisterMBean(EObject obj) {
        this.deregisterMBean(this.getConfigId(obj));
    }

    protected String expandVariable(String string) throws IllegalArgumentException {
        return super.expandVariable(string);
    }

    public static Properties getProperties(Service service) {
        Properties result = new Properties();
        EList props = service.getProperties();
        if (props != null) {
            for (int i = 0; i < props.size(); ++i) {
                Property property = (Property)props.get(i);
                result.put(property.getName(), property.getValue());
            }
        }
        return result;
    }

    public static Properties getProperties(ConfigObject service) {
        Properties result = new Properties();
        List props = service.getObjectList("properties");
        for (int i = 0; i < props.size(); ++i) {
            ConfigObject property = (ConfigObject)props.get(i);
            String name = property.getString("name", "__null__");
            String value = property.getString("value", "__null__");
            result.put(name, value);
        }
        return result;
    }

    public String toString() {
        return this.getName() + " [" + this.getClass() + "]";
    }
}

