/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime;

public class InstalledOptionalPackageMetaData {
    private String name;
    private String specVersion;
    private String implVersion;
    private int id;
    private String sharedLibraryName = null;
    private boolean dependencyToIOPSpecified = false;
    private boolean specifiedDependencyIsResolved = false;
    private int dependencyType = 0;

    public static InstalledOptionalPackageMetaData getInstanceWithSpecifiedDependency(String optionalPackageName, String optionalPackageVersion) {
        return new InstalledOptionalPackageMetaData(optionalPackageName, optionalPackageVersion);
    }

    public static InstalledOptionalPackageMetaData getInstanceWithNoSpecifiedDependency(int referencingDependencyType) {
        return new InstalledOptionalPackageMetaData(referencingDependencyType);
    }

    public InstalledOptionalPackageMetaData(int referencingDependencyType) {
        this.dependencyType = referencingDependencyType;
    }

    public int getTypeOfUnresolvedDependency() {
        return this.dependencyType;
    }

    public InstalledOptionalPackageMetaData(String optionalPackageName, String optionalPackageVersion) {
        this.name = optionalPackageName;
        this.specVersion = optionalPackageVersion;
        this.implVersion = null;
        this.calculateHashId();
        this.dependencyToIOPSpecified = true;
    }

    public InstalledOptionalPackageMetaData(int _dependencyType, String optionalPackageName, String optionalPackageSpecVersion, String optionalPackageImplVersion) {
        this.name = optionalPackageName;
        this.specVersion = optionalPackageSpecVersion;
        this.implVersion = optionalPackageImplVersion;
        this.calculateHashId();
        this.dependencyToIOPSpecified = true;
        this.dependencyType = _dependencyType;
    }

    private void calculateHashId() {
        this.id = this.name != null ? (this.specVersion != null ? this.name.hashCode() + this.specVersion.hashCode() : this.name.hashCode()) : (this.specVersion != null ? this.specVersion.hashCode() : 0);
    }

    public String getLibraryName() {
        return this.sharedLibraryName;
    }

    public boolean dependenciesAreSpecified() {
        return this.dependencyToIOPSpecified;
    }

    public boolean specifiedDependenciesAreResolved() {
        return this.specifiedDependencyIsResolved;
    }

    public void setLibraryName(String _libraryName) {
        if (_libraryName != null) {
            this.specifiedDependencyIsResolved = true;
            this.sharedLibraryName = _libraryName;
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        InstalledOptionalPackageMetaData tempKey = (InstalledOptionalPackageMetaData)obj;
        if (tempKey != null) {
            if (tempKey.name != null) {
                if (tempKey.specVersion != null) {
                    return tempKey.name.equals(this.name) && tempKey.specVersion.equals(this.specVersion);
                }
                return this.specVersion == null && tempKey.name.equals(this.name);
            }
            if (tempKey.specVersion != null) {
                return this.name == null && tempKey.specVersion.equals(this.specVersion);
            }
            return this.specVersion == null && this.name == null;
        }
        return false;
    }

    public String toString() {
        return "name = " + this.name + ", specVersion = " + this.specVersion + ", implVersion = " + this.implVersion + ", libraryName = " + this.sharedLibraryName + ", hashId = " + this.id;
    }
}

