/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;

public class FileLocatorImpl
implements FileLocator {
    private static TraceComponent tc = Tr.register(FileLocatorImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private Repository repository = null;
    private ConfigService configService = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    protected String SOURCE_FILE = this.getClass().getName();

    public FileLocatorImpl() {
        try {
            this.repository = WsServiceRegistry.getService(this, Repository.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, this.SOURCE_FILE + ".FileLocatorImpl", FFDC_ID_1);
            Tr.error(tc, "CWPST0092E");
        }
        try {
            this.configService = WsServiceRegistry.getService(this, ConfigService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, this.SOURCE_FILE + ".FileLocatorImpl", FFDC_ID_3);
            Tr.error(tc, "CWPST0119E");
        }
    }

    public String getAttachmentPath(String appName, String type) {
        String attachmentPath = null;
        StringBuffer buf = new StringBuffer(this.repository.getRootURI());
        buf.append("/cells/");
        buf.append(this.repository.getCellName());
        buf.append("/applications/");
        buf.append(this.getAppPathFragment(buf.toString(), appName));
        attachmentPath = this.getApplicationAttachment(buf.toString(), appName, type);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attachment location is " + attachmentPath);
        }
        return attachmentPath;
    }

    private String getAppPathFragment(String basePath, String appName) {
        StringBuffer fragment = new StringBuffer();
        fragment.append(appName);
        fragment.append(".ear/deployments");
        final File file = new File(basePath + File.separator + fragment.toString());
        StringBuffer buf = (StringBuffer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File[] files;
                StringBuffer strBuf = new StringBuffer();
                if (file.exists() && (files = file.listFiles()).length >= 1) {
                    strBuf.append("/");
                    strBuf.append(files[0].getName());
                }
                return strBuf;
            }
        });
        fragment.append(buf);
        return fragment.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getApplicationAttachment(String basePath, String appName, String type) {
        String attachmentPath;
        block27: {
            EList archives;
            String resourcePath;
            String binariesURL;
            block28: {
                String deploymentURI;
                attachmentPath = null;
                String fileLoaded = deploymentURI = basePath + "/deployment.xml";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "application deployment.xml location is " + deploymentURI);
                }
                ConfigObject deployment = null;
                ConfigObject appDeploy = null;
                try {
                    List docs = null;
                    try {
                        docs = (List)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException, ConfigurationError {
                                return FileLocatorImpl.this.configService.getDocumentObjects(null, deploymentURI);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception thrown in getApplicationAttachment resource.load()");
                            Tr.debug(tc, "Need to check to see if this is a pre-6.1 system app");
                        }
                        String installRoot = System.getProperty("was.install.root");
                        StringBuffer buf = new StringBuffer();
                        buf.append(installRoot);
                        buf.append(File.separator).append("systemApps").append(File.separator);
                        buf.append(appName);
                        buf.append(".ear");
                        String systemAppDir = buf.toString();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "   systemAppDir is " + systemAppDir);
                        }
                        final File file = new File(systemAppDir);
                        Boolean exists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                if (file.exists()) {
                                    return Boolean.TRUE;
                                }
                                return Boolean.FALSE;
                            }
                        });
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "   exists is " + exists);
                        }
                        if (exists.booleanValue()) {
                            return attachmentPath;
                        }
                        throw e.getException();
                    }
                    deployment = (ConfigObject)docs.get(0);
                    if (deployment == null) break block27;
                    appDeploy = deployment.getObject("deployedObject");
                    if (appDeploy.getBoolean("useMetadataFromBinaries", false)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "in deployment.xml, useMetadataFromBinaries = true");
                        }
                        binariesURL = appDeploy.getString("binariesURL", "__null__");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "application location is " + binariesURL);
                        }
                        if (binariesURL != null) {
                            attachmentPath = binariesURL;
                            String looseConfigURI = null;
                            List list = appDeploy.getObjectList("properties");
                            for (ConfigObject prop : list) {
                                if (!"was.loose.config".equals(prop.getString("name", "__null__"))) continue;
                                looseConfigURI = prop.getString("value", "__null__");
                                if (!tc.isDebugEnabled()) break;
                                Tr.debug(tc, "loose config property is " + looseConfigURI);
                                break;
                            }
                            if (looseConfigURI != null) {
                                if (looseConfigURI.toLowerCase().startsWith("file:/")) {
                                    looseConfigURI = looseConfigURI.substring(6);
                                }
                                fileLoaded = looseConfigURI;
                                LooseApplication looseApplication = null;
                                WASResourceSetImpl resSet = new WASResourceSetImpl();
                                URI looseURI = URI.createFileURI(looseConfigURI);
                                final Resource looseResource = resSet.createResource(looseURI);
                                final InputStream instream = FileAccessor.getInputStream(looseConfigURI);
                                if (looseResource == null || instream == null) break block27;
                                try {
                                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                        public Object run() throws IOException {
                                            looseResource.load(instream, new HashMap());
                                            return null;
                                        }
                                    });
                                }
                                catch (PrivilegedActionException e) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Exception thrown in getApplicationAttachment looseResource.load()");
                                    }
                                    throw e.getException();
                                }
                                looseApplication = (LooseApplication)looseResource.getContents().get(0);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Read loose application object");
                                }
                                resourcePath = null;
                                if (looseApplication == null) break block27;
                                archives = looseApplication.getLooseArchives();
                                break block28;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "No looseconfig.xmi found in deployment.xml so use standard attachment path");
                            }
                            attachmentPath = basePath;
                            break block27;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No binariesURL found in deployment.xml so use standard attachment path");
                        }
                        attachmentPath = basePath;
                        break block27;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "in deployment.xml, useMetadataFromBinaries = false");
                    }
                    attachmentPath = basePath;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, this.SOURCE_FILE + ".getAttachmentPath", FFDC_ID_2);
                    Tr.error(tc, "CWPST0097E", fileLoaded);
                }
                break block27;
            }
            for (int j = 0; j < archives.size(); ++j) {
                LooseArchive archive = (LooseArchive)archives.get(j);
                if (!archive.getBinariesPath().equals(binariesURL)) continue;
                resourcePath = archive.getResourcesPath();
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Found matching path in looseConfig.xml: " + resourcePath);
                break;
            }
            if (resourcePath != null) {
                attachmentPath = resourcePath;
            }
        }
        if (attachmentPath != null) {
            StringBuffer buf = new StringBuffer(attachmentPath);
            buf.append("/META-INF");
            buf.append("/");
            buf.append(type);
            attachmentPath = buf.toString();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attachment path is " + attachmentPath);
        }
        return attachmentPath;
    }

    public String getAttachmentPath(String busName, String wsnServiceName, String type) {
        String attachmentPath = null;
        StringBuffer buf = new StringBuffer(this.repository.getRootURI());
        buf.append("/cells/");
        buf.append(this.repository.getCellName());
        buf.append("/buses/");
        buf.append(busName);
        buf.append("/wsn/");
        buf.append(wsnServiceName);
        buf.append("/META-INF/");
        buf.append(type);
        attachmentPath = buf.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attachment location is " + attachmentPath);
        }
        return attachmentPath;
    }

    public String getSystemAttachmentPath(String type) {
        StringBuffer buf = new StringBuffer(this.repository.getRootURI());
        buf.append("/cells/");
        buf.append(this.repository.getCellName());
        buf.append("/");
        buf.append(type);
        buf.append("/");
        buf.append("policyAttachments.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "System policyAttachment location is " + buf.toString());
        }
        return buf.toString();
    }

    public String getPolicySetPath(String policySet) {
        StringBuffer buf = new StringBuffer(this.repository.getRootURI());
        buf.append("/cells/");
        buf.append(this.repository.getCellName());
        buf.append("/");
        buf.append("PolicySets");
        buf.append("/");
        buf.append(policySet);
        buf.append("/");
        buf.append("policySet.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Policy set path is " + buf);
        }
        return buf.toString();
    }

    public String getPolicyTypeConfigPath(String policySet, String policyType) {
        StringBuffer buf = new StringBuffer(this.repository.getRootURI());
        buf.append("/cells/");
        buf.append(this.repository.getCellName());
        buf.append("/");
        buf.append("PolicySets");
        buf.append("/");
        buf.append(policySet);
        buf.append("/");
        buf.append("PolicyTypes");
        buf.append("/");
        buf.append(policyType);
        buf.append("/");
        buf.append("policy.xml");
        return buf.toString();
    }

    public String get61DefaultBindingPath(String policyType) {
        String serverName;
        String nodeName;
        String cellName;
        String root = this.repository.getRootURI();
        String path = FileLocatorImpl.constructPathName(root, cellName = this.repository.getCellName(), nodeName = this.repository.getNodeName(), serverName = this.repository.getServerName(), policyType);
        String uri = FileAccessor.exists(path) ? path : (FileAccessor.exists(path = FileLocatorImpl.constructPathName(root, cellName, nodeName, null, policyType)) ? path : FileLocatorImpl.constructPathName(root, cellName, null, null, policyType));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, policyType + ": " + uri);
        }
        return uri;
    }

    public String getDefaultBindingPath(String policyType, String bindingName) {
        String root = this.repository.getRootURI();
        String cellName = this.repository.getCellName();
        StringBuffer buf = new StringBuffer(root);
        buf.append("/cells/");
        buf.append(cellName);
        buf.append("/");
        buf.append("bindings");
        buf.append("/");
        buf.append(bindingName);
        buf.append("/");
        buf.append("PolicyTypes");
        buf.append("/");
        buf.append(policyType);
        buf.append("/bindings.xml");
        String uri = buf.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, policyType + ": " + uri);
        }
        return uri;
    }

    public String getGeneralBindingPath(String policyType, String bindingName) {
        return this.getDefaultBindingPath(policyType, bindingName);
    }

    private static String constructPathName(String root, String cell, String node, String server, String type) {
        StringBuffer buf = new StringBuffer(root);
        buf.append("/cells/");
        buf.append(cell);
        if (node != null) {
            buf.append("/nodes/");
            buf.append(node);
            if (server != null) {
                buf.append("/servers/");
                buf.append(server);
            }
        }
        buf.append("/");
        buf.append("PolicyTypes");
        buf.append("/");
        buf.append(type);
        buf.append("/bindings.xml");
        return buf.toString();
    }

    public String getCustomBindingPath(String rootDir, String bindingName, String policyType) {
        StringBuffer buf = new StringBuffer(rootDir);
        buf.append("/");
        buf.append(bindingName);
        buf.append("/");
        buf.append("PolicyTypes");
        buf.append("/");
        buf.append(policyType);
        buf.append("/bindings.xml");
        return buf.toString();
    }

    public String getParent(String pathname) {
        File file = new File(pathname);
        return file.getParent();
    }

    public String getDefaultBindingsFilePath() {
        StringBuffer buf = new StringBuffer(this.repository.getRootURI());
        buf.append("/cells/");
        buf.append(this.repository.getCellName());
        buf.append("/");
        buf.append("bindings");
        buf.append("/");
        buf.append("defaultBindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default bindings file path is " + buf);
        }
        return buf.toString();
    }

    public String getResourceName(String resourceType) {
        String resource = null;
        resource = "node".equals(resourceType) ? this.repository.getNodeName() : this.repository.getServerName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, resource + ": " + resource);
        }
        return resource;
    }
}

