/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.runtime.VariableExpander;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class VariableExpanderImpl
implements VariableExpander {
    private static TraceComponent tc = Tr.register(VariableExpanderImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", Locale.getDefault());
    private Map variables = System.getProperties();

    public String expand(String variable) throws IllegalArgumentException {
        return this.substitute(variable, this.variables);
    }

    void append(StringBuffer result, String src, int offset, int len) {
        if (len < 0) {
            len = src.length() - offset;
        }
        result.ensureCapacity(result.length() + len);
        len += offset;
        for (int i = offset; i < len; ++i) {
            result.append(src.charAt(i));
        }
    }

    String expand(String line, int startIdx, int endIdx, Map vars, Map varsInUse) throws IllegalArgumentException {
        StringBuffer result = new StringBuffer();
        block4: for (int curIdx = startIdx; curIdx < endIdx; ++curIdx) {
            int idx = line.indexOf(36, curIdx);
            this.append(result, line, curIdx, idx - curIdx);
            if (idx == -1) break;
            curIdx = idx + 1;
            if (curIdx >= endIdx) continue;
            switch (line.charAt(curIdx)) {
                case '$': {
                    result.append('$');
                    continue block4;
                }
                case '(': 
                case '{': {
                    char openParen = line.charAt(curIdx);
                    char closeParen = openParen == '(' ? (char)')' : '}';
                    int beg = curIdx + 1;
                    int end = line.indexOf(closeParen, beg);
                    if (end == -1) {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0089E", new Object[0], "Unterminated variable reference"));
                    }
                    curIdx = this.indexOf(line, '$', beg, end);
                    if (curIdx != -1) {
                        beg = curIdx + 1;
                        int count = 0;
                        for (curIdx = beg; curIdx < line.length(); ++curIdx) {
                            char c = line.charAt(curIdx);
                            if (c == openParen) {
                                ++count;
                                continue;
                            }
                            if (c == closeParen && --count < 0) break;
                        }
                        if (count < 0) {
                            String s = this.expand(line, beg, curIdx, vars, varsInUse);
                        }
                    } else {
                        curIdx = end;
                    }
                    this.referenceVariable(result, line, beg, end - beg, vars, varsInUse);
                    continue block4;
                }
                default: {
                    char c = line.charAt(curIdx);
                    if (Character.isWhitespace(c)) continue block4;
                    this.referenceVariable(result, line, curIdx, 1, vars, varsInUse);
                }
            }
        }
        return result.toString();
    }

    String expand(String line, Map vars, Map varsInUse) throws IllegalArgumentException {
        return this.expand(line, 0, line.length(), vars, varsInUse);
    }

    int indexOf(String s, char c, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    String recursivelyExpand(String varName, Map vars, Map varsInUse) throws IllegalArgumentException {
        if (varsInUse.get(varName) != null) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0090E", new Object[]{varName}, "Recursive variable: {0}"));
        }
        varsInUse.put(varName, varName);
        String value = (String)vars.get(varName);
        if (value == null) {
            value = "";
        }
        String s = this.expand(value, vars, varsInUse);
        varsInUse.remove(varName);
        return s;
    }

    void referenceVariable(StringBuffer sb, String line, int beg, int len, Map vars, Map varsInUse) throws IllegalArgumentException {
        String varName = line.substring(beg, beg + len);
        if (!vars.containsKey(varName)) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0091E", new Object[]{varName}, "Undefined variable: {0}"));
        }
        String s = this.recursivelyExpand(varName, vars, varsInUse);
        sb.append(s);
    }

    public String substitute(String line, Map vars) throws IllegalArgumentException {
        if (line == null) {
            return null;
        }
        return this.expand(line, 0, line.length(), vars, new HashMap());
    }
}

