/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wspolicy.NullPolicyException;
import com.ibm.websphere.wspolicy.PolicyException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.DefaultResourceEvaluator;
import com.ibm.ws.policyset.runtime.InactivePolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationImpl;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationWrapper;
import com.ibm.ws.policyset.runtime.ResourceEvaluator;
import com.ibm.ws.wspolicy.UnknownOperationException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.policyset.WSPolicyProcessor;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyAttachmentsImpl
implements PolicySetAttachments {
    private static TraceComponent tc = Tr.register(WSPolicyAttachmentsImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private WSPolicyProcessor _wsPolicyProcessor;
    private DefaultResourceEvaluator _defaultResourceEvaluator;
    private List<PolicySetReference> _referenceList;
    private String _applicationPath;
    private boolean _invocationBlocked;
    private InactivePolicySetConfiguration _inactivePolicySetConfiguration;
    private PolicySetAttachments _psa;
    private PolicySetConfiguration _policySetConfigurationWrapper;
    private ClassLoader _appClassLoader;
    private ClassLoader _systemClassLoader;
    private boolean _refreshRequired;

    public WSPolicyAttachmentsImpl(WSPolicyProcessor wsPolicyProcessor, PolicySetAttachments attachments, String pathname, String serviceName, String moduleName) {
        block12: {
            this._defaultResourceEvaluator = new DefaultResourceEvaluator();
            this._referenceList = new ArrayList<PolicySetReference>();
            this._refreshRequired = true;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSPolicyAttachmentsImpl", new Object[]{pathname});
            }
            this._psa = attachments;
            try {
                PolicySetAttachment psa;
                if (attachments != null && attachments instanceof PolicySetAttachmentsImpl && (psa = ((PolicySetAttachmentsImpl)attachments).getAttachments()) != null) {
                    List<PolicySetReference> referenceList = psa.getPolicySetReference();
                    for (PolicySetReference psr : referenceList) {
                        List<Resource> resources = psr.getResource();
                        Iterator<Resource> resIter = resources.iterator();
                        boolean match = false;
                        while (resIter.hasNext()) {
                            Resource res = resIter.next();
                            String resourcePattern = res.getPattern();
                            PolicyResource policyResource = new PolicyResource(resourcePattern);
                            if (policyResource.getServiceName() == null) {
                                if (moduleName != null && policyResource.getModuleName() != null && !policyResource.getModuleName().equals(moduleName)) continue;
                                match = true;
                                break;
                            }
                            if (!policyResource.getServiceName().equals(serviceName) || moduleName != null && policyResource.getModuleName() != null && !policyResource.getModuleName().equals(moduleName)) continue;
                            match = true;
                            break;
                        }
                        if (!match) continue;
                        this._referenceList.add(psr);
                    }
                }
                this._wsPolicyProcessor = wsPolicyProcessor;
                this._applicationPath = pathname;
                if (tc.isDetailEnabled()) {
                    Tr.debug(tc, "initWSPolicyProcessor", "client capabilities");
                }
                if (!this.isProviderSideOnly()) {
                    if (tc.isDetailEnabled()) {
                        Tr.debug(tc, "initWSPolicyProcessor", "WS-Policy intersection. Load client requirements");
                    }
                    HashMap<String, Object> transformOptions = new HashMap<String, Object>();
                    transformOptions.put("com.ibm.ws.wspolicy.PolicySetAttachment", this);
                    this._wsPolicyProcessor.loadRequesterWSPolicy(this._referenceList, transformOptions);
                }
                this._wsPolicyProcessor.storeReferenceList(this._referenceList);
            }
            catch (PolicyException e) {
                FFDCFilter.processException(e, this.getClass().toString(), "1:142:1.15");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception thrown in WSPolicyAttachmentsImpl CTOR");
                }
                this._invocationBlocked = true;
                this._inactivePolicySetConfiguration = new InactivePolicySetConfiguration(e);
                if (!tc.isInfoEnabled()) break block12;
                Tr.info(tc, e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSPolicyAttachmentsImpl");
        }
    }

    public PolicySetConfiguration getPolicySet(String resourceName) throws Exception {
        return this.getPolicySet(resourceName, this._defaultResourceEvaluator, this._appClassLoader, this._systemClassLoader);
    }

    @Override
    public PolicySetConfiguration getPolicySet(String resourceName, ClassLoader appClassLoader, ClassLoader systemClassLoader) throws Exception {
        return this.getPolicySet(resourceName, this._defaultResourceEvaluator, appClassLoader, systemClassLoader);
    }

    @Override
    public PolicySetConfiguration getPolicySet(String resourceName, ResourceEvaluator resourceEvaluator, ClassLoader appClassLoader, ClassLoader systemCL) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySet", resourceName);
        }
        if (this._invocationBlocked) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicySet", resourceName);
            }
            return new PolicySetConfigurationWrapper(this._inactivePolicySetConfiguration, this, resourceName);
        }
        this._appClassLoader = appClassLoader;
        this._systemClassLoader = systemCL;
        PolicySetConfiguration clientOnlyPolicySetConfiguration = this._psa.getPolicySet(resourceName, appClassLoader, systemCL);
        this._policySetConfigurationWrapper = new PolicySetConfigurationWrapper(clientOnlyPolicySetConfiguration, this, resourceName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySet", resourceName);
        }
        return this._policySetConfigurationWrapper;
    }

    public PolicySetConfiguration getPolicySet(MessageContext mc, String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySet", mc);
        }
        PolicySetConfigurationImpl virtualPolicySet = null;
        if (this._invocationBlocked) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicySet", mc);
            }
            return this._inactivePolicySetConfiguration;
        }
        try {
            PolicySetReference psr;
            String policySetName;
            List typesInPolicySet;
            if (this._wsPolicyProcessor.isAttached(resourceName, mc)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is a WS-Policy attached at: " + resourceName);
                }
                typesInPolicySet = null;
                policySetName = null;
                psr = null;
                if (this._referenceList != null) {
                    psr = this.findAttachment(resourceName, this._defaultResourceEvaluator);
                }
                if (psr != null && (policySetName = psr.getName()) != null && !policySetName.equals("")) {
                    try {
                        typesInPolicySet = PolicySetAttachmentsImpl.getTypesForPolicySet(policySetName);
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Caught Exception doing getTypesForPolicySet ", e);
                        }
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.policyset.runtime.WSPolicyAttachmentsImpl.getPolicySet", "293", this);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getPolicySet", resourceName);
                        }
                        return this._inactivePolicySetConfiguration;
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no valid WS-Policy attached at: " + resourceName);
                }
                if (this._inactivePolicySetConfiguration == null) {
                    this._inactivePolicySetConfiguration = new InactivePolicySetConfiguration(new PolicyException(new WSPolicyInternalException()));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPolicySet", resourceName);
                }
                return this._inactivePolicySetConfiguration;
            }
            Vector<String> usedTypes = new Vector<String>();
            virtualPolicySet = (PolicySetConfigurationImpl)this._wsPolicyProcessor.generateQOSProperties(this._systemClassLoader, resourceName, typesInPolicySet, usedTypes, mc, policySetName);
            virtualPolicySet.setPolicyTypeConfiguration("attachmentType", "client");
            String bindingName = psr != null && psr.getPolicySetBinding() != null ? psr.getPolicySetBinding().getName() : null;
            String bindingScope = psr != null && psr.getPolicySetBinding() != null ? psr.getPolicySetBinding().getScope() : null;
            String rootDir = this._applicationPath.substring(0, this._applicationPath.length() - "clientPolicyAttachments.xml".length() - 1);
            BindingAggregator.getCustomBinding(rootDir, bindingName, this._appClassLoader, this._systemClassLoader, virtualPolicySet, usedTypes, "client", bindingScope);
        }
        catch (NullPolicyException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NullPolicy encountered. Can not continue. " + resourceName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicySet", resourceName);
            }
            return new InactivePolicySetConfiguration(e);
        }
        catch (UnknownOperationException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Virtual operation  " + resourceName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicySet", resourceName);
            }
            return new InactivePolicySetConfiguration(e);
        }
        catch (PolicyException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PolicyException encountered. Can not continue. " + resourceName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicySet", resourceName);
            }
            return new InactivePolicySetConfiguration(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySet", resourceName);
        }
        return virtualPolicySet;
    }

    private PolicySetReference findAttachment(String resourceName, ResourceEvaluator resourceEvaluator) {
        String attachmentType = "client";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAttachment", resourceName);
        }
        PolicySetReference policyRef = null;
        int matchDistance = Integer.MAX_VALUE;
        PolicySetReference savedPolicyRef = null;
        int savedMatchDistance = Integer.MAX_VALUE;
        if (resourceName != null) {
            if (!resourceName.endsWith("/")) {
                resourceName = resourceName + "/";
            }
            String resourceWithoutModule = resourceName;
            String savedResourceName = resourceName;
            boolean keepSearching = true;
            boolean resourceContainsModule = false;
            if (attachmentType.equals("client") && !resourceName.equals(resourceWithoutModule = this.removeModuleName(resourceName))) {
                resourceContainsModule = true;
            }
            while (keepSearching) {
                List<PolicySetReference> referenceList = this._referenceList;
                Iterator<PolicySetReference> references = referenceList.iterator();
                block1: while (matchDistance != 0 && references.hasNext()) {
                    PolicySetReference reference = references.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Testing attachment id " + reference.getId());
                        Tr.debug(tc, "   Policy set name is " + reference.getName());
                        Tr.debug(tc, "   Binding is " + reference.getPolicySetBinding());
                    }
                    List<Resource> resourceList = reference.getResource();
                    Iterator<Resource> resources = resourceList.iterator();
                    while (resources.hasNext()) {
                        int distance;
                        String resourcePattern = resources.next().getPattern();
                        if (resourcePattern == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "findAttachment, resourcePattern is null, skip it");
                            continue;
                        }
                        if (!resourcePattern.endsWith("/")) {
                            resourcePattern = resourcePattern + "/";
                        }
                        resourcePattern = this.removeModuleName(resourcePattern);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "resourceName=" + resourceName + ", resourcePattern=" + resourcePattern);
                        }
                        if ((distance = resourceEvaluator.getMatchDistance(resourcePattern, resourceName)) < 0) continue;
                        if (distance < matchDistance) {
                            policyRef = reference;
                            matchDistance = distance;
                        }
                        if (matchDistance != 0) continue;
                        continue block1;
                    }
                }
                if (attachmentType.equals("client")) {
                    if (matchDistance != 0 && resourceContainsModule) {
                        savedPolicyRef = policyRef;
                        savedMatchDistance = matchDistance;
                        resourceName = resourceWithoutModule;
                        resourceContainsModule = false;
                        matchDistance = Integer.MAX_VALUE;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "match distance = " + savedMatchDistance);
                        Tr.debug(tc, "getting ready to check without moduleName, updated resourceName = " + resourceName);
                        continue;
                    }
                    keepSearching = false;
                    continue;
                }
                keepSearching = false;
            }
            if (attachmentType.equals("client") && savedMatchDistance <= matchDistance) {
                policyRef = savedPolicyRef;
                matchDistance = savedMatchDistance;
                resourceName = savedResourceName;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Closer match, so using policy reference with module name");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resourceName is null");
        }
        if (tc.isDebugEnabled()) {
            if (matchDistance < Integer.MAX_VALUE) {
                Tr.debug(tc, "Found attachment with id, name, and matchDistance of:", new Object[]{policyRef.getId(), policyRef.getName(), new Integer(matchDistance)});
            } else {
                Tr.debug(tc, "Found no attachment");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAttachment", resourceName);
        }
        return policyRef;
    }

    private String removeModuleName(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeModuleName", resourceName);
        }
        String updatedResource = resourceName;
        PolicyResource policyResource = new PolicyResource(resourceName);
        String moduleName = policyResource.getModuleName();
        if (moduleName != null) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(resourceName.substring(0, resourceName.indexOf(moduleName)));
            strBuf.append(resourceName.substring(resourceName.indexOf(moduleName) + moduleName.length() + 1));
            updatedResource = strBuf.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resource contains module name");
                Tr.debug(tc, "Resource without moduleName is: " + updatedResource);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeModuleName", updatedResource);
        }
        return updatedResource;
    }

    public boolean isProviderSideOnly() {
        return this._referenceList == null;
    }

    @Override
    public boolean isAttached(String resourceName, ResourceEvaluator resourceEvaluator) {
        return true;
    }

    @Override
    public boolean isAttached(String resourceName) {
        return this.isAttached(resourceName, this._defaultResourceEvaluator);
    }

    public boolean isRefreshRequired(MessageContext msgCtx) {
        return this._refreshRequired;
    }

    public void setRefreshRequired(MessageContext msgCtx, boolean required) {
        this._refreshRequired = required;
    }

    public void refreshProviderPolicy(MessageContext msgCtx) {
        this._wsPolicyProcessor.clearProviderPolicy(msgCtx);
    }

    @Override
    public List<String> getResourceNames() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceNames", this);
        }
        List<String> resultList = null;
        if (this._psa != null) {
            resultList = this._psa.getResourceNames();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceNames", resultList);
        }
        return resultList;
    }
}

