/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationImpl;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class PolicyTypeAggregator {
    private static TraceComponent tc = Tr.register(PolicyTypeAggregator.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static String className = "com.ibm.ws.policyset.runtime.PolicySetAggregator";
    private static Map policySetConfigs = new HashMap();
    private static Integer policySetConfigsLock = new Integer(0);
    private static List extensions = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicySetConfiguration getPolicySetConfiguration(ClassLoader systemCL, String policySetName, List types) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetConfiguration", policySetName);
        }
        PolicySetConfigurationImpl psConfig = null;
        Integer n = policySetConfigsLock;
        synchronized (n) {
            psConfig = (PolicySetConfigurationImpl)policySetConfigs.get(policySetName);
            if (psConfig == null) {
                try {
                    psConfig = new PolicySetConfigurationImpl();
                    psConfig.setPolicyTypeConfiguration("com.ibm.ws.policyset.POLICY_NAME_KEY", policySetName);
                    List extensions = PolicyTypeAggregator.getExtensions();
                    VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
                    for (PolicyTypeLoader loader : extensions) {
                        try {
                            if (types != null && types.contains(loader.getType())) {
                                InputStream policyTypeConfig = PolicyTypeAggregator.getPolicyTypeInputStream(policySetName, loader.getType());
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "About to call load on " + loader.getClass().getName());
                                }
                                loader.load(systemCL, variableExpander, policyTypeConfig, psConfig);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Back from load on " + loader.getClass().getName());
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Policy type is not included in policy set: " + loader.getType());
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException(t, className, FFDC_ID_1);
                        }
                    }
                    policySetConfigs.put(policySetName, psConfig);
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, className, FFDC_ID_2);
                }
            }
            psConfig = new PolicySetConfigurationImpl(psConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetConfiguration", policySetName);
        }
        return psConfig;
    }

    public static List getExtensions() {
        if (extensions == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading policy type loader extensions");
            }
            extensions = new ArrayList();
            String extensionPointId = PolicySetUtil.isClient() ? "com.ibm.wsfp.thinclient.ibmaxis2-qos-policytypeloader" : "com.ibm.wsfp.main.ibmaxis2-qos-policytypeloader";
            IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(extensionPointId);
            if (elements.length == 0 && PolicySetUtil.isClient()) {
                extensionPointId = "com.ibm.wsfp.main.ibmaxis2-qos-policytypeloader";
                elements = registry.getConfigurationElementsFor(extensionPointId);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + elements.length + " extensions for " + extensionPointId);
            }
            HashMap properties = new HashMap();
            for (int i = 0; i < elements.length; ++i) {
                try {
                    String classname = elements[i].getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found " + classname);
                    }
                    Class<?> loaderClass = Class.forName(classname);
                    Constructor<?> constructor = loaderClass.getConstructor(new Class[0]);
                    PolicyTypeLoader loader = (PolicyTypeLoader)constructor.newInstance(new Object[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "About to call init on " + classname);
                    }
                    loader.init(properties);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "back from call init on " + classname);
                    }
                    extensions.add(loader);
                    continue;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, className, FFDC_ID_3);
                }
            }
        }
        return extensions;
    }

    public static InputStream getPolicyTypeInputStream(String policySet, String policyType) {
        FileLocator locator = FileLocatorFactory.getFileLocator();
        String path = locator.getPolicyTypeConfigPath(policySet, policyType);
        InputStream input = FileAccessor.getInputStream(path);
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refresh() {
        Integer n = policySetConfigsLock;
        synchronized (n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resetting policySetConfigs");
            }
            policySetConfigs = new HashMap();
        }
    }
}

