/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.EmptyPolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.PolicyTypeAggregator;
import com.ibm.ws.policyset.runtime.WSPolicyAttachmentsImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wspolicy.policyset.WSPolicyFactory;
import com.ibm.ws.wspolicy.policyset.WSPolicyProcessor;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

public class PolicySetUtil {
    private static TraceComponent tc = Tr.register(PolicySetUtil.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", Locale.getDefault());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private String className = this.getClass().getName();
    private static PolicySetUtil policySetUtil = null;
    private ClassLoader systemCL = null;
    private static FileLocator fileLocator = null;
    private static Boolean client = null;

    public static synchronized PolicySetUtil getInstance(ClassLoader sysCL) {
        if (policySetUtil == null) {
            policySetUtil = new PolicySetUtil();
            policySetUtil.init(sysCL);
            policySetUtil.initMBean();
        }
        return policySetUtil;
    }

    private PolicySetUtil() {
    }

    private void init(ClassLoader sysCL) {
        this.systemCL = sysCL;
    }

    public PolicySetAttachments getAttachments(String appName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttachments", appName);
        }
        String pathname = this.getAttachmentPath(appName, "policyAttachments.xml");
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, "application");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachments", appName);
        }
        return attachments;
    }

    public PolicySetAttachments getClientAttachments(String appName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAttachments", appName);
        }
        String pathname = this.getAttachmentPath(appName, "clientPolicyAttachments.xml");
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, "client");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAttachments", appName);
        }
        return attachments;
    }

    public PolicySetAttachments getClientAttachments(String appName, String serviceName, String moduleName) throws Exception {
        WSPolicyProcessor wsPolicyProcessor;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAttachments", appName);
        }
        String pathname = this.getAttachmentPath(appName, "clientPolicyAttachments.xml");
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, "client");
        if (pathname != null && (wsPolicyProcessor = WSPolicyFactory.newInstance().createPolicyProcessor(pathname.substring(0, pathname.indexOf("clientPolicyAttachments.xml") - 1), serviceName, moduleName)).isWSPolicyProcessingRequired()) {
            WSPolicyAttachmentsImpl wsPolicyAttachments = new WSPolicyAttachmentsImpl(wsPolicyProcessor, attachments, pathname, serviceName, moduleName);
            attachments = wsPolicyAttachments;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAttachments", appName);
        }
        return attachments;
    }

    public PolicySetAttachments getClientAttachments(String busName, String wsnServiceName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAttachments, busName=", busName + ", wsnServiceName=" + wsnServiceName);
        }
        String pathname = this.getWsnClientAttachmentPath(busName, wsnServiceName, "clientPolicyAttachments.xml");
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, "client");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAttachments, busName=", busName + ", wsnServiceName=" + wsnServiceName);
        }
        return attachments;
    }

    public PolicySetAttachments getSystemAttachments(String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemAttachments", type);
        }
        if (!type.equals("system/trust")) {
            throw new Exception(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0088E", new Object[]{type}, "Unknown system policy set type: {0}"));
        }
        String context = "sts/policy";
        String pathname = this.getSystemAttachmentPath(context);
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, type);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemAttachments", type);
        }
        return attachments;
    }

    public void refresh() {
        BindingAggregator.refresh();
        PolicyTypeAggregator.refresh();
    }

    private PolicySetAttachments getAttachmentsFromFile(String pathname, String type) throws Exception {
        PolicySetAttachments attachments;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAttachmentsFromFile", pathname);
            }
            attachments = null;
            try {
                if (pathname != null && FileAccessor.exists(pathname)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found attachments");
                    }
                    BindingAggregator.getDefaultBinding(this.systemCL, type);
                    PolicySetAttachment psa = null;
                    final InputStream input = FileAccessor.getInputStream(pathname);
                    try {
                        psa = (PolicySetAttachment)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                                PolicySetAttachmentHelper psaHelper = PolicySetAttachmentHelperFactory.createHelper(input);
                                PolicySetAttachment psa = psaHelper.getPolicySetAttachmentObject();
                                return psa;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException(e, this.className + ".getAttachmentsFromFile", FFDC_ID_2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception thrown in getPolicySetAttachmentObject");
                        }
                        throw e.getException();
                    }
                    String parentDir = this.getFileLocator().getParent(pathname);
                    attachments = new PolicySetAttachmentsImpl(parentDir, psa, type);
                    break block10;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found no attachments at " + pathname);
                }
                attachments = new EmptyPolicySetAttachmentsImpl();
            }
            catch (Exception e) {
                FFDCFilter.processException(e, this.className + ".getAttachmentsFromFile", FFDC_ID_1);
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachmentsFromFile", pathname);
        }
        return attachments;
    }

    private synchronized FileLocator getFileLocator() {
        if (fileLocator == null) {
            fileLocator = FileLocatorFactory.getFileLocator();
        }
        return fileLocator;
    }

    private String getAttachmentPath(String appName, String type) {
        FileLocator locator = this.getFileLocator();
        String path = locator.getAttachmentPath(appName, type);
        return path;
    }

    private String getWsnClientAttachmentPath(String busName, String wsnServiceName, String type) {
        FileLocator locator = this.getFileLocator();
        String path = locator.getAttachmentPath(busName, wsnServiceName, type);
        return path;
    }

    private String getSystemAttachmentPath(String type) {
        FileLocator locator = this.getFileLocator();
        String path = locator.getSystemAttachmentPath(type);
        return path;
    }

    static boolean isClient() {
        if (client == null) {
            Repository repository = null;
            try {
                repository = WsServiceRegistry.getService(FileAccessor.class, Repository.class);
                client = repository != null ? Boolean.FALSE : Boolean.TRUE;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting client flag to " + client);
                }
            }
            catch (Throwable t) {
                Tr.debug(tc, "Caught exception, setting client flag to true: ", t);
                client = Boolean.TRUE;
            }
        }
        return client;
    }

    void initMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initMBean");
        }
        if (!PolicySetUtil.isClient()) {
            try {
                DefaultRuntimeCollaborator collab = new DefaultRuntimeCollaborator(this, "PolicySetManager");
                AdminServiceFactory.getMBeanFactory().activateMBean("PolicySetManager", collab, "PolicySetManager", "META-INF/PolicySetManager.xml");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Activated PolicySetManager MBean");
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "PolicySetUtil.initMBean", FFDC_ID_3);
                Tr.error(tc, "CWPST0027E", t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initMBean");
        }
    }
}

