/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import java.lang.reflect.Constructor;

public class FileLocatorFactory {
    private static TraceComponent tc = Tr.register(FileLocatorFactory.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static String clientClassName = "com.ibm.ws.policyset.runtime.client.FileLocatorImpl";
    private static String serverClassName = "com.ibm.ws.policyset.runtime.server.FileLocatorImpl";
    private static FileLocator fileLocator = null;

    public static synchronized FileLocator getFileLocator() {
        if (fileLocator == null) {
            try {
                Class classObj = FileLocatorFactory.getClassObj();
                Class[] arg = new Class[]{};
                Constructor constructor = classObj.getConstructor(arg);
                Object[] param = new Object[]{};
                fileLocator = (FileLocator)constructor.newInstance(param);
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.policyset.runtime.FileLocatorFactory", "42");
            }
        }
        return fileLocator;
    }

    private static Class getClassObj() throws ClassNotFoundException {
        Class<?> classObj = null;
        try {
            classObj = PolicySetUtil.isClient() ? Class.forName(clientClassName) : Class.forName(serverClassName);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.policyset.runtime.FileLocatorFactory", "69");
            Tr.debug(tc, "Caught exception", t);
            classObj = Class.forName(clientClassName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using class " + classObj.getName());
        }
        return classObj;
    }
}

