/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.BindingDefinitionHelper;
import com.ibm.ws.policyset.admin.BindingDefinitionHelperFactory;
import com.ibm.ws.policyset.admin.DefaultBindingsHelper;
import com.ibm.ws.policyset.admin.DefaultBindingsHelperFactory;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.runtime.BindingLoader;
import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.DefaultBindingImpl;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class BindingAggregator {
    private static TraceComponent tc = Tr.register(BindingAggregator.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String FFDC_ID_8 = "FFDC-8";
    private static final String FFDC_ID_9 = "FFDC-9";
    private static final String FFDC_ID_10 = "FFDC-10";
    private static final String FFDC_ID_11 = "FFDC-11";
    private static final String FFDC_ID_12 = "FFDC-12";
    private static final String FFDC_ID_13 = "FFDC-13";
    private static final String FFDC_ID_14 = "FFDC-14";
    private static final String FFDC_ID_15 = "FFDC-15";
    private static final String FFDC_ID_16 = "FFDC-16";
    private static final String FFDC_ID_17 = "FFDC-17";
    private static final String FFDC_ID_18 = "FFDC-18";
    private static String className = "com.ibm.ws.policyset.runtime.BindingAggregator";
    private static DefaultBinding default61Binding = null;
    private static DefaultBinding appDefaultBinding = null;
    private static DefaultBinding clientDefaultBinding = null;
    private static Integer defaultBindingLock = new Integer(0);
    private static List extensions = null;
    private static Map bindingsMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DefaultBinding getDefaultBinding(ClassLoader systemCL, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultBinding");
        }
        String bindingName = null;
        boolean loadedBinding = false;
        Integer n = defaultBindingLock;
        synchronized (n) {
            if (type.equals("application") && appDefaultBinding == null || type.equals("client") && clientDefaultBinding == null) {
                try {
                    if (type.equals("application")) {
                        appDefaultBinding = new DefaultBindingImpl();
                    } else {
                        clientDefaultBinding = new DefaultBindingImpl();
                    }
                    if (bindingsMap == null) {
                        bindingsMap = new HashMap();
                    }
                    List extensions = BindingAggregator.getExtensions();
                    bindingName = BindingAggregator.getDefaultBindingName(type);
                    VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
                    for (BindingLoader loader : extensions) {
                        try {
                            InputStream policyTypeBinding = BindingAggregator.getDefaultBindingInputStream(loader.getType(), bindingName);
                            if (type.equals("application")) {
                                loader.loadDefault(systemCL, variableExpander, policyTypeBinding, appDefaultBinding);
                                continue;
                            }
                            loader.loadDefault(systemCL, variableExpander, policyTypeBinding, clientDefaultBinding);
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException(t, className, FFDC_ID_10);
                        }
                    }
                    loadedBinding = true;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, className, FFDC_ID_11);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultBinding");
        }
        if (type.equals("application")) {
            if (loadedBinding && bindingName != null) {
                bindingsMap.put(bindingName, appDefaultBinding);
            }
            return appDefaultBinding;
        }
        if (loadedBinding && bindingName != null) {
            bindingsMap.put(bindingName, clientDefaultBinding);
        }
        return clientDefaultBinding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DefaultBinding get61DefaultBinding(ClassLoader systemCL) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get61DefaultBinding");
        }
        Integer n = defaultBindingLock;
        synchronized (n) {
            if (default61Binding == null) {
                try {
                    default61Binding = new DefaultBindingImpl();
                    List extensions = BindingAggregator.getExtensions();
                    VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
                    for (BindingLoader loader : extensions) {
                        try {
                            InputStream policyTypeBinding = BindingAggregator.get61DefaultBindingInputStream(loader.getType());
                            loader.loadDefault(systemCL, variableExpander, policyTypeBinding, default61Binding);
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException(t, className, FFDC_ID_12);
                        }
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, className, FFDC_ID_13);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get61DefaultBinding");
        }
        return default61Binding;
    }

    public static synchronized void getCustomBinding(String rootDir, String bindingName, ClassLoader appCL, ClassLoader systemCL, PolicySetConfiguration psConfig, List types, String type, String bindingScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomBinding");
        }
        String version = "7.0.0.0";
        try {
            String nodeVersion;
            psConfig.setPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_NAME_KEY", bindingName);
            psConfig.setPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_SCOPE_KEY", bindingScope);
            boolean is61App = false;
            if (!(rootDir == null || rootDir.contains("sts/policy") || rootDir.contains("buses") && rootDir.contains("wsn") || !(version = BindingAggregator.getCustomBindingVersion(rootDir)).equals("7.0.0.0") || PolicySetUtil.isClient() || !(nodeVersion = BindingAggregator.getModuleTargetVersion()).startsWith("6.1"))) {
                version = "6.1.0.0";
            }
            DefaultBinding generalBinding = null;
            Boolean isGeneralBinding = false;
            if (version.startsWith("6.1")) {
                BindingAggregator.get61DefaultBinding(systemCL);
            } else {
                BindingAggregator.getDefaultBinding(systemCL, type);
                if (bindingName != null && bindingScope != null && bindingScope.equals("domain")) {
                    generalBinding = BindingAggregator.getGeneralBinding(systemCL, bindingName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "General binding loaded..." + generalBinding);
                    }
                    isGeneralBinding = true;
                }
            }
            List extensions = BindingAggregator.getExtensions();
            VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
            for (BindingLoader loader : extensions) {
                try {
                    if (types == null || !types.contains(loader.getType())) continue;
                    InputStream policyTypeBinding = null;
                    if (isGeneralBinding.booleanValue()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to call loadCustom for general binding on " + loader.getClass().getName());
                        }
                        loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, generalBinding, psConfig);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Back from loadCustom on " + loader.getClass().getName());
                        continue;
                    }
                    if (bindingName != null) {
                        policyTypeBinding = BindingAggregator.getCustomBindingInputStream(rootDir, bindingName, loader.getType());
                    }
                    if (version.equals("6.1.0.0")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to call loadCustom and sending 6.1 default bindings on " + loader.getClass().getName());
                        }
                        loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, default61Binding, psConfig);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to call loadCustom and using 7.0 default bindings on " + loader.getClass().getName());
                        }
                        if (type.equals("application")) {
                            loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, appDefaultBinding, psConfig);
                        } else {
                            loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, clientDefaultBinding, psConfig);
                        }
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Back from loadCustom on " + loader.getClass().getName());
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, className, FFDC_ID_5);
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, className, FFDC_ID_6);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomBinding");
        }
    }

    private static List getExtensions() throws Throwable {
        if (extensions == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading policy binding loader extensions");
            }
            extensions = new ArrayList();
            try {
                String extensionPointId = PolicySetUtil.isClient() ? "com.ibm.wsfp.thinclient.ibmaxis2-qos-bindingloader" : "com.ibm.wsfp.main.ibmaxis2-qos-bindingloader";
                IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
                IConfigurationElement[] elements = registry.getConfigurationElementsFor(extensionPointId);
                if (elements.length == 0 && PolicySetUtil.isClient()) {
                    extensionPointId = "com.ibm.wsfp.main.ibmaxis2-qos-bindingloader";
                    elements = registry.getConfigurationElementsFor(extensionPointId);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found " + elements.length + " extensions for " + extensionPointId);
                }
                HashMap properties = new HashMap();
                for (int i = 0; i < elements.length; ++i) {
                    try {
                        String classname = elements[i].getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found " + classname);
                        }
                        Class<?> loaderClass = Class.forName(classname);
                        Constructor<?> constructor = loaderClass.getConstructor(new Class[0]);
                        BindingLoader loader = (BindingLoader)constructor.newInstance(new Object[0]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to call init on " + classname);
                        }
                        loader.init(properties);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Back from init on " + classname);
                        }
                        extensions.add(loader);
                        continue;
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException(t, className, FFDC_ID_3);
                    }
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, className, FFDC_ID_4);
                throw t;
            }
        }
        return extensions;
    }

    public static InputStream get61DefaultBindingInputStream(String policyType) {
        FileLocator locator = FileLocatorFactory.getFileLocator();
        String path = locator.get61DefaultBindingPath(policyType);
        InputStream input = FileAccessor.getInputStream(path);
        return input;
    }

    public static InputStream getDefaultBindingInputStream(String policyType, String bindingName) {
        FileLocator locator = FileLocatorFactory.getFileLocator();
        String path = locator.getDefaultBindingPath(policyType, bindingName);
        InputStream input = FileAccessor.getInputStream(path);
        return input;
    }

    public static InputStream getGeneralBindingInputStream(String policyType, String bindingName) {
        FileLocator locator = FileLocatorFactory.getFileLocator();
        String path = locator.getGeneralBindingPath(policyType, bindingName);
        InputStream input = FileAccessor.getInputStream(path);
        return input;
    }

    public static InputStream getCustomBindingInputStream(String rootDir, String bindingName, String policyType) {
        FileLocator locator = FileLocatorFactory.getFileLocator();
        String path = locator.getCustomBindingPath(rootDir, bindingName, policyType);
        InputStream input = FileAccessor.getInputStream(path);
        return input;
    }

    public static String getDefaultBindingName(String type) throws Throwable {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking up default binding file");
        }
        Properties bindingNames = new Properties();
        String defaultBinding = null;
        String path = FileLocatorFactory.getFileLocator().getDefaultBindingsFilePath();
        final InputStream istream = FileAccessor.getInputStream(path);
        if (istream != null) {
            final String node = FileLocatorFactory.getFileLocator().getResourceName("node");
            final String server = FileLocatorFactory.getFileLocator().getResourceName("server");
            try {
                bindingNames = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoItemFoundException {
                        DefaultBindingsHelper bindingsHelper = DefaultBindingsHelperFactory.createHelper(istream);
                        Properties props = bindingsHelper.getServerDefaults(server, node);
                        return props;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException(e, "com.ibm.ws.policyset.runtime.BindingAggregator", FFDC_ID_7);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception thrown in getServerDefaults");
                }
                throw e.getException();
            }
            boolean checkGlobalDefaults = false;
            boolean checkDomainDefaults = false;
            if (bindingNames != null && !bindingNames.isEmpty()) {
                defaultBinding = type.equals("application") ? bindingNames.getProperty("provider") : bindingNames.getProperty("client");
                if (defaultBinding == null) {
                    checkDomainDefaults = true;
                } else if (defaultBinding.equals("")) {
                    checkDomainDefaults = true;
                }
            } else {
                checkDomainDefaults = true;
            }
            if (checkDomainDefaults) {
                final String domain = BindingAggregator.getDomainForServer();
                if (domain != null) {
                    final InputStream instream = FileAccessor.getInputStream(path);
                    try {
                        bindingNames = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoItemFoundException {
                                DefaultBindingsHelper bindingsHelper = DefaultBindingsHelperFactory.createHelper(instream);
                                Properties props = bindingsHelper.getDomainDefaults(domain);
                                return props;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException(e, "com.ibm.ws.policyset.runtime.BindingAggregator", FFDC_ID_8);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception thrown in getServerDefaults");
                        }
                        throw e.getException();
                    }
                    if (bindingNames != null && !bindingNames.isEmpty()) {
                        defaultBinding = type.equals("application") ? bindingNames.getProperty("provider") : bindingNames.getProperty("client");
                        if (defaultBinding == null) {
                            checkGlobalDefaults = true;
                        } else if (defaultBinding.equals("")) {
                            checkGlobalDefaults = true;
                        }
                    } else {
                        checkGlobalDefaults = true;
                    }
                } else {
                    checkGlobalDefaults = true;
                }
            }
            if (checkGlobalDefaults) {
                final InputStream instream = FileAccessor.getInputStream(path);
                try {
                    bindingNames = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoItemFoundException {
                            DefaultBindingsHelper bindingsHelper = DefaultBindingsHelperFactory.createHelper(instream);
                            Properties props = bindingsHelper.getDomainDefaults("global");
                            return props;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.policyset.runtime.BindingAggregator", FFDC_ID_14);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception thrown in getServerDefaults");
                    }
                    throw e.getException();
                }
            }
        }
        if (bindingNames != null && !bindingNames.isEmpty() && (defaultBinding = type.equals("application") ? bindingNames.getProperty("provider") : bindingNames.getProperty("client")) != null && defaultBinding.equals("")) {
            defaultBinding = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultBindingNames", defaultBinding);
        }
        return defaultBinding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDomainForServer() throws Exception, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainForServer");
        }
        String domain = null;
        boolean pushed = false;
        try {
            pushed = SecurityObjectLocator.pushContext("", "application");
            domain = SecurityObjectLocator.getSecurityConfigManager().getDomainName();
        }
        finally {
            if (pushed) {
                SecurityObjectLocator.popContext();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainForServer, domain=" + domain);
        }
        return domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized DefaultBinding getGeneralBinding(ClassLoader systemCL, String bindingName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGeneralBinding, bindingName = " + bindingName);
        }
        boolean loadedBinding = false;
        DefaultBinding generalBinding = null;
        Integer n = defaultBindingLock;
        synchronized (n) {
            generalBinding = (DefaultBinding)bindingsMap.get(bindingName);
            if (generalBinding == null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "General binding not already loaded; need to load it");
                    }
                    generalBinding = new DefaultBindingImpl();
                    List extensions = BindingAggregator.getExtensions();
                    VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
                    for (BindingLoader loader : extensions) {
                        try {
                            InputStream policyTypeBinding = BindingAggregator.getGeneralBindingInputStream(loader.getType(), bindingName);
                            if (policyTypeBinding == null) continue;
                            loader.loadDefault(systemCL, variableExpander, policyTypeBinding, generalBinding);
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException(t, className, FFDC_ID_15);
                        }
                    }
                    loadedBinding = true;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, className, FFDC_ID_16);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGeneralBinding");
        }
        if (loadedBinding && bindingName != null) {
            bindingsMap.put(bindingName, generalBinding);
        }
        return generalBinding;
    }

    private static String getModuleTargetVersion() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleTargetVersion");
        }
        final String node = FileLocatorFactory.getFileLocator().getResourceName("node");
        String baseVersion = null;
        try {
            baseVersion = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
                    return helper.getNodeBaseProductVersion(node);
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException(e, "com.ibm.ws.policyset.runtime.BindingAggregator", FFDC_ID_18);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown in getModuleTargetVersion - ManagedObjectMetadataAccessorFactory.createAccessor()");
            }
            throw e.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleTargetVersion, baseVersion = " + baseVersion);
        }
        return baseVersion;
    }

    private static String getCustomBindingVersion(String rootDir) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomBindingVersion, rootDir = " + rootDir);
        }
        String version = "7.0.0.0";
        final File appfile = new File(rootDir);
        File[] appFiles = (File[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File[] files = null;
                if (appfile.exists()) {
                    files = appfile.listFiles();
                }
                return files;
            }
        });
        if (appFiles != null) {
            for (int i = 0; i < appFiles.length && version.equals("7.0.0.0"); ++i) {
                FilenameFilter policyTypesFilter;
                String[] policyTypes;
                final File bindingFile = appFiles[i];
                Boolean fileIsDirectory = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        boolean checkDirectory = bindingFile.isDirectory();
                        return checkDirectory;
                    }
                });
                boolean isDirectory = fileIsDirectory;
                if (!isDirectory || (policyTypes = (String[])AccessController.doPrivileged(new PrivilegedAction(policyTypesFilter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.contains("PolicyTypes");
                    }
                }){
                    final /* synthetic */ FilenameFilter val$policyTypesFilter;
                    {
                        this.val$policyTypesFilter = filenameFilter;
                    }

                    public Object run() {
                        return bindingFile.list(this.val$policyTypesFilter);
                    }
                })).length <= 0) continue;
                final FilenameFilter bindingDefFilter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.contains("bindingDefinition.xml");
                    }
                };
                File[] bindingDefList = (File[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return bindingFile.listFiles(bindingDefFilter);
                    }
                });
                if (bindingDefList.length > 0) {
                    File bindingDef = bindingDefList[0];
                    String path = bindingDef.toString();
                    final InputStream instream = FileAccessor.getInputStream(path);
                    try {
                        version = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoItemFoundException {
                                BindingDefinitionHelper bindingDefHelper = BindingDefinitionHelperFactory.createHelper(instream);
                                return bindingDefHelper.getVersion();
                            }
                        });
                        continue;
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException(e, "com.ibm.ws.policyset.runtime.BindingAggregator", FFDC_ID_17);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception thrown in getServerDefaults");
                        }
                        throw e.getException();
                    }
                }
                version = "6.1.0.0";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomBindingVersion, version = " + version);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refresh() {
        Integer n = defaultBindingLock;
        synchronized (n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resetting default bindings and bindings map");
            }
            default61Binding = null;
            appDefaultBinding = null;
            clientDefaultBinding = null;
            bindingsMap = null;
        }
    }
}

