/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.xmlns.prod.websphere._200605.policyset.NamespacePrefixMapperImpl;
import com.ibm.xmlns.prod.websphere._200605.policyset.PolicySet;
import com.ibm.xmlns.prod.websphere._200605.policyset.PolicyType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetHelperImpl
implements PolicySetHelper,
PolicyConstants {
    private String fileName = null;
    private PolicySet policySet = null;
    private int rc = 0;
    private boolean fileLoaded = false;
    protected String className = this.getClass().getName();
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private boolean readOnly = false;
    private static Locale _locale = null;
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
    private static ResourceBundle resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String[] supportedAttributes = new String[]{"name", "description", "default", "type", "version"};
    private static TraceComponent tc = Tr.register(PolicySetHelperImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");

    public PolicySetHelperImpl(String fileName) {
        this.fileName = fileName;
    }

    public PolicySetHelperImpl(InputStream istream) {
        this.inputStream = istream;
        this.readOnly = true;
    }

    public PolicySetHelperImpl(InputStream istream, OutputStream outStream) {
        this.inputStream = istream;
        this.outputStream = outStream;
    }

    private void loadData() throws JAXBException, FileNotFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadData for file " + this.fileName);
        }
        this.policySet = null;
        InputStream istream = this.inputStream;
        boolean createdStream = false;
        try {
            if (istream == null) {
                if (this.fileName != null) {
                    istream = new FileInputStream(this.fileName);
                    createdStream = true;
                } else {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
                }
            }
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200605.policyset");
            Unmarshaller um = jc.createUnmarshaller();
            this.policySet = (PolicySet)um.unmarshal(istream);
            if (createdStream) {
                istream.close();
            }
        }
        catch (JAXBException jaxe) {
            FFDCFilter.processException(jaxe, this.className, FFDC_ID_1);
            Tr.error(tc, "CWPST0001E", new Object[]{jaxe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught JAXBException while parsing file");
                jaxe.printStackTrace();
            }
            if (createdStream) {
                istream.close();
            }
            throw jaxe;
        }
        catch (FileNotFoundException fnfe) {
            FFDCFilter.processException(fnfe, this.className, FFDC_ID_2);
            Tr.error(tc, "CWPST0001E", new Object[]{fnfe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught FileNotFoundException while parsing file");
                fnfe.printStackTrace();
            }
            throw fnfe;
        }
        catch (IOException ioe) {
            FFDCFilter.processException(ioe, this.className, FFDC_ID_7);
            Tr.error(tc, "CWPST0001E", new Object[]{ioe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught IOException while parsing file");
                ioe.printStackTrace();
            }
            throw ioe;
        }
        this.fileLoaded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadData for file " + this.fileName);
        }
    }

    private int saveData() throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveData for file " + this.fileName);
        }
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        int retCode = 0;
        OutputStream outStream = this.outputStream;
        boolean createdStream = false;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200605.policyset");
            if (outStream == null) {
                outStream = new FileOutputStream(this.fileName);
                createdStream = true;
            }
            Marshaller m = jc.createMarshaller();
            try {
                m.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            m.marshal((Object)this.policySet, outStream);
            if (createdStream) {
                outStream.close();
            }
        }
        catch (JAXBException jaxe) {
            FFDCFilter.processException(jaxe, this.className, FFDC_ID_3);
            Tr.error(tc, "CWPST0002E", new Object[]{jaxe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught JAXBException while writing file");
                jaxe.printStackTrace();
            }
            if (createdStream) {
                outStream.close();
            }
            throw jaxe;
        }
        catch (FileNotFoundException fnfe) {
            FFDCFilter.processException(fnfe, this.className, FFDC_ID_4);
            Tr.error(tc, "CWPST0002E", new Object[]{fnfe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught FileNotFoundException while writing file");
                fnfe.printStackTrace();
            }
            throw fnfe;
        }
        catch (IllegalArgumentException iae) {
            FFDCFilter.processException(iae, this.className, FFDC_ID_5);
            Tr.error(tc, "CWPST0002E", new Object[]{iae.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IllegalArgumentException while writing file");
                iae.printStackTrace();
            }
            if (outStream != null && createdStream) {
                outStream.close();
            }
            throw iae;
        }
        catch (IOException ioe) {
            FFDCFilter.processException(ioe, this.className, FFDC_ID_6);
            Tr.error(tc, "CWPST0002E", new Object[]{ioe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IOException while writing file");
                ioe.printStackTrace();
            }
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveData for file " + this.fileName);
        }
        return retCode;
    }

    @Override
    public Properties getPolicySet() throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        Properties props = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySet != null) {
            String description;
            props = new Properties();
            if (this.policySet.getName() == null) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"name", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
            props.setProperty("name", this.policySet.getName());
            if (this.policySet.getDefault() == null) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"default", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
            props.setProperty("default", this.policySet.getDefault());
            if (this.policySet.getDescription() != null) {
                description = this.policySet.getDescription();
                if (description.startsWith("$KEY_")) {
                    String keyname = description.substring(5);
                    description = resourceBundle2.getString(keyname);
                }
            } else {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"description", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
            props.setProperty("description", description);
            if (this.policySet.getType() == null) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"type", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
            props.setProperty("type", this.policySet.getType());
            if (this.policySet.getVersion() != null) {
                props.setProperty("version", this.policySet.getVersion());
            }
        }
        return props;
    }

    @Override
    public PolicySet getPolicySetObject() throws JAXBException, FileNotFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        if (!this.fileLoaded) {
            this.loadData();
        }
        return this.policySet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int createPolicySet(String policySetDescription, String policySetType) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        String policySetName = null;
        this.rc = 0;
        if (this.fileName == null || !this.fileName.contains("policySet.xml")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0080E", new Object[]{this.fileName}, "The following file name is invalid: {0}"));
        String dirName = this.fileName.substring(0, this.fileName.indexOf("policySet.xml") - 1);
        policySetName = dirName.substring(dirName.lastIndexOf(File.separator) + 1);
        if (policySetName == null || policySetName.equals("")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
        this.policySet = new PolicySet();
        this.policySet.setName(policySetName);
        if (policySetDescription != null) {
            this.policySet.setDescription(policySetDescription);
        } else {
            this.policySet.setDescription("");
        }
        if (policySetType != null) {
            if (!policySetType.equals("application") && !policySetType.equals("system/trust") && !policySetType.equals("system")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0076E", new Object[]{policySetType}, "Policy set type is invalid: {0}"));
            this.policySet.setType(policySetType);
        } else {
            this.policySet.setType("application");
        }
        this.policySet.setDefault("false");
        this.policySet.setVersion("7.0.0.0");
        this.rc = this.saveData();
        if (!tc.isDebugEnabled()) return this.rc;
        Tr.debug(tc, "createPolicySet, rc = " + this.rc);
        return this.rc;
    }

    @Override
    public int updatePolicySet(Properties updatedValues, boolean allowNameChange) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (updatedValues != null && !updatedValues.isEmpty()) {
            if (!this.fileLoaded) {
                this.loadData();
            }
            if (this.policySet != null) {
                boolean isValid = true;
                String attribKey = null;
                Enumeration<?> keys = updatedValues.propertyNames();
                while (keys.hasMoreElements() && isValid) {
                    attribKey = (String)keys.nextElement();
                    isValid = this.isSupported(attribKey);
                }
                if (!isValid) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0077E", new Object[]{attribKey}, "Attribute is invalid: {0}"));
                }
                String attribValue = updatedValues.getProperty("name");
                if (attribValue != null) {
                    if (allowNameChange) {
                        this.policySet.setName(attribValue);
                    } else {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0078E", new Object[0], "The policy set name cannot be changed"));
                    }
                }
                if ((attribValue = updatedValues.getProperty("description")) != null) {
                    this.policySet.setDescription(attribValue);
                }
                if ((attribValue = updatedValues.getProperty("default")) != null) {
                    this.policySet.setDefault(attribValue);
                }
                if ((attribValue = updatedValues.getProperty("type")) != null) {
                    if (attribValue.equals("application") || attribValue.equals("system/trust") || attribValue.equals("system")) {
                        this.policySet.setType(attribValue);
                    } else {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0076E", new Object[]{attribValue}, "Policy set type is invalid: {0}"));
                    }
                }
                if ((attribValue = updatedValues.getProperty("version")) != null) {
                    this.policySet.setVersion(attribValue);
                }
                this.rc = this.saveData();
            }
        } else {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updatePolicySet, rc = " + this.rc);
        }
        return this.rc;
    }

    @Override
    public int addPolicyType(String policyType, boolean enable) throws JAXBException, FileNotFoundException, IllegalArgumentException, DuplicateItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        boolean ableToAdd = true;
        if (policyType != null && !policyType.equals("")) {
            List policyTypes = this.processPolicyTypes();
            if (policyTypes != null && !policyTypes.isEmpty()) {
                for (int i = 0; i < policyTypes.size() && ableToAdd; ++i) {
                    PolicyType policy = (PolicyType)policyTypes.get(i);
                    if (!policy.getType().equals(policyType)) continue;
                    ableToAdd = false;
                    this.rc = -3;
                    throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0082E", new Object[]{policyType}, "Policy type already exists: {0}"));
                }
            }
            if (ableToAdd && this.rc == 0) {
                PolicyType newPolicyType = new PolicyType();
                newPolicyType.setType(policyType);
                if (enable) {
                    newPolicyType.setEnabled("true");
                } else {
                    newPolicyType.setEnabled("false");
                }
                newPolicyType.setProvides("");
                this.policySet.getPolicyType().add(newPolicyType);
                this.rc = this.saveData();
            }
        } else {
            this.rc = -7;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{policyType}, "Input parameter is invalid: {0}"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addPolicyType, rc = " + this.rc + ", policyType = " + policyType);
        }
        return this.rc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int deletePolicyType(String policyType) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        boolean typeFound = false;
        if (policyType != null && !policyType.equals("")) {
            List policyTypes = this.processPolicyTypes();
            if (policyTypes != null && !policyTypes.isEmpty()) {
                for (int i = 0; i < policyTypes.size() && !typeFound; ++i) {
                    PolicyType policy = (PolicyType)policyTypes.get(i);
                    if (!policy.getType().equals(policyType)) continue;
                    typeFound = true;
                    policyTypes.remove(i);
                }
            } else {
                this.rc = -4;
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{policyType}, "Policy type not found: {0}"));
            }
            if (this.rc == 0) {
                if (!typeFound) {
                    this.rc = -4;
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{policyType}, "Policy type not found: {0}"));
                }
                this.rc = this.saveData();
            }
        } else {
            this.rc = -7;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{policyType}, "Input parameter is invalid: {0}"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deletePolicyType, rc = " + this.rc + ", policyType = " + policyType);
        }
        return this.rc;
    }

    @Override
    public List<String> listPolicyTypes() throws JAXBException, FileNotFoundException, IOException {
        return this.listPolicyTypes(false);
    }

    @Override
    public List<String> listEnabledPolicyTypes() throws JAXBException, FileNotFoundException, IOException {
        return this.listPolicyTypes(true);
    }

    private List<String> listPolicyTypes(boolean limitToEnabled) throws JAXBException, FileNotFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        ArrayList<String> returnList = null;
        this.rc = 0;
        List policyTypes = this.processPolicyTypes();
        if (policyTypes != null && !policyTypes.isEmpty()) {
            returnList = new ArrayList<String>(policyTypes.size());
            for (int i = 0; i < policyTypes.size(); ++i) {
                PolicyType policy = (PolicyType)policyTypes.get(i);
                String enabled = policy.getEnabled();
                if (enabled == null) {
                    enabled = "true";
                }
                if (limitToEnabled && !enabled.equals("true")) continue;
                returnList.add(policy.getType());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "listPolicyTypes, rc = " + this.rc);
        }
        return returnList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Properties getPolicyType(String policyType, String[] attributes) throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        List policyTypes;
        String description;
        boolean typeFound;
        Properties props;
        block11: {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
            resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
            props = null;
            this.rc = 0;
            typeFound = false;
            description = "";
            if (policyType != null && !policyType.equals("")) {
                policyTypes = this.processPolicyTypes();
                if (policyTypes != null && !policyTypes.isEmpty()) {
                    break block11;
                } else {
                    this.rc = -4;
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{policyType}, "Policy type not found: {0}"));
                }
            }
            this.rc = -7;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{policyType}, "Input parameter is invalid: {0}"));
        }
        for (int i = 0; i < policyTypes.size() && !typeFound; ++i) {
            PolicyType policy = (PolicyType)policyTypes.get(i);
            if (!policy.getType().equals(policyType)) continue;
            typeFound = true;
            props = new Properties();
            if (attributes != null && attributes.length != 0) {
                for (int j = 0; j < attributes.length; ++j) {
                    if ("type".equals(attributes[j])) {
                        props.setProperty("type", policy.getType());
                    }
                    if ("provides".equals(attributes[j])) {
                        props.setProperty("provides", policy.getProvides());
                    }
                    if ("enabled".equals(attributes[j])) {
                        props.setProperty("enabled", policy.getEnabled());
                    }
                    if (!"description".equals(attributes[j])) continue;
                    description = resourceBundle2.getString(policyType + ".description");
                    props.setProperty("description", description);
                }
                continue;
            }
            props.setProperty("type", policy.getType());
            props.setProperty("provides", policy.getProvides());
            props.setProperty("enabled", policy.getEnabled());
            description = resourceBundle2.getString(policyType + ".description");
            props.setProperty("description", description);
        }
        if (!typeFound) {
            this.rc = -4;
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{policyType}, "Policy type not found: {0}"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicyType, rc = " + this.rc + ", policyType = " + policyType);
        }
        return props;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int setPolicyType(String policyType, Properties updatedValues) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        block9: {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
            resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
            if (this.readOnly) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
            }
            this.rc = 0;
            boolean typeFound = false;
            if (policyType != null && !policyType.equals("") && updatedValues != null && !updatedValues.isEmpty()) {
                List policyTypes = this.processPolicyTypes();
                if (policyTypes != null && !policyTypes.isEmpty()) {
                    for (int i = 0; i < policyTypes.size() && !typeFound; ++i) {
                        String enabledValue;
                        PolicyType policy = (PolicyType)policyTypes.get(i);
                        if (!policy.getType().equals(policyType)) continue;
                        typeFound = true;
                        String providesValue = updatedValues.getProperty("provides");
                        if (providesValue != null) {
                            policy.setProvides(providesValue);
                        }
                        if ((enabledValue = updatedValues.getProperty("enabled")) != null) {
                            policy.setEnabled(enabledValue);
                        }
                        this.policySet.getPolicyType().set(i, policy);
                        this.rc = this.saveData();
                    }
                    if (!typeFound) {
                        this.rc = -4;
                        throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{policyType}, "Policy type not found: {0}"));
                    }
                    break block9;
                } else {
                    this.rc = -4;
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{policyType}, "Policy type not found: {0}"));
                }
            }
            this.rc = -7;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setPolicyType, rc = " + this.rc + ", policyType = " + policyType);
        }
        return this.rc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getPolicyTypeAttribute(String policyType, String attributeName) throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        String attributeValue;
        block9: {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
            resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
            attributeValue = null;
            this.rc = 0;
            boolean typeFound = false;
            if (policyType != null && !policyType.equals("") && attributeName != null && !attributeName.equals("")) {
                List policyTypes = this.processPolicyTypes();
                if (policyTypes != null && !policyTypes.isEmpty()) {
                    for (int i = 0; i < policyTypes.size() && !typeFound; ++i) {
                        PolicyType policy = (PolicyType)policyTypes.get(i);
                        if (!policy.getType().equals(policyType)) continue;
                        typeFound = true;
                        if (attributeName.equals("type")) {
                            attributeValue = policy.getType();
                        }
                        if (attributeName.equals("provides")) {
                            attributeValue = policy.getProvides();
                        }
                        if (attributeName.equals("enabled")) {
                            attributeValue = policy.getEnabled();
                        }
                        if (!attributeName.equals("description")) continue;
                        attributeValue = resourceBundle2.getString(policyType + ".description");
                    }
                    if (!typeFound) {
                        this.rc = -4;
                        throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{policyType}, "Policy type not found: {0}"));
                    }
                    break block9;
                } else {
                    this.rc = -4;
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{policyType}, "Policy type not found: {0}"));
                }
            }
            this.rc = -7;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicyTypeAttribute, rc = " + this.rc + ", policyType = " + policyType);
        }
        return attributeValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int setPolicyTypeAttribute(String policyType, String attributeName, String attributeValue) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        List policyTypes;
        boolean typeFound;
        block11: {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
            resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
            if (this.readOnly) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
            }
            this.rc = 0;
            typeFound = false;
            if (attributeValue == null) {
                attributeValue = "";
            }
            if (policyType != null && !policyType.equals("") && attributeName != null && !attributeName.equals("")) {
                policyTypes = this.processPolicyTypes();
                if (policyTypes != null && !policyTypes.isEmpty()) {
                    break block11;
                } else {
                    this.rc = -4;
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{policyType}, "Policy type not found: {0}"));
                }
            }
            this.rc = -7;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        for (int i = 0; i < policyTypes.size() && !typeFound; ++i) {
            PolicyType policy = (PolicyType)policyTypes.get(i);
            if (!policy.getType().equals(policyType)) continue;
            typeFound = true;
            if (attributeName.equals("type")) {
                this.rc = -7;
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0079E", new Object[0], "The policy type cannot be changed"));
            }
            if (attributeName.equals("provides")) {
                policy.setProvides(attributeValue);
            }
            if (attributeName.equals("enabled")) {
                policy.setEnabled(attributeValue);
            }
            this.policySet.getPolicyType().set(i, policy);
            this.rc = this.saveData();
        }
        if (!typeFound) {
            this.rc = -4;
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0081E", new Object[]{policyType}, "Policy type not found: {0}"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setPolicyTypeAttribute, rc = " + this.rc + ", policyType = " + policyType);
        }
        return this.rc;
    }

    @Override
    public boolean isDefaultPolicySet() throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        boolean defaultPolicy = false;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySet != null) {
            if (this.policySet.getDefault() != null) {
                if (this.policySet.getDefault().equals("true")) {
                    defaultPolicy = true;
                }
            } else {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"default", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
        }
        return defaultPolicy;
    }

    @Override
    public String getPolicySetType() throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", PolicySetHelperImpl.getLocale());
        String type = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySet != null) {
            if (this.policySet.getType() != null) {
                type = this.policySet.getType();
            } else {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"type", PolicySetHelperImpl.getPolicySetName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
        }
        return type;
    }

    @Override
    public void setLocale(Locale locale) {
        _locale = locale;
    }

    private static Locale getLocale() {
        if (_locale == null) {
            return Locale.getDefault();
        }
        return _locale;
    }

    private List processPolicyTypes() throws JAXBException, FileNotFoundException, IOException {
        List<PolicyType> policyTypes = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySet != null) {
            policyTypes = this.policySet.getPolicyType();
        } else {
            this.rc = -1;
        }
        return policyTypes;
    }

    private boolean isSupported(String attribute) {
        for (int i = 0; i < supportedAttributes.length; ++i) {
            if (!supportedAttributes[i].equals(attribute)) continue;
            return true;
        }
        return false;
    }

    private static String getPolicySetName(String filePath) {
        String dirName = null;
        if (filePath != null) {
            int index = filePath.lastIndexOf(File.separatorChar);
            String str1 = filePath.substring(0, index);
            index = str1.lastIndexOf(File.separatorChar);
            dirName = str1.substring(index + 1);
        }
        return dirName;
    }
}

