/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.NamespacePrefixMapperImpl;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetBinding;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetAttachmentHelperImpl
implements PolicySetAttachmentHelper,
PolicyConstants {
    private String fileName = null;
    private int rc = 0;
    private boolean fileLoaded = false;
    private PolicySetAttachment policySetAttachment = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private boolean readOnly = false;
    private static Locale _locale = null;
    protected String className = this.getClass().getName();
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static TraceComponent tc = Tr.register(PolicySetAttachmentHelperImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");

    public PolicySetAttachmentHelperImpl(String fileName) {
        this.fileName = fileName;
    }

    public PolicySetAttachmentHelperImpl(InputStream istream) {
        this.inputStream = istream;
        this.readOnly = true;
    }

    public PolicySetAttachmentHelperImpl(InputStream istream, OutputStream outStream, String fileName) {
        this.inputStream = istream;
        this.fileName = fileName;
        this.outputStream = outStream;
    }

    private void loadData() throws JAXBException, FileNotFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadData for file " + this.fileName);
        }
        this.policySetAttachment = null;
        InputStream istream = null;
        boolean createdStream = false;
        try {
            istream = this.inputStream;
            if (istream == null) {
                if (this.fileName != null) {
                    istream = new FileInputStream(this.fileName);
                    createdStream = true;
                } else {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
                }
            }
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200605.policysetattachment");
            Unmarshaller um = jc.createUnmarshaller();
            this.policySetAttachment = (PolicySetAttachment)um.unmarshal(istream);
            if (createdStream) {
                istream.close();
            }
        }
        catch (JAXBException jaxe) {
            FFDCFilter.processException(jaxe, this.className, FFDC_ID_1);
            Tr.error(tc, "CWPST0001E", new Object[]{jaxe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught JAXBException while parsing file");
                jaxe.printStackTrace();
            }
            if (createdStream) {
                istream.close();
            }
            throw jaxe;
        }
        catch (FileNotFoundException fnfe) {
            FFDCFilter.processException(fnfe, this.className, FFDC_ID_2);
            Tr.error(tc, "CWPST0001E", new Object[]{fnfe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught FileNotFoundException while parsing file");
                fnfe.printStackTrace();
            }
            throw fnfe;
        }
        catch (IOException ioe) {
            FFDCFilter.processException(ioe, this.className, FFDC_ID_7);
            Tr.error(tc, "CWPST0001E", new Object[]{ioe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught IOException while parsing file");
                ioe.printStackTrace();
            }
            throw ioe;
        }
        this.fileLoaded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadData for file " + this.fileName);
        }
    }

    private int saveData() throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveData for file " + this.fileName);
        }
        int retCode = 0;
        OutputStream outStream = this.outputStream;
        boolean createdStream = false;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200605.policysetattachment");
            if (outStream == null) {
                outStream = new FileOutputStream(this.fileName);
                createdStream = true;
            }
            Marshaller m = jc.createMarshaller();
            try {
                m.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            m.marshal((Object)this.policySetAttachment, outStream);
            if (createdStream) {
                outStream.close();
            }
        }
        catch (JAXBException jaxe) {
            FFDCFilter.processException(jaxe, this.className, FFDC_ID_3);
            Tr.error(tc, "CWPST0002E", new Object[]{jaxe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught JAXBException while writing file");
                jaxe.printStackTrace();
            }
            if (createdStream) {
                outStream.close();
            }
            throw jaxe;
        }
        catch (FileNotFoundException fnfe) {
            FFDCFilter.processException(fnfe, this.className, FFDC_ID_4);
            Tr.error(tc, "CWPST0002E", new Object[]{fnfe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught FileNotFoundException while writing file");
                fnfe.printStackTrace();
            }
            throw fnfe;
        }
        catch (IllegalArgumentException iae) {
            FFDCFilter.processException(iae, this.className, FFDC_ID_5);
            Tr.error(tc, "CWPST0002E", new Object[]{iae.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IllegalArgumentException while writing file");
                iae.printStackTrace();
            }
            if (outStream != null && createdStream) {
                outStream.close();
            }
            throw iae;
        }
        catch (IOException ioe) {
            FFDCFilter.processException(ioe, this.className, FFDC_ID_6);
            Tr.error(tc, "CWPST0002E", new Object[]{ioe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IOException while writing file");
                ioe.printStackTrace();
            }
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveData for file " + this.fileName);
        }
        return retCode;
    }

    @Override
    public int createPolicySetAttachment() throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (this.fileName == null) {
            this.rc = -6;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
        }
        this.policySetAttachment = new PolicySetAttachment();
        this.rc = this.saveData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createPolicySetAttachment, rc = " + this.rc);
        }
        return this.rc;
    }

    @Override
    public int createPolicySetAttachment(PolicySetAttachment policyAttachment) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (this.fileName == null) {
            this.rc = -6;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
        }
        this.policySetAttachment = policyAttachment;
        this.rc = this.saveData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createPolicySetAttachment(policyAttachment), rc = " + this.rc);
        }
        return this.rc;
    }

    @Override
    public PolicySetAttachment getPolicySetAttachmentObject() throws JAXBException, FileNotFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (!this.fileLoaded) {
            this.loadData();
        }
        return this.policySetAttachment;
    }

    @Override
    public boolean isAttachedToPolicySet(String policySetName) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        boolean isAttached = false;
        if (policySetName != null && !policySetName.equals("")) {
            List<PolicySetReference> policyReferences = this.returnPolicyReferences(policySetName, "name");
            if (policyReferences != null && !policyReferences.isEmpty()) {
                isAttached = true;
            }
        } else {
            this.rc = -7;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{policySetName}, "Input parameter is invalid: {0}"));
        }
        return isAttached;
    }

    @Override
    public boolean isAttachmentListEmpty() throws JAXBException, FileNotFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        boolean isEmpty = true;
        List<PolicySetReference> policyReferences = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySetAttachment != null && (policyReferences = this.policySetAttachment.getPolicySetReference()) != null && !policyReferences.isEmpty()) {
            isEmpty = false;
        }
        return isEmpty;
    }

    @Override
    public List<Properties> getPolicySetAttachments(String policySetName) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        ArrayList<Properties> returnList = null;
        this.rc = 0;
        List<PolicySetReference> policyReferences = this.returnPolicyReferences(policySetName, "name");
        if (policyReferences != null && !policyReferences.isEmpty()) {
            returnList = this.returnAttachments(policyReferences);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicySetAttachments(String), rc = " + this.rc);
        }
        return returnList;
    }

    @Override
    public List<Properties> getPolicySetAttachments() throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        ArrayList<Properties> returnList = null;
        List<PolicySetReference> policyReferences = null;
        this.rc = 0;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySetAttachment != null && (policyReferences = this.policySetAttachment.getPolicySetReference()) != null && !policyReferences.isEmpty()) {
            returnList = this.returnAttachments(policyReferences);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPolicySetAttachments(), rc = " + this.rc);
        }
        return returnList;
    }

    @Override
    public String attachPolicySet(String policySetName, String attachmentType, String[] resources) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        String id = null;
        if (policySetName != null && !policySetName.equals("") && resources != null) {
            if (!this.fileLoaded) {
                this.loadData();
            }
        } else {
            this.rc = -7;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        id = this.createAttachmentId(attachmentType);
        List<Resource> newResources = this.convertResourceList(resources);
        PolicySetReference psetRef = new PolicySetReference();
        psetRef.setName(policySetName);
        psetRef.setId(id);
        psetRef.getResource().addAll(newResources);
        this.policySetAttachment.getPolicySetReference().add(psetRef);
        this.rc = this.saveData();
        return id;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int updatePolicySetAttachment(String attachmentId, String[] resources, int operation) throws JAXBException, FileNotFoundException, IllegalArgumentException, DuplicateItemFoundException, NoItemFoundException, IOException {
        boolean providerPolicySetEnabled;
        PolicySetReference policyRef;
        block16: {
            int len$;
            String[] arr$;
            block17: {
                block14: {
                    block15: {
                        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
                        if (this.readOnly) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
                        }
                        this.rc = 0;
                        if (attachmentId == null || attachmentId.equals("") || resources == null) break block14;
                        List<PolicySetReference> policyReferences = this.returnPolicyReferences(attachmentId, "id");
                        if (policyReferences == null || policyReferences.isEmpty()) break block15;
                        if (policyReferences.size() != 1) {
                            this.rc = -9;
                            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0072E", new Object[]{attachmentId}, "More than one attachment found with id: {0}"));
                        }
                        policyRef = policyReferences.get(0);
                        providerPolicySetEnabled = false;
                        for (Resource resource : policyRef.getResource()) {
                            if (this.getIdForProviderPolicySetAttachment(resource.getPattern()) == null) continue;
                            providerPolicySetEnabled = true;
                            break;
                        }
                        if (providerPolicySetEnabled && resources.length > 1) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0144E", new Object[0], "Multiple resources are not valid when provider policy set is enabled."));
                        }
                        if (operation != 1 && operation != 2) break block16;
                        if (providerPolicySetEnabled) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0145E", new Object[0], "Unable to add nor replace resources when provider policy set is enabled."));
                        }
                        arr$ = resources;
                        len$ = arr$.length;
                        break block17;
                    }
                    this.rc = -8;
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{attachmentId}, "Attachment not found: {0}"));
                }
                this.rc = -7;
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
            }
            for (int i$ = 0; i$ < len$; ++i$) {
                String resource = arr$[i$];
                if (this.getIdForProviderPolicySetAttachment(resource) == null) continue;
                providerPolicySetEnabled = true;
                break;
            }
            if (providerPolicySetEnabled) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0145E", new Object[0], "Unable to add nor replace resources when provider policy set is enabled."));
            }
        }
        if (operation == 1) {
            List<Resource> newResources = this.convertResourceList(resources);
            policyRef.getResource().clear();
            policyRef.getResource().addAll(newResources);
        } else {
            List<String> currentResources = this.convertResourceBeansToResourcePatterns(policyRef.getResource());
            List<String> updatedResources = null;
            if (operation == 2) {
                updatedResources = this.addResources(currentResources, resources);
            } else if (operation == 3) {
                if (providerPolicySetEnabled) {
                    this.removePolicySetFromAttachment(attachmentId);
                    updatedResources = currentResources;
                } else {
                    updatedResources = this.removeResources(currentResources, resources);
                }
            }
            List<Resource> newResources = this.convertResourceList(updatedResources);
            policyRef.getResource().clear();
            policyRef.getResource().addAll(newResources);
        }
        this.rc = this.saveData();
        return this.rc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isResourceListEmpty(String attachmentId) throws JAXBException, FileNotFoundException, NoItemFoundException, IllegalArgumentException, DuplicateItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        boolean isEmpty = false;
        if (attachmentId != null && !attachmentId.equals("")) {
            List<PolicySetReference> policyReferences = this.returnPolicyReferences(attachmentId, "id");
            if (policyReferences != null && !policyReferences.isEmpty()) {
                if (policyReferences.size() == 1) {
                    PolicySetReference policyRef = policyReferences.get(0);
                    List<Resource> resources = policyRef.getResource();
                    if (!resources.isEmpty()) return isEmpty;
                    return true;
                }
                this.rc = -9;
                throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0072E", new Object[]{attachmentId}, "More than one attachment found with id: {0}"));
            }
            this.rc = -8;
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{attachmentId}, "Attachment not found: {0}"));
        }
        this.rc = -7;
        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{attachmentId}, "Input parameter is invalid: {0}"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int deleteAttachment(String attachmentId) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (attachmentId != null && !attachmentId.equals("")) {
            List<PolicySetReference> policyReferences = this.returnPolicyReferences(attachmentId, "id");
            if (policyReferences != null && !policyReferences.isEmpty()) {
                int i = 0;
                while (true) {
                    if (i >= policyReferences.size()) {
                        this.rc = this.saveData();
                        return this.rc;
                    }
                    this.policySetAttachment.getPolicySetReference().remove(policyReferences.get(i));
                    ++i;
                }
            }
            this.rc = -8;
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{attachmentId}, "Attachment not found: {0}"));
        }
        this.rc = -7;
        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{attachmentId}, "Input parameter is invalid: {0}"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int detachPolicySet(String policySetName) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        List<PolicySetReference> policyReferences;
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (policySetName != null && !policySetName.equals("")) {
            policyReferences = this.returnPolicyReferences(policySetName, "name");
            if (policyReferences == null || policyReferences.isEmpty()) {
                this.rc = -8;
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{policySetName}, "Attachment not found: {0}"));
            }
        } else {
            this.rc = -7;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{policySetName}, "Input parameter is invalid: {0}"));
        }
        Iterator<PolicySetReference> i$ = policyReferences.iterator();
        while (true) {
            if (!i$.hasNext()) {
                this.rc = this.saveData();
                return this.rc;
            }
            PolicySetReference reference = i$.next();
            if (reference.isProviderPolicyEnabled() != null && reference.isProviderPolicyEnabled().booleanValue()) {
                reference.setName(null);
                continue;
            }
            this.policySetAttachment.getPolicySetReference().remove(reference);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int transferAttachments(String sourcePolicySetName, String destPolicySetName) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        block4: {
            block5: {
                block2: {
                    block3: {
                        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
                        if (this.readOnly) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
                        }
                        this.rc = 0;
                        if (sourcePolicySetName == null || sourcePolicySetName.equals("") || destPolicySetName == null || destPolicySetName.equals("")) break block2;
                        List<PolicySetReference> policyReferences = this.returnPolicyReferences(sourcePolicySetName, "name");
                        if (policyReferences == null || policyReferences.isEmpty()) break block3;
                        for (int i = 0; i < policyReferences.size(); ++i) {
                            PolicySetReference refBean = policyReferences.get(i);
                            refBean.setName(destPolicySetName);
                        }
                        this.rc = this.saveData();
                        if (!tc.isDebugEnabled()) break block4;
                        break block5;
                    }
                    this.rc = -8;
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{sourcePolicySetName}, "Attachment not found: {0}"));
                }
                this.rc = -7;
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
            }
            Tr.debug(tc, "transferAttachments(String), rc = " + this.rc);
        }
        return this.rc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getPolicySetForAttachment(String attachmentId) throws JAXBException, FileNotFoundException, IllegalArgumentException, DuplicateItemFoundException, NoItemFoundException, IOException {
        String policySetName;
        block3: {
            block4: {
                block1: {
                    block2: {
                        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
                        policySetName = "";
                        this.rc = 0;
                        if (attachmentId == null || attachmentId.equals("")) break block1;
                        List<PolicySetReference> policyReferences = this.returnPolicyReferences(attachmentId, "id");
                        if (policyReferences == null || policyReferences.isEmpty()) break block2;
                        if (policyReferences.size() != 1) {
                            this.rc = -9;
                            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0072E", new Object[]{attachmentId}, "More than one attachment found with id: {0}"));
                        }
                        PolicySetReference policyRef = policyReferences.get(0);
                        policySetName = policyRef.getName();
                        if (!tc.isDebugEnabled()) break block3;
                        break block4;
                    }
                    this.rc = -8;
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{attachmentId}, "Attachment not found: {0}"));
                }
                this.rc = -7;
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{attachmentId}, "Input parameter is invalid: {0}"));
            }
            Tr.debug(tc, "getPolicySetForAttachment(String), rc = " + this.rc);
        }
        return policySetName;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Properties getBindingReference(String attachmentId) throws JAXBException, FileNotFoundException, IllegalArgumentException, DuplicateItemFoundException, NoItemFoundException, IOException {
        Properties props;
        block6: {
            block4: {
                block5: {
                    resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
                    String bindingRef = "";
                    this.rc = 0;
                    props = new Properties();
                    if (attachmentId == null || attachmentId.equals("")) break block4;
                    List<PolicySetReference> policyReferences = this.returnPolicyReferences(attachmentId, "id");
                    if (policyReferences == null || policyReferences.isEmpty()) break block5;
                    if (policyReferences.size() != 1) {
                        this.rc = -9;
                        throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0072E", new Object[]{attachmentId}, "More than one attachment found with id: {0}"));
                    }
                    PolicySetReference policyRef = policyReferences.get(0);
                    PolicySetBinding binding = policyRef.getPolicySetBinding();
                    if (binding != null) {
                        bindingRef = binding.getName();
                        props.setProperty("name", bindingRef);
                        String bindingScope = binding.getScope();
                        if (bindingScope != null) {
                            props.setProperty("scope", bindingScope);
                        }
                    }
                    break block6;
                }
                this.rc = -8;
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{attachmentId}, "Attachment not found: {0}"));
            }
            this.rc = -7;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{"attachmentId"}, "Input parameter is invalid: {0}"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBindingReference(String), rc = " + this.rc);
        }
        return props;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int setBindingReference(String attachmentId, String bindingReference, String bindingScope) throws JAXBException, FileNotFoundException, IllegalArgumentException, DuplicateItemFoundException, NoItemFoundException, IOException {
        block11: {
            block12: {
                block9: {
                    block10: {
                        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
                        if (this.readOnly) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
                        }
                        this.rc = 0;
                        boolean removeBinding = true;
                        if (bindingReference != null && !bindingReference.equals("")) {
                            removeBinding = false;
                        }
                        if (attachmentId == null || attachmentId.equals("")) break block9;
                        List<PolicySetReference> policyReferences = this.returnPolicyReferences(attachmentId, "id");
                        if (policyReferences == null || policyReferences.isEmpty()) break block10;
                        if (policyReferences.size() != 1) {
                            this.rc = -9;
                            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0072E", new Object[]{attachmentId}, "More than one attachment found with id: {0}"));
                        }
                        PolicySetReference policyRef = policyReferences.get(0);
                        if (removeBinding) {
                            policyRef.setPolicySetBinding(null);
                        } else {
                            PolicySetBinding binding = policyRef.getPolicySetBinding();
                            if (binding != null) {
                                binding.setName(bindingReference);
                                if (bindingScope != null) {
                                    binding.setScope(bindingScope);
                                }
                            } else {
                                binding = new PolicySetBinding();
                                binding.setName(bindingReference);
                                if (bindingScope != null) {
                                    binding.setScope(bindingScope);
                                }
                                policyRef.setPolicySetBinding(binding);
                            }
                        }
                        this.rc = this.saveData();
                        if (!tc.isDebugEnabled()) break block11;
                        break block12;
                    }
                    this.rc = -8;
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{attachmentId}, "Attachment not found: {0}"));
                }
                this.rc = -7;
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{attachmentId}, "Input parameter is invalid: {0}"));
            }
            Tr.debug(tc, "setBindingReference(String, String), rc = " + this.rc);
        }
        return this.rc;
    }

    @Override
    public List<String> getBindingReferencesForPolicySet(String policySetName) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        ArrayList<String> returnList = new ArrayList<String>();
        this.rc = 0;
        List<PolicySetReference> policyReferences = this.returnPolicyReferences(policySetName, "name");
        if (policyReferences != null && !policyReferences.isEmpty()) {
            for (int i = 0; i < policyReferences.size(); ++i) {
                PolicySetReference policyRef = policyReferences.get(i);
                PolicySetBinding binding = policyRef.getPolicySetBinding();
                if (binding == null) continue;
                returnList.add(binding.getName());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBindingReferencesForPolicySet(String), rc = " + this.rc);
        }
        return returnList;
    }

    @Override
    public List<String> getAttachmentIdsForBinding(String bindingName) throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        ArrayList<String> returnList = new ArrayList<String>();
        this.rc = 0;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySetAttachment != null) {
            List<PolicySetReference> policyReferences = this.policySetAttachment.getPolicySetReference();
            if (policyReferences != null && !policyReferences.isEmpty()) {
                for (int i = 0; i < policyReferences.size(); ++i) {
                    PolicySetReference policyRef = policyReferences.get(i);
                    PolicySetBinding binding = policyRef.getPolicySetBinding();
                    if (binding == null || !binding.getName().equals(bindingName)) continue;
                    returnList.add(policyRef.getId());
                }
            } else {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0071E", new Object[0], "No attachments found"));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAttachmentIdsForBinding(String), rc = " + this.rc);
        }
        return returnList;
    }

    @Override
    public List<String> getPolicySetResources(String policySetID, String matchOn) throws FileNotFoundException, IllegalArgumentException, JAXBException, IOException {
        String methodName = "getPolicySetResources";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetResources", new Object[]{policySetID, matchOn});
        }
        ArrayList<String> references = new ArrayList<String>();
        List<PolicySetReference> psrs = this.returnPolicyReferences(policySetID, matchOn);
        for (PolicySetReference psr : psrs) {
            for (Resource resource : psr.getResource()) {
                references.add(resource.getPattern());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetResources", references);
        }
        return references;
    }

    @Override
    public String getIdForPolicySetAttachment(String resource) throws FileNotFoundException, IllegalArgumentException, JAXBException, IOException {
        List<PolicySetReference> policyReferences;
        String methodName = "getIdForPolicySetAttachment";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdForPolicySetAttachment", new Object[]{resource});
        }
        String existingAttachmentID = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (resource != null && !resource.endsWith("/")) {
            resource = resource + "/";
        }
        if (this.policySetAttachment != null && (policyReferences = this.policySetAttachment.getPolicySetReference()) != null) {
            for (PolicySetReference psr : policyReferences) {
                if (psr.getResource() == null) continue;
                for (Resource r : psr.getResource()) {
                    String pattern = r.getPattern();
                    if (!pattern.endsWith("/")) {
                        pattern = pattern + "/";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pattern: " + pattern);
                        Tr.debug(tc, "psr.getName(): " + psr.getName());
                    }
                    if (!pattern.equals(resource) || psr.getName() == null || psr.getName().equals("")) continue;
                    existingAttachmentID = psr.getId();
                    break;
                }
                if (existingAttachmentID == null) continue;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdForPolicySetAttachment", existingAttachmentID);
        }
        return existingAttachmentID;
    }

    @Override
    public String getIdForProviderPolicySetAttachment(String resource) throws FileNotFoundException, IllegalArgumentException, JAXBException, IOException {
        List<PolicySetReference> policyReferences;
        String methodName = "getIdForProviderPolicySetAttachment";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdForProviderPolicySetAttachment", new Object[]{resource});
        }
        String existingAttachmentID = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (resource != null && !resource.endsWith("/")) {
            resource = resource + "/";
        }
        if (this.policySetAttachment != null && (policyReferences = this.policySetAttachment.getPolicySetReference()) != null) {
            for (PolicySetReference psr : policyReferences) {
                if (psr.getResource() == null) continue;
                for (Resource r : psr.getResource()) {
                    String pattern = r.getPattern();
                    if (!pattern.endsWith("/")) {
                        pattern = pattern + "/";
                    }
                    if (!pattern.equals(resource) || psr.isProviderPolicyEnabled() == null || !psr.isProviderPolicyEnabled().booleanValue()) continue;
                    existingAttachmentID = psr.getId();
                    break;
                }
                if (existingAttachmentID == null) continue;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdForProviderPolicySetAttachment", existingAttachmentID);
        }
        return existingAttachmentID;
    }

    @Override
    public String attachProviderPolicySet(String attachmentType, String resource) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        String methodName = "attachProviderPolicySet";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attachProviderPolicySet", new Object[]{attachmentType, resource});
        }
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        String id = null;
        if (resource != null) {
            if (!this.fileLoaded) {
                this.loadData();
            }
        } else {
            this.rc = -7;
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        id = this.createAttachmentId(attachmentType);
        PolicySetReference psetRef = new PolicySetReference();
        psetRef.setProviderPolicyEnabled(true);
        psetRef.setId(id);
        Resource r = new Resource();
        r.setPattern(resource);
        psetRef.getResource().add(r);
        this.policySetAttachment.getPolicySetReference().add(psetRef);
        this.rc = this.saveData();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attachProviderPolicySet", id);
        }
        return id;
    }

    @Override
    public int addProviderPolicySetToAttachment(String attachmentId) throws FileNotFoundException, IllegalArgumentException, JAXBException, IOException, NoItemFoundException, DuplicateItemFoundException {
        String methodName = "addProviderPolicySetToAttachment";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProviderPolicySetToAttachment", new Object[]{attachmentId});
        }
        int rc = this.modifyPolicySetReference(attachmentId, "providerPolicySet", new Boolean(true));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProviderPolicySetToAttachment", rc);
        }
        return rc;
    }

    @Override
    public int removeProviderPolicySetFromAttachment(String attachmentId) throws FileNotFoundException, IllegalArgumentException, JAXBException, IOException, NoItemFoundException, DuplicateItemFoundException {
        String methodName = "removeProviderPolicySetFromAttachment";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeProviderPolicySetFromAttachment", new Object[]{attachmentId});
        }
        int rc = this.modifyPolicySetReference(attachmentId, "providerPolicySet", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeProviderPolicySetFromAttachment", rc);
        }
        return rc;
    }

    @Override
    public int addPolicySetToAttachment(String attachmentId, String policySet) throws FileNotFoundException, IllegalArgumentException, JAXBException, IOException, NoItemFoundException, DuplicateItemFoundException {
        String methodName = "addPolicySetToAttachment";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPolicySetToAttachment", new Object[]{attachmentId, policySet});
        }
        int rc = this.modifyPolicySetReference(attachmentId, "name", policySet);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPolicySetToAttachment", rc);
        }
        return rc;
    }

    @Override
    public int removePolicySetFromAttachment(String attachmentId) throws FileNotFoundException, IllegalArgumentException, JAXBException, IOException, NoItemFoundException, DuplicateItemFoundException {
        String methodName = "removePolicySetFromAttachment";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePolicySetFromAttachment", new Object[]{attachmentId});
        }
        int rc = this.modifyPolicySetReference(attachmentId, "name", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePolicySetFromAttachment", rc);
        }
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int modifyPolicySetReference(String attachmentId, String modifyKey, Object modifyValue) throws FileNotFoundException, IllegalArgumentException, JAXBException, IOException, NoItemFoundException, DuplicateItemFoundException {
        block8: {
            block9: {
                block6: {
                    block7: {
                        String methodName = "modifyPolicySetReference";
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "modifyPolicySetReference", new Object[]{attachmentId, modifyKey, modifyValue});
                        }
                        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", PolicySetAttachmentHelperImpl.getLocale());
                        if (this.readOnly) {
                            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
                        }
                        this.rc = 0;
                        if (attachmentId == null || attachmentId.equals("")) break block6;
                        List<PolicySetReference> policyReferences = this.returnPolicyReferences(attachmentId, "id");
                        if (policyReferences == null || policyReferences.isEmpty()) break block7;
                        if (policyReferences.size() != 1) {
                            this.rc = -9;
                            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0072E", new Object[]{attachmentId}, "More than one attachment found with id: {0}"));
                        }
                        PolicySetReference policyRef = policyReferences.get(0);
                        if (modifyKey.equals("name")) {
                            policyRef.setName((String)modifyValue);
                        } else if (modifyKey.equals("providerPolicySet")) {
                            policyRef.setProviderPolicyEnabled((Boolean)modifyValue);
                        }
                        this.rc = this.saveData();
                        if (!tc.isEntryEnabled()) break block8;
                        break block9;
                    }
                    this.rc = -8;
                    throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0070E", new Object[]{attachmentId}, "Attachment not found: {0}"));
                }
                this.rc = -7;
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{attachmentId}, "Input parameter is invalid: {0}"));
            }
            Tr.exit(tc, "modifyPolicySetReference", this.rc);
        }
        return this.rc;
    }

    @Override
    public void setLocale(Locale locale) {
        _locale = locale;
    }

    private static Locale getLocale() {
        if (_locale == null) {
            return Locale.getDefault();
        }
        return _locale;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<PolicySetReference> returnPolicyReferences(String policySetId, String matchOn) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        List<PolicySetReference> policyReferences = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.policySetAttachment != null) {
            policyReferences = this.policySetAttachment.getPolicySetReference();
            if (policyReferences == null) return policyReferences;
            if (policyReferences.isEmpty()) return policyReferences;
            if (policySetId == null || policySetId.equals("") || matchOn == null || matchOn.equals("")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{policySetId}, "Input parameter is invalid: {0}"));
            ArrayList<PolicySetReference> references = new ArrayList<PolicySetReference>();
            int i = 0;
            while (i < policyReferences.size()) {
                PolicySetReference policyRef = policyReferences.get(i);
                String matchValue = "";
                if (matchOn.equals("name")) {
                    matchValue = policyRef.getName();
                } else if (matchOn.equals("id")) {
                    matchValue = policyRef.getId();
                } else if (matchOn.equals("providerPolicySet") && policyRef.isProviderPolicyEnabled() != null) {
                    matchValue = policyRef.isProviderPolicyEnabled().toString();
                }
                if (policySetId.equals(matchValue)) {
                    references.add(policyRef);
                }
                ++i;
            }
            return references;
        }
        this.rc = -1;
        return policyReferences;
    }

    private ArrayList<Properties> returnAttachments(List policyReferences) {
        ArrayList<Properties> returnList = new ArrayList<Properties>(policyReferences.size());
        for (int i = 0; i < policyReferences.size(); ++i) {
            List<Resource> resources;
            Properties props = new Properties();
            PolicySetReference policyRef = (PolicySetReference)policyReferences.get(i);
            if (policyRef.getName() != null) {
                props.setProperty("name", policyRef.getName());
            } else {
                props.setProperty("name", "");
            }
            props.setProperty("id", policyRef.getId());
            if (policyRef.isProviderPolicyEnabled() != null && policyRef.isProviderPolicyEnabled().booleanValue()) {
                props.setProperty("providerPolicySet", "true");
            } else {
                props.setProperty("providerPolicySet", "false");
            }
            PolicySetBinding binding = policyRef.getPolicySetBinding();
            if (binding != null) {
                props.setProperty("binding", binding.getName());
                String bindingScope = binding.getScope();
                if (bindingScope != null) {
                    props.setProperty("bindingScope", bindingScope);
                }
            }
            if ((resources = policyRef.getResource()) != null) {
                for (int k = 0; k < resources.size(); ++k) {
                    Resource resource = resources.get(k);
                    if (resource == null) continue;
                    props.setProperty("pattern." + k, resource.getPattern());
                }
            }
            returnList.add(props);
        }
        return returnList;
    }

    private List<Resource> convertResourceList(String[] resources) {
        ArrayList<Resource> newResources = new ArrayList<Resource>();
        for (int i = 0; i < resources.length; ++i) {
            Resource resourceBean = new Resource();
            resourceBean.setPattern(resources[i]);
            newResources.add(resourceBean);
        }
        return newResources;
    }

    private List<Resource> convertResourceList(List resources) {
        ArrayList<Resource> newResources = new ArrayList<Resource>();
        for (int i = 0; i < resources.size(); ++i) {
            Resource resourceBean = new Resource();
            resourceBean.setPattern((String)resources.get(i));
            newResources.add(resourceBean);
        }
        return newResources;
    }

    private List<String> convertResourceBeansToResourcePatterns(List resources) {
        ArrayList<String> newResources = new ArrayList<String>();
        for (int i = 0; i < resources.size(); ++i) {
            Resource resourceBean = (Resource)resources.get(i);
            newResources.add(resourceBean.getPattern());
        }
        return newResources;
    }

    private List<String> addResources(List<String> currentResources, String[] resources) throws DuplicateItemFoundException {
        ArrayList<String> newResources = new ArrayList<String>();
        newResources.addAll(currentResources);
        for (int i = 0; i < resources.length; ++i) {
            String newResource = resources[i];
            if (currentResources.contains(newResource)) {
                this.rc = -7;
                throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0073E", new Object[]{newResource}, "The resource already exists in the attachment: {0}"));
            }
            newResources.add(newResource);
        }
        return newResources;
    }

    private List<String> removeResources(List<String> currentResources, String[] resources) throws NoItemFoundException {
        ArrayList<String> newResources = new ArrayList<String>();
        newResources.addAll(currentResources);
        for (int i = 0; i < resources.length; ++i) {
            String newResource = resources[i];
            if (!currentResources.contains(newResource)) {
                this.rc = -7;
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0074E", new Object[]{newResource}, "Resource not found in the attachment: {0}"));
            }
            newResources.remove(newResource);
        }
        return newResources;
    }

    private String createAttachmentId(String attachmentType) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        Random generator = new Random();
        int randomIndex = generator.nextInt(1000);
        if (attachmentType.equals("client")) {
            randomIndex += 1000;
        }
        String attachmentId = String.valueOf(randomIndex);
        List<PolicySetReference> policyReferences = this.returnPolicyReferences(attachmentId, "id");
        while (policyReferences != null && !policyReferences.isEmpty()) {
            randomIndex = generator.nextInt(1000);
            attachmentId = String.valueOf(randomIndex);
            policyReferences = this.returnPolicyReferences(attachmentId, "id");
        }
        return attachmentId;
    }
}

