/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.BindingDefinitionHelper;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.xmlns.prod.websphere._200711.bindingdefinition.BindingDefinition;
import com.ibm.xmlns.prod.websphere._200711.bindingdefinition.Domain;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

public class BindingDefinitionHelperImpl
implements BindingDefinitionHelper,
PolicyConstants {
    private String fileName = null;
    private BindingDefinition bindingDefinition = null;
    private int rc = 0;
    private boolean fileLoaded = false;
    protected String className = this.getClass().getName();
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private boolean readOnly = false;
    private static Locale _locale = null;
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
    private static ResourceBundle resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String[] supportedAttributes = new String[]{"description", "domain", "type"};
    private static TraceComponent tc = Tr.register(BindingDefinitionHelperImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");

    public BindingDefinitionHelperImpl(String fileName) {
        this.fileName = fileName;
    }

    public BindingDefinitionHelperImpl(InputStream istream) {
        this.inputStream = istream;
        this.readOnly = true;
    }

    public BindingDefinitionHelperImpl(InputStream istream, OutputStream outStream, String fileName) {
        this.inputStream = istream;
        this.fileName = fileName;
        this.outputStream = outStream;
    }

    private void loadData() throws JAXBException, FileNotFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadData for file " + this.fileName);
        }
        this.bindingDefinition = null;
        InputStream istream = this.inputStream;
        boolean createdStream = false;
        try {
            if (istream == null) {
                if (this.fileName != null) {
                    istream = new FileInputStream(this.fileName);
                    createdStream = true;
                } else {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
                }
            }
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200711.bindingdefinition");
            Unmarshaller um = jc.createUnmarshaller();
            this.bindingDefinition = (BindingDefinition)um.unmarshal(istream);
            if (createdStream) {
                istream.close();
            }
        }
        catch (JAXBException jaxe) {
            FFDCFilter.processException(jaxe, this.className, FFDC_ID_1);
            Tr.error(tc, "CWPST0001E", new Object[]{jaxe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught JAXBException while parsing file");
                jaxe.printStackTrace();
            }
            if (createdStream) {
                istream.close();
            }
            throw jaxe;
        }
        catch (FileNotFoundException fnfe) {
            FFDCFilter.processException(fnfe, this.className, FFDC_ID_2);
            Tr.error(tc, "CWPST0001E", new Object[]{fnfe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught FileNotFoundException while parsing file");
                fnfe.printStackTrace();
            }
            throw fnfe;
        }
        catch (IOException ioe) {
            FFDCFilter.processException(ioe, this.className, FFDC_ID_7);
            Tr.error(tc, "CWPST0001E", new Object[]{ioe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught IOException while parsing file");
                ioe.printStackTrace();
            }
            throw ioe;
        }
        this.fileLoaded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadData for file " + this.fileName);
        }
    }

    private int saveData() throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveData for file " + this.fileName);
        }
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        int retCode = 0;
        OutputStream outStream = this.outputStream;
        boolean createdStream = false;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200711.bindingdefinition");
            if (outStream == null) {
                outStream = new FileOutputStream(this.fileName);
                createdStream = true;
            }
            Marshaller m = jc.createMarshaller();
            try {
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            m.marshal((Object)this.bindingDefinition, outStream);
            if (createdStream) {
                outStream.close();
            }
        }
        catch (JAXBException jaxe) {
            FFDCFilter.processException(jaxe, this.className, FFDC_ID_3);
            Tr.error(tc, "CWPST0002E", new Object[]{jaxe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught JAXBException while writing file");
                jaxe.printStackTrace();
            }
            if (createdStream) {
                outStream.close();
            }
            throw jaxe;
        }
        catch (FileNotFoundException fnfe) {
            FFDCFilter.processException(fnfe, this.className, FFDC_ID_4);
            Tr.error(tc, "CWPST0002E", new Object[]{fnfe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught FileNotFoundException while writing file");
                fnfe.printStackTrace();
            }
            throw fnfe;
        }
        catch (IllegalArgumentException iae) {
            FFDCFilter.processException(iae, this.className, FFDC_ID_5);
            Tr.error(tc, "CWPST0002E", new Object[]{iae.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IllegalArgumentException while writing file");
                iae.printStackTrace();
            }
            if (outStream != null && createdStream) {
                outStream.close();
            }
            throw iae;
        }
        catch (IOException ioe) {
            FFDCFilter.processException(ioe, this.className, FFDC_ID_6);
            Tr.error(tc, "CWPST0002E", new Object[]{ioe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IOException while writing file");
                ioe.printStackTrace();
            }
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveData for file " + this.fileName);
        }
        return retCode;
    }

    public Properties getBindingDefinition() throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        Properties props = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.bindingDefinition != null) {
            String description;
            props = new Properties();
            if (this.bindingDefinition.getDescription() != null) {
                description = this.bindingDefinition.getDescription();
                if (description.startsWith("$KEY_")) {
                    String keyname = description.substring(5);
                    description = resourceBundle2.getString(keyname);
                }
            } else {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"description", BindingDefinitionHelperImpl.getBindingName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
            props.setProperty("description", description);
            if (this.bindingDefinition.getType() == null) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"type", BindingDefinitionHelperImpl.getBindingName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
            props.setProperty("type", this.bindingDefinition.getType());
            if (this.bindingDefinition.getVersion() == null) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"version", BindingDefinitionHelperImpl.getBindingName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
            props.setProperty("version", this.bindingDefinition.getVersion());
            if (this.bindingDefinition.getDomain() != null) {
                props.setProperty("domain", this.bindingDefinition.getDomain().getName());
            } else {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"domain", BindingDefinitionHelperImpl.getBindingName(this.fileName)}, "Attribute not found in policy set: {0}"));
            }
        }
        return props;
    }

    public BindingDefinition getBindingDefinitionObject() throws JAXBException, FileNotFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        if (!this.fileLoaded) {
            this.loadData();
        }
        return this.bindingDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int createBindingDefinition(String description, String type, String domain, String version) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        String bindingName = null;
        this.rc = 0;
        if (this.fileName == null || !this.fileName.contains("bindingDefinition.xml")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0080E", new Object[]{this.fileName}, "The following file name is invalid: {0}"));
        String dirName = this.fileName.substring(0, this.fileName.indexOf("bindingDefinition.xml") - 1);
        bindingName = dirName.substring(dirName.lastIndexOf(File.separator) + 1);
        if (bindingName == null || bindingName.equals("")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
        this.bindingDefinition = new BindingDefinition();
        if (description != null) {
            this.bindingDefinition.setDescription(description);
        } else {
            this.bindingDefinition.setDescription("");
        }
        if (type != null) {
            if (!type.equals("provider") && !type.equals("client")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0159E", new Object[]{type}, "The {0} binding type is not valid"));
            this.bindingDefinition.setType(type);
        } else {
            this.bindingDefinition.setType("provider");
        }
        if (domain != null) {
            this.bindingDefinition.setDomain(new Domain());
            this.bindingDefinition.getDomain().setName(domain);
        } else {
            this.bindingDefinition.setDomain(new Domain());
            this.bindingDefinition.getDomain().setName("global");
        }
        if (version != null) {
            this.bindingDefinition.setVersion(version);
        } else {
            this.bindingDefinition.setVersion("7.0.0.0");
        }
        this.rc = this.saveData();
        if (!tc.isDebugEnabled()) return this.rc;
        Tr.debug(tc, "createBindingDefinition, rc = " + this.rc);
        return this.rc;
    }

    public int updateBindingDefinition(Properties updatedValues) throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (updatedValues != null && !updatedValues.isEmpty()) {
            if (!this.fileLoaded) {
                this.loadData();
            }
            if (this.bindingDefinition != null) {
                boolean isValid = true;
                String attribKey = null;
                Enumeration<?> keys = updatedValues.propertyNames();
                while (keys.hasMoreElements() && isValid) {
                    attribKey = (String)keys.nextElement();
                    isValid = this.isSupported(attribKey);
                }
                if (!isValid) {
                    throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0077E", new Object[]{attribKey}, "Attribute is invalid: {0}"));
                }
                String attribValue = updatedValues.getProperty("description");
                if (attribValue != null) {
                    this.bindingDefinition.setDescription(attribValue);
                }
                if ((attribValue = updatedValues.getProperty("type")) != null) {
                    if (attribValue.equals("provider") || attribValue.equals("client")) {
                        this.bindingDefinition.setType(attribValue);
                    } else {
                        throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0159E", new Object[]{attribValue}, "The {0} binding type is not valid"));
                    }
                }
                if ((attribValue = updatedValues.getProperty("domain")) != null) {
                    this.bindingDefinition.getDomain().setName(attribValue);
                }
                if ((attribValue = updatedValues.getProperty("version")) != null) {
                    this.bindingDefinition.setVersion(attribValue);
                }
                this.rc = this.saveData();
            }
        } else {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0068E", new Object[0], "Invalid input parameter"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updatebindingDefinition, rc = " + this.rc);
        }
        return this.rc;
    }

    public Properties getBindingAttributes(String[] attributes) throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        this.rc = 0;
        Properties props = new Properties();
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.bindingDefinition != null) {
            if (attributes != null && attributes.length != 0) {
                for (int j = 0; j < attributes.length; ++j) {
                    if ("type".equals(attributes[j])) {
                        props.setProperty("type", this.bindingDefinition.getType());
                    }
                    if ("domain".equals(attributes[j])) {
                        props.setProperty("domain", this.bindingDefinition.getDomain().getName());
                    }
                    if ("description".equals(attributes[j])) {
                        String description = this.bindingDefinition.getDescription();
                        if (description.startsWith("$KEY_")) {
                            String keyname = description.substring(5);
                            description = resourceBundle2.getString(keyname);
                        }
                        props.setProperty("description", description);
                    }
                    if (!"version".equals(attributes[j])) continue;
                    props.setProperty("version", this.bindingDefinition.getVersion());
                }
            } else {
                props.setProperty("type", this.bindingDefinition.getType());
                props.setProperty("domain", this.bindingDefinition.getDomain().getName());
                props.setProperty("version", this.bindingDefinition.getVersion());
                String description = this.bindingDefinition.getDescription();
                if (description.startsWith("$KEY_")) {
                    String keyname = description.substring(5);
                    description = resourceBundle2.getString(keyname);
                }
                props.setProperty("description", description);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBindingAttributes, rc = " + this.rc);
        }
        return props;
    }

    public int setBindingAttributes(Properties updatedValues) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        this.rc = 0;
        if (updatedValues != null && !updatedValues.isEmpty()) {
            if (!this.fileLoaded) {
                this.loadData();
            }
            if (this.bindingDefinition != null) {
                String versionValue;
                String domainValue;
                String descriptionValue;
                String typeValue = updatedValues.getProperty("type");
                if (typeValue != null) {
                    this.bindingDefinition.setType(typeValue);
                }
                if ((descriptionValue = updatedValues.getProperty("description")) != null) {
                    this.bindingDefinition.setDescription(descriptionValue);
                }
                if ((domainValue = updatedValues.getProperty("domain")) != null) {
                    this.bindingDefinition.getDomain().setName(domainValue);
                }
                if ((versionValue = updatedValues.getProperty("version")) != null) {
                    this.bindingDefinition.setVersion(versionValue);
                }
                this.rc = this.saveData();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setBindingAttributes, rc = " + this.rc);
        }
        return this.rc;
    }

    public String getBindingType() throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        String type = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.bindingDefinition != null) {
            if (this.bindingDefinition.getType() != null) {
                type = this.bindingDefinition.getType();
            } else {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"type", BindingDefinitionHelperImpl.getBindingName(this.fileName)}, "Attribute not found in binding definition: {0}"));
            }
        }
        return type;
    }

    public String getDomain() throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        String domain = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.bindingDefinition != null) {
            if (this.bindingDefinition.getDomain() != null) {
                domain = this.bindingDefinition.getDomain().getName();
            } else {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"type", BindingDefinitionHelperImpl.getBindingName(this.fileName)}, "Attribute not found in binding definition: {0}"));
            }
        }
        return domain;
    }

    public String getDescription() throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        String description = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.bindingDefinition != null) {
            if (this.bindingDefinition.getDescription() != null) {
                description = this.bindingDefinition.getDescription();
                if (description.startsWith("$KEY_")) {
                    String keyname = description.substring(5);
                    description = resourceBundle2.getString(keyname);
                }
            } else {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"type", BindingDefinitionHelperImpl.getBindingName(this.fileName)}, "Attribute not found in binding definition: {0}"));
            }
        }
        return description;
    }

    public String getVersion() throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        String version = null;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.bindingDefinition != null) {
            if (this.bindingDefinition.getVersion() != null) {
                version = this.bindingDefinition.getVersion();
            } else {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0083E", new Object[]{"version", BindingDefinitionHelperImpl.getBindingName(this.fileName)}, "Attribute not found in binding definition: {0}"));
            }
        }
        return version;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setBindingType(String type) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        this.rc = 0;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.bindingDefinition != null) {
            if (type != null) {
                if (!type.equals("provider") && !type.equals("client")) throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0159E", new Object[]{type}, "The {0} binding type is not valid"));
                this.bindingDefinition.setType(type);
            } else {
                this.bindingDefinition.setType("provider");
            }
            this.rc = this.saveData();
        }
        if (!tc.isDebugEnabled()) return this.rc;
        Tr.debug(tc, "setBindingType, rc = " + this.rc);
        return this.rc;
    }

    public int setDomain(String domain) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        this.rc = 0;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.bindingDefinition != null) {
            if (domain != null) {
                this.bindingDefinition.getDomain().setName(domain);
            } else {
                this.bindingDefinition.getDomain().setName("global");
            }
            this.rc = this.saveData();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDomain, rc = " + this.rc);
        }
        return this.rc;
    }

    public int setDescription(String description) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        this.rc = 0;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.bindingDefinition != null) {
            if (description != null) {
                this.bindingDefinition.setDescription(description);
            }
            this.rc = this.saveData();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDescription, rc = " + this.rc);
        }
        return this.rc;
    }

    public int setVersion(String version) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", BindingDefinitionHelperImpl.getLocale());
        resourceBundle2 = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policyStrings", BindingDefinitionHelperImpl.getLocale());
        this.rc = 0;
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.bindingDefinition != null) {
            if (version != null) {
                this.bindingDefinition.setVersion(version);
            }
            this.rc = this.saveData();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setVersion, rc = " + this.rc);
        }
        return this.rc;
    }

    public void setLocale(Locale locale) {
        _locale = locale;
    }

    private static Locale getLocale() {
        if (_locale == null) {
            return Locale.getDefault();
        }
        return _locale;
    }

    private boolean isSupported(String attribute) {
        for (int i = 0; i < supportedAttributes.length; ++i) {
            if (!supportedAttributes[i].equals(attribute)) continue;
            return true;
        }
        return false;
    }

    private static String getBindingName(String filePath) {
        String dirName = null;
        if (filePath != null) {
            int index = filePath.lastIndexOf(File.separatorChar);
            String str1 = filePath.substring(0, index);
            index = str1.lastIndexOf(File.separatorChar);
            dirName = str1.substring(index + 1);
        }
        return dirName;
    }
}

