/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditSchedulerImpl;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.deploy.PolicySetAttachmentInstallTask;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;

public class CopyBindingsTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentInstallTask.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    protected String className = ((Object)((Object)this)).getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private RepositoryContext _deployContext = null;
    private EARFile _localear = null;

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CopyBindingsTask.performTask()");
        }
        try {
            EARFile ear = this.getEar();
            this._deployContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            Locale locale = (Locale)this.scheduler.getProperties().get("app.client.locale");
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.bundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", locale);
            String clientRelativePath = "META-INF" + File.separator + "clientPolicyAttachments.xml";
            String serverRelativePath = "META-INF" + File.separator + "policyAttachments.xml";
            String clientFileName = this._deployContext.getPath() + File.separator + clientRelativePath;
            String serverFileName = this._deployContext.getPath() + File.separator + serverRelativePath;
            File clientFileObj = new File(clientFileName);
            File serverFileObj = new File(serverFileName);
            if (clientFileObj.exists()) {
                this.validatePolicySets(clientFileObj, clientFileName);
            }
            if (serverFileObj.exists()) {
                this.validatePolicySets(serverFileObj, serverFileName);
            }
            String pattern = "META-INF/.*/bindings.xml";
            String patternBD = "META-INF/.*/bindingDefinition.xml";
            String providerTxt = "META-INF/.*/provider.txt";
            for (org.eclipse.jst.j2ee.commonarchivecore.internal.File file : ear.getFiles()) {
                if (file instanceof Container || file.isSetDirectoryEntry() && file.isDirectoryEntry()) continue;
                String fName = file.getURI();
                if (!(fName = fName.replace('\\', '/')).matches(pattern) && !fName.matches(patternBD) && !fName.matches(providerTxt)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CopyBindingsTask, Copy " + fName);
                }
                InputStream is = ear.getInputStream(fName);
                OutputStream os = this._deployContext.getOutputStream(fName);
                this.save2File(is, os);
                os.close();
                is.close();
                this._deployContext.notifyChanged(0, fName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CopyBindingsTask.performTask()");
            }
            return true;
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, this.className, FFDC_ID_1);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "CWPST0149E", new String[]{this.scheduler.getAppName(), th.toString()}));
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"CWPST0150E"));
        }
    }

    private void validatePolicySets(File fileObj, String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validatePolicySets(fileName = " + fileName + ")");
        }
        try {
            PolicySetAttachmentHelper attachmentHelper = PolicySetAttachmentHelperFactory.createHelper(fileName);
            PolicySetAttachment attachment = attachmentHelper.getPolicySetAttachmentObject();
            if (attachment != null) {
                List<PolicySetReference> referenceList = attachment.getPolicySetReference();
                List policySetList = this.listPolicySets();
                for (PolicySetReference reference : referenceList) {
                    String psName = reference.getName();
                    if (psName == null) continue;
                    boolean policySetFound = false;
                    Iterator policySetListIt = policySetList.iterator();
                    while (policySetListIt.hasNext() && !policySetFound) {
                        String policySetListItem = policySetListIt.next().toString();
                        if (!policySetListItem.equals(psName)) continue;
                        policySetFound = true;
                        break;
                    }
                    if (policySetFound || !tc.isWarningEnabled()) continue;
                    Tr.warning(tc, CommonUtil.getFormattedMessage(this.getResourceBundle(), "CWPST0148W", new Object[]{psName}, "Policyset {0} is not defined on server."));
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validatePolicySets(fileName = " + fileName + ")");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, this.className, FFDC_ID_1);
            Tr.error(tc, "Exception: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List listPolicySets() throws Exception {
        List policySetsList = null;
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        if (cmdMgr != null) {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = new Session();
            try {
                AdminCommand cmd = cmdMgr.createCommand("listPolicySets");
                cmd.setConfigSession(session);
                cmd.execute();
                CommandResult res = cmd.getCommandResult();
                if (!res.isSuccessful()) {
                    throw new Exception("failure during");
                }
                policySetsList = (List)res.getResult();
            }
            catch (Exception e) {
                Tr.error(tc, "Exception: " + e.getMessage());
            }
            finally {
                configService.discard(session);
            }
        }
        return policySetsList;
    }

    private void save2File(InputStream is, OutputStream os) throws Exception {
        byte[] bar;
        int bRead;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save2File");
        }
        int avail = is.available();
        while (avail > 0 && (bRead = is.read(bar = new byte[avail])) >= 1) {
            os.write(bar, 0, bRead);
            avail = is.available();
        }
        os.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save2File");
        }
    }

    private EARFile getEar() throws Exception {
        if (this._localear != null) {
            return this._localear;
        }
        EARFile ear = null;
        if (this.scheduler instanceof InstallScheduler) {
            ear = this._localear = ((InstallScheduler)this.scheduler).getEarFile(false, true);
        } else if (this.scheduler instanceof UpdateScheduler) {
            RepositoryContext rc = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            if (!ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)rc).isZeroBinaryCopy()) {
                this._localear = ConfigRepoHelper.getEarFileFromBinaries((RepositoryContext)rc, (WorkSpace)this.scheduler.getWorkSpace(), (ResourceBundle)this.getResourceBundle(), (boolean)true);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "zero bin copy so get ear from source");
                }
                this._localear = (EARFile)((UpdateSchedulerImpl)this.scheduler).getContentAsArchive(false, true);
            }
            ear = this._localear;
        } else if (this.scheduler instanceof EditSchedulerImpl) {
            RepositoryContext rc = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            ear = this._localear = ConfigRepoHelper.getEarFileFromDeployment((WorkSpace)this.scheduler.getWorkSpace(), (RepositoryContext)rc);
        }
        return ear;
    }
}

