/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.commands.util.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicySetWorkSpaceHelper;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceEvent;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceListener;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidationManager
implements WorkSpaceListener {
    private static TraceComponent tc = Tr.register(ValidationManager.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    static Map<String, ValidationManager> managers = Collections.synchronizedMap(new HashMap());
    private Session session = null;
    private List<String> policySets = null;
    private boolean isValidated = false;

    public static synchronized ValidationManager getManager(Session session) {
        String sessionName;
        ValidationManager manager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getManager", session);
        }
        if ((manager = managers.get(sessionName = session.toString())) == null) {
            manager = ValidationManager.createManager(session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getManager", session);
        }
        return manager;
    }

    private static ValidationManager createManager(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createManager", session);
        }
        String sessionName = session.toString();
        ValidationManager manager = new ValidationManager(session);
        managers.put(sessionName, manager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createManager", session);
        }
        return manager;
    }

    private ValidationManager(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor", session);
        }
        this.session = session;
        try {
            WorkSpace workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
            workspace.addWorkSpaceListener((WorkSpaceListener)this);
            this.policySets = new ArrayList<String>();
        }
        catch (WorkSpaceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.policyset.admin.commands.ValidationManager", "94");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor", session);
        }
    }

    public void markForValidation(String policySet) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "markForValidation", policySet);
        }
        if (!this.policySets.contains(policySet)) {
            this.policySets.add(policySet);
        }
    }

    public void handle(WorkSpaceEvent wsEvent) {
        int type;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle", wsEvent.getType());
        }
        if ((type = wsEvent.getType()) == 25 && !this.isValidated) {
            this.validate();
            this.isValidated = true;
            this.cleanUp();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle", wsEvent.getType());
        }
    }

    private void validate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            for (String policySetName : this.policySets) {
                String policySetFilePath;
                StringBuffer invalidPolicyTypes = PolicySetCommandUtil.validatePolicySet(this.session, policySetName, policySetFilePath = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, policySetName, false));
                if (invalidPolicyTypes.length() != 0) {
                    Tr.error(tc, "CWPST0025E", new Object[]{invalidPolicyTypes.toString()});
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Policy types valid for policy set: " + policySetName);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.policyset.admin.commands.ValidationManager", "104");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    private void cleanUp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanUp");
        }
        managers.remove(this.session.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanUp");
        }
    }
}

