/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetWorkSpaceHelper
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(PolicySetWorkSpaceHelper.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());

    public static List<String> listPolicySets(Session session, boolean defaultPolicySets) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicySets", new Object[]{session, defaultPolicySets});
        }
        RepositoryContext repContext = null;
        repContext = defaultPolicySets ? CommonWorkSpaceHelper.getTemplatesRepositoryContext(session) : CommonWorkSpaceHelper.getCellRepositoryContext(session);
        List fileList = repContext.getAllList(false);
        ArrayList<String> retList = new ArrayList<String>();
        String fileName = null;
        for (int k = 0; k < fileList.size(); ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (fileName.endsWith("policySet.xml") && fileName.startsWith("PolicySets")) {
                if (!repContext.isExtracted(fileName)) {
                    repContext.extract(fileName, false);
                }
                String fullPath = CommonWorkSpaceHelper.getFullPath(repContext, fileName);
                retList.add(fullPath);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "listPolicySets, file path is " + fullPath);
                }
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "listPolicySets, fileName=" + fileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicySets, retList=" + retList);
        }
        return retList;
    }

    public static String getPolicySetFile(Session session, String policySet, boolean isDefaultPolicySet) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getPolicySetFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetFile", new Object[]{session, policySet, isDefaultPolicySet});
        }
        RepositoryContext repContext = null;
        repContext = isDefaultPolicySet ? CommonWorkSpaceHelper.getTemplatesRepositoryContext(session) : CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = CommonWorkSpaceHelper.getPolicySetFileName(policySet);
        if (!repContext.isAvailable(expectedFileName = expectedFileName.replace(File.separatorChar, '/'))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{policySet}, "Policy set is not found: {0}"));
        }
        if (!repContext.isExtracted(expectedFileName)) {
            repContext.extract(expectedFileName, false);
        }
        String fullPath = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        fullPath = fullPath.replace('/', File.separatorChar);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetFile", "fullPath=" + fullPath);
        }
        return fullPath;
    }

    public static List<String> getPolicySetDirectoryFiles(Session session, String policySet, boolean isDefaultPolicySet) throws WorkSpaceException, NoItemFoundException {
        String expectedFileName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetDirectoryFiles, policySet=" + policySet + ", isDefaultPolicySet=" + isDefaultPolicySet);
        }
        ArrayList<String> retList = new ArrayList<String>();
        String fileName = null;
        boolean trDebug = tc.isDebugEnabled();
        RepositoryContext repContext = null;
        repContext = isDefaultPolicySet ? CommonWorkSpaceHelper.getTemplatesRepositoryContext(session) : CommonWorkSpaceHelper.getCellRepositoryContext(session);
        if (!repContext.isAvailable(expectedFileName = CommonWorkSpaceHelper.getPolicySetFileName(policySet))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{policySet}, "Policy set is not found: {0}"));
        }
        List fileList = repContext.getAllList(false);
        for (int k = 0; k < fileList.size(); ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (fileName.equals("PolicySets" + File.separatorChar + policySet) || fileName.startsWith("PolicySets" + File.separatorChar + policySet + File.separatorChar)) {
                if (!repContext.isExtracted(fileName)) {
                    repContext.extract(fileName, false);
                }
                retList.add(CommonWorkSpaceHelper.getFullPath(repContext, fileName));
            }
            if (!trDebug) continue;
            Tr.debug(tc, "getPolicySetDirectoryFiles, fileName=" + fileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetDirectoryFiles, retList.size()=" + retList.size());
        }
        return retList;
    }

    public static boolean updatePolicySetFile(Session session, String policySet) throws WorkSpaceException, NoItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "udpatePolicySetFile, policySet=" + policySet);
        }
        if (!(repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session)).isAvailable(expectedFileName = CommonWorkSpaceHelper.getPolicySetFileName(policySet))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{policySet}, "Policy set is not found: {0}"));
        }
        repContext.notifyChanged(1, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "udpatePolicySetFile, policySet=" + policySet);
        }
        return true;
    }

    public static boolean doesPolicySetExist(Session session, String policySet) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesPolicySetExist, policySet=" + policySet);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        List fileList = repContext.getAllList(false);
        boolean policySetFound = false;
        String fileName = null;
        String psFileNamePrefix = CommonWorkSpaceHelper.getPolicySetFilePrefix(policySet, true);
        for (int k = 0; k < fileList.size() && !policySetFound; ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (!fileName.toLowerCase().startsWith(psFileNamePrefix)) continue;
            policySetFound = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesPolicySetExist, policySetFound=" + policySetFound);
        }
        return policySetFound;
    }

    public static String createPolicySet(Session session, String policySet) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPolicySet, policySet=" + policySet);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = CommonWorkSpaceHelper.getPolicySetFileName(policySet);
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean policySetFound = PolicySetWorkSpaceHelper.doesPolicySetExist(session, policySet);
        if (policySetFound) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0058E", new Object[]{policySet}, "Duplicate policy set is found: {0}"));
        }
        repContext.getOutputStream(expectedFileName);
        repContext.notifyChanged(0, expectedFileName);
        String fullPath = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        fullPath = fullPath.replace('/', File.separatorChar);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPolicySetFile, fullPath=" + fullPath);
        }
        return fullPath;
    }

    public static boolean deletePolicySet(Session session, String policySet) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deletePolicySet, policySet=" + policySet);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        List fileList = repContext.getAllList(false);
        ArrayList<String> deletedFiles = new ArrayList<String>();
        boolean policySetFound = false;
        String fileName = null;
        String psFileNamePrefix = CommonWorkSpaceHelper.getPolicySetFilePrefix(policySet, false);
        for (int k = 0; k < fileList.size(); ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (!fileName.startsWith(psFileNamePrefix)) continue;
            policySetFound = true;
            if (!repContext.isExtracted(fileName)) {
                repContext.extract(fileName, false);
            }
            deletedFiles.add(fileName);
        }
        if (!policySetFound) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{policySet}, "Policy set is not found: {0}"));
        }
        repContext.notifyChanged(2, deletedFiles);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deletePolicySet, policySet=" + policySet);
        }
        return true;
    }

    public static boolean copyPolicySetFiles(Session session, List fileList, String destinationDir, String sourcePolicySet, String destPolicySet) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyPolicySetFiles, fileList=" + fileList + ", destinationDir=" + destinationDir + ", sourcePolicySet=" + sourcePolicySet + ", destPolicySet=" + destPolicySet);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        Iterator fileListIt = fileList.iterator();
        String fileName = "";
        String modifiedFileName = "";
        String toFileName = "";
        boolean copyStatus = false;
        while (fileListIt.hasNext()) {
            fileName = (String)fileListIt.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fileName: " + fileName);
            }
            modifiedFileName = fileName.substring(fileName.indexOf("PolicySets"));
            modifiedFileName = modifiedFileName.replaceFirst(sourcePolicySet, destPolicySet);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modifiedFileName: " + modifiedFileName);
            }
            toFileName = destinationDir + File.separatorChar + modifiedFileName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "toFileName: " + toFileName);
            }
            repContext.getOutputStream(modifiedFileName);
            CommonWorkSpaceHelper.copyFile(fileName, toFileName);
            repContext.notifyChanged(0, modifiedFileName);
        }
        copyStatus = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyPolicySetFiles, sourcePolicySet=" + sourcePolicySet + ", destPolicySet=" + destPolicySet + ", copyStatus=" + copyStatus);
        }
        return copyStatus;
    }

    public static String getImportFileName(Session session, String zipFullName, String filePath) throws NoItemFoundException, WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getImportFileName", new Object[]{session, zipFullName, filePath});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        zipFullName = zipFullName.replace('\\', '/');
        repContext.getOutputStream(zipFullName);
        repContext.notifyChanged(0, zipFullName);
        String outFileName = filePath + File.separatorChar + zipFullName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getImportFileName: ", outFileName);
        }
        return outFileName;
    }
}

