/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.PolicyTypeWorkSpaceHelper;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class PolicySetCommandUtil
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(PolicySetCommandUtil.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());
    private static final String INVALID_CHAR_ERROR_MSG = "Invalid character in destination policy set name: {0}";
    private static final String FFDC_ID_1 = "FFDC-1";

    public static StringBuffer validatePolicySet(Session session, String policySetName, String policySetFilePath) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validatePolicySet, policySetName=" + policySetName + ", policySetFilePath=" + policySetFilePath);
        }
        StringBuffer invalidPolicyTypes = new StringBuffer();
        List<Object> policyTypeList = new ArrayList();
        policyTypeList = PolicyTypeWorkSpaceHelper.listPolicyTypes(session, policySetName);
        Iterator<Object> policyTypeListIt = policyTypeList.iterator();
        while (policyTypeListIt.hasNext()) {
            boolean policyTypeValid = false;
            String policyType = (String)policyTypeListIt.next();
            String policyTypeFilePath = PolicyTypeWorkSpaceHelper.getPolicyTypeFile(session, policySetName, policyType, false);
            if (policyTypeFilePath == null) continue;
            PolicyTypeProvider policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(policyType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Before validate, policyTypeProvider=" + policyTypeProvider + " " + policyType + " " + policyTypeFilePath);
            }
            if (policyTypeProvider != null) {
                block10: {
                    try {
                        HashMap context = new HashMap();
                        policyTypeValid = policyTypeProvider.validate(policySetFilePath, policyTypeFilePath, session, context);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, "PolicySetCommandUtil.validatePolicySet", FFDC_ID_1);
                        Tr.error(tc, "CWPST0028E", new Object[]{e.toString()});
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Exception caught - " + e);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "After validate, policyTypeValid=" + policyTypeValid);
                }
                if (policyTypeValid) continue;
                if (invalidPolicyTypes.length() > 0) {
                    invalidPolicyTypes.append(",");
                }
                invalidPolicyTypes.append(policyType);
                continue;
            }
            Tr.error(tc, "CWPST0042E", new Object[]{policyType});
            if (invalidPolicyTypes.length() > 0) {
                invalidPolicyTypes.append(",");
            }
            invalidPolicyTypes.append(policyType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validatePolicySet, invalidPolicyTypes=" + invalidPolicyTypes);
        }
        return invalidPolicyTypes;
    }

    public static void validatePolicySetName(String policySetName) throws IllegalArgumentException {
        StringCharacterIterator iter = new StringCharacterIterator(policySetName);
        char c = iter.first();
        while (c != '\uffff') {
            if (!Character.isWhitespace(c) && !Character.isLetterOrDigit(c) && "-_".indexOf(c) == -1) {
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0026E", new Object[]{policySetName}, INVALID_CHAR_ERROR_MSG));
            }
            c = iter.next();
        }
    }
}

