/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.policyset.admin.BindingDefinitionHelper;
import com.ibm.ws.policyset.admin.BindingDefinitionHelperFactory;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetBindingWorkSpaceHelper
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(PolicySetBindingWorkSpaceHelper.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());

    public static List<String> listBindingsForApplication(Session session, String appName, String attachmentType) throws WorkSpaceException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listBindingsForApplication, appName=" + appName);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String startPath = "META-INF" + File.separator;
        String endPath = File.separator + "bindings.xml";
        List<String> retList = PolicySetBindingWorkSpaceHelper.retrieveBindingNames(session, repContext, startPath, endPath, attachmentType, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listBindingsForApplication, retList=" + retList);
        }
        return retList;
    }

    public static List listBindingsForWSNClient(Session session, String busName, String serviceName) throws WorkSpaceException, Exception {
        String methodName = "listBindingsForWSNClient";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listBindingsForWSNClient", new Object[]{session, busName, serviceName});
        }
        RepositoryContext busesRepContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName);
        RepositoryContext wsnContext = (RepositoryContext)busesRepContext.findContext("wsn", serviceName).iterator().next();
        String startPath = "META-INF" + File.separator;
        String endPath = File.separator + "bindings.xml";
        List<String> retList = PolicySetBindingWorkSpaceHelper.retrieveBindingNames(session, wsnContext, startPath, endPath, "WSNClient", false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listBindingsForWSNClient", retList);
        }
        return retList;
    }

    public static List<String> listBindingsForTrust(Session session) throws WorkSpaceException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listBindingsForTrust");
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String startPath = "sts" + File.separator + "policy" + File.separator;
        String endPath = File.separator + "bindings.xml";
        List<String> retList = PolicySetBindingWorkSpaceHelper.retrieveBindingNames(session, repContext, startPath, endPath, "system/trust", false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listBindingsForTrust, retList=" + retList);
        }
        return retList;
    }

    public static List<String> listNamedBindings(Session session, String attachmentType) throws WorkSpaceException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listNamedBindings");
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String startPath = "bindings" + File.separator;
        String endPath = File.separator + "bindings.xml";
        List<String> retList = PolicySetBindingWorkSpaceHelper.retrieveBindingNames(session, repContext, startPath, endPath, attachmentType, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listNamedBindings, retList=" + retList);
        }
        return retList;
    }

    private static List<String> retrieveBindingNames(Session session, RepositoryContext repContext, String startPath, String endPath, String attachmentType, boolean namedBinding) throws WorkSpaceException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveBindingNames, startPath=" + startPath + ", endPath=" + endPath);
        }
        List fileList = repContext.getAllList(false);
        ArrayList<String> retList = new ArrayList<String>();
        String fileName = null;
        for (int k = 0; k < fileList.size(); ++k) {
            String bindingDir;
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieveBindingNames, fileName=" + fileName);
            }
            if (!fileName.endsWith(endPath) || !fileName.startsWith(startPath) || retList.contains(bindingDir = PolicySetBindingWorkSpaceHelper.getBindingDirName(fileName))) continue;
            if (attachmentType.equals("system/trust") || attachmentType.equals("WSNClient")) {
                retList.add(bindingDir);
                continue;
            }
            if (!namedBinding) {
                String indicatorFileName = PolicySetBindingWorkSpaceHelper.getProviderBindingIndicatorFileName(bindingDir);
                if ((repContext.isAvailable(indicatorFileName) || !attachmentType.equals("client")) && (!repContext.isAvailable(indicatorFileName) || !attachmentType.equals("application"))) continue;
                retList.add(bindingDir);
                continue;
            }
            String pathname = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFile(session, bindingDir);
            BindingDefinitionHelper bindingHelper = BindingDefinitionHelperFactory.createHelper(pathname);
            bindingHelper.setLocale(CommonUtil.getLocale());
            String bindingType = bindingHelper.getBindingType();
            if ((!bindingType.equals("provider") || !attachmentType.equals("application")) && (!bindingType.equals("client") || !attachmentType.equals("client"))) continue;
            retList.add(bindingDir);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveBindingNames, retList=" + retList);
        }
        return retList;
    }

    public static String getApplicationBindingFile(Session session, String appName, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getApplicationBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationBindingFile, appName=" + appName + ", bindingName=" + bindingName + ", policyType=" + policyType);
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getApplicationBindingFileName(bindingName, policyType);
        String fullPath = PolicySetBindingWorkSpaceHelper.getBindingFile(appRepContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationBindingFile", fullPath);
        }
        return fullPath;
    }

    public static String createApplicationBindingFile(Session session, String appName, String bindingName, String policyType, String attachmentType) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException, IOException {
        String indicatorFileName;
        String expectedFileName;
        RepositoryContext appRepContext;
        String fullPath;
        String methodName = "createApplicationBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createApplicationBindingFile, appName=" + appName + ", bindingName=" + bindingName + ", policyType=" + policyType + ", attachmentType=" + attachmentType);
        }
        if ((fullPath = PolicySetBindingWorkSpaceHelper.createBindingFile(appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName), expectedFileName = PolicySetBindingWorkSpaceHelper.getApplicationBindingFileName(bindingName, policyType))) == null) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0085E", new Object[]{appName}, "Duplicate bindings.xml already exists: {0}"));
        }
        if (attachmentType.equals("application") && !appRepContext.isAvailable(indicatorFileName = PolicySetBindingWorkSpaceHelper.getProviderBindingIndicatorFileName(bindingName))) {
            appRepContext.getOutputStream(indicatorFileName);
            String indicatorPath = CommonWorkSpaceHelper.getFullPath(appRepContext, indicatorFileName);
            CommonWorkSpaceHelper.writeFile(indicatorPath);
            appRepContext.notifyChanged(0, indicatorFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createApplicationBindingFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateApplicationBindingFile(Session session, String appName, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateApplicationBindingFile, appName=" + appName + ", bindingName=" + bindingName + ", policyType=" + policyType);
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getApplicationBindingFileName(bindingName, policyType);
        appRepContext.notifyChanged(1, expectedFileName);
        return true;
    }

    public static boolean deleteApplicationBindingFile(Session session, String appName, String bindingName, String policyType, String attachmentType) throws WorkSpaceException, NoItemFoundException, IOException {
        String expectedFileName;
        RepositoryContext appRepContext;
        boolean delete;
        String methodName = "deleteApplicationBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteApplicationBindingFile, appName=" + appName + ", bindingName=" + bindingName + ", policyType=" + policyType + ", attachmentType=" + attachmentType);
        }
        if (!(delete = PolicySetBindingWorkSpaceHelper.deleteBindingFile(appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName), expectedFileName = PolicySetBindingWorkSpaceHelper.getApplicationBindingFileName(bindingName, policyType)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{bindingName}, "Binding file is not found: {0}"));
        }
        if (attachmentType.equals("application")) {
            String indicatorFileName = PolicySetBindingWorkSpaceHelper.getProviderBindingIndicatorFileName(bindingName);
            PolicySetBindingWorkSpaceHelper.deleteBindingFile(appRepContext, indicatorFileName);
        } else if (PolicySetBindingWorkSpaceHelper.getNamedBindingDir(session, bindingName, true) == null) {
            String definitionFileName = PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFileName(bindingName);
            PolicySetBindingWorkSpaceHelper.deleteBindingFile(appRepContext, definitionFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteApplicationBindingFile", delete);
        }
        return delete;
    }

    public static boolean deleteApplicationBinding(Session session, String appName, String bindingName) throws WorkSpaceException, NoItemFoundException {
        String psFileNamePrefix;
        RepositoryContext appRepContext;
        boolean deleted;
        String methodName = "deleteApplicationBinding";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteApplicationBinding, appName=" + appName + ", bindingName=" + bindingName);
        }
        if (!(deleted = PolicySetBindingWorkSpaceHelper.deleteBinding(appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName), psFileNamePrefix = PolicySetBindingWorkSpaceHelper.getBindingDirPrefix(bindingName)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{bindingName}, "Binding file is not found: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteApplicationBinding", deleted);
        }
        return deleted;
    }

    public static String getApplicationBindingDir(Session session, String appName, String bindingName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getApplicationBindingDir";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationBindingDir, appName=" + appName + ", bindingName=" + bindingName);
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String bindingFileNamePrefix = PolicySetBindingWorkSpaceHelper.getBindingDirPrefix(bindingName);
        String bindingDir = PolicySetBindingWorkSpaceHelper.getBindingDir(appRepContext, bindingFileNamePrefix);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationBindingDir", bindingDir);
        }
        return bindingDir;
    }

    public static String getCellDefaultBindingFile(Session session, String policyType) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getCellDefaultBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellDefaultBindingFile, policyType=" + policyType);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getCellDefaultBindingFileName(policyType);
        String fullPath = PolicySetBindingWorkSpaceHelper.getBindingFile(repContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellDefaultBindingFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateCellDefaultBindingFile(Session session, String policyType) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCellDefaultBindingFile, policyType=" + policyType);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getCellDefaultBindingFileName(policyType);
        repContext.notifyChanged(1, expectedFileName);
        return true;
    }

    public static String getServerDefaultBindingFile(Session session, String policyType, String node, String server) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getServerDefaultBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerDefaultBindingFile, policyType=" + policyType + ", node=" + node + ", server=" + server);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getServerRepositoryContext(session, node, server);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getServerDefaultBindingFileName(policyType);
        String fullPath = PolicySetBindingWorkSpaceHelper.getBindingFile(repContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerDefaultBindingFile", fullPath);
        }
        return fullPath;
    }

    public static String createServerDefaultBindingFile(Session session, String policyType, String node, String server) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        String fullPath;
        String methodName = "createServerDefaultBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerDefaultBindingFile, policyType=" + policyType + ", node=" + node + ", server=" + server);
        }
        if ((fullPath = PolicySetBindingWorkSpaceHelper.createBindingFile(repContext = CommonWorkSpaceHelper.getServerRepositoryContext(session, node, server), expectedFileName = PolicySetBindingWorkSpaceHelper.getServerDefaultBindingFileName(policyType))) == null) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0085E", new Object[]{server}, "Duplicate bindings.xml already exists: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerDefaultBindingFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateServerDefaultBindingFile(Session session, String policyType, String node, String server) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerDefaultBindingFile, policyType=" + policyType + ", node=" + node + ", server=" + server);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getServerRepositoryContext(session, node, server);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getServerDefaultBindingFileName(policyType);
        repContext.notifyChanged(1, expectedFileName);
        return true;
    }

    public static boolean deleteCellDefaultBindingFile(Session session, String policyType) throws WorkSpaceException, NoItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        boolean delete;
        String methodName = "deleteCellDefaultBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteCellDefaultBindingFile, policyType=" + policyType);
        }
        if (!(delete = PolicySetBindingWorkSpaceHelper.deleteBindingFile(repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session), expectedFileName = PolicySetBindingWorkSpaceHelper.getCellDefaultBindingFileName(policyType)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0064E", new Object[]{policyType}, "The {0} default cell-level binding file is not found."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteCellDefaultBindingFile");
        }
        return delete;
    }

    public static boolean deleteServerDefaultBindingFile(Session session, String policyType, String node, String server) throws WorkSpaceException, NoItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        boolean delete;
        String methodName = "deleteServerDefaultBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteServerDefaultBindingFile, policyType=" + policyType + ", node=" + node + ", server=" + server);
        }
        if (!(delete = PolicySetBindingWorkSpaceHelper.deleteBindingFile(repContext = CommonWorkSpaceHelper.getServerRepositoryContext(session, node, server), expectedFileName = PolicySetBindingWorkSpaceHelper.getServerDefaultBindingFileName(policyType)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0065E", new Object[]{policyType}, "Default server-level binding file is not found: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteServerDefaultBindingFile");
        }
        return delete;
    }

    public static String getApplicationBindingDefinitionFile(Session session, String appName, String bindingName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getApplicationBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationBindingFile, appName=" + appName + ", bindingName=" + bindingName);
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFileName(bindingName);
        String fullPath = PolicySetBindingWorkSpaceHelper.getBindingFile(appRepContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationBindingFile", fullPath);
        }
        return fullPath;
    }

    public static String createApplicationBindingDefinitionFile(Session session, String appName, String bindingName) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String expectedFileName;
        RepositoryContext appRepContext;
        String fullPath;
        String methodName = "createNamedBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNamedBindingFile, bindingName=" + bindingName);
        }
        if ((fullPath = PolicySetBindingWorkSpaceHelper.createBindingFile(appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName), expectedFileName = PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFileName(bindingName))) == null) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0085E", new Object[]{bindingName}, "Duplicate bindings.xml already exists: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNamedBindingFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateApplicationBindingDefinitionFile(Session session, String appName, String bindingName) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNamedBindingFile, bindingName=" + bindingName);
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getApplicationBindingDefinitionFileName(bindingName);
        appRepContext.notifyChanged(1, expectedFileName);
        return true;
    }

    public static String getTrustBindingFile(Session session, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getTrustBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustBindingFile, bindingName=" + bindingName + ", policyType=" + policyType);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getTrustBindingFileName(bindingName, policyType);
        String fullPath = PolicySetBindingWorkSpaceHelper.getBindingFile(repContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustBindingFile", fullPath);
        }
        return fullPath;
    }

    public static String createTrustBindingFile(Session session, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        String fullPath;
        String methodName = "createTrustBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTrustBindingFile, bindingName=" + bindingName + ", policyType=" + policyType);
        }
        if ((fullPath = PolicySetBindingWorkSpaceHelper.createBindingFile(repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session), expectedFileName = PolicySetBindingWorkSpaceHelper.getTrustBindingFileName(bindingName, policyType))) == null) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0085E", new Object[]{bindingName}, "Duplicate bindings.xml already exists: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTrustBindingFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateTrustBindingFile(Session session, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateTrustBindingFile, bindingName=" + bindingName + ", policyType=" + policyType);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getTrustBindingFileName(bindingName, policyType);
        repContext.notifyChanged(1, expectedFileName);
        return true;
    }

    public static boolean deleteTrustBindingFile(Session session, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        boolean delete;
        String methodName = "deleteTrustBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteTrustBindingFile, bindingName=" + bindingName + ", policyType=" + policyType);
        }
        if (!(delete = PolicySetBindingWorkSpaceHelper.deleteBindingFile(repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session), expectedFileName = PolicySetBindingWorkSpaceHelper.getTrustBindingFileName(bindingName, policyType)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0086E", new Object[]{bindingName, policyType}, "Binding file {0} is not found for policy type {1}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteTrustBindingFile");
        }
        return delete;
    }

    public static boolean deleteTrustBinding(Session session, String bindingName) throws WorkSpaceException, NoItemFoundException {
        String bindingFileNamePrefix;
        RepositoryContext repContext;
        boolean deleted;
        String methodName = "deleteTrustBinding";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteTrustBinding, bindingName=" + bindingName);
        }
        if (!(deleted = PolicySetBindingWorkSpaceHelper.deleteBinding(repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session), bindingFileNamePrefix = PolicySetBindingWorkSpaceHelper.getTrustBindingDirPrefix(bindingName)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{bindingName}, "Binding file is not found: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteTrustBinding", deleted);
        }
        return deleted;
    }

    public static String getTrustBindingDir(Session session, String bindingName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getTrustBindingDir";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustBindingDir, bindingName=" + bindingName);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String bindingFileNamePrefix = PolicySetBindingWorkSpaceHelper.getTrustBindingDirPrefix(bindingName);
        String bindingDir = PolicySetBindingWorkSpaceHelper.getBindingDir(repContext, bindingFileNamePrefix);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustBindingDir", bindingDir);
        }
        return bindingDir;
    }

    public static String getWSNClientBindingFile(Session session, String bindingName, String policyType, String busName, String serviceName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getWSNClientBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSNClientBindingFile", new Object[]{session, bindingName, policyType, busName, serviceName});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName);
        RepositoryContext wsnContext = (RepositoryContext)repContext.findContext("wsn", serviceName).iterator().next();
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getWSNClientBindingFileName(serviceName, bindingName, policyType);
        String fullPath = PolicySetBindingWorkSpaceHelper.getBindingFile(wsnContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSNClientBindingFile", fullPath);
        }
        return fullPath;
    }

    public static String getWSNClientBindingDir(Session session, String bindingName, String busName, String serviceName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getWSNClientBindingDir";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSNClientBindingDir", new Object[]{session, bindingName, busName, serviceName});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName);
        RepositoryContext wsnContext = (RepositoryContext)repContext.findContext("wsn", serviceName).iterator().next();
        String bindingFileNamePrefix = PolicySetBindingWorkSpaceHelper.getWSNClientBindingDirPrefix(serviceName, bindingName);
        String bindingDir = PolicySetBindingWorkSpaceHelper.getBindingDir(wsnContext, bindingFileNamePrefix);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSNClientBindingDir", bindingDir);
        }
        return bindingDir;
    }

    public static String createWSNClientBindingFile(Session session, String bindingName, String policyType, String busName, String serviceName) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        RepositoryContext wsnContext;
        String fullPath;
        String methodName = "createWSNClientBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createWSNClientBindingFile", new Object[]{session, bindingName, policyType, busName, serviceName});
        }
        if ((fullPath = PolicySetBindingWorkSpaceHelper.createBindingFile(wsnContext = (RepositoryContext)(repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName)).findContext("wsn", serviceName).iterator().next(), expectedFileName = PolicySetBindingWorkSpaceHelper.getWSNClientBindingFileName(serviceName, bindingName, policyType))) == null) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0085E", new Object[]{bindingName}, "Duplicate bindings.xml already exists: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createWSNClientBindingFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateWSNClientBindingFile(Session session, String bindingName, String policyType, String busName, String serviceName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "updateWSNClientBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, methodName, new Object[]{session, bindingName, policyType, busName, serviceName});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName);
        RepositoryContext wsnContext = (RepositoryContext)repContext.findContext("wsn", serviceName).iterator().next();
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getWSNClientBindingFileName(serviceName, bindingName, policyType);
        wsnContext.notifyChanged(1, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, methodName, true);
        }
        return true;
    }

    public static boolean deleteWSNClientBindingFile(Session session, String bindingName, String policyType, String busName, String serviceName) throws WorkSpaceException, NoItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        RepositoryContext wsnContext;
        boolean delete;
        String methodName = "deleteWSNClientBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteWSNClientBindingFile");
        }
        if (!(delete = PolicySetBindingWorkSpaceHelper.deleteBindingFile(wsnContext = (RepositoryContext)(repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName)).findContext("wsn", serviceName).iterator().next(), expectedFileName = PolicySetBindingWorkSpaceHelper.getWSNClientBindingFileName(serviceName, bindingName, policyType)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0086E", new Object[]{bindingName, policyType}, "Binding file {0} is not found for policy type {1}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteWSNClientBindingFile");
        }
        return delete;
    }

    public static boolean deleteWSNClientBinding(Session session, String bindingName, String busName, String serviceName) throws WorkSpaceException, NoItemFoundException {
        String bindingFileNamePrefix;
        RepositoryContext repContext;
        RepositoryContext wsnContext;
        boolean deleted;
        String methodName = "deleteWSNClientBinding";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteWSNClientBinding", new Object[]{session, bindingName, busName, serviceName});
        }
        if (!(deleted = PolicySetBindingWorkSpaceHelper.deleteBinding(wsnContext = (RepositoryContext)(repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName)).findContext("wsn", serviceName).iterator().next(), bindingFileNamePrefix = PolicySetBindingWorkSpaceHelper.getWSNClientBindingDirPrefix(serviceName, bindingName)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{bindingName}, "Binding file is not found: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteWSNClientBinding", deleted);
        }
        return deleted;
    }

    private static String getBindingFile(RepositoryContext repContext, String expectedFileName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingFile", new Object[]{repContext, expectedFileName});
        }
        String fullPath = null;
        if (repContext.isAvailable(expectedFileName)) {
            if (!repContext.isExtracted(expectedFileName)) {
                repContext.extract(expectedFileName, false);
            }
            fullPath = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBindingFile", fullPath);
        }
        return fullPath;
    }

    public static String getNamedBindingFile(Session session, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getNamedBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamedBindingFile, bindingName=" + bindingName + ", policyType=" + policyType);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getNamedBindingFileName(bindingName, policyType);
        String fullPath = PolicySetBindingWorkSpaceHelper.getBindingFile(repContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamedBindingFile", fullPath);
        }
        return fullPath;
    }

    public static String createNamedBindingFile(Session session, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        String fullPath;
        String methodName = "createNamedBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNamedBindingFile, bindingName=" + bindingName + ", policyType=" + policyType);
        }
        if ((fullPath = PolicySetBindingWorkSpaceHelper.createBindingFile(repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session), expectedFileName = PolicySetBindingWorkSpaceHelper.getNamedBindingFileName(bindingName, policyType))) == null) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0085E", new Object[]{bindingName}, "Duplicate bindings.xml already exists: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNamedBindingFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateNamedBindingFile(Session session, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNamedBindingFile, bindingName=" + bindingName + ", policyType=" + policyType);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getNamedBindingFileName(bindingName, policyType);
        repContext.notifyChanged(1, expectedFileName);
        return true;
    }

    public static boolean deleteNamedBindingFile(Session session, String bindingName, String policyType) throws WorkSpaceException, NoItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        boolean delete;
        String methodName = "deleteNamedBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteNamedBindingFile, bindingName=" + bindingName + ", policyType=" + policyType);
        }
        if (!(delete = PolicySetBindingWorkSpaceHelper.deleteBindingFile(repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session), expectedFileName = PolicySetBindingWorkSpaceHelper.getNamedBindingFileName(bindingName, policyType)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0086E", new Object[]{bindingName, policyType}, "Binding file {0} is not found for policy type {1}"));
        }
        if (PolicySetBindingWorkSpaceHelper.getNamedBindingDir(session, bindingName, true) == null) {
            String definitionFileName = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFileName(bindingName);
            PolicySetBindingWorkSpaceHelper.deleteBindingFile(repContext, definitionFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteNamedBindingFile");
        }
        return delete;
    }

    public static boolean deleteNamedBinding(Session session, String bindingName) throws WorkSpaceException, NoItemFoundException {
        String bindingFileNamePrefix;
        RepositoryContext repContext;
        boolean deleted;
        String methodName = "deleteNamedBinding";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteNamedBinding, bindingName=" + bindingName);
        }
        if (!(deleted = PolicySetBindingWorkSpaceHelper.deleteBinding(repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session), bindingFileNamePrefix = PolicySetBindingWorkSpaceHelper.getNamedBindingDirPrefix(bindingName, false)))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{bindingName}, "Binding file is not found: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteNamedBinding", deleted);
        }
        return deleted;
    }

    public static String getNamedBindingDefinitionFile(Session session, String bindingName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getNamedBindingDefinitionFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamedBindingDefinitionFile, bindingName=" + bindingName);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFileName(bindingName);
        String fullPath = PolicySetBindingWorkSpaceHelper.getBindingFile(repContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamedBindingDefinitionFile", fullPath);
        }
        return fullPath;
    }

    public static String getNamedBindingDir(Session session, String bindingName, boolean includePolicyTypes) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getNamedBindingDir";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamedBindingDir, bindingName=" + bindingName);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String bindingFileNamePrefix = null;
        bindingFileNamePrefix = includePolicyTypes ? PolicySetBindingWorkSpaceHelper.getNamedBindingPolicyTypesDirPrefix(bindingName) : PolicySetBindingWorkSpaceHelper.getNamedBindingDirPrefix(bindingName, false);
        String bindingDir = PolicySetBindingWorkSpaceHelper.getBindingDir(repContext, bindingFileNamePrefix);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamedBindingDir", bindingDir);
        }
        return bindingDir;
    }

    private static String getBindingDir(RepositoryContext repContext, String bindingFileNamePrefix) {
        String methodName = "getBindingDir";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingDir", new Object[]{repContext, bindingFileNamePrefix});
        }
        String bindingDir = null;
        List fileList = repContext.getAllList(false);
        boolean bindingFound = false;
        String fileName = null;
        for (int k = 0; k < fileList.size() && !bindingFound; ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (!fileName.startsWith(bindingFileNamePrefix)) continue;
            bindingFound = true;
        }
        if (bindingFound) {
            bindingDir = bindingFileNamePrefix;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBindingDir", bindingDir);
        }
        return bindingDir;
    }

    public static String createNamedBindingDefinitionFile(Session session, String bindingName) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        String fullPath;
        String methodName = "createNamedBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNamedBindingFile, bindingName=" + bindingName);
        }
        if ((fullPath = PolicySetBindingWorkSpaceHelper.createBindingFile(repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session), expectedFileName = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFileName(bindingName))) == null) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0161E", new Object[]{bindingName}, "A duplicate bindingDefinition.xml file already exists: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNamedBindingFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateNamedBindingDefinitionFile(Session session, String bindingName) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNamedBindingFile, bindingName=" + bindingName);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFileName(bindingName);
        repContext.notifyChanged(1, expectedFileName);
        return true;
    }

    public static List<String> getBindingDirectoryFiles(Session session, String binding) throws WorkSpaceException, NoItemFoundException {
        String expectedFileName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingDirectoryFiles, binding=" + binding);
        }
        ArrayList<String> retList = new ArrayList<String>();
        String fileName = null;
        boolean trDebug = tc.isDebugEnabled();
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        if (!repContext.isAvailable(expectedFileName = PolicySetBindingWorkSpaceHelper.getNamedBindingDefinitionFileName(binding))) {
            throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0063E", new Object[]{binding}, "The {0} binding file is not found"));
        }
        List fileList = repContext.getAllList(false);
        for (int k = 0; k < fileList.size(); ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (fileName.equals("bindings" + File.separatorChar + binding) || fileName.startsWith("bindings" + File.separatorChar + binding + File.separatorChar)) {
                if (!repContext.isExtracted(fileName)) {
                    repContext.extract(fileName, false);
                }
                retList.add(CommonWorkSpaceHelper.getFullPath(repContext, fileName));
            }
            if (!trDebug) continue;
            Tr.debug(tc, "getBindingDirectoryFiles, fileName=" + fileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBindingDirectoryFiles, retList.size()=" + retList.size());
        }
        return retList;
    }

    public static boolean copyNamedBindingFiles(Session session, List fileList, String destinationDir, String sourceBinding, String destBinding) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyNamedBindingFiles, fileList=" + fileList + ", destinationDir=" + destinationDir + ", sourceBinding=" + sourceBinding + ", destBinding=" + destBinding);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        Iterator fileListIt = fileList.iterator();
        String fileName = "";
        String modifiedFileName = "";
        String toFileName = "";
        boolean copyStatus = false;
        while (fileListIt.hasNext()) {
            fileName = (String)fileListIt.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fileName: " + fileName);
            }
            modifiedFileName = fileName.substring(fileName.indexOf("bindings"));
            modifiedFileName = modifiedFileName.replaceFirst(sourceBinding, destBinding);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modifiedFileName: " + modifiedFileName);
            }
            toFileName = destinationDir + File.separatorChar + modifiedFileName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "toFileName: " + toFileName);
            }
            repContext.getOutputStream(modifiedFileName);
            CommonWorkSpaceHelper.copyFile(fileName, toFileName);
            repContext.notifyChanged(0, modifiedFileName);
        }
        copyStatus = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyNamedBindingFiles, sourceBinding=" + sourceBinding + ", destBinding=" + destBinding + ", copyStatus=" + copyStatus);
        }
        return copyStatus;
    }

    public static boolean doesNamedBindingExist(Session session, String binding) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesNamedBindingExist, binding=" + binding);
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        List fileList = repContext.getAllList(false);
        boolean bindingFound = false;
        String fileName = null;
        String bindingNamePrefix = PolicySetBindingWorkSpaceHelper.getNamedBindingDirPrefix(binding, true);
        for (int k = 0; k < fileList.size() && !bindingFound; ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (!fileName.toLowerCase().startsWith(bindingNamePrefix)) continue;
            bindingFound = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesNamedBindingExist, bindingFound=" + bindingFound);
        }
        return bindingFound;
    }

    public static String getDefaultBindingsFile(Session session) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getDefaultBindingsFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultBindingsFile");
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getDefaultBindingsFileName();
        String fullPath = PolicySetBindingWorkSpaceHelper.getBindingFile(repContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultBindingsFile", fullPath);
        }
        return fullPath;
    }

    public static String createDefaultBindingsFile(Session session) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String expectedFileName;
        RepositoryContext repContext;
        String fullPath;
        String methodName = "createDefaultBindingsFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDefaultBindingsFile");
        }
        if ((fullPath = PolicySetBindingWorkSpaceHelper.createBindingFile(repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session), expectedFileName = PolicySetBindingWorkSpaceHelper.getDefaultBindingsFileName())) == null) {
            throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0130E", new Object[0], "Duplicate defaultBindings.xml already exists"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultBindingsFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateDefaultBindingsFile(Session session) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNamedBindingFile");
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetBindingWorkSpaceHelper.getDefaultBindingsFileName();
        repContext.notifyChanged(1, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNamedBindingFile");
        }
        return true;
    }

    private static String createBindingFile(RepositoryContext repContext, String expectedFileName) throws WorkSpaceException {
        String methodName = "createBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBindingFile", new Object[]{repContext, expectedFileName});
        }
        String fullPath = null;
        if (repContext.isAvailable(expectedFileName)) {
            fullPath = null;
        } else {
            repContext.getOutputStream(expectedFileName);
            repContext.notifyChanged(0, expectedFileName);
            fullPath = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBindingFile", fullPath);
        }
        return fullPath;
    }

    private static boolean deleteBindingFile(RepositoryContext repContext, String expectedFileName) throws WorkSpaceException {
        String methodName = "deleteBindingFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteBindingFile", new Object[]{repContext, expectedFileName});
        }
        boolean delete = false;
        if (repContext.isAvailable(expectedFileName)) {
            if (!repContext.isExtracted(expectedFileName)) {
                repContext.extract(expectedFileName, false);
            }
            repContext.notifyChanged(2, expectedFileName);
            delete = true;
        } else {
            delete = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBindingFile", delete);
        }
        return delete;
    }

    private static boolean deleteBinding(RepositoryContext repContext, String bindingFileNamePrefix) throws NoItemFoundException, WorkSpaceException {
        String methodName = "deleteBinding";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteBinding", new Object[]{repContext, bindingFileNamePrefix});
        }
        boolean deleted = false;
        List fileList = repContext.getAllList(false);
        ArrayList<String> deletedFiles = new ArrayList<String>();
        String fileName = null;
        for (int k = 0; k < fileList.size(); ++k) {
            fileName = ((WorkSpaceFile)fileList.get(k)).getFileName();
            if (!fileName.startsWith(bindingFileNamePrefix)) continue;
            if (!repContext.isExtracted(fileName)) {
                repContext.extract(fileName, false);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding file to delete list: " + fileName);
            }
            deletedFiles.add(fileName);
        }
        if (!deletedFiles.isEmpty()) {
            repContext.notifyChanged(2, deletedFiles);
            deleted = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBinding", deleted);
        }
        return deleted;
    }

    private static String getApplicationBindingFileName(String bindingName, String policyType) {
        StringBuffer buf = new StringBuffer();
        buf.append("META-INF").append(File.separator).append(bindingName).append(File.separator).append("PolicyTypes").append(File.separator).append(policyType).append(File.separator).append("bindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getApplicationBindingFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getApplicationBindingDefinitionFileName(String bindingName) {
        StringBuffer buf = new StringBuffer();
        buf.append("META-INF").append(File.separator).append(bindingName).append(File.separator).append("bindingDefinition.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getApplicationBindingDefinitionFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getWSNClientBindingFileName(String serviceName, String bindingName, String policyType) {
        String methodName = "getWSNClientBindingFileName";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSNClientBindingFileName", new Object[]{serviceName, bindingName, policyType});
        }
        String wsnClientFilePath = "META-INF" + File.separator + bindingName + File.separator + "PolicyTypes" + File.separator + policyType + File.separator + "bindings.xml";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSNClientBindingFileName", wsnClientFilePath);
        }
        return wsnClientFilePath;
    }

    private static String getProviderBindingIndicatorFileName(String bindingName) {
        StringBuffer buf = new StringBuffer();
        buf.append("META-INF").append(File.separator).append(bindingName).append(File.separator).append("provider.txt");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getProviderBindingIndicatorFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getTrustBindingFileName(String bindingName, String policyType) {
        StringBuffer buf = new StringBuffer();
        buf.append("sts").append(File.separator).append("policy").append(File.separator).append(bindingName).append(File.separator).append("PolicyTypes").append(File.separator).append(policyType).append(File.separator).append("bindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTrustBindingFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getNamedBindingFileName(String bindingName, String policyType) {
        StringBuffer buf = new StringBuffer();
        buf.append("bindings").append(File.separator).append(bindingName).append(File.separator).append("PolicyTypes").append(File.separator).append(policyType).append(File.separator).append("bindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getNamedBindingFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getNamedBindingDefinitionFileName(String bindingName) {
        StringBuffer buf = new StringBuffer();
        buf.append("bindings").append(File.separator).append(bindingName).append(File.separator).append("bindingDefinition.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getNamedBindingDefinitionFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getDefaultBindingsFileName() {
        StringBuffer buf = new StringBuffer();
        buf.append("bindings").append(File.separator).append("defaultBindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDefaultBindingsFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getCellDefaultBindingFileName(String policyType) {
        StringBuffer buf = new StringBuffer();
        buf.append("PolicyTypes").append(File.separator).append(policyType).append(File.separator).append("bindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCellDefaultBindingFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getServerDefaultBindingFileName(String policyType) {
        StringBuffer buf = new StringBuffer();
        buf.append("PolicyTypes").append(File.separator).append(policyType).append(File.separator).append("bindings.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerDefaultBindingFileName, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getBindingDirPrefix(String bindingName) {
        StringBuffer buf = new StringBuffer();
        buf.append("META-INF").append(File.separator).append(bindingName).append(File.separator);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBindingDirPrefix, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getTrustBindingDirPrefix(String bindingName) {
        StringBuffer buf = new StringBuffer();
        buf.append("sts").append(File.separator).append("policy").append(File.separator).append(bindingName).append(File.separator);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTrustBindingDirPrefix, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getNamedBindingDirPrefix(String bindingName, boolean toLowerCase) {
        StringBuffer buf = new StringBuffer();
        buf.append("bindings").append(File.separator).append(bindingName).append(File.separator);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getNamedBindingDirPrefix, buf.toString()=" + buf.toString());
        }
        if (toLowerCase) {
            return buf.toString().toLowerCase();
        }
        return buf.toString();
    }

    private static String getNamedBindingPolicyTypesDirPrefix(String bindingName) {
        StringBuffer buf = new StringBuffer();
        buf.append("bindings").append(File.separator).append(bindingName).append(File.separator).append("PolicyTypes").append(File.separator);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getNamedBindingPolicyTypesDirPrefix, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getWSNClientBindingDirPrefix(String serviceName, String bindingName) {
        String methodName = "getWSNClientBindingDirPrefix";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSNClientBindingDirPrefix", new Object[]{serviceName, bindingName});
        }
        String wsnClientBindingDir = "META-INF" + File.separator + bindingName + File.separator;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSNClientBindingDirPrefix", wsnClientBindingDir);
        }
        return wsnClientBindingDir;
    }

    private static String getBindingDirName(String filePath) {
        int index = filePath.lastIndexOf("PolicyTypes");
        String str1 = filePath.substring(0, index - 1);
        index = str1.lastIndexOf(File.separatorChar);
        String dirName = str1.substring(index + 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLastDirName, filePath=" + filePath + ", str1=" + str1 + ", dirName=" + dirName);
        }
        return dirName;
    }
}

