/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.commands.util.CommonWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.util.PolicyControlWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelper;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelperFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetAttachmentWorkSpaceHelper
implements PolicyConstants {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentWorkSpaceHelper.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", CommonUtil.getLocale());

    public static String getPolicySetAttachmentFile(Session session, String appName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getPolicySetAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetAttachmentFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = "META-INF" + File.separator + "policyAttachments.xml";
        String fullPath = PolicySetAttachmentWorkSpaceHelper.getAttachmentFile(appRepContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static String createPolicySetAttachmentFile(Session session, String appName) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String methodName = "createPolicySetAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPolicySetAttachmentFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = "META-INF" + File.separator + "policyAttachments.xml";
        String fullPath = PolicySetAttachmentWorkSpaceHelper.createAttachmentFile(appRepContext, expectedFileName, "application", new Object[]{appName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPolicySetAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updatePolicySetAttachmentFile(Session session, String appName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "updatePolicySetAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePolicySetAttachmentFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = "META-INF" + File.separator + "policyAttachments.xml";
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean update = PolicySetAttachmentWorkSpaceHelper.updateAttachmentFile(appRepContext, expectedFileName, "application", new Object[]{appName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updatePolicySetAttachmentFile", update);
        }
        return update;
    }

    public static boolean deletePolicySetAttachmentFile(Session session, String appName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "deletePolicySetAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deletePolicySetAttachmentFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = "META-INF" + File.separator + "policyAttachments.xml";
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean delete = PolicySetAttachmentWorkSpaceHelper.deleteAttachmentFile(appRepContext, expectedFileName, "application", new Object[]{appName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deletePolicySetAttachmentFile", delete);
        }
        return delete;
    }

    public static String getTrustAttachmentFile(Session session) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getTrustAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustAttachmentFile", new Object[]{session});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetAttachmentWorkSpaceHelper.getTrustFilePath();
        String fullPath = PolicySetAttachmentWorkSpaceHelper.getAttachmentFile(repContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static String createTrustAttachmentFile(Session session) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String methodName = "createTrustAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTrustAttachmentFile", new Object[]{session});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetAttachmentWorkSpaceHelper.getTrustFilePath();
        String fullPath = PolicySetAttachmentWorkSpaceHelper.createAttachmentFile(repContext, expectedFileName, "system/trust", new Object[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTrustAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateTrustAttachmentFile(Session session) throws WorkSpaceException, NoItemFoundException {
        String methodName = "updateTrustAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateTrustAttachmentFile", new Object[]{session});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetAttachmentWorkSpaceHelper.getTrustFilePath();
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean update = PolicySetAttachmentWorkSpaceHelper.updateAttachmentFile(repContext, expectedFileName, "system/trust", new Object[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateTrustAttachmentFile", update);
        }
        return update;
    }

    public static boolean deleteTrustAttachmentFile(Session session) throws WorkSpaceException, NoItemFoundException {
        String methodName = "deleteTrustAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteTrustAttachmentFile", new Object[]{session});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
        String expectedFileName = PolicySetAttachmentWorkSpaceHelper.getTrustFilePath();
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean delete = PolicySetAttachmentWorkSpaceHelper.deleteAttachmentFile(repContext, expectedFileName, "system/trust", new Object[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteTrustAttachmentFile", delete);
        }
        return delete;
    }

    public static String getClientAttachmentFile(Session session, String appName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAttachmentFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = "META-INF" + File.separator + "clientPolicyAttachments.xml";
        String fullPath = PolicySetAttachmentWorkSpaceHelper.getAttachmentFile(appRepContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static String createClientAttachmentFile(Session session, String appName) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String methodName = "createClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClientAttachmentFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = "META-INF" + File.separator + "clientPolicyAttachments.xml";
        String fullPath = PolicySetAttachmentWorkSpaceHelper.createAttachmentFile(appRepContext, expectedFileName, "client", new Object[]{appName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClientAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateClientAttachmentFile(Session session, String appName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "updateClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateClientAttachmentFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = "META-INF" + File.separator + "clientPolicyAttachments.xml";
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean update = PolicySetAttachmentWorkSpaceHelper.updateAttachmentFile(appRepContext, expectedFileName, "client", new Object[]{appName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateClientAttachmentFile", update);
        }
        return update;
    }

    public static boolean deleteClientAttachmentFile(Session session, String appName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "deleteClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteClientAttachmentFile", new Object[]{session, appName});
        }
        RepositoryContext appRepContext = CommonWorkSpaceHelper.getAppRepositoryContext(session, appName);
        String expectedFileName = "META-INF" + File.separator + "clientPolicyAttachments.xml";
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean delete = PolicySetAttachmentWorkSpaceHelper.deleteAttachmentFile(appRepContext, expectedFileName, "client", new Object[]{appName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteClientAttachmentFile", delete);
        }
        return delete;
    }

    public static String getWSNClientAttachmentFile(Session session, String busName, String serviceName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getWSNClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSNClientAttachmentFile", new Object[]{session, busName, serviceName});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName);
        String expectedFileName = PolicySetAttachmentWorkSpaceHelper.getWSNClientFilePath(serviceName);
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        RepositoryContext wsnContext = (RepositoryContext)repContext.findContext("wsn", serviceName).iterator().next();
        String fullPath = PolicySetAttachmentWorkSpaceHelper.getAttachmentFile(wsnContext, expectedFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSNClientAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static String createWSNClientAttachmentFile(Session session, String busName, String serviceName) throws WorkSpaceException, NoItemFoundException, DuplicateItemFoundException {
        String methodName = "createWSNClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createWSNClientAttachmentFile", new Object[]{session, busName, serviceName});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName);
        RepositoryContext wsnContext = (RepositoryContext)repContext.findContext("wsn", serviceName).iterator().next();
        String expectedFileName = PolicySetAttachmentWorkSpaceHelper.getWSNClientFilePath(serviceName);
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        String fullPath = PolicySetAttachmentWorkSpaceHelper.createAttachmentFile(wsnContext, expectedFileName, "WSNClient", new Object[]{"bus: " + busName + " " + "WSNService" + ": " + serviceName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createWSNClientAttachmentFile", fullPath);
        }
        return fullPath;
    }

    public static boolean updateWSNClientAttachmentFile(Session session, String busName, String serviceName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "updateWSNClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateWSNClientAttachmentFile", new Object[]{session, busName, serviceName});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName);
        String expectedFileName = PolicySetAttachmentWorkSpaceHelper.getWSNClientFilePath(serviceName);
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        RepositoryContext wsnContext = (RepositoryContext)repContext.findContext("wsn", serviceName).iterator().next();
        boolean update = PolicySetAttachmentWorkSpaceHelper.updateAttachmentFile(wsnContext, expectedFileName, "WSNClient", new Object[]{busName, serviceName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateWSNClientAttachmentFile", update);
        }
        return update;
    }

    public static boolean deleteWSNClientAttachmentFile(Session session, String busName, String serviceName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "deleteWSNClientAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteWSNClientAttachmentFile", new Object[]{session, busName, serviceName});
        }
        RepositoryContext repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName);
        RepositoryContext wsnContext = (RepositoryContext)repContext.findContext("wsn", serviceName).iterator().next();
        String expectedFileName = PolicySetAttachmentWorkSpaceHelper.getWSNClientFilePath(serviceName);
        expectedFileName = expectedFileName.replace(File.separatorChar, '/');
        boolean delete = PolicySetAttachmentWorkSpaceHelper.deleteAttachmentFile(wsnContext, expectedFileName, "WSNClient", new Object[]{busName, serviceName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteWSNClientAttachmentFile", delete);
        }
        return delete;
    }

    public static List<String> listPolicySetAttachmentFiles(Session session, String attachmentType) throws WorkSpaceException, NoItemFoundException {
        Properties p = new Properties();
        p.setProperty("application", "*");
        return PolicySetAttachmentWorkSpaceHelper.listPolicySetAttachmentFiles(session, attachmentType, p);
    }

    public static List<String> listPolicySetAttachmentFiles(Session session, String attachmentType, Properties searchPattern) throws WorkSpaceException, NoItemFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listPolicySetAttachmentFiles, attachmentType=" + attachmentType + ", searchPattern=" + searchPattern);
        }
        ArrayList<String> retList = new ArrayList<String>();
        if (attachmentType.equals("application") || attachmentType.equals("client")) {
            WorkSpace workspace = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
            RepositoryMetaData metaData = workspace.getMetaData();
            RepositoryContextType contextType = metaData.getContextType("deployments");
            Collection col = workspace.findContext(contextType);
            Iterator contextIt = col.iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "listPolicySetAttachmentFiles: find app repcontexts: " + col.size());
            }
            String fileName = null;
            String appSearchPattern = searchPattern.getProperty("application");
            while (contextIt.hasNext()) {
                fileName = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFileInApp((RepositoryContext)contextIt.next(), attachmentType, appSearchPattern);
                if (fileName == null) continue;
                retList.add(fileName);
            }
        } else if (attachmentType.equals("WSNClient")) {
            String busName = searchPattern.getProperty("bus");
            String serviceName = searchPattern.getProperty("WSNService");
            if (busName != null && serviceName != null) {
                RepositoryContext repContext = CommonWorkSpaceHelper.getBusesRepositoryContext(session, busName);
                RepositoryContext wsnContext = (RepositoryContext)repContext.findContext("wsn", serviceName).iterator().next();
                String fullPath = PolicySetAttachmentWorkSpaceHelper.getAttachmentFile(wsnContext, PolicySetAttachmentWorkSpaceHelper.getWSNClientFilePath(serviceName));
                if (fullPath != null) {
                    fullPath = fullPath.replace(File.separatorChar, '/');
                    retList.add(fullPath);
                }
            } else {
                RepositoryContext cellRepContext = CommonWorkSpaceHelper.getCellRepositoryContext(session);
                RepositoryContextType busesRepContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("buses");
                List busesRepositoryContexts = cellRepContext.getChildren(busesRepContextType);
                for (RepositoryContext busRepContext : busesRepositoryContexts) {
                    RepositoryContextType wsnRepContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("wsn");
                    List wsnRepositoryContexts = busRepContext.getChildren(wsnRepContextType);
                    for (RepositoryContext wsnRepContext : wsnRepositoryContexts) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "wsnRepContext: " + wsnRepContext);
                        }
                        Set files = wsnRepContext.getFiles();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "files: " + files);
                        }
                        for (String file : files) {
                            String fullPath;
                            if (!file.endsWith("clientPolicyAttachments.xml")) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "File matched: " + file);
                            }
                            if ((fullPath = PolicySetAttachmentWorkSpaceHelper.getAttachmentFile(wsnRepContext, file)) == null || !PolicySetAttachmentWorkSpaceHelper.doesFileExist(fullPath)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "File really exists");
                            }
                            fullPath = fullPath.replace(File.separatorChar, '/');
                            retList.add(fullPath);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPolicySetAttachmentFiles, retList=" + retList + ", retList.size()=" + retList.size());
        }
        return retList;
    }

    public static void removeWSPolicy(Session session, String applicationName, List<String> resources) throws Exception {
        String controlFile;
        String methodName = "removeWSPolicy";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeWSPolicy", new Object[]{session, applicationName, resources});
        }
        if ((controlFile = PolicyControlWorkSpaceHelper.getWSPolicyServiceControlFile(session, applicationName)) != null) {
            String policySetAttachmentFile = PolicySetAttachmentWorkSpaceHelper.getPolicySetAttachmentFile(session, applicationName);
            WSPolicyServiceControlHelper controlHelper = WSPolicyServiceControlHelperFactory.createHelper(controlFile, policySetAttachmentFile);
            for (String resource : resources) {
                controlHelper.removeWSPolicyServiceControlReference(resource);
            }
            List<Properties> referenceProperties = controlHelper.getWSPolicyServiceControlReferencesProperties();
            if (referenceProperties == null || referenceProperties.size() == 0) {
                PolicyControlWorkSpaceHelper.deleteWSPolicyServiceControlFile(session, applicationName);
            } else {
                PolicyControlWorkSpaceHelper.updateWSPolicyServiceControlFile(session, applicationName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeWSPolicy");
        }
    }

    private static boolean doesFileExist(String fullPath) {
        String methodName = "doesFileExist";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesFileExist", new Object[]{fullPath});
        }
        boolean fileExists = false;
        fullPath = fullPath.replace(File.separatorChar, '/');
        try {
            File javaFile = new File(fullPath);
            if (javaFile.exists()) {
                fileExists = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesFileExist", fileExists);
        }
        return fileExists;
    }

    private static String getAttachmentFile(RepositoryContext repContext, String expectedFileName) throws WorkSpaceException, NoItemFoundException {
        String methodName = "getAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttachmentFile", new Object[]{repContext, expectedFileName});
        }
        String fileName = null;
        if (repContext.isAvailable(expectedFileName)) {
            if (!repContext.isExtracted(expectedFileName)) {
                repContext.extract(expectedFileName, false);
            }
            fileName = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning null, cannot find file: " + expectedFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachmentFile", fileName);
        }
        return fileName;
    }

    private static String createAttachmentFile(RepositoryContext repContext, String expectedFileName, String attachmentType, Object[] exceptionArgs) throws WorkSpaceException, DuplicateItemFoundException {
        String methodName = "createAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAttachmentFile", new Object[]{repContext, expectedFileName, attachmentType, exceptionArgs});
        }
        String fileName = null;
        if (repContext.isAvailable(expectedFileName)) {
            if (attachmentType.equals("application")) {
                throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0060E", exceptionArgs, "Duplicate policyAttachments.xml is found: {0}"));
            }
            if (attachmentType.equals("system/trust")) {
                throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0087E", exceptionArgs, "Duplicate system/trust policyAttachments.xml is found"));
            }
            if (attachmentType.equals("client")) {
                throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0061E", exceptionArgs, "Duplicate clientPolicyAttachments.xml is found: {0}"));
            }
            if (attachmentType.equals("WSNClient")) {
                throw new DuplicateItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0061E", exceptionArgs, "Duplicate clientPolicyAttachments.xml is found: {0}"));
            }
        } else {
            repContext.getOutputStream(expectedFileName);
            repContext.notifyChanged(0, expectedFileName);
            fileName = CommonWorkSpaceHelper.getFullPath(repContext, expectedFileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAttachmentFile", fileName);
        }
        return fileName;
    }

    private static boolean updateAttachmentFile(RepositoryContext repContext, String expectedFileName, String attachmentType, Object[] exceptionArgs) throws WorkSpaceException, NoItemFoundException {
        String methodName = "updateAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAttachmentFile", new Object[]{repContext, expectedFileName, attachmentType, exceptionArgs});
        }
        boolean update = false;
        if (repContext.isAvailable(expectedFileName = expectedFileName.replace(File.separatorChar, '/'))) {
            repContext.notifyChanged(1, expectedFileName);
            update = true;
        } else {
            if (attachmentType.equals("application")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0031E", exceptionArgs, "Policy attachment file is not found: {0}"));
            }
            if (attachmentType.equals("system/trust")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0033E", exceptionArgs, "System/trust policy attachment file is not found"));
            }
            if (attachmentType.equals("client")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0032E", exceptionArgs, "Client policy attachment file is not found: {0}"));
            }
            if (attachmentType.equals("WSNClient")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0108E", exceptionArgs, "The client policy attachment file is not found for bus: {0} WSN service: {1}"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAttachmentFile", update);
        }
        return update;
    }

    private static boolean deleteAttachmentFile(RepositoryContext repContext, String expectedFileName, String attachmentType, Object[] exceptionArgs) throws WorkSpaceException, NoItemFoundException {
        String methodName = "deleteAttachmentFile";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAttachmentFile", new Object[]{repContext, expectedFileName, attachmentType, exceptionArgs});
        }
        boolean delete = false;
        if (repContext.isAvailable(expectedFileName = expectedFileName.replace(File.separatorChar, '/'))) {
            if (!repContext.isExtracted(expectedFileName)) {
                repContext.extract(expectedFileName, false);
            }
            repContext.notifyChanged(2, expectedFileName);
            delete = true;
        } else {
            if (attachmentType.equals("application")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0031E", exceptionArgs, "Policy attachment file is not found: {0}"));
            }
            if (attachmentType.equals("system/trust")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0033E", exceptionArgs, "System/trust policy attachment file is not found"));
            }
            if (attachmentType.equals("client")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0032E", exceptionArgs, "Client policy attachment file is not found: {0}"));
            }
            if (attachmentType.equals("WSNClient")) {
                throw new NoItemFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0108E", exceptionArgs, "The client policy attachment file is not found for bus: {0} WSN service: {1}"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteAttachmentFile", delete);
        }
        return delete;
    }

    private static boolean matchAppName(String appName, String appSearchPattern) {
        if (appSearchPattern == null || appSearchPattern.equals("*")) {
            return true;
        }
        if (appSearchPattern.endsWith("*")) {
            String prefix = appSearchPattern.substring(0, appSearchPattern.length() - 1);
            return appName.startsWith(prefix);
        }
        return appName.equals(appSearchPattern);
    }

    private static String getPolicySetAttachmentFileInApp(RepositoryContext appRepContext, String attachmentType, String appSearchPattern) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetAttachmentFileInApp, attachmentType=" + attachmentType + ", appSearchPattern=" + appSearchPattern);
        }
        CommonWorkSpaceHelper.validateMonitorAuthorization(appRepContext);
        String path = appRepContext.getPath();
        int index = path.lastIndexOf(File.separatorChar);
        String appName = path.substring(index + 1);
        boolean matched = PolicySetAttachmentWorkSpaceHelper.matchAppName(appName, appSearchPattern);
        boolean trDebug = tc.isDebugEnabled();
        if (trDebug) {
            Tr.debug(tc, "getPolicySetAttachmentFileInApp, appSearchPattern=" + appSearchPattern + ", appName=" + appName + ", match=" + matched);
        }
        if (!matched) {
            return null;
        }
        String expectedFileName = null;
        expectedFileName = attachmentType.equals("application") ? "META-INF" + File.separator + "policyAttachments.xml" : "META-INF" + File.separator + "clientPolicyAttachments.xml";
        if (appRepContext.isAvailable(expectedFileName = expectedFileName.replace(File.separatorChar, '/'))) {
            if (!appRepContext.isExtracted(expectedFileName)) {
                appRepContext.extract(expectedFileName, false);
            }
            String fullPath = CommonWorkSpaceHelper.getFullPath(appRepContext, expectedFileName);
            fullPath = fullPath.replace('/', File.separatorChar);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicySetAttachmentFileInApp, fullPath=" + fullPath);
            }
            return fullPath;
        }
        return null;
    }

    private static String getTrustFilePath() {
        StringBuffer buf = new StringBuffer();
        buf.append("sts").append(File.separator).append("policy").append(File.separator).append("policyAttachments.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTrustFilePath, buf.toString()=" + buf.toString());
        }
        return buf.toString();
    }

    private static String getWSNClientFilePath(String serviceName) {
        String methodName = "getWSNClientFilePath";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSNClientFilePath", new Object[]{serviceName});
        }
        String wsnClientFilePath = "META-INF" + File.separator + "clientPolicyAttachments.xml";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSNClientFilePath", wsnClientFilePath);
        }
        return wsnClientFilePath;
    }
}

